/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util.imgscalr;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.collections.BufferOverflowException;

public class CircularByteBuffer {
    private static final int DEFAULT_SIZE = 1024;
    public static final int INFINITE_SIZE = -1;
    protected byte[] buffer;
    protected volatile int readPosition = 0;
    protected volatile int writePosition = 0;
    protected volatile int markPosition = 0;
    protected volatile int markSize = 0;
    protected volatile boolean infinite = false;
    protected boolean blockingWrite = true;
    protected InputStream in = new CircularByteBufferInputStream();
    protected boolean inputStreamClosed = false;
    protected OutputStream out = new CircularByteBufferOutputStream();
    protected boolean outputStreamClosed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        CircularByteBuffer circularByteBuffer = this;
        synchronized (circularByteBuffer) {
            this.readPosition = 0;
            this.writePosition = 0;
            this.markPosition = 0;
            this.outputStreamClosed = false;
            this.inputStreamClosed = false;
        }
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvailable() {
        CircularByteBuffer circularByteBuffer = this;
        synchronized (circularByteBuffer) {
            return this.available();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSpaceLeft() {
        CircularByteBuffer circularByteBuffer = this;
        synchronized (circularByteBuffer) {
            return this.spaceLeft();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        CircularByteBuffer circularByteBuffer = this;
        synchronized (circularByteBuffer) {
            return this.buffer.length;
        }
    }

    private void resize() {
        byte[] newBuffer = new byte[this.buffer.length * 2];
        int marked = this.marked();
        int available = this.available();
        if (this.markPosition <= this.writePosition) {
            int length = this.writePosition - this.markPosition;
            System.arraycopy(this.buffer, this.markPosition, newBuffer, 0, length);
        } else {
            int length1 = this.buffer.length - this.markPosition;
            System.arraycopy(this.buffer, this.markPosition, newBuffer, 0, length1);
            int length2 = this.writePosition;
            System.arraycopy(this.buffer, 0, newBuffer, length1, length2);
        }
        this.buffer = newBuffer;
        this.markPosition = 0;
        this.readPosition = marked;
        this.writePosition = marked + available;
    }

    private int spaceLeft() {
        if (this.writePosition < this.markPosition) {
            return this.markPosition - this.writePosition - 1;
        }
        return this.buffer.length - 1 - (this.writePosition - this.markPosition);
    }

    private int available() {
        if (this.readPosition <= this.writePosition) {
            return this.writePosition - this.readPosition;
        }
        return this.buffer.length - (this.readPosition - this.writePosition);
    }

    private int marked() {
        if (this.markPosition <= this.readPosition) {
            return this.readPosition - this.markPosition;
        }
        return this.buffer.length - (this.markPosition - this.readPosition);
    }

    private void ensureMark() {
        if (this.marked() >= this.markSize) {
            this.markPosition = this.readPosition;
            this.markSize = 0;
        }
    }

    public CircularByteBuffer() {
        this(1024, true);
    }

    public CircularByteBuffer(int size) {
        this(size, true);
    }

    public CircularByteBuffer(boolean blockingWrite) {
        this(1024, blockingWrite);
    }

    public CircularByteBuffer(int size, boolean blockingWrite) {
        if (size == -1) {
            this.buffer = new byte[1024];
            this.infinite = true;
        } else {
            this.buffer = new byte[size];
            this.infinite = false;
        }
        this.blockingWrite = blockingWrite;
    }

    protected class CircularByteBufferOutputStream
    extends OutputStream {
        protected CircularByteBufferOutputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            CircularByteBuffer circularByteBuffer = CircularByteBuffer.this;
            synchronized (circularByteBuffer) {
                if (!CircularByteBuffer.this.outputStreamClosed) {
                    this.flush();
                }
                CircularByteBuffer.this.outputStreamClosed = true;
            }
        }

        @Override
        public void flush() throws IOException {
            if (CircularByteBuffer.this.outputStreamClosed) {
                throw new IOException("OutputStream has been closed; cannot flush a closed OutputStream.");
            }
            if (CircularByteBuffer.this.inputStreamClosed) {
                throw new IOException("Buffer closed by inputStream; cannot flush.");
            }
        }

        @Override
        public void write(byte[] cbuf) throws IOException {
            this.write(cbuf, 0, cbuf.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] cbuf, int off, int len) throws IOException {
            while (len > 0) {
                int written;
                CircularByteBuffer circularByteBuffer = CircularByteBuffer.this;
                synchronized (circularByteBuffer) {
                    if (CircularByteBuffer.this.outputStreamClosed) {
                        throw new IOException("OutputStream has been closed; cannot write to a closed OutputStream.");
                    }
                    if (CircularByteBuffer.this.inputStreamClosed) {
                        throw new IOException("Buffer closed by InputStream; cannot write to a closed buffer.");
                    }
                    int spaceLeft = CircularByteBuffer.this.spaceLeft();
                    while (CircularByteBuffer.this.infinite && spaceLeft < len) {
                        CircularByteBuffer.this.resize();
                        spaceLeft = CircularByteBuffer.this.spaceLeft();
                    }
                    if (!CircularByteBuffer.this.blockingWrite && spaceLeft < len) {
                        throw new BufferOverflowException("CircularByteBuffer is full; cannot write " + len + " bytes");
                    }
                    int realLen = Math.min(len, spaceLeft);
                    int firstLen = Math.min(realLen, CircularByteBuffer.this.buffer.length - CircularByteBuffer.this.writePosition);
                    int secondLen = Math.min(realLen - firstLen, CircularByteBuffer.this.buffer.length - CircularByteBuffer.this.markPosition - 1);
                    written = firstLen + secondLen;
                    if (firstLen > 0) {
                        System.arraycopy(cbuf, off, CircularByteBuffer.this.buffer, CircularByteBuffer.this.writePosition, firstLen);
                    }
                    if (secondLen > 0) {
                        System.arraycopy(cbuf, off + firstLen, CircularByteBuffer.this.buffer, 0, secondLen);
                        CircularByteBuffer.this.writePosition = secondLen;
                    } else {
                        CircularByteBuffer.this.writePosition += written;
                    }
                    if (CircularByteBuffer.this.writePosition == CircularByteBuffer.this.buffer.length) {
                        CircularByteBuffer.this.writePosition = 0;
                    }
                    off += written;
                }
                if ((len -= written) <= 0) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (Exception x) {
                    throw new IOException("Waiting for available space in buffer interrupted.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int c) throws IOException {
            boolean written = false;
            while (!written) {
                CircularByteBuffer circularByteBuffer = CircularByteBuffer.this;
                synchronized (circularByteBuffer) {
                    if (CircularByteBuffer.this.outputStreamClosed) {
                        throw new IOException("OutputStream has been closed; cannot write to a closed OutputStream.");
                    }
                    if (CircularByteBuffer.this.inputStreamClosed) {
                        throw new IOException("Buffer closed by InputStream; cannot write to a closed buffer.");
                    }
                    int spaceLeft = CircularByteBuffer.this.spaceLeft();
                    while (CircularByteBuffer.this.infinite && spaceLeft < 1) {
                        CircularByteBuffer.this.resize();
                        spaceLeft = CircularByteBuffer.this.spaceLeft();
                    }
                    if (!CircularByteBuffer.this.blockingWrite && spaceLeft < 1) {
                        throw new BufferOverflowException("CircularByteBuffer is full; cannot write 1 byte");
                    }
                    if (spaceLeft > 0) {
                        CircularByteBuffer.this.buffer[CircularByteBuffer.this.writePosition] = (byte)(c & 0xFF);
                        ++CircularByteBuffer.this.writePosition;
                        if (CircularByteBuffer.this.writePosition == CircularByteBuffer.this.buffer.length) {
                            CircularByteBuffer.this.writePosition = 0;
                        }
                        written = true;
                    }
                }
                if (written) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (Exception x) {
                    throw new IOException("Waiting for available space in buffer interrupted.");
                }
            }
        }
    }

    protected class CircularByteBufferInputStream
    extends InputStream {
        protected CircularByteBufferInputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            CircularByteBuffer circularByteBuffer = CircularByteBuffer.this;
            synchronized (circularByteBuffer) {
                if (CircularByteBuffer.this.inputStreamClosed) {
                    throw new IOException("InputStream has been closed, it is not ready.");
                }
                return CircularByteBuffer.this.available();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            CircularByteBuffer circularByteBuffer = CircularByteBuffer.this;
            synchronized (circularByteBuffer) {
                CircularByteBuffer.this.inputStreamClosed = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mark(int readAheadLimit) {
            CircularByteBuffer circularByteBuffer = CircularByteBuffer.this;
            synchronized (circularByteBuffer) {
                if (CircularByteBuffer.this.buffer.length - 1 > readAheadLimit) {
                    CircularByteBuffer.this.markSize = readAheadLimit;
                    CircularByteBuffer.this.markPosition = CircularByteBuffer.this.readPosition;
                }
            }
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            while (true) {
                CircularByteBuffer circularByteBuffer = CircularByteBuffer.this;
                synchronized (circularByteBuffer) {
                    if (CircularByteBuffer.this.inputStreamClosed) {
                        throw new IOException("InputStream has been closed; cannot read from a closed InputStream.");
                    }
                    int available = CircularByteBuffer.this.available();
                    if (available > 0) {
                        int result = CircularByteBuffer.this.buffer[CircularByteBuffer.this.readPosition] & 0xFF;
                        ++CircularByteBuffer.this.readPosition;
                        if (CircularByteBuffer.this.readPosition == CircularByteBuffer.this.buffer.length) {
                            CircularByteBuffer.this.readPosition = 0;
                        }
                        CircularByteBuffer.this.ensureMark();
                        return result;
                    }
                    if (CircularByteBuffer.this.outputStreamClosed) {
                        return -1;
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception x) {
                    throw new IOException("Blocking read operation interrupted.");
                }
            }
        }

        @Override
        public int read(byte[] cbuf) throws IOException {
            return this.read(cbuf, 0, cbuf.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] cbuf, int off, int len) throws IOException {
            while (true) {
                CircularByteBuffer circularByteBuffer = CircularByteBuffer.this;
                synchronized (circularByteBuffer) {
                    if (CircularByteBuffer.this.inputStreamClosed) {
                        throw new IOException("InputStream has been closed; cannot read from a closed InputStream.");
                    }
                    int available = CircularByteBuffer.this.available();
                    if (available > 0) {
                        int length = Math.min(len, available);
                        int firstLen = Math.min(length, CircularByteBuffer.this.buffer.length - CircularByteBuffer.this.readPosition);
                        int secondLen = length - firstLen;
                        System.arraycopy(CircularByteBuffer.this.buffer, CircularByteBuffer.this.readPosition, cbuf, off, firstLen);
                        if (secondLen > 0) {
                            System.arraycopy(CircularByteBuffer.this.buffer, 0, cbuf, off + firstLen, secondLen);
                            CircularByteBuffer.this.readPosition = secondLen;
                        } else {
                            CircularByteBuffer.this.readPosition += length;
                        }
                        if (CircularByteBuffer.this.readPosition == CircularByteBuffer.this.buffer.length) {
                            CircularByteBuffer.this.readPosition = 0;
                        }
                        CircularByteBuffer.this.ensureMark();
                        return length;
                    }
                    if (CircularByteBuffer.this.outputStreamClosed) {
                        return -1;
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception x) {
                    throw new IOException("Blocking read operation interrupted.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset() throws IOException {
            CircularByteBuffer circularByteBuffer = CircularByteBuffer.this;
            synchronized (circularByteBuffer) {
                if (CircularByteBuffer.this.inputStreamClosed) {
                    throw new IOException("InputStream has been closed; cannot reset a closed InputStream.");
                }
                CircularByteBuffer.this.readPosition = CircularByteBuffer.this.markPosition;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long n) throws IOException, IllegalArgumentException {
            while (true) {
                CircularByteBuffer circularByteBuffer = CircularByteBuffer.this;
                synchronized (circularByteBuffer) {
                    if (CircularByteBuffer.this.inputStreamClosed) {
                        throw new IOException("InputStream has been closed; cannot skip bytes on a closed InputStream.");
                    }
                    int available = CircularByteBuffer.this.available();
                    if (available > 0) {
                        int firstLen;
                        int length = Math.min((int)n, available);
                        int secondLen = length - (firstLen = Math.min(length, CircularByteBuffer.this.buffer.length - CircularByteBuffer.this.readPosition));
                        CircularByteBuffer.this.readPosition = secondLen > 0 ? secondLen : (CircularByteBuffer.this.readPosition += length);
                        if (CircularByteBuffer.this.readPosition == CircularByteBuffer.this.buffer.length) {
                            CircularByteBuffer.this.readPosition = 0;
                        }
                        CircularByteBuffer.this.ensureMark();
                        return length;
                    }
                    if (CircularByteBuffer.this.outputStreamClosed) {
                        return 0L;
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception x) {
                    throw new IOException("Blocking read operation interrupted.");
                }
            }
        }
    }
}

