/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util.imgscalr;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.util.imgscalr.CircularByteBuffer;
import org.lamsfoundation.lams.util.imgscalr.Scalr;

public class ResizePictureUtil {
    private static Logger log = Logger.getLogger(ResizePictureUtil.class);

    public static InputStream resize(InputStream is, int largestDimension) throws IOException {
        try {
            BufferedImage image = ImageIO.read(is);
            return ResizePictureUtil.resize(image, largestDimension);
        }
        catch (IOException e) {
            log.error((Object)e.getStackTrace());
            return null;
        }
    }

    public static InputStream resize(BufferedImage image, int largestDimension) throws IOException {
        try {
            BufferedImage outImage = Scalr.resize(image, Scalr.Method.QUALITY, largestDimension, new BufferedImageOp[0]);
            ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("jpeg").next();
            ImageWriteParam jpgWriteParam = imageWriter.getDefaultWriteParam();
            jpgWriteParam.setCompressionMode(2);
            jpgWriteParam.setCompressionQuality(0.95f);
            CircularByteBuffer outputBuffer = new CircularByteBuffer(-1);
            ImageOutputStream ios = ImageIO.createImageOutputStream(outputBuffer.getOutputStream());
            imageWriter.setOutput(ios);
            IIOImage outputImage = new IIOImage(outImage, null, null);
            imageWriter.write(null, outputImage, jpgWriteParam);
            imageWriter.dispose();
            outputBuffer.getOutputStream().close();
            return outputBuffer.getInputStream();
        }
        catch (IOException e) {
            log.error((Object)e.getStackTrace());
            return null;
        }
    }
}

