/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util.zipfile;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.FileUtilException;
import org.lamsfoundation.lams.util.zipfile.ZipFileUtilException;

public class ZipFileUtil {
    private static Logger log = Logger.getLogger(ZipFileUtil.class);
    public static final String prefix = "lamszip_";
    private static int BUFFER_SIZE = 8192;

    public static String expandZip(InputStream is, String zipFileName) throws ZipFileUtilException {
        String tempDirName = ZipFileUtil.prepareTempDirectory(zipFileName);
        ZipFileUtil.extractZipFile(is, tempDirName);
        return tempDirName;
    }

    public static void expandZipToFolder(InputStream is, String destFolder) throws ZipFileUtilException {
        ZipFileUtil.extractZipFile(is, destFolder);
    }

    protected static String prepareTempDirectory(String zipFileName) throws ZipFileUtilException {
        int dotIndex = zipFileName.indexOf(".");
        String shortZipName = dotIndex > -1 ? zipFileName.substring(0, dotIndex) : zipFileName;
        String tempSysDirName = System.getProperty("java.io.tmpdir");
        if (tempSysDirName == null) {
            throw new ZipFileUtilException("No temporary directory known to the server. [System.getProperty( \"java.io.tmpdir\" ) returns null. ]\n Cannot upload package.");
        }
        String tempDirName = tempSysDirName + File.separator + prefix + System.currentTimeMillis() + "_" + shortZipName;
        File tempDir = new File(tempDirName);
        int i = 0;
        while (tempDir.exists() && i < 100) {
            tempDirName = tempSysDirName + File.separator + prefix + System.currentTimeMillis() + "_" + i + shortZipName;
            tempDir = new File(tempDirName);
        }
        if (tempDir.exists()) {
            throw new ZipFileUtilException("Temporary filename/directory that we would use to extract files already exists: " + tempDirName + ". Unable to upload Content Package.");
        }
        tempDir.mkdirs();
        return tempDirName;
    }

    private static void extractZipFile(InputStream is, String tempDirName) throws ZipFileUtilException {
        ZipInputStream zis = new ZipInputStream(is);
        byte[] data = new byte[BUFFER_SIZE];
        ZipEntry entry = null;
        FilterOutputStream dest = null;
        String entryName = null;
        try {
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                if (entry.isDirectory()) continue;
                entryName = entry.getName();
                Object destName = tempDirName + File.separator + entryName;
                destName = FileUtil.makeCanonicalPath((String)destName);
                ZipFileUtil.prepareDirectory((String)destName);
                FileOutputStream fos = new FileOutputStream((String)destName);
                dest = new BufferedOutputStream(fos, BUFFER_SIZE);
                while ((count = zis.read(data, 0, BUFFER_SIZE)) != -1) {
                    ((BufferedOutputStream)dest).write(data, 0, count);
                }
                ((BufferedOutputStream)dest).flush();
                dest.close();
                dest = null;
            }
        }
        catch (IOException ioe) {
            log.error((Object)("Exception occured processing entries in zip file. Entry was " + entryName), (Throwable)ioe);
            throw new ZipFileUtilException("Exception occured processing entries in zip file. Entry was " + entryName, ioe);
        }
        finally {
            if (dest != null) {
                try {
                    dest.close();
                }
                catch (IOException ioe2) {
                    log.error((Object)"Exception thrown in finally statement, trying to close destination file.", (Throwable)ioe2);
                }
            }
        }
    }

    private static void prepareDirectory(String destName) {
        File destNameFile = new File(destName);
        String path = destNameFile.getParent();
        if (path != null) {
            File pathDir = new File(path);
            pathDir.mkdirs();
        }
    }

    public static boolean deleteDirectory(String directoryName) throws ZipFileUtilException {
        if (directoryName != null) {
            String tempSysDirNamePrefix = System.getProperty("java.io.tmpdir") + File.separator + prefix;
            if (!directoryName.startsWith(tempSysDirNamePrefix)) {
                throw new ZipFileUtilException("Invalid directory delete request. Received request to delete directory " + directoryName + " but name doesn't start with the temporary directory location (" + tempSysDirNamePrefix + "). Not deleting directory");
            }
            return FileUtil.deleteDirectory(new File(directoryName));
        }
        return false;
    }

    private static String appendToString(String origString, String newMessage) {
        if (origString != null) {
            return origString + "   \n" + newMessage;
        }
        return newMessage;
    }

    public static String createZipFile(String zipFileName, String directoryToZip) throws ZipFileUtilException {
        int dotIndex = zipFileName.indexOf(".");
        Object fileNameOfZipToCreate = dotIndex > -1 ? zipFileName : zipFileName + ".zip";
        try {
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream((String)fileNameOfZipToCreate)));
            File directory = new File(directoryToZip);
            if (!directory.exists()) {
                throw new ZipFileUtilException("The specified directory " + directoryToZip + " does not exist");
            }
            File[] files = directory.listFiles();
            ZipFileUtil.zipFiles(out, files, directory.getCanonicalPath());
            out.close();
        }
        catch (IOException e1) {
            throw new ZipFileUtilException("An error has occurred while trying to zip the files. Error message is: " + e1.getMessage(), e1);
        }
        return fileNameOfZipToCreate;
    }

    public static String createZipFile(String zipFileName, String directoryToZip, String directoryToPlaceZip) throws ZipFileUtilException {
        int dotIndex;
        if (!FileUtil.directoryExist(directoryToPlaceZip)) {
            try {
                FileUtil.createDirectory(directoryToPlaceZip);
            }
            catch (FileUtilException e) {
                throw new ZipFileUtilException("The temporary directory to place the zip file could be not created: " + e.getMessage(), e);
            }
        }
        Object zipFile = (dotIndex = zipFileName.indexOf(".")) > -1 ? zipFileName : zipFileName + ".zip";
        String fileNameOfZipToCreate = directoryToPlaceZip + File.separator + (String)zipFile;
        try {
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(fileNameOfZipToCreate)));
            File directory = new File(directoryToZip);
            if (!directory.exists()) {
                throw new ZipFileUtilException("The specified directory " + directoryToZip + " does not exist");
            }
            File[] files = directory.listFiles();
            ZipFileUtil.zipFiles(out, files, directory.getCanonicalPath());
            out.close();
        }
        catch (IOException e1) {
            throw new ZipFileUtilException("An error has occurred while trying to zip the files. Error message is: " + e1.getMessage(), e1);
        }
        return fileNameOfZipToCreate;
    }

    protected static void zipFiles(ZipOutputStream zop, File[] files, String dirPath) throws ZipFileUtilException {
        File file = null;
        ZipEntry entry = null;
        BufferedInputStream source = null;
        byte[] data = new byte[BUFFER_SIZE];
        try {
            for (int i = 0; i < files.length; ++i) {
                int length;
                file = files[i];
                if (file.isDirectory()) {
                    File[] filesInsideDir = file.listFiles();
                    ZipFileUtil.zipFiles(zop, filesInsideDir, dirPath);
                    continue;
                }
                source = new BufferedInputStream(new FileInputStream(file));
                entry = new ZipEntry(ZipFileUtil.removeDirPath(file.getCanonicalPath(), dirPath));
                zop.setMethod(8);
                zop.setLevel(-1);
                zop.putNextEntry(entry);
                while ((length = source.read(data)) > 0) {
                    zop.write(data, 0, length);
                }
                zop.closeEntry();
                source.close();
                source = null;
            }
        }
        catch (IOException e) {
            throw new ZipFileUtilException("An error has occurred while trying to zip the files. Error message is: " + e.getMessage(), e);
        }
    }

    private static String removeDirPath(String absoluteFilePath, String rootDirPath) {
        int rootDirLength = rootDirPath.length();
        return absoluteFilePath.substring(rootDirLength + 1, absoluteFilePath.length());
    }
}

