/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.controller;

import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.logevent.service.ILogEventService;
import org.lamsfoundation.lams.tool.IToolVO;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.ToolContentManager;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.WebUtil;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;

public abstract class LamsAuthoringFinishController {
    private static Logger log = Logger.getLogger(LamsAuthoringFinishController.class);
    private static final String ACTION_NAME = "action";
    private static final String ACTION_MODE = "mode";
    private static final String CUSTOMISE_SESSION_ID = "customiseSessionID";
    private static final String TOOL_SIGNATURE = "signature";
    private static final String CONFIRM_ACTION = "confirm";
    private static final String CANCEL_ACTION = "cancel";
    private static final String DEFINE_LATER_ACTION = "defineLater";
    private static final String RE_EDIT_URL = "reEditUrl";
    @Autowired
    @Qualifier(value="logEventService")
    private ILogEventService logEventService;
    @Autowired
    @Qualifier(value="lamsToolService")
    private ILamsToolService lamsToolService;

    public void execute(HttpServletRequest request, HttpServletResponse response, ApplicationContext applicationContext) throws IOException {
        String action = request.getParameter(ACTION_NAME);
        ToolAccessMode mode = WebUtil.readToolAccessModeParam(request, ACTION_MODE, false);
        String cSessionID = request.getParameter(CUSTOMISE_SESSION_ID);
        String notifyCloseURL = (String)request.getSession().getAttribute("notifyCloseURL");
        Long toolContentId = new Long(WebUtil.readLongParam(request, "toolContentID"));
        this.clearSession(cSessionID, request.getSession(), mode);
        if (StringUtils.equals((String)action, (String)CONFIRM_ACTION)) {
            Object nextUrl = this.getLamsUrl() + "authoringConfirm.jsp";
            String signature = request.getParameter(TOOL_SIGNATURE);
            String contentFolderID = "TODO_remove-change_optional_to_false";
            contentFolderID = WebUtil.readStrParam(request, "contentFolderID", true);
            IToolVO tool = this.lamsToolService.getToolBySignature(signature);
            String reeditUrl = WebUtil.appendParameterToURL(this.getLamsUrl() + tool.getAuthorUrl(), "toolContentID", toolContentId.toString());
            reeditUrl = WebUtil.appendParameterToURL(reeditUrl, "contentFolderID", contentFolderID);
            if (notifyCloseURL != null && notifyCloseURL.length() > 0) {
                reeditUrl = WebUtil.appendParameterToURL(reeditUrl, "notifyCloseURL", notifyCloseURL);
            }
            nextUrl = WebUtil.appendParameterToURL((String)nextUrl, RE_EDIT_URL, URLEncoder.encode(reeditUrl, "UTF-8"));
            if (!StringUtils.isBlank((String)notifyCloseURL)) {
                nextUrl = WebUtil.appendParameterToURL((String)nextUrl, "notifyCloseURL", notifyCloseURL);
            }
            response.sendRedirect((String)nextUrl);
        }
        if (StringUtils.equals((String)action, (String)DEFINE_LATER_ACTION)) {
            this.logEventService.logFinishEditingActivityInMonitor(toolContentId);
        }
        if (StringUtils.equals((String)action, (String)CANCEL_ACTION) && mode.isTeacher()) {
            String signature = request.getParameter(TOOL_SIGNATURE);
            ToolContentManager contentManager = (ToolContentManager)this.findToolService(applicationContext, signature);
            contentManager.resetDefineLater(toolContentId);
            this.logEventService.logCancelEditingActivityInMonitor(toolContentId);
        }
    }

    protected abstract void clearSession(String var1, HttpSession var2, ToolAccessMode var3);

    private String getLamsUrl() {
        String serverURL = Configuration.get(ConfigurationKeys.SERVER_URL);
        if (StringUtils.isBlank((String)serverURL)) {
            log.warn((Object)"ServerURLTag unable to write out server URL as it is missing from the configuration file.");
        }
        return serverURL;
    }

    private Object findToolService(ApplicationContext applicationContext, String signature) throws NoSuchBeanDefinitionException {
        IToolVO tool = this.lamsToolService.getToolBySignature(signature);
        return applicationContext.getBean(tool.getServiceName());
    }
}

