/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.cache;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.NotImplementedException;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.persister.collection.AbstractCollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.lamsfoundation.lams.cache.ICacheManager;

public class CacheManager
implements ICacheManager {
    protected Logger log = Logger.getLogger(CacheManager.class);
    private String DEFAULT_CACHE_OBJECT_NAME = "jboss.cache:service=TreeCache";
    private String cacheObjectName = null;
    private SessionFactory sessionFactory;
    private Cache cache = null;
    private Object listener = null;

    private Cache getCache() {
        throw new NotImplementedException("You can not retrieve Cache using JMX on current JBoss version");
    }

    @Override
    public String[] getPartsFromClass(Class clasz) {
        return clasz.getName().split("\\.");
    }

    private Fqn getFqn(Class clasz) {
        return Fqn.fromElements((Object[])this.getPartsFromClass(clasz));
    }

    private Fqn getFqn(String[] classNameParts) {
        return Fqn.fromElements((Object[])classNameParts);
    }

    @Override
    public Object getItem(String[] classNameParts, Object key) {
        if (key == null || classNameParts == null) {
            return null;
        }
        return this.getItem(this.getFqn(classNameParts), key);
    }

    @Override
    public Object getItem(Class clasz, Object key) {
        if (key == null || clasz == null) {
            return null;
        }
        return this.getItem(this.getFqn(clasz), key);
    }

    private Object getItem(Fqn fqn, Object key) {
        Cache cache = this.getCache();
        if (cache == null) {
            this.log.warn((Object)("Unable to get item with fqn " + fqn + " key " + key + " as we can't get the JBOSS Cache mbean."));
            return null;
        }
        Object obj = null;
        try {
            obj = cache.get(fqn, key);
            if (obj != null) {
                this.log.debug((Object)("Retrieved object from cache fqn " + fqn + " key " + key));
            }
        }
        catch (CacheException e) {
            this.log.error((Object)("JBOSS Cache exception occured getting object from cache. fqn " + fqn + " key " + key), (Throwable)e);
        }
        return obj;
    }

    @Override
    public void addItem(String[] classNameParts, Object key, Object item) {
        if (item != null && key != null && classNameParts != null) {
            this.addItem(this.getFqn(classNameParts), key, item);
        }
    }

    @Override
    public void addItem(Class clasz, Object key, Object item) {
        if (item != null && key != null && clasz != null) {
            this.addItem(this.getFqn(clasz), key, item);
        }
    }

    private void addItem(Fqn fqn, Object key, Object item) {
        Cache cache = this.getCache();
        if (cache == null) {
            this.log.warn((Object)("Unable to get cache item with fqn " + fqn + " key " + key + " as we can't get the JBOSS Cache mbean."));
            return;
        }
        try {
            cache.put(fqn, key, item);
        }
        catch (CacheException e) {
            this.log.error((Object)("JBOSS Cache exception occured putting object in cache. fqn " + fqn + " key " + key), (Throwable)e);
        }
    }

    @Override
    public Map<String, Set<String>> getCachedItems() {
        Cache cache = this.getCache();
        TreeMap<String, Set<String>> allChildNames = new TreeMap<String, Set<String>>();
        if (cache == null) {
            this.log.warn((Object)"Unable to get cache items as we can't get the JBOSS Cache mbean.");
        } else {
            this.addChildren("/", cache, allChildNames);
        }
        return allChildNames;
    }

    @Override
    public Set<String> getCachedClasses() {
        TreeSet<String> cachedClasses = new TreeSet<String>();
        for (Map.Entry cacheEntry : this.getSessionFactory().getAllClassMetadata().entrySet()) {
            if (!((EntityPersister)cacheEntry.getValue()).hasCache()) continue;
            cachedClasses.add((String)cacheEntry.getKey());
        }
        for (Map.Entry cacheEntry : this.getSessionFactory().getAllCollectionMetadata().entrySet()) {
            if (!((AbstractCollectionPersister)cacheEntry.getValue()).hasCache()) continue;
            cachedClasses.add((String)cacheEntry.getKey());
        }
        return cachedClasses;
    }

    @Override
    public void clearCachedClass(String className) {
        for (Map.Entry cacheEntry : this.getSessionFactory().getAllClassMetadata().entrySet()) {
            if (className != null && !className.equals(cacheEntry.getKey()) || !((EntityPersister)cacheEntry.getValue()).hasCache()) continue;
            this.getSessionFactory().evictEntity((String)cacheEntry.getKey());
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Evicted entity: " + (String)cacheEntry.getKey()));
        }
        for (Map.Entry cacheEntry : this.getSessionFactory().getAllCollectionMetadata().entrySet()) {
            if (className != null && !className.equals(cacheEntry.getKey()) || !((AbstractCollectionPersister)cacheEntry.getValue()).hasCache()) continue;
            this.getSessionFactory().evictCollection((String)cacheEntry.getKey());
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Evicted collection: " + (String)cacheEntry.getKey()));
        }
    }

    private void addChildren(String node, Cache cache, Map allChildNames) {
        try {
            Set childNames = cache.getChildrenNames(node);
            if (childNames != null) {
                allChildNames.put(node, childNames);
                for (String childNode : childNames) {
                    if (node.endsWith("/")) {
                        this.addChildren(node + childNode, cache, allChildNames);
                        continue;
                    }
                    this.addChildren(node + "/" + childNode, cache, allChildNames);
                }
            }
        }
        catch (CacheException e) {
            this.log.error((Object)"JBOSS Cache exception occured getting child names from cache", (Throwable)e);
        }
    }

    @Override
    public void clearCache(String node) {
        Cache cache = this.getCache();
        if (cache == null) {
            this.log.warn((Object)("Unable to clear cache node " + node + " as we can't get the JBOSS Cache mbean."));
        } else {
            try {
                cache.removeNode(node);
            }
            catch (CacheException e) {
                this.log.error((Object)"JBOSS Cache exception occured getting child names from cache", (Throwable)e);
            }
        }
    }

    @Override
    public void removeItem(String[] classNameParts, Object key) {
        Cache cache = this.getCache();
        if (cache == null) {
            this.log.warn((Object)("Unable to remove cache item " + classNameParts + ":" + key + "as we can't get the JBOSS Cache mbean."));
        } else {
            try {
                cache.remove(this.getFqn(classNameParts), key);
            }
            catch (CacheException e) {
                this.log.error((Object)"JBOSS Cache exception occured getting child names from cache", (Throwable)e);
            }
        }
    }

    public String getCacheObjectName() {
        return this.cacheObjectName;
    }

    public void setCacheObjectName(String cacheObjectName) {
        this.cacheObjectName = cacheObjectName;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

