/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.comments.dao.hibernate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.hibernate.Hibernate;
import org.hibernate.SQLQuery;
import org.hibernate.type.Type;
import org.lamsfoundation.lams.comments.Comment;
import org.lamsfoundation.lams.comments.dao.ICommentDAO;
import org.lamsfoundation.lams.comments.service.ICommentService;
import org.lamsfoundation.lams.comments.util.TopicComparator;
import org.lamsfoundation.lams.comments.util.TopicComparatorLike;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class CommentDAO
extends HibernateDaoSupport
implements ICommentDAO {
    private static final String SQL_QUERY_FIND_ROOT_TOPICS = "from " + Comment.class.getName() + " cs " + " where cs.parent is null and cs.session.externalId=:externalId and " + " cs.session.externalIdType=:externalIdType and cs.session.externalSignature=:externalSignature";
    private static final String SQL_QUERY_GET_COMPLETE_THREAD = "SELECT c.*, SUM(l.vote) likes_total, l2.vote user_vote FROM lams_comment c  LEFT JOIN lams_comment_likes l ON c.uid = l.comment_uid  LEFT JOIN lams_comment_likes l2 ON c.uid = l2.comment_uid AND l2.user_id=:userId  WHERE c.thread_comment_uid = :threadId  GROUP BY c.uid";
    private static final String SQL_QUERY_FIND_FIRST_THREAD_TOP_BY_UID = "SELECT uid FROM lams_comment WHERE root_comment_uid = :rootUid AND comment_level = 1 AND sticky = 0 ORDER BY uid DESC";
    private static final String SQL_QUERY_FIND_NEXT_THREAD_TOP = "SELECT uid FROM lams_comment WHERE root_comment_uid = :rootUid AND uid < :lastUid AND comment_level = 1 AND sticky = 0 ORDER BY uid DESC";
    private static final String SQL_QUERY_FIND_NEXT_THREAD_MESSAGES = "SELECT c.*, SUM(l.vote) likes_total, l2.vote user_vote FROM lams_comment c  LEFT JOIN lams_comment_likes l ON c.uid = l.comment_uid  LEFT JOIN lams_comment_likes l2 ON c.uid = l2.comment_uid AND l2.user_id=:userId  WHERE c.thread_comment_uid IN (:threadIds)  GROUP BY c.uid";
    private static final String SQL_QUERY_FIND_FIRST_THREAD_TOP_BY_LIKES = "SELECT c.*, COALESCE(SUM(l.vote),0) likes_total, l2.vote user_vote FROM lams_comment c  LEFT JOIN lams_comment_likes l ON c.uid = l.comment_uid  LEFT JOIN lams_comment_likes l2 ON c.uid = l2.comment_uid AND l2.user_id=:userId  WHERE root_comment_uid = :rootUid AND comment_level = 1 AND sticky = 0  GROUP BY c.uid  ORDER BY likes_total DESC, c.uid DESC";
    private static final String SQL_QUERY_FIND_NEXT_THREAD_TOP_BY_LIKE = "SELECT * FROM (  SELECT c.*, COALESCE(SUM(l.vote),0) likes_total, l2.vote user_vote  FROM lams_comment c  LEFT JOIN lams_comment_likes l ON c.uid = l.comment_uid  LEFT JOIN lams_comment_likes l2 ON c.uid = l2.comment_uid AND l2.user_id=:userId  WHERE root_comment_uid = :rootUid AND comment_level = 1 AND sticky = 0  GROUP BY c.uid  ORDER BY likes_total DESC, c.uid DESC) cl  WHERE (cl.likes_total = :like AND cl.uid < :lastUid )  OR cl.likes_total < :like";
    private static final String SQL_QUERY_FIND_NEXT_THREAD_MESSAGES_REPLIES_ONLY = "SELECT c.*, COALESCE(SUM(l.vote),0) likes_total, l2.vote user_vote FROM lams_comment c  LEFT JOIN lams_comment_likes l ON c.uid = l.comment_uid  LEFT JOIN lams_comment_likes l2 ON c.uid = l2.comment_uid AND l2.user_id=:userId  WHERE c.thread_comment_uid IN (:threadIds) and comment_level > 1  GROUP BY c.uid";
    private static final String SQL_QUERY_FIND_STICKY_BY_UID = "SELECT uid FROM lams_comment WHERE root_comment_uid = :rootUid AND comment_level = 1 AND sticky = 1 ORDER BY uid DESC";
    private static final String SQL_QUERY_FIND_STICKY_BY_LIKES = "SELECT c.*, COALESCE(SUM(l.vote),0) likes_total, l2.vote user_vote FROM lams_comment c  LEFT JOIN lams_comment_likes l ON c.uid = l.comment_uid  LEFT JOIN lams_comment_likes l2 ON c.uid = l2.comment_uid AND l2.user_id=:userId  WHERE root_comment_uid = :rootUid AND comment_level = 1  AND c.sticky = 1  GROUP BY c.uid  ORDER BY likes_total DESC, c.uid DESC";

    @Override
    public void saveOrUpdate(Comment comment) {
        this.getHibernateTemplate().saveOrUpdate((Object)comment);
    }

    @Override
    public Comment getById(Long commentId) {
        return (Comment)this.getHibernateTemplate().get(Comment.class, (Serializable)commentId);
    }

    @Override
    public Comment getRootTopic(Long externalId, Integer externalIdType, String externalSignature) {
        List list = this.getSession().createQuery(SQL_QUERY_FIND_ROOT_TOPICS).setLong("externalId", externalId.longValue()).setInteger("externalIdType", externalIdType.intValue()).setString("externalSignature", externalSignature).list();
        if (list != null && list.size() > 0) {
            return (Comment)list.get(0);
        }
        return null;
    }

    @Override
    public SortedSet<Comment> getThreadByThreadId(Long threadCommentId, Integer sortBy, Integer userId) {
        SQLQuery query = this.getSession().createSQLQuery(SQL_QUERY_GET_COMPLETE_THREAD);
        query.addEntity("comment", Comment.class).addScalar("likes_total", (Type)Hibernate.INTEGER).addScalar("user_vote", (Type)Hibernate.INTEGER).setLong("userId", userId != null ? (long)userId.intValue() : 0L).setLong("threadId", threadCommentId.longValue());
        List results = query.list();
        return this.upgradeComments(results, sortBy);
    }

    private SortedSet<Comment> upgradeComments(List<Object[]> rawObjects, Integer sortBy) {
        TopicComparator comparator = ICommentService.SORT_BY_LIKE.equals(sortBy) ? new TopicComparatorLike() : new TopicComparator();
        TreeSet<Comment> results = new TreeSet<Comment>(comparator);
        for (Object[] rawObject : rawObjects) {
            Comment comment = (Comment)rawObject[0];
            Integer likeCount = (Integer)rawObject[1];
            comment.setLikeCount(likeCount != null ? likeCount : 0);
            Integer userVote = (Integer)rawObject[2];
            comment.setVote(userVote);
            results.add(comment);
        }
        return results;
    }

    @Override
    public SortedSet<Comment> getNextThreadByThreadId(Long rootTopicId, Long previousThreadMessageId, Integer numberOfThreads, Integer sortBy, String extraSortParam, Integer userId) {
        if (ICommentService.SORT_BY_LIKE.equals(sortBy)) {
            return this.getNextThreadByThreadIdLikes(rootTopicId, previousThreadMessageId, numberOfThreads, sortBy, extraSortParam, userId);
        }
        return this.getNextThreadByThreadIdNewestFirst(rootTopicId, previousThreadMessageId, numberOfThreads, sortBy, userId);
    }

    private SortedSet<Comment> getNextThreadByThreadIdNewestFirst(Long rootTopicId, Long previousThreadMessageId, Integer numberOfThreads, Integer sortBy, Integer userId) {
        List threadUidList = null;
        threadUidList = previousThreadMessageId == null || previousThreadMessageId == 0L ? this.getSession().createSQLQuery(SQL_QUERY_FIND_FIRST_THREAD_TOP_BY_UID).setLong("rootUid", rootTopicId.longValue()).setMaxResults(numberOfThreads.intValue()).list() : this.getSession().createSQLQuery(SQL_QUERY_FIND_NEXT_THREAD_TOP).setLong("rootUid", rootTopicId.longValue()).setLong("lastUid", previousThreadMessageId.longValue()).setMaxResults(numberOfThreads.intValue()).list();
        if (threadUidList != null && threadUidList.size() > 0) {
            SQLQuery query = this.getSession().createSQLQuery(SQL_QUERY_FIND_NEXT_THREAD_MESSAGES);
            query.addEntity("comment", Comment.class).addScalar("likes_total", (Type)Hibernate.INTEGER).addScalar("user_vote", (Type)Hibernate.INTEGER).setLong("userId", userId != null ? (long)userId.intValue() : 0L).setParameterList("threadIds", (Collection)threadUidList);
            List results = query.list();
            return this.upgradeComments(results, sortBy);
        }
        return new TreeSet<Comment>();
    }

    private SortedSet<Comment> getNextThreadByThreadIdLikes(Long rootTopicId, Long previousThreadMessageId, Integer numberOfThreads, Integer sortBy, String extraSortParam, Integer userId) {
        List topThreadObjects = null;
        topThreadObjects = previousThreadMessageId == null || previousThreadMessageId == 0L ? this.getSession().createSQLQuery(SQL_QUERY_FIND_FIRST_THREAD_TOP_BY_LIKES).addEntity("comment", Comment.class).addScalar("likes_total", (Type)Hibernate.INTEGER).addScalar("user_vote", (Type)Hibernate.INTEGER).setLong("rootUid", rootTopicId.longValue()).setLong("userId", userId != null ? (long)userId.intValue() : 0L).setMaxResults(numberOfThreads.intValue()).list() : this.getSession().createSQLQuery(SQL_QUERY_FIND_NEXT_THREAD_TOP_BY_LIKE).addEntity("comment", Comment.class).addScalar("likes_total", (Type)Hibernate.INTEGER).addScalar("user_vote", (Type)Hibernate.INTEGER).setLong("rootUid", rootTopicId.longValue()).setLong("lastUid", previousThreadMessageId.longValue()).setString("like", extraSortParam).setLong("userId", userId != null ? (long)userId.intValue() : 0L).setMaxResults(numberOfThreads.intValue()).list();
        if (topThreadObjects != null && topThreadObjects.size() > 0) {
            ArrayList<Long> threadUidList = new ArrayList<Long>();
            for (Object[] rawObject : topThreadObjects) {
                Comment comment = (Comment)rawObject[0];
                threadUidList.add(comment.getUid());
            }
            SQLQuery query = this.getSession().createSQLQuery(SQL_QUERY_FIND_NEXT_THREAD_MESSAGES_REPLIES_ONLY);
            query.addEntity("comment", Comment.class).addScalar("likes_total", (Type)Hibernate.INTEGER).addScalar("user_vote", (Type)Hibernate.INTEGER).setLong("userId", userId != null ? (long)userId.intValue() : 0L).setParameterList("threadIds", threadUidList);
            List results = query.list();
            topThreadObjects.addAll(results);
            return this.upgradeComments(topThreadObjects, sortBy);
        }
        return new TreeSet<Comment>();
    }

    @Override
    public SortedSet<Comment> getStickyThreads(Long rootTopicId, Integer sortBy, String extraSortParam, Integer userId) {
        if (ICommentService.SORT_BY_LIKE.equals(sortBy)) {
            return this.getStickyByThreadIdLikes(rootTopicId, sortBy, extraSortParam, userId);
        }
        return this.getStickyByThreadIdNewestFirst(rootTopicId, sortBy, userId);
    }

    private SortedSet<Comment> getStickyByThreadIdNewestFirst(Long rootTopicId, Integer sortBy, Integer userId) {
        List threadUidList = this.getSession().createSQLQuery(SQL_QUERY_FIND_STICKY_BY_UID).setLong("rootUid", rootTopicId.longValue()).list();
        if (threadUidList != null && threadUidList.size() > 0) {
            SQLQuery query = this.getSession().createSQLQuery(SQL_QUERY_FIND_NEXT_THREAD_MESSAGES);
            query.addEntity("comment", Comment.class).addScalar("likes_total", (Type)Hibernate.INTEGER).addScalar("user_vote", (Type)Hibernate.INTEGER).setLong("userId", userId != null ? (long)userId.intValue() : 0L).setParameterList("threadIds", (Collection)threadUidList);
            List results = query.list();
            return this.upgradeComments(results, sortBy);
        }
        return new TreeSet<Comment>();
    }

    private SortedSet<Comment> getStickyByThreadIdLikes(Long rootTopicId, Integer sortBy, String extraSortParam, Integer userId) {
        List topThreadObjects = this.getSession().createSQLQuery(SQL_QUERY_FIND_STICKY_BY_LIKES).addEntity("comment", Comment.class).addScalar("likes_total", (Type)Hibernate.INTEGER).addScalar("user_vote", (Type)Hibernate.INTEGER).setLong("rootUid", rootTopicId.longValue()).setLong("userId", userId != null ? (long)userId.intValue() : 0L).list();
        if (topThreadObjects != null && topThreadObjects.size() > 0) {
            ArrayList<Long> threadUidList = new ArrayList<Long>();
            for (Object[] rawObject : topThreadObjects) {
                Comment comment = (Comment)rawObject[0];
                threadUidList.add(comment.getUid());
            }
            SQLQuery query = this.getSession().createSQLQuery(SQL_QUERY_FIND_NEXT_THREAD_MESSAGES_REPLIES_ONLY);
            query.addEntity("comment", Comment.class).addScalar("likes_total", (Type)Hibernate.INTEGER).addScalar("user_vote", (Type)Hibernate.INTEGER).setLong("userId", userId != null ? (long)userId.intValue() : 0L).setParameterList("threadIds", threadUidList);
            List results = query.list();
            topThreadObjects.addAll(results);
            return this.upgradeComments(topThreadObjects, sortBy);
        }
        return new TreeSet<Comment>();
    }
}

