/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.exception.GroupingException;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.MessageService;

public abstract class Grouper {
    private static Logger log = Logger.getLogger(Grouper.class);
    String DEFAULT_GROUP_NAME_PREFIX_I18N = "group.name.prefix";
    private MessageService commonMessageService;

    public void setCommonMessageService(MessageService commonMessageService) {
        this.commonMessageService = commonMessageService;
    }

    protected MessageService getCommonMessageService() {
        return this.commonMessageService;
    }

    public abstract void doGrouping(Grouping var1, String var2, List<User> var3) throws GroupingException;

    public abstract void doGrouping(Grouping var1, String var2, User var3) throws GroupingException;

    public abstract void doGrouping(Grouping var1, Long var2, List<User> var3) throws GroupingException;

    public String getPrefix() {
        String prefix = this.commonMessageService != null ? this.commonMessageService.getMessage(this.DEFAULT_GROUP_NAME_PREFIX_I18N) : "";
        prefix = prefix.trim();
        return prefix.length() > 0 ? prefix : "Group";
    }

    public void removeLearnersFromGroup(Grouping grouping, Long groupID, List<User> learners) throws GroupingException {
        Set groups = grouping.getGroups();
        Iterator iter = groups.iterator();
        boolean groupFound = false;
        while (iter.hasNext() && !groupFound) {
            Group group = (Group)iter.next();
            if (groupID != null && !groupID.equals(group.getGroupId())) continue;
            boolean bl = groupFound = groupID != null;
            if (group.mayBeDeleted()) {
                boolean removed = group.getUsers().removeAll(learners);
                if (!removed || !log.isDebugEnabled()) continue;
                log.debug((Object)("Removed " + learners.size() + " users from group " + group.getGroupName()));
                continue;
            }
            String error = "Tried to remove a group which cannot be removed (tool sessions probably exist). Group " + group + " grouping " + grouping + ". Not removing the group.";
            log.error((Object)error);
            throw new GroupingException(error);
        }
    }

    public Group createGroup(Grouping grouping, String name) throws GroupingException {
        String trimmedName = name.trim();
        if (trimmedName == null || trimmedName.length() == 0) {
            log.warn((Object)("Tried to add a group with no name to grouping " + grouping + ". Not creating group."));
            return null;
        }
        HashSet emptySet = new HashSet();
        Group newGroup = Group.createLearnerGroup(grouping, trimmedName, emptySet);
        if (newGroup == null) {
            trimmedName = trimmedName + " " + new Long(System.currentTimeMillis()).toString();
            newGroup = Group.createLearnerGroup(grouping, trimmedName, emptySet);
        }
        if (newGroup == null) {
            log.warn((Object)("Having trouble creating a unique name for a group. Have tried " + trimmedName));
            int attempt = 1;
            while (newGroup == null && attempt < 5) {
                newGroup = Group.createLearnerGroup(grouping, trimmedName + " " + new Integer(attempt).toString(), emptySet);
            }
            if (newGroup == null) {
                String error = "Unable to create a unique name for a group. Tried 5 variations on " + trimmedName + " now giving up.";
                log.error((Object)error);
                throw new GroupingException(error);
            }
        }
        if (newGroup != null) {
            grouping.getGroups().add(newGroup);
        }
        return newGroup;
    }

    public void removeGroup(Grouping grouping, Long groupID) throws GroupingException {
        Iterator iter = grouping.getGroups().iterator();
        boolean groupDeleted = false;
        while (!groupDeleted && iter.hasNext()) {
            Group group = (Group)iter.next();
            if (!group.getGroupId().equals(groupID)) continue;
            if (group.mayBeDeleted()) {
                if (log.isDebugEnabled()) {
                    log.warn((Object)("Deleting group " + group.getGroupName() + " for grouping " + grouping));
                }
                iter.remove();
                groupDeleted = true;
                continue;
            }
            String error = "Tried to remove a group which cannot be removed (tool sessions probably exist). Group " + group + " grouping " + grouping + ". Not removing the group.";
            log.error((Object)error);
            throw new GroupingException(error);
        }
        if (!groupDeleted) {
            log.warn((Object)("Tried to remove a group " + groupID + " but the group does not exist for grouping " + grouping + "."));
        }
    }
}

