/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dao.hibernate;

import java.util.Set;
import org.hibernate.Query;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.learningdesign.Competence;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.dao.ICompetenceDAO;

public class CompetenceDAO
extends BaseDAO
implements ICompetenceDAO {
    private static final String LOAD_COMPETENCE_BY_LDID_AND_TITLE = "from lams_competence in class " + Competence.class.getName() + " where title=? AND learning_design_id=?";

    @Override
    public void saveOrUpdate(Competence competence) {
        this.getHibernateTemplate().saveOrUpdate((Object)competence);
    }

    @Override
    public Competence getCompetence(LearningDesign design, String competenceTitle) {
        if (design != null && competenceTitle != null) {
            Long designID = design.getLearningDesignId();
            Query query = this.getSession().createQuery(LOAD_COMPETENCE_BY_LDID_AND_TITLE);
            query.setString(0, competenceTitle);
            query.setLong(1, designID.longValue());
            return (Competence)query.uniqueResult();
        }
        return null;
    }

    @Override
    public void delete(Competence competence) {
        this.getHibernateTemplate().delete((Object)competence);
    }

    @Override
    public void deleteAll(Set<Competence> competences) {
        this.getHibernateTemplate().deleteAll(competences);
    }
}

