/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dao.hibernate;

import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.lamsfoundation.lams.authoring.web.AuthoringAction;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningDesignAccess;
import org.lamsfoundation.lams.learningdesign.dao.ILearningDesignDAO;

public class LearningDesignDAO
extends BaseDAO
implements ILearningDesignDAO {
    private static Logger log = Logger.getLogger(AuthoringAction.class);
    private static final String TABLENAME = "lams_learning_design";
    private static final String VALID_IN_FOLDER = "from lams_learning_design in class " + LearningDesign.class.getName() + " where valid_design_flag=true AND workspace_folder_id=? AND removed=0";
    private static final String ALL_IN_FOLDER = "from lams_learning_design in class " + LearningDesign.class.getName() + " where workspace_folder_id=? AND removed=0";
    private static final String FIND_BY_ORIGINAL = "from lams_learning_design in class " + LearningDesign.class.getName() + " where original_learning_design_id=? AND removed=0";
    private static final String FIND_LD_NAMES_IN_FOLDER = "select title from " + LearningDesign.class.getName() + " where workspace_folder_id=? AND title like ? AND removed=0";
    private static final String ACCESS_BY_USER = "from " + LearningDesignAccess.class.getName() + " as a where a.userId = ? order by a.accessDate desc";

    @Override
    public LearningDesign getLearningDesignById(Long learningDesignId) {
        LearningDesign design = (LearningDesign)super.find(LearningDesign.class, learningDesignId);
        return design != null && design.getRemoved() == false ? design : null;
    }

    @Override
    public List getAllValidLearningDesignsInFolder(Integer workspaceFolderID) {
        return this.getHibernateTemplate().find(VALID_IN_FOLDER, (Object)workspaceFolderID);
    }

    @Override
    public List getAllLearningDesignsInFolder(Integer workspaceFolderID) {
        return this.getHibernateTemplate().find(ALL_IN_FOLDER, (Object)workspaceFolderID);
    }

    @Override
    public List getLearningDesignsByOriginalDesign(Long originalDesignID) {
        log.error((Object)"getLearningDesignsByOriginalDesign called");
        List list = this.getHibernateTemplate().find(FIND_BY_ORIGINAL, (Object)originalDesignID);
        return list;
    }

    @Override
    public List getLearningDesignTitlesByWorkspaceFolder(Integer workspaceFolderID, String prefix) {
        return this.getHibernateTemplate().find(FIND_LD_NAMES_IN_FOLDER, new Object[]{workspaceFolderID, prefix + "%"});
    }

    @Override
    public List<LearningDesignAccess> getAccessByUser(Integer userId) {
        return this.getHibernateTemplate().find(ACCESS_BY_USER, (Object)userId);
    }

    @Override
    public List<LearningDesign> getAllPagedLearningDesigns(Integer workspaceFolderID, Integer page, Integer size, String sortName, String sortDate) {
        String sortingOrder = this.setupSortString(sortName, sortDate);
        Query query = this.getSession().createQuery(ALL_IN_FOLDER + sortingOrder).setParameter(0, (Object)workspaceFolderID.longValue());
        if (page != null && size != null) {
            query.setFirstResult(page * size).setMaxResults(size.intValue());
        }
        return query.list();
    }

    @Override
    public List<LearningDesign> getValidPagedLearningDesigns(Integer workspaceFolderID, Integer page, Integer size, String sortName, String sortDate) {
        String sortingOrder = this.setupSortString(sortName, sortDate);
        Query query = this.getSession().createQuery(VALID_IN_FOLDER + sortingOrder).setParameter(0, (Object)workspaceFolderID.longValue());
        if (page != null && size != null) {
            query.setFirstResult(page * size).setMaxResults(size.intValue());
        }
        return query.list();
    }

    private String setupSortString(String sortName, String sortDate) {
        if (sortName != null && sortDate != null) {
            return " order by title " + sortName + ", last_modified_date_time " + sortDate;
        }
        if (sortDate != null) {
            return " order by last_modified_date_time " + sortDate;
        }
        return " order by title " + (sortName != null ? sortName : "ASC");
    }

    @Override
    public long countAllLearningDesigns(Integer workspaceFolderID, boolean validDesignsOnly) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("workspaceFolder.workspaceFolderId", workspaceFolderID);
        properties.put("removed", Boolean.FALSE);
        if (validDesignsOnly) {
            properties.put("validDesign", validDesignsOnly);
        }
        return this.countByProperties(LearningDesign.class, properties);
    }

    @Override
    public void delete(Object object) {
        LearningDesign design = (LearningDesign)object;
        log.debug((Object)("Removing learning design " + design));
        if (design != null && !design.getRemoved().booleanValue()) {
            design.setRemoved(Boolean.TRUE);
            this.update(design);
        }
    }
}

