/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.lesson.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.dao.IBaseDAO;
import org.lamsfoundation.lams.index.IndexLessonBean;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouper;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.dao.IGroupingDAO;
import org.lamsfoundation.lams.learningdesign.exception.GroupingException;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.LessonClass;
import org.lamsfoundation.lams.lesson.dao.ILearnerProgressDAO;
import org.lamsfoundation.lams.lesson.dao.ILessonClassDAO;
import org.lamsfoundation.lams.lesson.dao.ILessonDAO;
import org.lamsfoundation.lams.lesson.dto.LessonDTO;
import org.lamsfoundation.lams.lesson.dto.LessonDetailsDTO;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.lesson.service.LessonServiceException;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.MessageService;

public class LessonService
implements ILessonService {
    private static Logger log = Logger.getLogger(LessonService.class);
    private ILessonDAO lessonDAO;
    private ILessonClassDAO lessonClassDAO;
    private IGroupingDAO groupingDAO;
    private MessageService messageService;
    private IBaseDAO baseDAO;
    private ILearnerProgressDAO learnerProgressDAO;

    public void setLessonDAO(ILessonDAO lessonDAO) {
        this.lessonDAO = lessonDAO;
    }

    public void setLessonClassDAO(ILessonClassDAO lessonClassDAO) {
        this.lessonClassDAO = lessonClassDAO;
    }

    public void setGroupingDAO(IGroupingDAO groupingDAO) {
        this.groupingDAO = groupingDAO;
    }

    public void setLearnerProgressDAO(ILearnerProgressDAO learnerProgressDAO) {
        this.learnerProgressDAO = learnerProgressDAO;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public void setBaseDAO(IBaseDAO baseDAO) {
        this.baseDAO = baseDAO;
    }

    @Override
    public List getActiveLessonLearners(Long lessonId) {
        return this.lessonDAO.getActiveLearnerByLesson(lessonId);
    }

    @Override
    public Integer getCountActiveLessonLearners(Long lessonId) {
        return this.lessonDAO.getCountActiveLearnerByLesson(lessonId);
    }

    @Override
    public List<User> getLessonLearners(Long lessonId, String searchPhrase, Integer limit, Integer offset, boolean orderAscending) {
        return this.lessonDAO.getLearnersByLesson(lessonId, searchPhrase, limit, offset, orderAscending);
    }

    @Override
    public Map<User, Boolean> getUsersWithLessonParticipation(Long lessonId, String role, String searchPhrase, Integer limit, Integer offset, boolean orderAscending) {
        return this.lessonDAO.getUsersWithLessonParticipation(lessonId, role, searchPhrase, limit, offset, orderAscending);
    }

    @Override
    public Integer getCountLessonLearners(Long lessonId, String searchPhrase) {
        return this.lessonDAO.getCountLearnersByLesson(lessonId, searchPhrase);
    }

    @Override
    public LessonDetailsDTO getLessonDetails(Long lessonId) {
        Lesson lesson = this.lessonDAO.getLesson(lessonId);
        LessonDetailsDTO dto = null;
        if (lesson != null) {
            dto = lesson.getLessonDetails();
            Integer active = this.getCountActiveLessonLearners(lessonId);
            dto.setNumberStartedLearners(active != null ? active : new Integer(0));
        }
        return dto;
    }

    @Override
    public LessonDTO getLessonData(Long lessonId) {
        Lesson lesson = this.lessonDAO.getLesson(lessonId);
        LessonDTO dto = null;
        if (lesson != null) {
            dto = lesson.getLessonData();
        }
        return dto;
    }

    @Override
    public Lesson getLesson(Long lessonId) {
        return this.lessonDAO.getLesson(lessonId);
    }

    @Override
    public void performGrouping(Long lessonId, GroupingActivity groupingActivity, User learner) throws LessonServiceException {
        Grouping grouping = groupingActivity.getCreateGrouping();
        if (grouping != null && grouping.isRandomGrouping()) {
            Grouper grouper = (grouping = this.groupingDAO.getGroupingById(grouping.getGroupingId())).getGrouper();
            if (grouper != null) {
                grouper.setCommonMessageService(this.messageService);
                try {
                    if (grouping.getGroups().size() == 0) {
                        List usersInLesson = this.getActiveLessonLearners(lessonId);
                        grouper.doGrouping(grouping, (String)null, (List<User>)usersInLesson);
                    } else if (!grouping.doesLearnerExist(learner)) {
                        grouper.doGrouping(grouping, null, learner);
                    }
                }
                catch (GroupingException e) {
                    throw new LessonServiceException(e);
                }
                this.groupingDAO.update(grouping);
            }
        } else {
            String error = "The method performGrouping supports only grouping methods where the grouper decides the groups (currently only RandomGrouping). Called with a groupingActivity with the wrong grouper " + groupingActivity.getActivityId();
            log.error((Object)error);
            throw new LessonServiceException(error);
        }
    }

    @Override
    public void performGrouping(GroupingActivity groupingActivity, String groupName, List learners) throws LessonServiceException {
        Grouping grouping = groupingActivity.getCreateGrouping();
        this.performGrouping(grouping, groupName, learners);
    }

    @Override
    public void performGrouping(Grouping grouping, String groupName, List learners) throws LessonServiceException {
        Grouper grouper;
        if (grouping != null && (grouper = (grouping = this.groupingDAO.getGroupingById(grouping.getGroupingId())).getGrouper()) != null) {
            grouper.setCommonMessageService(this.messageService);
            try {
                grouper.doGrouping(grouping, groupName, (List<User>)learners);
            }
            catch (GroupingException e) {
                throw new LessonServiceException(e);
            }
            this.groupingDAO.update(grouping);
        }
    }

    @Override
    public void performGrouping(Grouping grouping, Long groupId, User learner) throws LessonServiceException {
        Grouper grouper;
        if (grouping != null && (grouper = (grouping = this.groupingDAO.getGroupingById(grouping.getGroupingId())).getGrouper()) != null) {
            grouper.setCommonMessageService(this.messageService);
            try {
                ArrayList<User> learners = new ArrayList<User>(1);
                learners.add(learner);
                grouper.doGrouping(grouping, groupId, learners);
            }
            catch (GroupingException e) {
                throw new LessonServiceException(e);
            }
            this.groupingDAO.update(grouping);
        }
    }

    @Override
    public void performGrouping(Grouping grouping, Long groupId, List learners) throws LessonServiceException {
        if (grouping != null) {
            Grouper grouper = grouping.getGrouper();
            if (grouper != null) {
                grouper.setCommonMessageService(this.messageService);
                try {
                    grouper.doGrouping(grouping, groupId, (List<User>)learners);
                }
                catch (GroupingException e) {
                    throw new LessonServiceException(e);
                }
                this.groupingDAO.update(grouping);
            }
        } else {
            String error = "The method performChosenGrouping supports only grouping methods where the supplied list should be used as a single group (currently only ChosenGrouping). Called with a grouping with the wrong grouper " + grouping;
            log.error((Object)error);
            throw new LessonServiceException(error);
        }
    }

    @Override
    public void removeLearnersFromGroup(Grouping grouping, Long groupID, List<User> learners) throws LessonServiceException {
        if (grouping != null) {
            Grouper grouper = (grouping = this.groupingDAO.getGroupingById(grouping.getGroupingId())).getGrouper();
            if (grouper != null) {
                try {
                    grouper.removeLearnersFromGroup(grouping, groupID, learners);
                }
                catch (GroupingException e) {
                    throw new LessonServiceException(e);
                }
            }
            this.groupingDAO.update(grouping);
        }
    }

    @Override
    public Group createGroup(Grouping grouping, String name) throws LessonServiceException {
        Group newGroup = null;
        if (grouping != null) {
            Grouper grouper = (grouping = this.groupingDAO.getGroupingById(grouping.getGroupingId())).getGrouper();
            if (grouper != null) {
                try {
                    newGroup = grouper.createGroup(grouping, name);
                }
                catch (GroupingException e) {
                    throw new LessonServiceException(e);
                }
            }
            this.groupingDAO.update(grouping);
        }
        return newGroup;
    }

    @Override
    public void removeGroup(Grouping grouping, Long groupID) throws LessonServiceException {
        if (grouping != null) {
            Grouper grouper = (grouping = this.groupingDAO.getGroupingById(grouping.getGroupingId())).getGrouper();
            if (grouper != null) {
                try {
                    grouper.removeGroup(grouping, groupID);
                }
                catch (GroupingException e) {
                    throw new LessonServiceException(e);
                }
            }
            this.groupingDAO.update(grouping);
        }
    }

    @Override
    public boolean addLearner(Long lessonId, Integer userId) throws LessonServiceException {
        User user;
        boolean ret;
        Lesson lesson = this.lessonDAO.getLesson(lessonId);
        if (lesson == null) {
            throw new LessonServiceException("Lesson " + lessonId + " does not exist. Unable to add learner to lesson.");
        }
        LessonClass lessonClass = lesson.getLessonClass();
        if (lessonClass == null) {
            throw new LessonServiceException("Lesson class for " + lessonId + " does not exist. Unable to add learner to lesson.");
        }
        Group learnersGroup = lessonClass.getLearnersGroup();
        if (learnersGroup != null) {
            this.lessonDAO.initialize(learnersGroup);
        }
        if (ret = lessonClass.addLearner(user = (User)this.baseDAO.find(User.class, userId))) {
            this.lessonClassDAO.updateLessonClass(lessonClass);
        }
        return ret;
    }

    @Override
    public boolean removeLearner(Long lessonId, Integer userId) {
        User user;
        Lesson lesson = this.lessonDAO.getLesson(lessonId);
        LessonClass lessonClass = lesson.getLessonClass();
        Group learnerGroup = lessonClass.getGroupBy(user = (User)this.baseDAO.find(User.class, userId));
        boolean result = learnerGroup.getUsers().remove(user);
        if (result) {
            this.lessonClassDAO.updateLessonClass(lessonClass);
        }
        return result;
    }

    @Override
    public void addLearners(Long lessonId, Integer[] userIds) throws LessonServiceException {
        Lesson lesson = this.lessonDAO.getLesson(lessonId);
        if (lesson == null) {
            throw new LessonServiceException("Lesson " + lessonId + " does not exist. Unable to add learner to lesson.");
        }
        LessonClass lessonClass = lesson.getLessonClass();
        if (lessonClass == null) {
            throw new LessonServiceException("Lesson class for " + lessonId + " does not exist. Unable to add learner to lesson.");
        }
        Group learnersGroup = lessonClass.getLearnersGroup();
        if (learnersGroup != null) {
            this.lessonDAO.initialize(learnersGroup);
        }
        HashSet<User> users = new HashSet<User>();
        for (Integer userId : userIds) {
            User user = (User)this.baseDAO.find(User.class, userId);
            users.add(user);
        }
        this.addLearners(lesson, users);
    }

    @Override
    public void addLearners(Lesson lesson, Collection<User> users) throws LessonServiceException {
        LessonClass lessonClass = lesson.getLessonClass();
        int numAdded = lessonClass.addLearners(users);
        if (numAdded > 0) {
            this.lessonClassDAO.updateLessonClass(lessonClass);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added " + numAdded + " learners to lessonClass " + lessonClass.getGroupingId()));
        }
    }

    @Override
    public void setLearners(Lesson lesson, Collection<User> users) throws LessonServiceException {
        LessonClass lessonClass = lesson.getLessonClass();
        int numberOfLearners = lessonClass.setLearners(users);
        this.lessonClassDAO.updateLessonClass(lessonClass);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set " + numberOfLearners + " learners in lessonClass " + lessonClass.getGroupingId()));
        }
    }

    @Override
    public boolean addStaffMember(Long lessonId, Integer userId) {
        Lesson lesson = this.lessonDAO.getLesson(lessonId);
        if (lesson == null) {
            throw new LessonServiceException("Lesson " + lessonId + " does not exist. Unable to add staff member to lesson.");
        }
        LessonClass lessonClass = lesson.getLessonClass();
        if (lessonClass == null) {
            throw new LessonServiceException("Lesson class for " + lessonId + " does not exist. Unable to add staff member to lesson.");
        }
        this.lessonDAO.initialize(lessonClass.getStaffGroup());
        User user = (User)this.baseDAO.find(User.class, userId);
        boolean ret = lessonClass.addStaffMember(user);
        if (ret) {
            this.lessonClassDAO.updateLessonClass(lessonClass);
        }
        return ret;
    }

    @Override
    public boolean removeStaffMember(Long lessonId, Integer userId) {
        Lesson lesson = this.lessonDAO.getLesson(lessonId);
        LessonClass lessonClass = lesson.getLessonClass();
        User user = (User)this.baseDAO.find(User.class, userId);
        Group staffGroup = lessonClass.getStaffGroup();
        boolean result = staffGroup.getUsers().remove(user);
        if (result) {
            this.lessonClassDAO.updateLessonClass(lessonClass);
        }
        return result;
    }

    @Override
    public void addStaffMembers(Long lessonId, Integer[] userIds) throws LessonServiceException {
        Lesson lesson = this.lessonDAO.getLesson(lessonId);
        if (lesson == null) {
            throw new LessonServiceException("Lesson " + lessonId + " does not exist. Unable to add learner to lesson.");
        }
        LessonClass lessonClass = lesson.getLessonClass();
        if (lessonClass == null) {
            throw new LessonServiceException("Lesson class for " + lessonId + " does not exist. Unable to add learner to lesson.");
        }
        this.lessonDAO.initialize(lessonClass.getStaffGroup());
        HashSet<User> users = new HashSet<User>();
        for (Integer userId : userIds) {
            User user = (User)this.baseDAO.find(User.class, userId);
            users.add(user);
        }
        this.addStaffMembers(lesson, users);
    }

    @Override
    public void addStaffMembers(Lesson lesson, Collection<User> users) throws LessonServiceException {
        LessonClass lessonClass = lesson.getLessonClass();
        int numAdded = lessonClass.addStaffMembers(users);
        if (numAdded > 0) {
            this.lessonClassDAO.updateLessonClass(lessonClass);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added " + numAdded + " staff members to lessonClass " + lessonClass.getGroupingId()));
        }
    }

    @Override
    public void setStaffMembers(Lesson lesson, Collection<User> users) throws LessonServiceException {
        LessonClass lessonClass = lesson.getLessonClass();
        int numberOfStaff = lessonClass.setStaffMembers(users);
        this.lessonClassDAO.updateLessonClass(lessonClass);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set " + numberOfStaff + " staff members in lessonClass " + lessonClass.getGroupingId()));
        }
    }

    @Override
    public void removeProgressReferencesToActivity(Activity activity) {
        if (activity != null) {
            log.debug((Object)("Processing learner progress for activity " + activity.getActivityId()));
            List<LearnerProgress> progresses = this.learnerProgressDAO.getLearnerProgressReferringToActivity(activity);
            if (progresses != null) {
                for (LearnerProgress progress : progresses) {
                    boolean removed;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Processing learner progress learner " + progress.getUser().getUserId()));
                    }
                    boolean recordUpdated = false;
                    boolean bl = removed = progress.getAttemptedActivities().remove(activity) != null;
                    if (removed) {
                        recordUpdated = true;
                        log.debug((Object)"Removed activity from attempted activities");
                    }
                    boolean bl2 = removed = progress.getCompletedActivities().remove(activity) != null;
                    if (removed) {
                        recordUpdated = true;
                        log.debug((Object)"Removed activity from completed activities");
                    }
                    if (progress.getCurrentActivity() != null && progress.getCurrentActivity().equals(activity)) {
                        progress.setCurrentActivity(null);
                        recordUpdated = true;
                        log.debug((Object)"Removed activity as current activity");
                    }
                    if (progress.getNextActivity() != null && progress.getNextActivity().equals(activity)) {
                        progress.setNextActivity(null);
                        recordUpdated = true;
                        log.debug((Object)"Removed activity as next activity");
                    }
                    if (progress.getPreviousActivity() != null && progress.getPreviousActivity().equals(activity)) {
                        progress.setPreviousActivity(null);
                        recordUpdated = true;
                        log.debug((Object)"Removed activity as previous activity");
                    }
                    if (!recordUpdated) continue;
                    this.learnerProgressDAO.updateLearnerProgress(progress);
                }
            }
        }
    }

    @Override
    public void removeLearnerProgress(Long lessonId, Integer userId) {
        LearnerProgress learnerProgress = this.getUserProgressForLesson(userId, lessonId);
        if (learnerProgress != null) {
            this.learnerProgressDAO.deleteLearnerProgress(learnerProgress);
        }
    }

    @Override
    public void performMarkLessonUncompleted(Long lessonId, Long firstAddedActivityId) throws LessonServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting learner progress to uncompleted for lesson " + lessonId));
        }
        int count = 0;
        List<LearnerProgress> progresses = this.learnerProgressDAO.getCompletedLearnerProgressForLesson(lessonId, null, null, true);
        Activity firstAddedActivity = (Activity)this.baseDAO.find(Activity.class, firstAddedActivityId);
        for (LearnerProgress progress : progresses) {
            if (progress.getLessonComplete() != 1) continue;
            progress.setLessonComplete((byte)0);
            progress.setFinishDate(null);
            progress.setCurrentActivity(firstAddedActivity);
            progress.setNextActivity(firstAddedActivity);
            ++count;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reset completed flag for " + count + " learners for lesson " + lessonId));
        }
    }

    @Override
    public List<User> getLearnersAttemptedOrCompletedActivity(Activity activity) throws LessonServiceException {
        return this.learnerProgressDAO.getLearnersAttemptedOrCompletedActivity(activity);
    }

    @Override
    public Integer getCountLearnersHaveAttemptedActivity(Activity activity) throws LessonServiceException {
        return this.learnerProgressDAO.getNumUsersAttemptedActivity(activity);
    }

    @Override
    public Map<Long, IndexLessonBean> getLessonsByOrgAndUserWithCompletedFlag(Integer userId, Integer orgId, Integer userRole) {
        TreeMap<Long, IndexLessonBean> map = new TreeMap<Long, IndexLessonBean>();
        List list = this.lessonDAO.getLessonsByOrgAndUserWithCompletedFlag(userId, orgId, userRole);
        if (list != null) {
            for (Object[] tuple : list) {
                Long lessonId = (Long)tuple[0];
                String lessonName = (String)tuple[1];
                String lessonDescription = (String)tuple[2];
                Integer lessonState = (Integer)tuple[3];
                Boolean lessonCompleted = (Boolean)tuple[4];
                lessonCompleted = lessonCompleted == null ? false : lessonCompleted;
                Boolean enableLessonNotifications = (Boolean)tuple[5];
                enableLessonNotifications = enableLessonNotifications == null ? false : enableLessonNotifications;
                Boolean dependent = (Boolean)tuple[6];
                dependent = dependent == null ? false : dependent;
                Boolean scheduledFinish = (Boolean)tuple[7];
                IndexLessonBean bean = new IndexLessonBean(lessonId, lessonName, lessonDescription, lessonState, lessonCompleted, enableLessonNotifications, dependent, scheduledFinish);
                map.put(new Long(lessonId), bean);
            }
        }
        return map;
    }

    @Override
    public List<Lesson> getLessonsByGroupAndUser(Integer userId, Integer organisationId) {
        List list = this.lessonDAO.getLessonsByGroupAndUser(userId, organisationId);
        return list;
    }

    @Override
    public List<Lesson> getLessonsByGroup(Integer organisationId) {
        List list = this.lessonDAO.getLessonsByGroup(organisationId);
        return list;
    }

    @Override
    public LearnerProgress getUserProgressForLesson(Integer learnerId, Long lessonId) {
        return this.learnerProgressDAO.getLearnerProgressByLearner(learnerId, lessonId);
    }

    @Override
    public List<LearnerProgress> getUserProgressForLesson(Long lessonId) {
        List<LearnerProgress> list = this.learnerProgressDAO.getLearnerProgressForLesson(lessonId);
        return list;
    }

    @Override
    public List getLessonsByOriginalLearningDesign(Long ldId, Integer orgId) {
        return this.lessonDAO.getLessonsByOriginalLearningDesign(ldId, orgId);
    }

    @Override
    public List<User> getMonitorsByToolSessionId(Long sessionId) {
        return this.lessonDAO.getMonitorsByToolSessionId(sessionId);
    }

    @Override
    public boolean checkLessonReleaseConditions(Long lessonId, Integer learnerId) {
        Lesson lesson = this.getLesson(lessonId);
        if (lesson != null) {
            for (Lesson precedingLesson : lesson.getPrecedingLessons()) {
                LearnerProgress progress = this.getUserProgressForLesson(learnerId, precedingLesson.getLessonId());
                if (progress != null && progress.isComplete()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Set<Lesson> getReleasedSucceedingLessons(Long completedLessonId, Integer learnerId) {
        HashSet<Lesson> releasedSucceedingLessons = new HashSet<Lesson>();
        Lesson lesson = this.getLesson(completedLessonId);
        if (lesson != null) {
            for (Lesson succeedingLesson : lesson.getSucceedingLessons()) {
                if (!succeedingLesson.isLessonAccessibleForLearner() || !this.checkLessonReleaseConditions(succeedingLesson.getLessonId(), learnerId)) continue;
                releasedSucceedingLessons.add(succeedingLesson);
            }
        }
        return releasedSucceedingLessons;
    }

    @Override
    public void addPrecedingLesson(Long lessonId, Long precedingLessonId) {
        Lesson addedPrecedingLesson = this.getLesson(precedingLessonId);
        if (addedPrecedingLesson == null) {
            throw new IllegalArgumentException("Preceding lesson with ID: " + lessonId + " does not exist.");
        }
        Lesson lesson = this.getLesson(lessonId);
        lesson.getPrecedingLessons().add(addedPrecedingLesson);
    }

    @Override
    public void removePrecedingLesson(Long lessonId, Long precedingLessonId) {
        Lesson lesson = this.getLesson(lessonId);
        Iterator<Lesson> precedingLessonIter = lesson.getPrecedingLessons().iterator();
        while (precedingLessonIter.hasNext()) {
            if (!precedingLessonIter.next().getLessonId().equals(precedingLessonId)) continue;
            precedingLessonIter.remove();
            break;
        }
    }
}

