/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.rating.service;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.rating.dao.IRatingCommentDAO;
import org.lamsfoundation.lams.rating.dao.IRatingCriteriaDAO;
import org.lamsfoundation.lams.rating.dao.IRatingDAO;
import org.lamsfoundation.lams.rating.dto.ItemRatingCriteriaDTO;
import org.lamsfoundation.lams.rating.dto.ItemRatingDTO;
import org.lamsfoundation.lams.rating.dto.RatingCommentDTO;
import org.lamsfoundation.lams.rating.dto.RatingDTO;
import org.lamsfoundation.lams.rating.model.LearnerItemRatingCriteria;
import org.lamsfoundation.lams.rating.model.Rating;
import org.lamsfoundation.lams.rating.model.RatingComment;
import org.lamsfoundation.lams.rating.model.RatingCriteria;
import org.lamsfoundation.lams.rating.service.IRatingService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;

public class RatingService
implements IRatingService {
    private static Logger log = Logger.getLogger(RatingService.class);
    private IRatingDAO ratingDAO;
    private IRatingCommentDAO ratingCommentDAO;
    private IRatingCriteriaDAO ratingCriteriaDAO;
    protected IUserManagementService userManagementService;
    protected MessageService messageService;

    @Override
    public Rating getRatingByItemAndUser(Long itemId, Integer userId) {
        return null;
    }

    @Override
    public List<Rating> getRatingsByItem(Long itemId) {
        return null;
    }

    @Override
    public int getCountItemsRatedByUser(Long toolContentId, Integer userId) {
        return this.ratingDAO.getCountItemsRatedByUser(toolContentId, userId);
    }

    @Override
    public Map<Long, Long> countUsersRatedEachItem(Long contentId, Collection<Long> itemIds, Integer excludeUserId) {
        return this.ratingDAO.countUsersRatedEachItem(contentId, itemIds, excludeUserId);
    }

    @Override
    public void saveOrUpdateRating(Rating rating) {
        this.ratingDAO.saveOrUpdate(rating);
    }

    @Override
    public ItemRatingCriteriaDTO rateItem(RatingCriteria ratingCriteria, Integer userId, Long itemId, float ratingFloat) {
        Long ratingCriteriaId = ratingCriteria.getRatingCriteriaId();
        Rating rating = this.ratingDAO.getRating(ratingCriteriaId, userId, itemId);
        if (rating == null) {
            rating = new Rating();
            rating.setItemId(itemId);
            User learner = (User)this.userManagementService.findById(User.class, userId);
            rating.setLearner(learner);
            rating.setRatingCriteria(ratingCriteria);
        }
        rating.setRating(ratingFloat);
        this.ratingDAO.saveOrUpdate(rating);
        return this.ratingDAO.getRatingAverageDTOByItem(ratingCriteriaId, itemId);
    }

    @Override
    public void commentItem(RatingCriteria ratingCriteria, Integer userId, Long itemId, String comment) {
        RatingComment ratingComment = this.ratingCommentDAO.getComment(ratingCriteria.getRatingCriteriaId(), userId, itemId);
        if (ratingComment == null) {
            ratingComment = new RatingComment();
            ratingComment.setItemId(itemId);
            User learner = (User)this.userManagementService.findById(User.class, userId);
            ratingComment.setLearner(learner);
            ratingComment.setRatingCriteria(ratingCriteria);
        }
        ratingComment.setComment(comment);
        this.ratingDAO.saveOrUpdate(ratingComment);
    }

    @Override
    public List<ItemRatingDTO> getRatingCriteriaDtos(Long contentId, Collection<Long> itemIds, boolean isCommentsByOtherUsersRequired, Long userId) {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        numberFormat.setMaximumFractionDigits(1);
        List<RatingCriteria> criterias = this.getCriteriasByToolContentId(contentId);
        boolean isSingleItem = itemIds.size() == 1;
        Long singleItemId = isSingleItem ? itemIds.iterator().next() : null;
        List<ItemRatingDTO> itemDtos = this.handleCommentsCriteria(criterias, itemIds, isCommentsByOtherUsersRequired, userId);
        List<Rating> userRatings = this.ratingDAO.getRatingsByUser(contentId, userId.intValue());
        List<Object[]> itemsStatistics = isSingleItem ? this.ratingDAO.getRatingAverageByContentAndItem(contentId, singleItemId) : this.ratingDAO.getRatingAverageByContentAndItems(contentId, itemIds);
        for (ItemRatingDTO itemDto : itemDtos) {
            Long itemId = itemDto.getItemId();
            LinkedList<ItemRatingCriteriaDTO> criteriaDtos = new LinkedList<ItemRatingCriteriaDTO>();
            itemDto.setCriteriaDtos(criteriaDtos);
            for (RatingCriteria criteria : criterias) {
                Long criteriaId = criteria.getRatingCriteriaId();
                if (criteria.isCommentsEnabled()) continue;
                ItemRatingCriteriaDTO criteriaDto = new ItemRatingCriteriaDTO();
                criteriaDto.setRatingCriteria(criteria);
                Rating userRating = null;
                for (Rating userRatingIter : userRatings) {
                    if (!userRatingIter.getItemId().equals(itemId) || !userRatingIter.getRatingCriteria().getRatingCriteriaId().equals(criteriaId)) continue;
                    userRating = userRatingIter;
                }
                String userRatingStr = userRating == null ? "" : numberFormat.format(userRating.getRating());
                criteriaDto.setUserRating(userRatingStr);
                Object[] itemStatistics = null;
                for (Object[] itemStatisticsIter : itemsStatistics) {
                    Long itemIdIter = (Long)itemStatisticsIter[0];
                    Long ratingCriteriaIdIter = (Long)itemStatisticsIter[1];
                    if (!itemIdIter.equals(itemId) || !ratingCriteriaIdIter.equals(criteriaId)) continue;
                    itemStatistics = itemStatisticsIter;
                }
                String averageRating = itemStatistics == null ? "0" : numberFormat.format(itemStatistics[2]);
                String numberOfVotes = itemStatistics == null ? "0" : String.valueOf(itemStatistics[3]);
                criteriaDto.setAverageRating(averageRating);
                criteriaDto.setNumberOfVotes(numberOfVotes);
                criteriaDtos.add(criteriaDto);
            }
        }
        return itemDtos;
    }

    private List<ItemRatingDTO> handleCommentsCriteria(List<RatingCriteria> criterias, Collection<Long> itemIds, boolean isCommentsByOtherUsersRequired, Long userId) {
        boolean isSingleItem = itemIds.size() == 1;
        Long singleItemId = isSingleItem ? itemIds.iterator().next() : null;
        LinkedList<ItemRatingDTO> itemDtos = new LinkedList<ItemRatingDTO>();
        for (Long itemId : itemIds) {
            ItemRatingDTO itemDto = new ItemRatingDTO();
            itemDto.setItemId(itemId);
            itemDtos.add(itemDto);
        }
        for (RatingCriteria criteria : criterias) {
            if (!criteria.isCommentsEnabled()) continue;
            Long commentCriteriaId = criteria.getRatingCriteriaId();
            List<RatingCommentDTO> commentDtos = isSingleItem ? this.ratingCommentDAO.getCommentsByCriteriaAndItem(commentCriteriaId, singleItemId) : (isCommentsByOtherUsersRequired ? this.ratingCommentDAO.getCommentsByCriteriaAndItems(commentCriteriaId, itemIds) : this.ratingCommentDAO.getCommentsByCriteriaAndItemsAndUser(commentCriteriaId, itemIds, userId.intValue()));
            for (ItemRatingDTO itemDto : itemDtos) {
                itemDto.setCommentsEnabled(true);
                itemDto.setCommentsCriteriaId(commentCriteriaId);
                itemDto.setCommentsMinWordsLimit(criteria.getCommentsMinWordsLimit());
                LinkedList<RatingCommentDTO> commentDtosPerItem = new LinkedList<RatingCommentDTO>();
                for (RatingCommentDTO commentDto : commentDtos) {
                    if (!commentDto.getItemId().equals(itemDto.getItemId())) continue;
                    commentDtosPerItem.add(commentDto);
                    if (!commentDto.getUserId().equals(userId)) continue;
                    itemDto.setCommentPostedByUser(commentDto);
                }
                itemDto.setCommentDtos(commentDtosPerItem);
            }
        }
        return itemDtos;
    }

    @Override
    public ItemRatingDTO getRatingCriteriaDtoWithActualRatings(Long contentId, Long itemId) {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        numberFormat.setMaximumFractionDigits(1);
        List<RatingCriteria> criterias = this.getCriteriasByToolContentId(contentId);
        List<Long> itemIds = Collections.singletonList(itemId);
        boolean isCommentsByOtherUsersRequired = false;
        Long userId = -1L;
        List<ItemRatingDTO> itemDtos = this.handleCommentsCriteria(criterias, itemIds, isCommentsByOtherUsersRequired, userId);
        ItemRatingDTO itemDto = itemDtos.get(0);
        List<Rating> itemRatings = this.ratingDAO.getRatingsByItem(contentId, itemId);
        LinkedList<ItemRatingCriteriaDTO> criteriaDtos = new LinkedList<ItemRatingCriteriaDTO>();
        for (RatingCriteria criteria : criterias) {
            Long criteriaId = criteria.getRatingCriteriaId();
            if (criteria.isCommentsEnabled()) continue;
            ItemRatingCriteriaDTO criteriaDto = new ItemRatingCriteriaDTO();
            criteriaDto.setRatingCriteria(criteria);
            ArrayList<RatingDTO> ratingDtos = new ArrayList<RatingDTO>();
            for (Rating itemRating : itemRatings) {
                if (!itemRating.getRatingCriteria().getRatingCriteriaId().equals(criteria.getRatingCriteriaId())) continue;
                RatingDTO ratingDto = new RatingDTO();
                String ratingStr = numberFormat.format(itemRating.getRating());
                ratingDto.setRating(ratingStr);
                ratingDto.setLearner(itemRating.getLearner());
                ratingDtos.add(ratingDto);
            }
            criteriaDto.setRatingDtos(ratingDtos);
            criteriaDtos.add(criteriaDto);
        }
        itemDto.setCriteriaDtos(criteriaDtos);
        return itemDto;
    }

    @Override
    public List<RatingCriteria> getCriteriasByToolContentId(Long toolContentId) {
        List<RatingCriteria> criterias = this.ratingCriteriaDAO.getByToolContentId(toolContentId);
        return criterias;
    }

    @Override
    public RatingCriteria getCriteriaByCriteriaId(Long ratingCriteriaId) {
        return this.ratingCriteriaDAO.getByRatingCriteriaId(ratingCriteriaId);
    }

    @Override
    public RatingCriteria getCriteriaByCriteriaId(Long ratingCriteriaId, Class clasz) {
        return this.ratingCriteriaDAO.getByRatingCriteriaId(ratingCriteriaId, clasz);
    }

    @Override
    public void saveRatingCriterias(HttpServletRequest request, Collection<RatingCriteria> oldCriterias, Long toolContentId) {
        HashMap<Integer, RatingCriteria> mapOrderIdToRatingCriteria = new HashMap<Integer, RatingCriteria>();
        for (RatingCriteria ratingCriteriaIter : oldCriterias) {
            mapOrderIdToRatingCriteria.put(ratingCriteriaIter.getOrderId(), ratingCriteriaIter);
        }
        int criteriaMaxOrderId = WebUtil.readIntParam(request, "criteriaMaxOrderId");
        for (int i = 1; i <= criteriaMaxOrderId; ++i) {
            String criteriaTitle = WebUtil.readStrParam(request, "criteriaTitle" + i, true);
            Object ratingCriteria = (RatingCriteria)mapOrderIdToRatingCriteria.get(i);
            if (StringUtils.isNotBlank((String)criteriaTitle)) {
                int newCriteriaOrderId = WebUtil.readIntParam(request, "criteriaOrderId" + i);
                if (ratingCriteria == null) {
                    ratingCriteria = new LearnerItemRatingCriteria();
                    ((RatingCriteria)ratingCriteria).setRatingCriteriaTypeId(3);
                    ((LearnerItemRatingCriteria)ratingCriteria).setToolContentId(toolContentId);
                }
                ((RatingCriteria)ratingCriteria).setOrderId(newCriteriaOrderId);
                ((RatingCriteria)ratingCriteria).setTitle(criteriaTitle);
                this.ratingCriteriaDAO.saveOrUpdate((RatingCriteria)ratingCriteria);
                continue;
            }
            if (ratingCriteria == null) continue;
            this.ratingCriteriaDAO.deleteRatingCriteria(((RatingCriteria)ratingCriteria).getRatingCriteriaId());
        }
        boolean isCommentsEnabled = WebUtil.readBooleanParam(request, "isCommentsEnabled", false);
        RatingCriteria commentsResponsibleCriteria = null;
        for (RatingCriteria ratingCriteriaIter : oldCriterias) {
            if (!ratingCriteriaIter.isCommentsEnabled()) continue;
            commentsResponsibleCriteria = ratingCriteriaIter;
            break;
        }
        if (isCommentsEnabled) {
            if (commentsResponsibleCriteria == null) {
                commentsResponsibleCriteria = new LearnerItemRatingCriteria();
                commentsResponsibleCriteria.setRatingCriteriaTypeId(3);
                ((LearnerItemRatingCriteria)commentsResponsibleCriteria).setToolContentId(toolContentId);
                commentsResponsibleCriteria.setOrderId(0);
                commentsResponsibleCriteria.setCommentsEnabled(true);
            }
            int commentsMinWordsLimit = WebUtil.readIntParam(request, "commentsMinWordsLimit");
            commentsResponsibleCriteria.setCommentsMinWordsLimit(commentsMinWordsLimit);
            this.ratingCriteriaDAO.saveOrUpdate(commentsResponsibleCriteria);
        } else if (commentsResponsibleCriteria != null) {
            this.ratingCriteriaDAO.deleteRatingCriteria(commentsResponsibleCriteria.getRatingCriteriaId());
        }
    }

    @Override
    public boolean isCommentsEnabled(Long toolContentId) {
        return this.ratingCriteriaDAO.isCommentsEnabledForToolContent(toolContentId);
    }

    @Override
    public int getCommentsMinWordsLimit(Long toolContentId) {
        return this.ratingCriteriaDAO.getCommentsMinWordsLimitForToolContent(toolContentId);
    }

    public void setRatingDAO(IRatingDAO ratingDAO) {
        this.ratingDAO = ratingDAO;
    }

    public void setRatingCommentDAO(IRatingCommentDAO ratingCommentDAO) {
        this.ratingCommentDAO = ratingCommentDAO;
    }

    public void setRatingCriteriaDAO(IRatingCriteriaDAO ratingCriteriaDAO) {
        this.ratingCriteriaDAO = ratingCriteriaDAO;
    }

    public void setUserManagementService(IUserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }
}

