/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.service;

import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ActivityEvaluation;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.tool.SystemTool;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.ToolAdapterContentManager;
import org.lamsfoundation.lams.tool.ToolContent;
import org.lamsfoundation.lams.tool.ToolContentIDGenerator;
import org.lamsfoundation.lams.tool.ToolContentManager;
import org.lamsfoundation.lams.tool.ToolOutput;
import org.lamsfoundation.lams.tool.ToolOutputDefinition;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.dao.ISystemToolDAO;
import org.lamsfoundation.lams.tool.dao.IToolContentDAO;
import org.lamsfoundation.lams.tool.dao.IToolSessionDAO;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.LamsToolServiceException;
import org.lamsfoundation.lams.tool.exception.RequiredGroupMissingException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.dao.DataIntegrityViolationException;

public class LamsCoreToolService
implements ILamsCoreToolService,
ApplicationContextAware {
    private static final Logger log = Logger.getLogger(LamsCoreToolService.class);
    private ApplicationContext context;
    private IToolSessionDAO toolSessionDAO;
    private ISystemToolDAO systemToolDAO;
    private ToolContentIDGenerator contentIDGenerator;
    protected IToolContentDAO toolContentDAO;
    private MessageService messageService;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void setToolSessionDAO(IToolSessionDAO toolSessionDAO) {
        this.toolSessionDAO = toolSessionDAO;
    }

    public ISystemToolDAO getSystemToolDAO() {
        return this.systemToolDAO;
    }

    public void setSystemToolDAO(ISystemToolDAO systemToolDAO) {
        this.systemToolDAO = systemToolDAO;
    }

    public void setContentIDGenerator(ToolContentIDGenerator contentIDGenerator) {
        this.contentIDGenerator = contentIDGenerator;
    }

    public void setToolContentDAO(IToolContentDAO toolContentDAO) {
        this.toolContentDAO = toolContentDAO;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    @Override
    public synchronized ToolSession createToolSession(User learner, ToolActivity activity, Lesson lesson) throws RequiredGroupMissingException, DataIntegrityViolationException {
        ToolSession toolSession = this.toolSessionDAO.getToolSessionByLearner(learner, activity);
        if (toolSession == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating tool session for [" + activity.getActivityId() + "," + activity.getTitle() + "] for learner [" + learner.getLogin() + "] lesson [" + lesson.getLessonId() + "," + lesson.getLessonName() + "]."));
            }
            toolSession = activity.createToolSessionForActivity(this.messageService, learner, lesson);
            this.toolSessionDAO.saveToolSession(toolSession);
            return toolSession;
        }
        return null;
    }

    @Override
    public ToolSession getToolSessionByLearner(User learner, Activity activity) throws LamsToolServiceException {
        return this.toolSessionDAO.getToolSessionByLearner(learner, activity);
    }

    @Override
    public ToolSession getToolSessionById(Long toolSessionId) {
        return this.toolSessionDAO.getToolSession(toolSessionId);
    }

    @Override
    public ToolSession getToolSessionByActivity(User learner, ToolActivity toolActivity) throws LamsToolServiceException {
        return this.toolSessionDAO.getToolSessionByLearner(learner, toolActivity);
    }

    @Override
    public void notifyToolsToCreateSession(ToolSession toolSession, ToolActivity activity) throws ToolException {
        try {
            ToolSessionManager sessionManager = (ToolSessionManager)this.findToolService(activity.getTool());
            sessionManager.createToolSession(toolSession.getToolSessionId(), toolSession.getToolSessionName(), activity.getToolContentId());
        }
        catch (NoSuchBeanDefinitionException e) {
            String message = "A tool which is defined in the database appears to missing from the classpath. Unable to create tool session. ToolActivity " + activity;
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
    }

    @Override
    public Long notifyToolToCopyContent(ToolActivity toolActivity, String customCSV) throws DataMissingException, ToolException {
        Long toolcontentID = toolActivity.getToolContentId();
        try {
            ToolContentManager contentManager = (ToolContentManager)this.findToolService(toolActivity.getTool());
            toolcontentID = this.contentIDGenerator.getNextToolContentIDFor(toolActivity.getTool());
            if (contentManager instanceof ToolAdapterContentManager) {
                ToolAdapterContentManager adapterContentManager = (ToolAdapterContentManager)contentManager;
                adapterContentManager.copyToolContent(toolActivity.getToolContentId(), toolcontentID, customCSV);
            } else {
                contentManager.copyToolContent(toolActivity.getToolContentId(), toolcontentID);
            }
        }
        catch (NoSuchBeanDefinitionException e) {
            String message = "A tool which is defined in the database appears to missing from the classpath. Unable to copy/update the tool content. ToolActivity " + toolActivity;
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
        return toolcontentID;
    }

    @Override
    public Long notifyToolToCopyContent(Long toolContentId, String customCSV) throws DataMissingException, ToolException {
        ToolContent toolContent = (ToolContent)this.toolContentDAO.find(ToolContent.class, toolContentId);
        if (toolContent == null) {
            String error = "The toolContentID " + toolContentId + " is not valid. No such record exists on the database.";
            log.error((Object)error);
            throw new DataMissingException(error);
        }
        Tool tool = toolContent.getTool();
        if (tool == null) {
            String error = "The tool for toolContentId " + toolContentId + " is missing.";
            log.error((Object)error);
            throw new DataMissingException(error);
        }
        Long newToolcontentID = this.contentIDGenerator.getNextToolContentIDFor(tool);
        try {
            ToolContentManager contentManager = (ToolContentManager)this.findToolService(tool);
            if (contentManager instanceof ToolAdapterContentManager) {
                ToolAdapterContentManager toolAdapterContentManager = (ToolAdapterContentManager)contentManager;
                toolAdapterContentManager.copyToolContent(toolContentId, newToolcontentID, customCSV);
            } else {
                contentManager.copyToolContent(toolContentId, newToolcontentID);
            }
        }
        catch (NoSuchBeanDefinitionException e) {
            String message = "A tool which is defined in the database appears to missing from the classpath. Unable to copy the tool content. ToolContentId " + toolContentId;
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
        return newToolcontentID;
    }

    @Override
    public void notifyToolToDeleteContent(ToolActivity toolActivity) throws ToolException {
        try {
            ToolContentManager contentManager = (ToolContentManager)this.findToolService(toolActivity.getTool());
            contentManager.removeToolContent(toolActivity.getToolContentId());
        }
        catch (NoSuchBeanDefinitionException e) {
            String message = "A tool which is defined in the database appears to missing from the classpath. Unable to delete the tool content. ToolActivity " + toolActivity;
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
    }

    @Override
    public void notifyToolToDeleteLearnerContent(ToolActivity toolActivity, Integer userId) throws ToolException {
        try {
            ToolContentManager contentManager = (ToolContentManager)this.findToolService(toolActivity.getTool());
            contentManager.removeLearnerContent(toolActivity.getToolContentId(), userId);
        }
        catch (NoSuchBeanDefinitionException e) {
            String message = "A tool which is defined in the database appears to missing from the classpath. Unable to delete learner content. ToolActivity " + toolActivity;
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
    }

    @Override
    public SortedMap<String, ToolOutputDefinition> getOutputDefinitionsFromTool(Long toolContentId, int definitionType) throws ToolException {
        ToolContent toolContent = (ToolContent)this.toolContentDAO.find(ToolContent.class, toolContentId);
        if (toolContent == null) {
            String error = "The toolContentID " + toolContentId + " is not valid. No such record exists on the database.";
            log.error((Object)error);
            throw new DataMissingException(error);
        }
        Tool tool = toolContent.getTool();
        if (tool == null) {
            String error = "The tool for toolContentId " + toolContentId + " is missing.";
            log.error((Object)error);
            throw new DataMissingException(error);
        }
        try {
            ToolContentManager contentManager = (ToolContentManager)this.findToolService(tool);
            return contentManager.getToolOutputDefinitions(toolContentId, definitionType);
        }
        catch (NoSuchBeanDefinitionException e) {
            String message = "A tool which is defined in the database appears to missing from the classpath. Unable to get the tool output definitions. ToolContentId " + toolContentId;
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
        catch (AbstractMethodError e) {
            String message = "Tool " + tool.getToolDisplayName() + " doesn't support the getToolOutputDefinitions(toolContentId) method so no output definitions can be accessed.";
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
    }

    @Override
    public SortedMap<String, ToolOutputDefinition> getOutputDefinitionsFromToolFiltered(Long outputToolContentId, int definitionType, Long inputToolContentId) throws ToolException {
        SortedMap<String, ToolOutputDefinition> definitions = this.getOutputDefinitionsFromTool(outputToolContentId, definitionType);
        ToolContent toolContent = (ToolContent)this.toolContentDAO.find(ToolContent.class, inputToolContentId);
        if (toolContent == null) {
            String error = "The toolContentID " + inputToolContentId + " is not valid. No such record exists on the database.";
            log.error((Object)error);
            throw new DataMissingException(error);
        }
        Tool tool = toolContent.getTool();
        if (tool == null) {
            String error = "The tool for toolContentId " + inputToolContentId + " is missing.";
            log.error((Object)error);
            throw new DataMissingException(error);
        }
        try {
            ToolContentManager contentManager = (ToolContentManager)this.findToolService(tool);
            Class[] supportedClasses = contentManager.getSupportedToolOutputDefinitionClasses(definitionType);
            if (supportedClasses != null) {
                TreeSet<String> keysToRemove = new TreeSet<String>();
                for (String key : definitions.keySet()) {
                    ToolOutputDefinition value = (ToolOutputDefinition)definitions.get(key);
                    Class valueClass = value.getValueClass();
                    boolean matchFound = false;
                    if (valueClass != null) {
                        for (Class supportedClass : supportedClasses) {
                            if (!supportedClass.isAssignableFrom(valueClass)) continue;
                            matchFound = true;
                            break;
                        }
                    }
                    if (matchFound) continue;
                    keysToRemove.add(key);
                }
                for (String key : keysToRemove) {
                    definitions.remove(key);
                }
            }
            return definitions;
        }
        catch (NoSuchBeanDefinitionException e) {
            String message = "A tool which is defined in the database appears to missing from the classpath. Unable to get the tool output definitions. ToolContentId " + inputToolContentId;
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
        catch (AbstractMethodError e) {
            String message = "Tool " + tool.getToolDisplayName() + " doesn't support the getSupportedToolOutputDefinitionClasses(definitionType) method so no output definitions can be accessed.";
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
    }

    @Override
    public ToolOutput getOutputFromTool(String conditionName, Long toolSessionId, Integer learnerId) throws ToolException {
        ToolSession session = this.toolSessionDAO.getToolSession(toolSessionId);
        return this.getOutputFromTool(conditionName, session, learnerId);
    }

    @Override
    public ToolOutput getOutputFromTool(String conditionName, ToolSession toolSession, Integer learnerId) throws ToolException {
        if (toolSession == null) {
            String error = "The toolSession is not valid. Unable to get the tool output";
            log.error((Object)error);
            throw new DataMissingException(error);
        }
        Tool tool = toolSession.getToolActivity().getTool();
        if (tool == null) {
            String error = "The tool for toolSession " + toolSession.getToolSessionId() + " is missing.";
            log.error((Object)error);
            throw new DataMissingException(error);
        }
        try {
            ToolSessionManager sessionManager = (ToolSessionManager)this.findToolService(tool);
            Long longLearnerId = learnerId != null ? new Long(learnerId.longValue()) : null;
            return sessionManager.getToolOutput(conditionName, toolSession.getToolSessionId(), longLearnerId);
        }
        catch (NoSuchBeanDefinitionException e) {
            String message = "A tool which is defined in the database appears to missing from the classpath. Unable to gt the tol output. toolSession " + toolSession.getToolSessionId();
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
        catch (AbstractMethodError e) {
            String message = "Tool " + tool.getToolDisplayName() + " doesn't support the getToolOutput(name, toolSessionId, learnerId) method so no output definitions can be accessed.";
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
    }

    @Override
    public List<ToolOutput> getOutputsFromTool(String conditionName, ToolActivity toolActivity) throws ToolException {
        if (toolActivity == null) {
            String error = "The toolActivity is null. Unable to get tool outputs";
            log.error((Object)error);
            throw new DataMissingException(error);
        }
        Tool tool = toolActivity.getTool();
        if (tool == null) {
            String error = "The tool for toolActivity " + toolActivity.getActivityId() + " is missing.";
            log.error((Object)error);
            throw new DataMissingException(error);
        }
        try {
            ToolSessionManager sessionManager = (ToolSessionManager)this.findToolService(tool);
            return sessionManager.getToolOutputs(conditionName, toolActivity.getToolContentId());
        }
        catch (NoSuchBeanDefinitionException e) {
            String message = "A tool which is defined in the database appears to missing from the classpath. Unable to grt the tol output. toolActivity " + toolActivity.getActivityId();
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
        catch (AbstractMethodError e) {
            String message = "Tool " + tool.getToolDisplayName() + " doesn't support the getToolOutput(name, toolSessionId, learnerId) method so no output definitions can be accessed.";
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
    }

    @Override
    public void forceCompleteActivity(ToolSession toolSession, User learner) throws ToolException {
        if (toolSession == null) {
            String error = "The toolSession is not valid. Unable to force complete activity.";
            log.error((Object)error);
            throw new DataMissingException(error);
        }
        Tool tool = toolSession.getToolActivity().getTool();
        if (tool == null) {
            String error = "The tool for toolSession " + toolSession.getToolSessionId() + " is missing.";
            log.error((Object)error);
            throw new DataMissingException(error);
        }
        try {
            ToolSessionManager sessionManager = (ToolSessionManager)this.findToolService(tool);
            sessionManager.forceCompleteUser(toolSession.getToolSessionId(), learner);
        }
        catch (NoSuchBeanDefinitionException e) {
            String message = "A tool which is defined in the database appears to missing from the classpath. Unable to force complete activity. toolSession " + toolSession.getToolSessionId();
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
        catch (AbstractMethodError e) {
            String message = "Tool " + tool.getToolDisplayName() + " doesn't support the forceCompleteUser(ToolSession toolSession, User learner) method so can't force complete learner.";
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
    }

    @Override
    public SortedMap<String, ToolOutput> getOutputFromTool(List<String> names, Long toolSessionId, Integer learnerId) throws ToolException {
        ToolSession session = this.toolSessionDAO.getToolSession(toolSessionId);
        return this.getOutputFromTool(names, session, learnerId);
    }

    @Override
    public SortedMap<String, ToolOutput> getOutputFromTool(List<String> names, ToolSession toolSession, Integer learnerId) throws ToolException {
        if (toolSession == null) {
            String error = "The toolSession is not valid. Unable to get the tool output";
            log.error((Object)error);
            throw new DataMissingException(error);
        }
        Tool tool = toolSession.getToolActivity().getTool();
        if (tool == null) {
            String error = "The tool for toolSession " + toolSession.getToolSessionId() + " is missing.";
            log.error((Object)error);
            throw new DataMissingException(error);
        }
        try {
            ToolSessionManager sessionManager = (ToolSessionManager)this.findToolService(tool);
            Long longLearnerId = learnerId != null ? new Long(learnerId.longValue()) : null;
            return sessionManager.getToolOutput(names, toolSession.getToolSessionId(), longLearnerId);
        }
        catch (NoSuchBeanDefinitionException e) {
            String message = "A tool which is defined in the database appears to missing from the classpath. Unable to gt the tol output. toolSession " + toolSession.getToolSessionId();
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
        catch (AbstractMethodError e) {
            String message = "Tool " + tool.getToolDisplayName() + " doesn't support the getToolOutput(name, toolSessionId, learnerId) method so no output definitions can be accessed.";
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
    }

    @Override
    public Long getActivityMaxPossibleMark(ToolActivity activity) {
        SortedMap<String, ToolOutputDefinition> map = this.getOutputDefinitionsFromTool(activity.getToolContentId(), 1);
        Set<ActivityEvaluation> actEvals = activity.getActivityEvaluations();
        if (map != null) {
            for (String key : map.keySet()) {
                ToolOutputDefinition definition = (ToolOutputDefinition)map.get(key);
                if (actEvals != null && actEvals.size() > 0) {
                    ActivityEvaluation actEval = actEvals.iterator().next();
                    if (!actEval.getToolOutputDefinition().equals(key)) continue;
                    Object upperLimit = definition.getEndValue();
                    if (upperLimit == null || !(upperLimit instanceof Long)) break;
                    return (Long)upperLimit;
                }
                if (definition.isDefaultGradebookMark() == null || !definition.isDefaultGradebookMark().booleanValue()) continue;
                Object upperLimit = definition.getEndValue();
                if (upperLimit == null || !(upperLimit instanceof Long)) break;
                return (Long)upperLimit;
            }
        }
        return null;
    }

    @Override
    public void updateToolSession(ToolSession toolSession) {
        this.toolSessionDAO.updateToolSession(toolSession);
    }

    @Override
    public List getToolSessionsByLesson(Lesson lesson) {
        return this.toolSessionDAO.getToolSessionsByLesson(lesson);
    }

    @Override
    public void deleteToolSession(ToolSession toolSession) {
        if (toolSession == null) {
            log.error((Object)"deleteToolSession: unable to delete tool session as tool session is null.");
            return;
        }
        ToolSessionManager sessionManager = (ToolSessionManager)this.findToolService(toolSession.getToolActivity().getTool());
        try {
            sessionManager.removeToolSession(toolSession.getToolSessionId());
        }
        catch (DataMissingException e) {
            log.error((Object)("Unable to delete tool data for tool session " + toolSession.getToolSessionId() + " as toolSession does not exist"), (Throwable)e);
        }
        catch (ToolException e) {
            log.error((Object)("Unable to delete tool data for tool session " + toolSession.getToolSessionId() + " as tool threw an exception"), (Throwable)e);
        }
        this.toolSessionDAO.removeToolSession(toolSession);
    }

    @Override
    public String getToolLearnerURL(Long lessonID, Activity activity, User learner) throws LamsToolServiceException {
        SystemTool sysTool;
        if (activity.isToolActivity()) {
            ToolActivity toolActivity = (ToolActivity)activity;
            String toolURL = toolActivity.getTool().getLearnerUrl();
            return this.setupToolURLWithToolSession(toolActivity, learner, toolURL);
        }
        if (activity.isSystemToolActivity() && (sysTool = this.systemToolDAO.getSystemToolByActivityTypeId(activity.getActivityTypeId())) != null) {
            return this.setupURLWithActivityLessonID(activity, lessonID, sysTool.getLearnerUrl());
        }
        return null;
    }

    @Override
    public String getToolLearnerPreviewURL(Long lessonID, Activity activity, User authorLearner) throws LamsToolServiceException {
        SystemTool sysTool;
        if (activity.isToolActivity()) {
            ToolActivity toolActivity = (ToolActivity)activity;
            String toolURL = toolActivity.getTool().getLearnerPreviewUrl();
            return this.setupToolURLWithToolSession(toolActivity, authorLearner, toolURL);
        }
        if (activity.isSystemToolActivity() && (sysTool = this.systemToolDAO.getSystemToolByActivityTypeId(activity.getActivityTypeId())) != null) {
            return this.setupURLWithActivityLessonID(activity, lessonID, sysTool.getLearnerPreviewUrl());
        }
        return null;
    }

    @Override
    public String getToolLearnerProgressURL(Long lessonID, Activity activity, User learner) throws LamsToolServiceException {
        SystemTool sysTool;
        if (activity.isToolActivity()) {
            ToolActivity toolActivity = (ToolActivity)activity;
            String toolURL = toolActivity.getTool().getLearnerProgressUrl();
            toolURL = this.appendUserIDToURL(learner, toolURL);
            return this.setupToolURLWithToolSession(toolActivity, learner, toolURL);
        }
        if (activity.isSystemToolActivity() && (sysTool = this.systemToolDAO.getSystemToolByActivityTypeId(activity.getActivityTypeId())) != null) {
            return this.setupURLWithActivityLessonUserID(activity, lessonID, learner.getUserId(), sysTool.getLearnerProgressUrl());
        }
        return null;
    }

    @Override
    public String getToolMonitoringURL(Long lessonID, Activity activity) throws LamsToolServiceException {
        SystemTool sysTool;
        if (activity.isToolActivity()) {
            ToolActivity toolActivity = (ToolActivity)activity;
            String url = toolActivity.getTool().getMonitorUrl();
            if (url != null) {
                return this.setupToolURLWithToolContent(toolActivity, url);
            }
        } else if (activity.isSystemToolActivity() && (sysTool = this.systemToolDAO.getSystemToolByActivityTypeId(activity.getActivityTypeId())) != null) {
            return this.setupURLWithActivityLessonID(activity, lessonID, sysTool.getMonitorUrl());
        }
        return null;
    }

    @Override
    public String getToolContributionURL(Long lessonID, Activity activity) throws LamsToolServiceException {
        SystemTool sysTool;
        if (activity.isSystemToolActivity() && (sysTool = this.systemToolDAO.getSystemToolByActivityTypeId(activity.getActivityTypeId())) != null) {
            return this.setupURLWithActivityLessonID(activity, lessonID, sysTool.getContributeUrl());
        }
        return null;
    }

    @Override
    public String getToolAuthorURL(Long lessonID, ToolActivity activity, ToolAccessMode mode) {
        String url = activity.getTool().getAuthorUrl();
        url = WebUtil.appendParameterToURL(url, "toolContentID", activity.getToolContentId().toString());
        Lesson lesson = (Lesson)this.toolContentDAO.find(Lesson.class, lessonID);
        url = WebUtil.appendParameterToURL(url, "contentFolderID", lesson.getLearningDesign().getContentFolderID());
        url = WebUtil.appendParameterToURL(url, "mode", mode.toString());
        return url;
    }

    private String appendUserIDToURL(User user, String toolURL) {
        return WebUtil.appendParameterToURL(toolURL, "userID", user.getUserId().toString());
    }

    @Override
    public String setupToolURLWithToolSession(ToolActivity activity, User learner, String toolURL) throws LamsToolServiceException {
        ToolSession toolSession = this.getToolSessionByActivity(learner, activity);
        if (toolSession == null) {
            String error = "Unable to set up url as session does not exist. Activity " + (activity != null ? activity.getActivityId() + ":" + activity.getTitle() : "null") + " learner " + (learner != null ? learner.getUserId() + ":" + learner.getLogin() : "null");
            log.error((Object)error);
            throw new LamsToolServiceException(error);
        }
        return WebUtil.appendParameterToURL(toolURL, "toolSessionID", toolSession.getToolSessionId().toString());
    }

    private String setupURLWithActivityLessonUserID(Activity activity, Long lessonID, Integer userID, String learnerURL) {
        String url = this.setupURLWithActivityLessonID(activity, lessonID, learnerURL);
        if (url != null && userID != null) {
            url = WebUtil.appendParameterToURL(url, "userID", userID.toString());
        }
        return url;
    }

    private String setupURLWithActivityLessonID(Activity activity, Long lessonID, String learnerURL) {
        String url = learnerURL;
        if (url != null && activity != null) {
            url = WebUtil.appendParameterToURL(url, "activityID", activity.getActivityId().toString());
        }
        if (url != null && lessonID != null) {
            url = WebUtil.appendParameterToURL(url, "lessonID", lessonID.toString());
        }
        return url;
    }

    @Override
    public String setupToolURLWithToolContent(ToolActivity activity, String toolURL) {
        return WebUtil.appendParameterToURL(toolURL, "toolContentID", activity.getToolContentId().toString());
    }

    @Override
    public Object findToolService(Tool tool) throws NoSuchBeanDefinitionException {
        return this.context.getBean(tool.getServiceName());
    }

    @Override
    public boolean isContentEdited(Activity activity) {
        if (activity.isToolActivity()) {
            ToolActivity toolActivity = (ToolActivity)activity;
            ToolContentManager toolService = (ToolContentManager)this.findToolService(toolActivity.getTool());
            return toolService.isContentEdited(toolActivity.getToolContentId());
        }
        return false;
    }
}

