/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.service;

import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Hibernate;
import org.hibernate.proxy.HibernateProxy;
import org.lamsfoundation.lams.gradebook.service.IGradebookService;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ActivityEvaluation;
import org.lamsfoundation.lams.learningdesign.FloatingActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.lesson.CompletedActivityProgress;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.tool.IToolVO;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.ToolOutput;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.dao.IToolContentDAO;
import org.lamsfoundation.lams.tool.dao.IToolDAO;
import org.lamsfoundation.lams.tool.dao.IToolSessionDAO;
import org.lamsfoundation.lams.tool.exception.LamsToolServiceException;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.FileUtilException;

public class LamsToolService
implements ILamsToolService {
    private static Logger log = Logger.getLogger(LamsToolService.class);
    private static final String LEADER_SELECTION_TOOL_SIGNATURE = "lalead11";
    private static final String LEADER_SELECTION_TOOL_OUTPUT_NAME_LEADER_USERID = "leader.user.id";
    private IActivityDAO activityDAO;
    private IToolDAO toolDAO;
    private IToolSessionDAO toolSessionDAO;
    private IToolContentDAO toolContentDAO;
    private IGradebookService gradebookService;
    private ILamsCoreToolService lamsCoreToolService;
    private ILessonService lessonService;

    @Override
    public Set<User> getAllPotentialLearners(long toolSessionId) throws LamsToolServiceException {
        ToolSession session = this.toolSessionDAO.getToolSession(toolSessionId);
        if (session != null) {
            return session.getLearners();
        }
        log.error((Object)("No tool session found for " + toolSessionId + ". No potential learners being returned."));
        return new HashSet<User>();
    }

    @Override
    public IToolVO getToolByID(Long toolId) {
        Tool tool = this.toolDAO.getToolByID(toolId);
        return tool.createBasicToolVO();
    }

    @Override
    public IToolVO getToolBySignature(String toolSignature) {
        Tool tool = this.toolDAO.getToolBySignature(toolSignature);
        return tool.createBasicToolVO();
    }

    @Override
    public Tool getPersistToolBySignature(String toolSignature) {
        return this.toolDAO.getToolBySignature(toolSignature);
    }

    @Override
    public long getToolDefaultContentIdBySignature(String toolSignature) {
        return this.toolDAO.getToolDefaultContentIdBySignature(toolSignature);
    }

    @Override
    public String generateUniqueContentFolder() throws FileUtilException, IOException {
        return FileUtil.generateUniqueContentFolderID();
    }

    @Override
    public String getLearnerContentFolder(Long toolSessionId, Long userId) {
        ToolSession toolSession = this.getToolSession(toolSessionId);
        Long lessonId = toolSession.getLesson().getLessonId();
        String learnerContentFolder = FileUtil.getLearnerContentFolder(lessonId, userId);
        return learnerContentFolder;
    }

    @Override
    public void saveOrUpdateTool(Tool tool) {
        this.toolDAO.saveOrUpdateTool(tool);
    }

    @Override
    public ToolSession getToolSession(Long toolSessionId) {
        return this.toolSessionDAO.getToolSession(toolSessionId);
    }

    @Override
    public Boolean isGroupedActivity(long toolContentID) {
        List activities = this.toolContentDAO.findByProperty(Activity.class, "toolContentId", toolContentID);
        if (activities.size() == 1) {
            Activity activity = (Activity)activities.get(0);
            return activity.getApplyGrouping();
        }
        log.debug((Object)"ToolContent contains multiple activities, can't test whether grouping applies.");
        return null;
    }

    @Override
    public String getActivityEvaluation(Long toolContentId) {
        List activities = this.toolContentDAO.findByProperty(Activity.class, "toolContentId", toolContentId);
        if (activities.size() != 1) {
            log.debug((Object)"ToolContent contains multiple activities, can't get ActivityEvaluation.");
            return null;
        }
        ToolActivity toolActivity = (ToolActivity)activities.get(0);
        Set<ActivityEvaluation> activityEvaluations = toolActivity.getActivityEvaluations();
        if (activityEvaluations.isEmpty()) {
            return null;
        }
        ActivityEvaluation activityEvaluation = activityEvaluations.iterator().next();
        return activityEvaluation.getToolOutputDefinition();
    }

    @Override
    public void setActivityEvaluation(Long toolContentId, String toolOutputDefinition) {
        ActivityEvaluation activityEvaluation;
        List activities = this.toolContentDAO.findByProperty(Activity.class, "toolContentId", toolContentId);
        if (activities.size() != 1) {
            throw new LamsToolServiceException("ToolContent contains multiple activities, can't set ActivityEvaluation.");
        }
        if (StringUtils.isEmpty((String)toolOutputDefinition)) {
            return;
        }
        ToolActivity toolActivity = (ToolActivity)activities.get(0);
        Set<ActivityEvaluation> activityEvaluations = toolActivity.getActivityEvaluations();
        boolean isToolOutputDefinitionChanged = true;
        if (activityEvaluations.isEmpty()) {
            activityEvaluation = new ActivityEvaluation();
            activityEvaluation.setActivity(toolActivity);
            activityEvaluations = new HashSet<ActivityEvaluation>();
            activityEvaluations.add(activityEvaluation);
            toolActivity.setActivityEvaluations(activityEvaluations);
        } else {
            activityEvaluation = activityEvaluations.iterator().next();
            isToolOutputDefinitionChanged = !toolOutputDefinition.equals(activityEvaluation.getToolOutputDefinition());
        }
        activityEvaluation.setToolOutputDefinition(toolOutputDefinition);
        this.activityDAO.insertOrUpdate(activityEvaluation);
        toolActivity.setActivityEvaluations(activityEvaluations);
        this.activityDAO.insertOrUpdate(toolActivity);
        if (isToolOutputDefinitionChanged) {
            this.gradebookService.updateUserMarksForActivity((Activity)toolActivity);
        }
    }

    @Override
    public Long getLeaderUserId(Long toolSessionId, Integer learnerId) {
        Long leaderUserId = null;
        ToolSession toolSession = this.getToolSession(toolSessionId);
        ToolActivity specifiedActivity = toolSession.getToolActivity();
        Activity leaderSelectionActivity = this.getNearestLeaderSelectionActivity(specifiedActivity, learnerId, toolSession.getLesson().getLessonId());
        if (leaderSelectionActivity != null) {
            ToolOutput output;
            User learner = (User)this.toolContentDAO.find(User.class, learnerId);
            String outputName = LEADER_SELECTION_TOOL_OUTPUT_NAME_LEADER_USERID;
            ToolSession leaderSelectionSession = this.toolSessionDAO.getToolSessionByLearner(learner, leaderSelectionActivity);
            if (leaderSelectionSession != null && (output = this.lamsCoreToolService.getOutputFromTool(outputName, leaderSelectionSession, null)) != null && output.getValue() != null) {
                leaderUserId = output.getValue().getLong();
            }
        }
        return leaderUserId;
    }

    private Activity getNearestLeaderSelectionActivity(Activity activity, Integer userId, Long lessonId) {
        Transition transitionTo;
        Class activityClass = Hibernate.getClass((Object)activity);
        if (activityClass.equals(ToolActivity.class)) {
            Hibernate.initialize((Object)activity);
            ToolActivity toolActivity = activity instanceof HibernateProxy ? (ToolActivity)((HibernateProxy)activity).getHibernateLazyInitializer().getImplementation() : (ToolActivity)activity;
            if (LEADER_SELECTION_TOOL_SIGNATURE.equals(toolActivity.getTool().getToolSignature())) {
                return activity;
            }
        } else if (activityClass.equals(FloatingActivity.class)) {
            LearnerProgress learnerProgress = this.lessonService.getUserProgressForLesson(userId, lessonId);
            Map<Activity, CompletedActivityProgress> completedActivities = learnerProgress.getCompletedActivities();
            Date leaderSelectActivityFinishDate = null;
            ToolActivity leaderSelectionActivity = null;
            for (Activity completedActivity : completedActivities.keySet()) {
                ToolActivity completedToolActivity;
                if (!(completedActivity instanceof ToolActivity) || !LEADER_SELECTION_TOOL_SIGNATURE.equals((completedToolActivity = (ToolActivity)completedActivity).getTool().getToolSignature())) continue;
                Date finishDate = completedActivities.get(completedActivity).getFinishDate();
                if (leaderSelectActivityFinishDate != null && finishDate.compareTo(leaderSelectActivityFinishDate) >= 0) continue;
                leaderSelectionActivity = completedToolActivity;
                leaderSelectActivityFinishDate = completedActivities.get(completedActivity).getFinishDate();
            }
            return leaderSelectionActivity;
        }
        if ((transitionTo = activity.getTransitionTo()) != null) {
            Activity fromActivity = transitionTo.getFromActivity();
            return this.getNearestLeaderSelectionActivity(fromActivity, userId, lessonId);
        }
        Activity parent = activity.getParentActivity();
        if (parent != null) {
            return this.getNearestLeaderSelectionActivity(parent, userId, lessonId);
        }
        return null;
    }

    @Override
    public Set<User> getUsersForActivity(Long toolSessionId) {
        ToolSession session = this.toolSessionDAO.getToolSession(toolSessionId);
        return session != null ? session.getLearners() : new HashSet<User>();
    }

    @Override
    public Integer getCountUsersForActivity(Long toolSessionId) {
        ToolSession session = this.toolSessionDAO.getToolSession(toolSessionId);
        if (session.getToolSessionTypeId() == 1) {
            return this.toolSessionDAO.getCountUsersGrouped(toolSessionId);
        }
        return session.getLearners().size();
    }

    public void setToolDAO(IToolDAO toolDAO) {
        this.toolDAO = toolDAO;
    }

    public void setActivityDAO(IActivityDAO activityDAO) {
        this.activityDAO = activityDAO;
    }

    public void setToolSessionDAO(IToolSessionDAO toolSessionDAO) {
        this.toolSessionDAO = toolSessionDAO;
    }

    public void setToolContentDAO(IToolContentDAO toolContentDAO) {
        this.toolContentDAO = toolContentDAO;
    }

    public void setGradebookService(IGradebookService gradebookService) {
        this.gradebookService = gradebookService;
    }

    public void setLamsCoreToolService(ILamsCoreToolService lamsCoreToolService) {
        this.lamsCoreToolService = lamsCoreToolService;
    }

    public void setLessonService(ILessonService lessonService) {
        this.lessonService = lessonService;
    }
}

