/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement.dao.hibernate;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Query;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.usermanagement.IUserDAO;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;

public class UserDAO
extends BaseDAO
implements IUserDAO {
    @Override
    public List<UserDTO> getAllUsersPaged(int page, int size, String sortBy, String sortOrder, String searchString) {
        String GET_USERS = "SELECT user.userId, user.login, user.firstName, user.lastName, user.email FROM " + User.class.getName() + " user " + " WHERE user.disabledFlag=0 ";
        GET_USERS = this.addNameSearch(GET_USERS, searchString);
        GET_USERS = GET_USERS + " ORDER BY CASE  WHEN :sortBy='userId' THEN user.userId  WHEN :sortBy='login' THEN user.login  WHEN :sortBy='firstName' THEN user.firstName  WHEN :sortBy='lastName' THEN user.lastName  WHEN :sortBy='email' THEN user.email  END " + sortOrder;
        Query query = this.getSession().createQuery(GET_USERS);
        query.setString("sortBy", sortBy);
        query.setFirstResult(page * size);
        query.setMaxResults(size);
        List list = query.list();
        ArrayList<UserDTO> userDtos = new ArrayList<UserDTO>();
        if (list != null && list.size() > 0) {
            for (Object[] element : list) {
                Integer userId = ((Number)element[0]).intValue();
                String login = (String)element[1];
                String firstName = (String)element[2];
                String lastName = (String)element[3];
                String email = (String)element[4];
                UserDTO userDto = new UserDTO(userId, firstName, lastName, login, null, null, null, email, null, null, null, null, null, null, null, true, null, false);
                userDtos.add(userDto);
            }
        }
        return userDtos;
    }

    @Override
    public int getCountUsers(String searchString) {
        String GET_USERS = "SELECT count(*) FROM " + User.class.getName() + " user " + " WHERE user.disabledFlag=0 ";
        GET_USERS = this.addNameSearch(GET_USERS, searchString);
        Query query = this.getSession().createQuery(GET_USERS);
        List list = query.list();
        if (list == null || list.size() == 0) {
            return 0;
        }
        return ((Number)list.get(0)).intValue();
    }

    private String addNameSearch(String query, String searchString) {
        StringBuilder queryWithSearch = new StringBuilder(query);
        if (!StringUtils.isBlank((String)searchString)) {
            String[] tokens;
            for (String token : tokens = searchString.trim().split("\\s+")) {
                String escToken = StringEscapeUtils.escapeSql((String)token);
                queryWithSearch.append(" AND (user.firstName LIKE '%").append(escToken).append("%' OR user.lastName LIKE '%").append(escToken).append("%' OR user.login LIKE '%").append(escToken).append("%' OR user.email LIKE '%").append(escToken).append("%')");
            }
        }
        return queryWithSearch.toString();
    }
}

