/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpSession;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.web.session.SessionManager;

public class DateUtil {
    public static final String WDDX_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String LAMS_FLASH_FORMAT = "dd/M/yyyy h:mm a";
    public static final int TYPE_BOTH = 1;
    public static final int TYPE_DATE = 2;
    public static final int TYPE_TIME = 3;

    public static Date convertToUTC(Date time) {
        TimeZone gmt = TimeZone.getTimeZone("Etc/GMT");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd kk:mm:ss");
        sdf.setTimeZone(gmt);
        String str = sdf.format(time);
        Timestamp gmtLocal = Timestamp.valueOf(str);
        GregorianCalendar gmtCanlendar = new GregorianCalendar(gmt);
        gmtCanlendar.setTimeInMillis(gmtLocal.getTime());
        return gmtCanlendar.getTime();
    }

    public static Date convertFromUTCToLocal(TimeZone localTimeZone, Date UTCDate) {
        GregorianCalendar canlendar = new GregorianCalendar(localTimeZone);
        long offset = canlendar.get(15) + canlendar.get(16);
        return new Date(UTCDate.getTime() + offset);
    }

    public static Date convertToTimeZoneFromDefault(TimeZone targetTimeZone, Date date) {
        TimeZone defaultTz = TimeZone.getDefault();
        Integer rawOffset = new Integer(defaultTz.getOffset(date.getTime()) - targetTimeZone.getOffset(date.getTime()));
        return new Date(date.getTime() - (long)rawOffset.intValue());
    }

    public static Date convertFromTimeZoneToDefault(TimeZone targetTimeZone, Date date) {
        TimeZone defaultTz = TimeZone.getDefault();
        Integer rawOffset = new Integer(defaultTz.getOffset(date.getTime()) - targetTimeZone.getOffset(date.getTime()));
        return new Date(date.getTime() + (long)rawOffset.intValue());
    }

    public static Date convertFromString(String dateString) throws ParseException {
        if (dateString == null) {
            return null;
        }
        SimpleDateFormat parser = null;
        String[] parseFormats = new String[]{WDDX_FORMAT};
        for (int i = 0; i < parseFormats.length; ++i) {
            if (i == 0) {
                parser = new SimpleDateFormat(parseFormats[0]);
            } else {
                parser.applyPattern(parseFormats[i]);
            }
            try {
                Date date = parser.parse(dateString);
                if (date == null) continue;
                return date;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        throw new ParseException("Unable to parse date " + dateString, 0);
    }

    public static Date convertFromString(String dateString, String dateFormat) throws ParseException {
        if (dateString == null) {
            return null;
        }
        SimpleDateFormat parser = new SimpleDateFormat(dateFormat);
        return parser.parse(dateString);
    }

    public static Date convertFromLAMSFlashFormat(String dateString) throws ParseException {
        return DateUtil.convertFromString(dateString, LAMS_FLASH_FORMAT);
    }

    public static String convertToStringForJSON(Date value, Locale locale) {
        return DateUtil.convertToStringForJSON(value, 2, 1, locale);
    }

    public static String convertToStringForJSON(Date value, Integer style, Locale locale) {
        return DateUtil.convertToStringForJSON(value, style, 1, locale);
    }

    public static String convertToStringForJSON(Date value, Integer style, Integer type, Locale locale) {
        int timeStyle;
        int dateStyle;
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        TimeZone tz = user.getTimeZone();
        switch (style) {
            case 3: {
                dateStyle = 3;
                timeStyle = 3;
                break;
            }
            case 0: {
                dateStyle = 1;
                timeStyle = 0;
                break;
            }
            default: {
                dateStyle = 1;
                timeStyle = 2;
            }
        }
        DateFormat df = null;
        switch (type) {
            case 2: {
                df = DateFormat.getDateInstance(dateStyle, locale);
                break;
            }
            case 3: {
                df = DateFormat.getTimeInstance(timeStyle, locale);
                break;
            }
            default: {
                df = DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
            }
        }
        if (tz != null) {
            df.setTimeZone(tz);
        }
        return df.format(value);
    }
}

