/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.filter;

import java.io.IOException;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.tool.IToolVO;
import org.lamsfoundation.lams.tool.ToolContent;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.dao.IToolContentDAO;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class AccessPermissionFilter
extends OncePerRequestFilter {
    private static Logger log = Logger.getLogger(AccessPermissionFilter.class);
    private static final char REQUEST_QUERY_SEPARATOR = '?';
    private static final String PAGE_LIST_DELIMITER = ";";
    private static ILamsToolService lamsToolService;
    private static ILamsCoreToolService lamsCoreToolService;
    private static IUserManagementService userManagementService;
    private static ILessonService lessonService;
    private static IToolContentDAO toolContentDAO;
    private String toolSignature;
    private Pattern monitorPattern;
    private Pattern learnerPattern;
    private String lessonSecuredPages;
    private String[] lessonSecuredPagesArray;

    protected void initFilterBean() {
        if (this.toolSignature == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Init parameter \"toolSignature\" is missing.");
            }
        } else {
            IToolVO tool = this.getLamsToolService().getToolBySignature(this.toolSignature);
            if (tool == null) {
                log.warn((Object)("Tool missing for provided signature: " + this.toolSignature));
            } else {
                this.monitorPattern = AccessPermissionFilter.makePattern(tool.getMonitorUrl());
                this.learnerPattern = AccessPermissionFilter.makePattern(tool.getLearnerUrl());
            }
        }
        if (this.lessonSecuredPages != null) {
            this.lessonSecuredPagesArray = this.lessonSecuredPages.split(PAGE_LIST_DELIMITER);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String requestURI = request.getRequestURI();
        boolean checkPerformed = false;
        if (this.lessonSecuredPagesArray != null) {
            for (String lessonSecuredPage : this.lessonSecuredPagesArray) {
                if (!requestURI.endsWith(lessonSecuredPage)) continue;
                checkPerformed = true;
                String lessonIDParam = request.getParameter("lessonID");
                if (lessonIDParam == null) continue;
                Long lessonId = Long.valueOf(lessonIDParam);
                Lesson lesson = this.getLessonService().getLesson(lessonId);
                if (lesson == null) continue;
                User user = this.getUser();
                if (lesson.getLessonClass() == null || !lesson.getLessonClass().getLearners().contains(user)) throw new SecurityException("User " + user.getLogin() + " is not a learner in the requested lesson. Lesson ID: " + lesson.getLessonId() + ", name: " + lesson.getLessonName());
                if (!this.getLessonService().checkLessonReleaseConditions(lessonId, user.getUserId())) throw new SecurityException("User " + user.getLogin() + " has not finished required preceding lessons. Lesson ID: " + lesson.getLessonId() + ", name: " + lesson.getLessonName());
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("OK, user " + user.getLogin() + " is a learner in the requested lesson. Lesson ID: " + lesson.getLessonId() + ", name: " + lesson.getLessonName()));
            }
        }
        if (!checkPerformed) {
            String requestURL = requestURI + '?' + request.getQueryString();
            if (this.learnerPattern != null && this.learnerPattern.matcher(requestURL).find()) {
                checkPerformed = true;
                String toolSessionIDParam = request.getParameter("toolSessionID");
                if (toolSessionIDParam != null) {
                    Long toolSessionID = Long.valueOf(toolSessionIDParam);
                    Set<User> learners = this.getLamsToolService().getAllPotentialLearners(toolSessionID);
                    User user = this.getUser();
                    if (learners == null || !learners.contains(user)) throw new SecurityException("User " + user.getLogin() + " is not a learner in the requested lesson. ToolSessionID: " + toolSessionIDParam);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("OK, user " + user.getLogin() + " is a learner in the requested lesson. ToolSessionID: " + toolSessionIDParam));
                    }
                }
            } else if (this.monitorPattern != null && this.monitorPattern.matcher(requestURL).find()) {
                checkPerformed = true;
                String toolContentIDParam = request.getParameter("toolContentID");
                if (toolContentIDParam != null) {
                    Long toolContentID = Long.valueOf(toolContentIDParam);
                    ToolContent toolContent = (ToolContent)this.getToolContentDAO().find(ToolContent.class, toolContentID);
                    Set activities = toolContent.getActivities();
                    if (activities != null && !activities.isEmpty()) {
                        boolean isStaffMember = false;
                        User user = this.getUser();
                        Lesson lesson = null;
                        for (ToolActivity activity : activities) {
                            lesson = (Lesson)activity.getLearningDesign().getLessons().iterator().next();
                            if (lesson.getLessonClass() == null || !lesson.getLessonClass().isStaffMember(user)) continue;
                            isStaffMember = true;
                            break;
                        }
                        if (!isStaffMember) throw new SecurityException("User " + user.getLogin() + " is not a monitor in the requested lesson." + (lesson == null ? "" : " Lesson ID: " + lesson.getLessonId() + ", name: " + lesson.getLessonName()));
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("OK, user " + user.getLogin() + " is a monitor in the requested lesson." + (lesson == null ? "" : " Lesson ID: " + lesson.getLessonId() + ", name: " + lesson.getLessonName())));
                        }
                    }
                }
            }
        }
        if (!checkPerformed && log.isTraceEnabled()) {
            log.trace((Object)"URL does not match any patterns to check, carry on.");
        }
        if (chain == null) return;
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private User getUser() {
        HttpSession session = SessionManager.getSession();
        UserDTO userDTO = (UserDTO)session.getAttribute("user");
        return this.getUserManagementService().getUserByLogin(userDTO.getLogin());
    }

    private ToolSession getToolSession(Long toolSessionID) {
        return this.getLamsToolService().getToolSession(toolSessionID);
    }

    private static Pattern makePattern(String literal) {
        String escaped = literal.replaceAll("\\.", "\\\\.").replaceAll("\\?", "\\\\?");
        return Pattern.compile(escaped, 2);
    }

    private IUserManagementService getUserManagementService() {
        if (userManagementService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getFilterConfig().getServletContext());
            userManagementService = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return userManagementService;
    }

    private ILamsToolService getLamsToolService() {
        if (lamsToolService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getFilterConfig().getServletContext());
            lamsToolService = (ILamsToolService)ctx.getBean("lamsToolService");
        }
        return lamsToolService;
    }

    private ILamsCoreToolService getLamsCoreToolService() {
        if (lamsCoreToolService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getFilterConfig().getServletContext());
            lamsCoreToolService = (ILamsCoreToolService)ctx.getBean("lamsCoreToolService");
        }
        return lamsCoreToolService;
    }

    private ILessonService getLessonService() {
        if (lessonService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getFilterConfig().getServletContext());
            lessonService = (ILessonService)ctx.getBean("lessonService");
        }
        return lessonService;
    }

    private IToolContentDAO getToolContentDAO() {
        if (toolContentDAO == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getFilterConfig().getServletContext());
            toolContentDAO = (IToolContentDAO)ctx.getBean("toolContentDAO");
        }
        return toolContentDAO;
    }

    public void setToolSignature(String toolName) {
        this.toolSignature = toolName;
    }

    public void setLessonSecuredPages(String lessonSecuredPages) {
        this.lessonSecuredPages = lessonSecuredPages;
    }
}

