/*
 * Decompiled with CFR 0.152.
 */
package middlegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import middlegen.Column;
import middlegen.PreferenceAware;
import middlegen.RelationshipRole;
import middlegen.Table;
import middlegen.TableElement;
import middlegen.predicates.column.Mandatory;
import middlegen.predicates.column.PrimaryKey;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.log4j.Category;

public class DbTable
extends PreferenceAware
implements Table {
    private TableElement _tableElement;
    private final Collection _relationsipRoles = new ArrayList();
    private final String _schemaName;
    private final List _columns = new ArrayList();
    private final Map _columnSqlName2ColumnMap = new HashMap();
    private final Collection _uniqueTuples = new ArrayList();
    private static Category _log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("middlegen.DbTable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _log = Category.getInstance((String)clazz.getName());
    }

    public DbTable(TableElement tableElement, String schemaName) {
        this._tableElement = tableElement;
        this._schemaName = schemaName;
    }

    public void setPosition(int x, int y) {
        this.setPrefsValue("x", String.valueOf(x));
        this.setPrefsValue("y", String.valueOf(y));
    }

    public int getPrefsX() {
        return this.getPrefsPos("x");
    }

    public int getPrefsY() {
        return this.getPrefsPos("y");
    }

    public Collection getColumns(Predicate predicate) {
        return CollectionUtils.select((Collection)this.getColumns(), (Predicate)predicate);
    }

    public TableElement getTableElement() {
        return this._tableElement;
    }

    public String getSqlName(boolean withSchemaPrefix) {
        return withSchemaPrefix ? this.getSchemaPrefixedSqlName() : this.getSqlName();
    }

    public String getSchemaPrefixedSqlName() {
        boolean noschema = this._schemaName == null || this._schemaName.trim().equals("");
        String result = noschema ? this.getSqlName() : String.valueOf(this._schemaName) + "." + this.getSqlName();
        return result;
    }

    public String getSqlName() {
        return this.getTableElement().getPhysicalName();
    }

    public String getName() {
        return this.getTableElement().getName();
    }

    public Collection getRelationshipRoles() {
        return this._relationsipRoles;
    }

    public Collection getColumns() {
        return Collections.unmodifiableCollection(this._columns);
    }

    public final Collection getMandatoryColumns() {
        return this.getColumns(Mandatory.getInstance());
    }

    public Collection getPrimaryKeyColumns() {
        return this.getColumns(PrimaryKey.getInstance());
    }

    public Collection getRelationshipRoles(Predicate predicate) {
        return CollectionUtils.select((Collection)this.getRelationshipRoles(), (Predicate)predicate);
    }

    public Column getPkColumn() {
        Column pkColumn = null;
        Iterator i = this._columns.iterator();
        while (i.hasNext()) {
            Column column = (Column)i.next();
            if (!column.isPk()) continue;
            if (pkColumn != null) {
                pkColumn = null;
                break;
            }
            pkColumn = column;
        }
        _log.debug((Object)("Table " + this.getSqlName() + "'s unique pk column:" + pkColumn));
        return pkColumn;
    }

    public int getIndex(String columnSqlName) {
        return this._columns.indexOf(this.getColumn(columnSqlName));
    }

    public Collection getUniqueTuples() {
        return this._uniqueTuples;
    }

    public Column getColumn(String sqlName) {
        Column result = (Column)this._columnSqlName2ColumnMap.get(sqlName.toLowerCase());
        if (result == null) {
            throw new IllegalArgumentException("There is no column named " + sqlName + " in the table named " + this.getSqlName());
        }
        return result;
    }

    public void addRelationshipRole(RelationshipRole relationshipRole) {
        this._relationsipRoles.add(relationshipRole);
    }

    public void addColumn(Column column) {
        this._columns.add(column);
        this._columnSqlName2ColumnMap.put(column.getSqlName().toLowerCase(), column);
    }

    public void addUniqueTuple(Collection uniqueTuple) {
        this._uniqueTuples.add(uniqueTuple);
    }

    public void sortColumns(Comparator comparator) {
        Collections.sort(this._columns, comparator);
    }

    public boolean equals(Object o) {
        if (o instanceof Table) {
            Table other = (Table)o;
            return this.getSqlName().equals(other.getSqlName());
        }
        return false;
    }

    public int hashCode() {
        return this.getSqlName().hashCode();
    }

    protected final String prefsPrefix() {
        return "tables/" + this.getSqlName();
    }

    private int getPrefsPos(String coord) {
        String c = this.getPrefsValue(coord);
        if (c == null) {
            return Integer.MIN_VALUE;
        }
        return Integer.parseInt(c);
    }
}

