/*
 * Decompiled with CFR 0.152.
 */
package middlegen;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;

public class KindFileResourceLoader
extends ResourceLoader {
    FileResourceLoader file = new FileResourceLoader();
    ClasspathResourceLoader classpath = new ClasspathResourceLoader();

    public synchronized InputStream getResourceStream(String templateName) throws ResourceNotFoundException {
        InputStream retVal = null;
        try {
            retVal = this.file.getResourceStream(templateName);
        }
        catch (ResourceNotFoundException e) {
            this.rsvc.info((Object)("KindFileResourceLoader : file loader failed to load: " + templateName));
            try {
                retVal = this.classpath.getResourceStream(templateName);
            }
            catch (ResourceNotFoundException re) {
                this.rsvc.info((Object)("KindFileResourceLoader : classpath loader failed to load: " + templateName));
            }
        }
        if (retVal == null) {
            retVal = new ByteArrayInputStream(new byte[0]);
        }
        return retVal;
    }

    public boolean isSourceModified(Resource resource) {
        return this.file.isSourceModified(resource) || this.classpath.isSourceModified(resource);
    }

    public long getLastModified(Resource resource) {
        return this.file.getLastModified(resource) + this.classpath.getLastModified(resource);
    }

    public void init(ExtendedProperties configuration) {
        this.file.commonInit(this.rsvc, configuration);
        this.file.init(configuration);
        this.classpath.commonInit(this.rsvc, configuration);
        this.classpath.init(configuration);
    }
}

