/*
 * Decompiled with CFR 0.152.
 */
package middlegen;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import middlegen.DatabaseInfo;
import middlegen.DbTable;
import middlegen.MiddlegenException;
import middlegen.MiddlegenTask;
import middlegen.Plugin;
import middlegen.Relation;
import middlegen.Table;
import middlegen.TableElement;
import org.apache.log4j.Category;

public class Middlegen {
    private String _appName;
    private DatabaseInfo _databaseInfo;
    private final HashMap _tableElements = new HashMap();
    private MiddlegenTask _middlegenTask;
    private final Map _tables = new HashMap();
    private final List _relations = new LinkedList();
    private final Collection _plugins = new LinkedList();
    private File _rootDir;
    private final Map _pluginClasses = new HashMap();
    public static final String _NL = System.getProperty("line.separator");
    public static final String BUGREPORT = String.valueOf(_NL) + _NL + "PLEASE FILE A BUG REPORT TO http://sourceforge.net/tracker/?group_id=36044&atid=415990." + _NL + "ENCLOSE THE FOLLOWING INFORMATION:" + _NL + "-THIS STACK TRACE" + _NL + "-THE VERSION YOU'RE USING (DATE IF YOU'RE USING CVS VERSION)" + _NL + _NL + _NL;
    private static Category _log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("middlegen.Middlegen");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _log = Category.getInstance((String)clazz.getName());
    }

    public Middlegen(MiddlegenTask middlegenTask) {
        this._middlegenTask = middlegenTask;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("middlegen.Plugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registerPlugin("simple", clazz);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("middlegen.javax.JavaPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registerPlugin("java", clazz2);
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("middlegen.Plugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registerPlugin("plugin", clazz3);
    }

    public void setAppname(String s) {
        this._appName = s;
    }

    public String getAppname() {
        return this._appName;
    }

    public DatabaseInfo getDatabaseInfo() {
        return this._databaseInfo;
    }

    public Map getTableElements() {
        return this._tableElements;
    }

    public MiddlegenTask getMiddlegenTask() {
        return this._middlegenTask;
    }

    public Collection getTables() {
        return this._tables.values();
    }

    public Collection getTables(Plugin plugin) {
        LinkedList<Table> result = new LinkedList<Table>();
        Iterator i = this.getTables().iterator();
        while (i.hasNext()) {
            result.add(plugin.decorate((DbTable)i.next()));
        }
        return result;
    }

    public List getRelations() {
        return this._relations;
    }

    public Collection getPlugins() {
        return this._plugins;
    }

    public Plugin getPlugin(String name) {
        Iterator p = this.getPlugins().iterator();
        while (p.hasNext()) {
            Plugin plugin = (Plugin)p.next();
            if (!plugin.getName().equals(name)) continue;
            return plugin;
        }
        return null;
    }

    public DbTable getTable(String tableSqlName) {
        DbTable result = (DbTable)this._tables.get(tableSqlName.toLowerCase());
        if (result == null) {
            throw new IllegalArgumentException("Couldn't find any table named " + tableSqlName + ". Check the spelling and make sure it figures among the declared tables.");
        }
        return result;
    }

    public Class getPluginClass(String name) {
        return (Class)this._pluginClasses.get(name);
    }

    public boolean containsTable(String tableSqlName) {
        return this._tables.get(tableSqlName.toLowerCase()) != null;
    }

    public void addPlugin(Plugin plugin) {
        this._plugins.add(plugin);
        plugin.setMiddlegen(this);
    }

    public void addTableElement(TableElement tableElement) {
        this._tableElements.put(tableElement.getName(), tableElement);
    }

    public void clear() {
        this._tables.clear();
        this._relations.clear();
    }

    public void addTable(DbTable table) {
        this._tables.put(table.getSqlName().toLowerCase(), table);
    }

    public void addRelation(Relation relation) {
        this._relations.add(relation);
    }

    public void registerPlugin(String name, Class clazz) {
        _log.info((Object)("Registering plugin " + name + "->" + clazz.getName()));
        this._pluginClasses.put(name, clazz);
    }

    public void decorateAll() {
        Iterator i = this.getPlugins().iterator();
        while (i.hasNext()) {
            Plugin plugin = (Plugin)i.next();
            plugin.decorateAll(this.getTables());
        }
    }

    public void validate() throws MiddlegenException {
        HashSet<String> pluginNames = new HashSet<String>();
        Iterator pluginIterator = this.getPlugins().iterator();
        while (pluginIterator.hasNext()) {
            Plugin plugin = (Plugin)pluginIterator.next();
            if (pluginNames.contains(plugin.getName())) {
                String msg = "There is already a plugin with the name " + plugin.getName() + ". If you're trying to use several plugins of the same type, please " + "give them a different name. This can be done with the name attribute in the plugin.";
                _log.error((Object)msg);
                throw new MiddlegenException(msg);
            }
            pluginNames.add(plugin.getName());
            _log.info((Object)("Validating " + plugin.getName()));
            plugin.validate();
        }
    }

    public void writeSource() throws MiddlegenException {
        Iterator pluginIterator = this.getPlugins().iterator();
        while (pluginIterator.hasNext()) {
            Plugin plugin = (Plugin)pluginIterator.next();
            _log.info((Object)("Invoking plugin " + plugin.getName()));
            plugin.generate();
        }
    }

    void setDatabaseInfo(DatabaseInfo databaseInfo) {
        this._databaseInfo = databaseInfo;
    }
}

