/*
 * Decompiled with CFR 0.152.
 */
package middlegen;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import middlegen.Column;
import middlegen.ColumnMap;
import middlegen.CrossrefElement;
import middlegen.Database;
import middlegen.DatabaseInfo;
import middlegen.DbColumn;
import middlegen.DbNameConverter;
import middlegen.DbTable;
import middlegen.Many2ManyElement;
import middlegen.Middlegen;
import middlegen.MiddlegenException;
import middlegen.Relation;
import middlegen.RelationshipRole;
import middlegen.TableElement;
import middlegen.Util;
import middlegen.javax.Sql2Java;
import org.apache.log4j.Category;

public class MiddlegenPopulator {
    private Database _database;
    private DatabaseMetaData _metaData;
    private Middlegen _middlegen;
    private String _schema;
    private String _catalog;
    private String[] _types = null;
    private final Map _many2many;
    private Connection _connection;
    private String _sortColumns;
    private final Collection EMPTY_COLLECTION = new ArrayList(0);
    private static Category _log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("middlegen.MiddlegenPopulator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _log = Category.getInstance((String)clazz.getName());
    }

    public MiddlegenPopulator(Middlegen middlegen, Database database, String schema, String catalog, Map many2many, String sortColumns) throws MiddlegenException {
        this._middlegen = middlegen;
        this._database = database;
        this._schema = Util.ensureNotNull(schema);
        this._catalog = catalog;
        this._many2many = many2many;
        this._sortColumns = sortColumns == null ? null : sortColumns.toLowerCase();
        try {
            this.tune(this.getConnection().getMetaData());
        }
        catch (SQLException e) {
            throw new MiddlegenException("Couldn't tune database:" + e.getMessage());
        }
    }

    public void addRegularTableElements() throws MiddlegenException {
        ResultSet tableRs = null;
        try {
            try {
                tableRs = this.getMetaData().getTables(this._catalog, this._schema, null, this._types);
                while (tableRs.next()) {
                    String tableName = tableRs.getString("TABLE_NAME");
                    String tableType = tableRs.getString("TABLE_TYPE");
                    String schemaName = tableRs.getString("TABLE_SCHEM");
                    String ownerSinonimo = null;
                    if ("TABLE".equals(tableType) || this._middlegen.getMiddlegenTask().isIncludeViews() && "VIEW".equals(tableType) || "SYNONYM".equals(tableType) && this.isOracle()) {
                        _log.debug((Object)("schema:" + this._schema + "," + schemaName));
                        _log.debug((Object)("table:" + tableName));
                        TableElement tableElement = new TableElement();
                        tableElement.setName(tableName);
                        if ("SYNONYM".equals(tableType) && this.isOracle() && (ownerSinonimo = this.getSynonymOwner(tableName)) != null) {
                            tableElement.setOwnerSynonymName(ownerSinonimo);
                        }
                        this._middlegen.addTableElement(tableElement);
                        continue;
                    }
                    _log.debug((Object)("Ignoring table " + tableName + " of type " + tableType));
                }
                if (this._middlegen.getTableElements().isEmpty()) {
                    String databaseStructure = this.getDatabaseStructure();
                    throw new MiddlegenException("Middlegen successfully connected to the database, but couldn't find any tables. Perhaps the specified schema or catalog is wrong? -Or maybe there aren't any tables in the database at all?" + databaseStructure);
                }
            }
            catch (SQLException e) {
                String databaseStructure = this.getDatabaseStructure();
                _log.error((Object)e.getMessage(), (Throwable)e);
                throw new MiddlegenException("Couldn't get list of tables from database. Probably a JDBC driver problem." + databaseStructure);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            try {
                tableRs.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
        Object var7_11 = null;
        try {
            tableRs.close();
        }
        catch (Exception ignore) {}
    }

    public void closeConnection() {
        try {
            if (this._connection != null) {
                this._connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void populate(Map wantedTables) throws MiddlegenException {
        try {
            DbTable table;
            this.addTables(wantedTables);
            Iterator tableIterator = this._middlegen.getTables().iterator();
            while (tableIterator.hasNext()) {
                table = (DbTable)tableIterator.next();
                this.addColumns(table);
            }
            tableIterator = this._middlegen.getTables().iterator();
            while (tableIterator.hasNext()) {
                table = (DbTable)tableIterator.next();
                this.addRelations(table, wantedTables);
            }
            if (this._middlegen.getRelations().size() == 0) {
                _log.warn((Object)"WARNING: Middlegen couldn't find any relations between any tables. This may be intentional from the design of the database, but it may also be because you have incorrectly defined the relationships. It could also be because the JDBC driver you're using doesn't correctly implement DatabaseMetaData. See the samples (for an example on how to define relationships) and verify that your driver correctly implements DatabaseMetaData.");
            }
            this.markFksToUnwantedTables();
            this.addMany2ManyRelations();
            this.warnUnidentifiedM2ms();
            this.getConnection().close();
            if (this._sortColumns != null) {
                ColumnComparator comparator = new ColumnComparator(this._sortColumns);
                Iterator tableIterator2 = this._middlegen.getTables().iterator();
                while (tableIterator2.hasNext()) {
                    DbTable table2 = (DbTable)tableIterator2.next();
                    table2.sortColumns(comparator);
                }
            }
        }
        catch (SQLException e) {
            _log.error((Object)e.getMessage(), (Throwable)e);
            throw new MiddlegenException("Database problem:" + e.getMessage());
        }
    }

    protected void addRelations(DbTable pkTable, Map wantedTables) throws MiddlegenException, SQLException {
        HashMap fkTables = new HashMap();
        int bogusFkName = 0;
        ResultSet exportedKeyRs = null;
        exportedKeyRs = pkTable.getTableElement().getOwnerSynonymName() != null ? this.getMetaData().getExportedKeys(this._catalog, pkTable.getTableElement().getOwnerSynonymName(), pkTable.getSqlName()) : this.getMetaData().getExportedKeys(this._catalog, this._schema, pkTable.getSqlName());
        while (exportedKeyRs.next()) {
            String fkTableName = exportedKeyRs.getString("FKTABLE_NAME");
            String fkColumnName = exportedKeyRs.getString("FKCOLUMN_NAME");
            if (this.isWantedTable(wantedTables, fkTableName)) {
                String pkColumnName = exportedKeyRs.getString("PKCOLUMN_NAME");
                String fkName = exportedKeyRs.getString("FK_NAME");
                short keySeq = exportedKeyRs.getShort("KEY_SEQ");
                if (keySeq == 0) {
                    bogusFkName = (short)(bogusFkName + 1);
                }
                if (fkName == null) {
                    fkName = String.valueOf(bogusFkName);
                }
                this.addCrossref(pkTable, pkColumnName, fkTableName, fkColumnName, fkName, fkTables);
                continue;
            }
            _log.info((Object)("Found a relation between " + pkTable.getSqlName() + " and " + fkTableName + ". Skipping it since " + fkTableName + " isn't among the specified tables."));
        }
        exportedKeyRs.close();
        Iterator crossrefs = pkTable.getTableElement().getCrossrefs().iterator();
        while (crossrefs.hasNext()) {
            CrossrefElement crossref = (CrossrefElement)crossrefs.next();
            if (wantedTables.containsKey(crossref.getFktable())) {
                String pkColumnName;
                String fkName = crossref.getName();
                if (fkName == null) {
                    bogusFkName = (short)(bogusFkName + 1);
                    fkName = String.valueOf(bogusFkName);
                }
                if ((pkColumnName = crossref.getPkcolumn()) == null) {
                    Column pkColumn = pkTable.getPkColumn();
                    if (pkColumn != null) {
                        pkColumnName = pkColumn.getSqlName();
                    } else {
                        throw new MiddlegenException("In custom defined crossref, the table " + pkTable.getSqlName() + " doesn't have a single-column primary key. You must therefore explicitly " + "declare pkcolumn=\"something\" in the crossref element.");
                    }
                }
                this.addCrossref(pkTable, pkColumnName, crossref.getFktable(), crossref.getFkcolumn(), fkName, fkTables);
                continue;
            }
            _log.info((Object)("The declared relation between " + pkTable.getSqlName() + " and " + crossref.getFktable() + " will be skipped since " + crossref.getFktable() + " isn't among the specified tables."));
        }
        Iterator fkTableIterator = fkTables.keySet().iterator();
        while (fkTableIterator.hasNext()) {
            DbTable fkTable = (DbTable)fkTableIterator.next();
            Map fkNameToColumnMapsMap = (Map)fkTables.get(fkTable);
            Iterator fkIterator = fkNameToColumnMapsMap.keySet().iterator();
            while (fkIterator.hasNext()) {
                String fkName = (String)fkIterator.next();
                Collection columnMaps = (Collection)fkNameToColumnMapsMap.get(fkName);
                if (columnMaps.size() < pkTable.getPrimaryKeyColumns().size()) {
                    _log.warn((Object)("WARNING: There is a relation between " + fkTable.getSqlName() + " and " + pkTable.getSqlName() + " that doesn't include all the " + " primary key columns. This may cause errors later on."));
                }
                ColumnMap[] columnMapArray = new ColumnMap[columnMaps.size()];
                columnMapArray = columnMaps.toArray(columnMapArray);
                String relationSuffix = "";
                String fkRoleSuffix = "";
                if (fkNameToColumnMapsMap.size() > 1) {
                    relationSuffix = "-";
                    fkRoleSuffix = String.valueOf(fkRoleSuffix) + "_by_";
                    int i = 0;
                    while (i < columnMapArray.length) {
                        if (i >= 1) {
                            relationSuffix = String.valueOf(relationSuffix) + "-";
                            fkRoleSuffix = String.valueOf(fkRoleSuffix) + "_and_";
                        }
                        relationSuffix = String.valueOf(relationSuffix) + columnMapArray[i].getForeignKey().toLowerCase();
                        fkRoleSuffix = String.valueOf(fkRoleSuffix) + columnMapArray[i].getForeignKey();
                        ++i;
                    }
                }
                fkRoleSuffix = DbNameConverter.getInstance().columnNameToVariableName(fkRoleSuffix);
                _log.debug((Object)("relationSuffix:" + relationSuffix + " (" + fkRoleSuffix + ")"));
                Relation relation = new Relation(pkTable, columnMapArray, fkTable, new ColumnMap[0], null, relationSuffix, fkRoleSuffix);
                this._middlegen.addRelation(relation);
            }
        }
    }

    String getSchemaName() {
        return this._schema;
    }

    private boolean isWantedTable(Map wantedTables, String tableName) {
        if (wantedTables.containsKey(tableName)) {
            return true;
        }
        Iterator i = wantedTables.keySet().iterator();
        while (i.hasNext()) {
            String wantedTableName = (String)i.next();
            if (!wantedTableName.toLowerCase().equals(tableName.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private String getDatabaseStructure() throws MiddlegenException {
        ResultSet schemaRs = null;
        ResultSet catalogRs = null;
        String nl = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer(nl);
        sb.append("Configured schema:").append(this._schema).append(nl);
        sb.append("Configured catalog:").append(this._catalog).append(nl);
        try {
            try {
                schemaRs = this.getMetaData().getSchemas();
                sb.append("Available schemas:").append(nl);
                while (schemaRs.next()) {
                    sb.append("  ").append(schemaRs.getString("TABLE_SCHEM")).append(nl);
                }
            }
            catch (SQLException e2) {
                _log.warn((Object)"Couldn't get schemas", (Throwable)e2);
                sb.append("  ?? Couldn't get schemas ??").append(nl);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                schemaRs.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
        Object var6_10 = null;
        try {
            schemaRs.close();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            try {
                catalogRs = this.getMetaData().getCatalogs();
                sb.append("Available catalogs:").append(nl);
                while (catalogRs.next()) {
                    sb.append("  ").append(catalogRs.getString("TABLE_CAT")).append(nl);
                }
            }
            catch (SQLException e2) {
                _log.warn((Object)"Couldn't get catalogs", (Throwable)e2);
                sb.append("  ?? Couldn't get catalogs ??").append(nl);
            }
        }
        catch (Throwable throwable) {
            var6_10 = null;
            try {
                catalogRs.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
        var6_10 = null;
        try {
            catalogRs.close();
        }
        catch (Exception ignore) {}
        return sb.toString();
    }

    private String getDatabaseTables() throws MiddlegenException {
        String nl = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer(nl);
        sb.append("Found the following tables:");
        sb.append(nl);
        ResultSet tableRs = null;
        try {
            try {
                tableRs = this.getMetaData().getTables(this._catalog, this._schema, null, this._types);
                while (tableRs.next()) {
                    String realTableName = tableRs.getString("TABLE_NAME");
                    sb.append(realTableName);
                    sb.append(" ");
                }
            }
            catch (SQLException e2) {
                _log.warn((Object)"Couldn't get schemas", (Throwable)e2);
                sb.append("  ?? Couldn't get schemas ??").append(nl);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {
                tableRs.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
        Object var5_8 = null;
        try {
            tableRs.close();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        sb.append(nl);
        sb.append("----");
        sb.append(nl);
        return sb.toString();
    }

    private Connection getConnection() throws MiddlegenException {
        if (this._connection == null) {
            this._connection = this._database.getConnection();
        }
        return this._connection;
    }

    private DatabaseMetaData getMetaData() throws MiddlegenException {
        if (this._metaData == null) {
            try {
                this._metaData = this.getConnection().getMetaData();
            }
            catch (SQLException e) {
                throw new MiddlegenException("Couldn't load Metadata");
            }
        }
        return this._metaData;
    }

    private Collection getM2Ms(String table1, String table2) {
        String orderedNameWithoutJoinTable;
        Collection result;
        if (table1.compareTo(table2) > 0) {
            String swap = table1;
            table1 = table2;
            table2 = swap;
        }
        if ((result = (Collection)this._many2many.get(orderedNameWithoutJoinTable = String.valueOf(table1) + "--" + table2)) == null) {
            result = this.EMPTY_COLLECTION;
        }
        return result;
    }

    private boolean isWanted(String table1, String jointable, String table2) {
        boolean result = false;
        Collection candidates = this.getM2Ms(table1, table2);
        Iterator i = candidates.iterator();
        while (i.hasNext()) {
            Many2ManyElement eminem = (Many2ManyElement)i.next();
            if (!eminem.matches(table1, jointable, table2)) continue;
            result = true;
            break;
        }
        return result;
    }

    private String getRelationSuffix(Relation a, Relation b) {
        String result = a.getRelationSuffix().equals("") || b.getRelationSuffix().equals("") ? String.valueOf(a.getRelationSuffix()) + b.getRelationSuffix() : String.valueOf(a.getRelationSuffix()) + "-" + b.getRelationSuffix();
        if (!result.equals("")) {
            result = "-by-" + result;
        }
        return result;
    }

    private String getFkRoleSuffix(Relation a, Relation b) {
        String result = a.getFkRoleSuffix().equals("") || b.getFkRoleSuffix().equals("") ? String.valueOf(a.getFkRoleSuffix()) + b.getFkRoleSuffix() : String.valueOf(a.getFkRoleSuffix()) + "-" + b.getFkRoleSuffix();
        if (!result.equals("")) {
            result = "_by_" + result;
        }
        return result;
    }

    private boolean isOracle() {
        boolean ret = false;
        try {
            ret = this.getMetaData().getDatabaseProductName().toLowerCase().indexOf("oracle") != -1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private String getSynonymOwner(String synonymName) throws MiddlegenException {
        String ret;
        block17: {
            PreparedStatement ps = null;
            ResultSet rs = null;
            ret = null;
            try {
                try {
                    ps = this.getConnection().prepareStatement("select table_owner from sys.all_synonyms where table_name=? and owner=?");
                    ps.setString(1, synonymName);
                    ps.setString(2, this._schema);
                    rs = ps.executeQuery();
                    if (!rs.next()) {
                        String databaseStructure = this.getDatabaseStructure();
                        throw new MiddlegenException("Wow! Synonym " + synonymName + " not found. How can it happen? " + databaseStructure);
                    }
                    ret = rs.getString(1);
                }
                catch (SQLException e) {
                    String databaseStructure = this.getDatabaseStructure();
                    _log.error((Object)e.getMessage(), (Throwable)e);
                    throw new MiddlegenException("Exception in getting synonym owner " + databaseStructure);
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            Object var7_10 = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (ps == null) break block17;
            try {
                ps.close();
            }
            catch (Exception e) {}
        }
        return ret;
    }

    private void markFksToUnwantedTables() throws MiddlegenException {
        ResultSet tableRs = null;
        try {
            try {
                tableRs = this.getMetaData().getTables(this._catalog, this._schema, null, this._types);
                while (tableRs.next()) {
                    String tableName = tableRs.getString("TABLE_NAME");
                    String tableType = tableRs.getString("TABLE_TYPE");
                    if ((!"TABLE".equals(tableType) || this._middlegen.containsTable(tableName)) && (!"SYNONYM".equals(tableType) || !this.isOracle())) continue;
                    String ownerSinonimo = null;
                    if ("SYNONYM".equals(tableType) && this.isOracle()) {
                        ownerSinonimo = this.getSynonymOwner(tableName);
                    }
                    ResultSet exportedKeyRs = null;
                    exportedKeyRs = ownerSinonimo != null ? this.getMetaData().getExportedKeys(this._catalog, ownerSinonimo, tableName) : this.getMetaData().getExportedKeys(this._catalog, this._schema, tableName);
                    while (exportedKeyRs.next()) {
                        String fkTableName = exportedKeyRs.getString("FKTABLE_NAME");
                        String fkColumnName = exportedKeyRs.getString("FKCOLUMN_NAME");
                        if (!this._middlegen.containsTable(fkTableName)) continue;
                        DbTable fkTable = this._middlegen.getTable(fkTableName);
                        DbColumn fkColumn = (DbColumn)fkTable.getColumn(fkColumnName);
                        fkColumn.setFk(true);
                    }
                }
            }
            catch (SQLException e) {
                String databaseStructure = this.getDatabaseStructure();
                _log.error((Object)e.getMessage(), (Throwable)e);
                throw new MiddlegenException("Couldn't get list of tables from database. Probably a JDBC driver problem." + databaseStructure);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            try {
                tableRs.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
        Object var10_14 = null;
        try {
            tableRs.close();
        }
        catch (Exception ignore) {}
    }

    private void addCrossref(DbTable pkTable, String pkColumnName, String fkTableName, String fkColumnName, String fkName, Map fkTables) {
        ArrayList<ColumnMap> columnMaps;
        HashMap<String, ArrayList<ColumnMap>> fkNameToColumnMapsMap;
        DbTable fkTable = this._middlegen.getTable(fkTableName);
        DbColumn pkColumn = (DbColumn)pkTable.getColumn(pkColumnName);
        if (!pkColumn.isPk()) {
            _log.warn((Object)("WARNING: In the relation involving foreign key column " + fkTableName + "(" + fkColumnName + ") and primary key column " + pkTable.getSqlName() + "(" + pkColumnName + ") the primary key column isn't " + "declared as a primary key column in the database. This may cause errors later on."));
        }
        if ((fkNameToColumnMapsMap = (HashMap<String, ArrayList<ColumnMap>>)fkTables.get(fkTable)) == null) {
            fkNameToColumnMapsMap = new HashMap<String, ArrayList<ColumnMap>>();
            fkTables.put(fkTable, fkNameToColumnMapsMap);
        }
        if ((columnMaps = (ArrayList<ColumnMap>)fkNameToColumnMapsMap.get(fkName)) == null) {
            columnMaps = new ArrayList<ColumnMap>();
            fkNameToColumnMapsMap.put(fkName, columnMaps);
        }
        columnMaps.add(new ColumnMap(pkColumnName, fkColumnName));
        DbColumn fkColumn = (DbColumn)fkTable.getColumn(fkColumnName);
        fkColumn.setFk(true);
    }

    private void addColumns(DbTable table) throws MiddlegenException, SQLException {
        List l;
        _log.debug((Object)("-------setColumns(" + table.getSqlName() + ")"));
        LinkedList<String> primaryKeys = new LinkedList<String>();
        ResultSet primaryKeyRs = null;
        primaryKeyRs = table.getTableElement().getOwnerSynonymName() != null ? this.getMetaData().getPrimaryKeys(this._catalog, table.getTableElement().getOwnerSynonymName(), table.getSqlName()) : this.getMetaData().getPrimaryKeys(this._catalog, this._schema, table.getSqlName());
        while (primaryKeyRs.next()) {
            String columnName = primaryKeyRs.getString("COLUMN_NAME");
            _log.debug((Object)("primary key:" + columnName));
            primaryKeys.add(columnName);
        }
        primaryKeyRs.close();
        LinkedList<String> indices = new LinkedList<String>();
        HashMap<String, String> uniqueIndices = new HashMap<String, String>();
        HashMap<String, ArrayList<String>> uniqueColumns = new HashMap<String, ArrayList<String>>();
        ResultSet indexRs = null;
        try {
            try {
                indexRs = table.getTableElement().getOwnerSynonymName() != null ? this.getMetaData().getIndexInfo(this._catalog, table.getTableElement().getOwnerSynonymName(), table.getSqlName(), false, true) : this.getMetaData().getIndexInfo(this._catalog, this._schema, table.getSqlName(), false, true);
                while (indexRs.next()) {
                    String columnName = indexRs.getString("COLUMN_NAME");
                    if (columnName != null) {
                        _log.debug((Object)("index:" + columnName));
                        indices.add(columnName);
                    }
                    String indexName = indexRs.getString("INDEX_NAME");
                    boolean nonUnique = indexRs.getBoolean("NON_UNIQUE");
                    if (nonUnique || columnName == null || indexName == null) continue;
                    l = (ArrayList<String>)uniqueColumns.get(indexName);
                    if (l == null) {
                        l = new ArrayList<String>();
                        uniqueColumns.put(indexName, (ArrayList<String>)l);
                    }
                    l.add(columnName);
                    uniqueIndices.put(columnName, indexName);
                    _log.debug((Object)("unique:" + columnName + " (" + indexName + ")"));
                }
            }
            catch (Throwable columnName) {}
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (indexRs != null) {
                indexRs.close();
            }
            throw throwable;
        }
        Object var12_17 = null;
        if (indexRs != null) {
            indexRs.close();
        }
        LinkedList<DbColumn> columns = new LinkedList<DbColumn>();
        ResultSet columnRs = null;
        columnRs = table.getTableElement().getOwnerSynonymName() != null ? this.getMetaData().getColumns(this._catalog, table.getTableElement().getOwnerSynonymName(), table.getSqlName(), null) : this.getMetaData().getColumns(this._catalog, this._schema, table.getSqlName(), null);
        while (columnRs.next()) {
            boolean isUnique;
            int sqlType = columnRs.getInt("DATA_TYPE");
            String sqlTypeName = columnRs.getString("TYPE_NAME");
            String columnName = columnRs.getString("COLUMN_NAME");
            String columnDefaultValue = columnRs.getString("COLUMN_DEF");
            boolean isNullable = 1 == columnRs.getInt("NULLABLE");
            int size = columnRs.getInt("COLUMN_SIZE");
            int decimalDigits = columnRs.getInt("DECIMAL_DIGITS");
            boolean isPk = false;
            Collection pkColumnsOverride = table.getTableElement().getPkColumnsOverrideCollection();
            isPk = pkColumnsOverride.size() > 0 ? pkColumnsOverride.contains(columnName) : primaryKeys.contains(columnName);
            boolean isIndexed = indices.contains(columnName);
            String uniqueIndex = (String)uniqueIndices.get(columnName);
            List columnsInUniqueIndex = null;
            if (uniqueIndex != null) {
                columnsInUniqueIndex = (List)uniqueColumns.get(uniqueIndex);
            }
            boolean bl = isUnique = columnsInUniqueIndex != null && columnsInUniqueIndex.size() == 1;
            if (isUnique) {
                _log.debug((Object)("unique column:" + columnName));
            }
            DbColumn column = new DbColumn(table, sqlType, sqlTypeName, columnName, size, decimalDigits, isPk, isNullable, isIndexed, isUnique, columnDefaultValue);
            columns.add(column);
        }
        columnRs.close();
        Iterator<Object> i = columns.iterator();
        while (i.hasNext()) {
            Column column = (Column)i.next();
            table.addColumn(column);
        }
        i = uniqueColumns.values().iterator();
        while (i.hasNext()) {
            l = (List)i.next();
            ArrayList<Column> uniqueTuple = new ArrayList<Column>();
            Iterator j = l.iterator();
            while (j.hasNext()) {
                String colName = (String)j.next();
                Column column = table.getColumn(colName);
                uniqueTuple.add(column);
            }
            table.addUniqueTuple(uniqueTuple);
        }
        if (primaryKeys.size() == 0) {
            _log.warn((Object)("WARNING: The JDBC driver didn't report any primary key columns in " + table.getSqlName()));
        }
    }

    private void tune(DatabaseMetaData metaData) throws SQLException {
        String databaseProductName = metaData.getDatabaseProductName();
        String databaseProductVersion = metaData.getDatabaseProductVersion();
        String driverName = metaData.getDriverName();
        String driverVersion = metaData.getDriverVersion();
        DatabaseInfo databaseInfo = new DatabaseInfo(databaseProductName, databaseProductVersion, driverName, driverVersion);
        this._middlegen.setDatabaseInfo(databaseInfo);
        _log.debug((Object)("databaseProductName=" + databaseProductName));
        _log.debug((Object)("databaseProductVersion=" + databaseProductVersion));
        _log.debug((Object)("driverName=" + driverName));
        _log.debug((Object)("driverVersion=" + driverVersion));
        _log.debug((Object)("schema=" + this._schema));
        _log.debug((Object)("catalog=" + this._catalog));
        if (this.isOracle()) {
            if (this._catalog != null) {
                this._catalog = this._catalog.toUpperCase();
            }
            if (this._schema != null) {
                this._schema = this._schema.toUpperCase();
            }
            this._types = new String[]{"TABLE", "VIEW", "SYNONYM"};
        }
        if (databaseProductName.toLowerCase().indexOf("microsoft") != -1) {
            Sql2Java.overridePreferredJavaTypeForSqlType(-2, "java.lang.String");
        }
        databaseProductName.toLowerCase().indexOf("hsql");
    }

    private void addMany2ManyRelations() {
        List relations = this._middlegen.getRelations();
        int one2manyCount = relations.size();
        int i = 0;
        while (i < one2manyCount - 1) {
            Relation firstRelation = (Relation)relations.get(i);
            RelationshipRole firstRole = firstRelation.getLeftRole();
            _log.debug((Object)("first:" + firstRole.getName()));
            int j = i + 1;
            while (j < one2manyCount) {
                Relation secondRelation = (Relation)relations.get(j);
                RelationshipRole secondRole = secondRelation.getLeftRole();
                _log.debug((Object)("second:" + secondRole.getName()));
                if (firstRole.getTarget() == secondRole.getTarget() && firstRole.getTarget() != null && this.isWanted(firstRole.getOrigin().getSqlName(), firstRole.getTarget().getSqlName(), secondRole.getOrigin().getSqlName())) {
                    Collection m2mElements = this.getM2Ms(firstRole.getOrigin().getSqlName(), secondRole.getOrigin().getSqlName());
                    String relationSuffix = null;
                    String fkRoleSuffix = null;
                    if (m2mElements.size() > 1) {
                        relationSuffix = "-via-" + firstRole.getTarget().getSqlName() + this.getRelationSuffix(firstRelation, secondRelation);
                        fkRoleSuffix = "_via_" + firstRole.getTarget().getSqlName() + this.getRelationSuffix(firstRelation, secondRelation);
                        fkRoleSuffix = DbNameConverter.getInstance().columnNameToVariableName(fkRoleSuffix);
                    } else {
                        relationSuffix = this.getRelationSuffix(firstRelation, secondRelation);
                        fkRoleSuffix = this.getRelationSuffix(firstRelation, secondRelation);
                    }
                    Relation m2m = new Relation(firstRole.getOrigin(), firstRole.getColumnMaps(), secondRole.getOrigin(), secondRole.getColumnMaps(), firstRole.getTarget(), relationSuffix, fkRoleSuffix);
                    this._middlegen.addRelation(m2m);
                }
                ++j;
            }
            ++i;
        }
    }

    private void warnUnidentifiedM2ms() {
        Iterator i = this._many2many.values().iterator();
        while (i.hasNext()) {
            Collection c = (Collection)i.next();
            Iterator j = c.iterator();
            while (j.hasNext()) {
                Many2ManyElement eminem = (Many2ManyElement)j.next();
                if (eminem.isMatched()) continue;
                _log.warn((Object)("The many2many relation " + eminem.toString() + " was declared, but not identified."));
            }
        }
    }

    private void addTables(Map wantedTables) throws MiddlegenException, SQLException {
        _log.debug((Object)"-- tables --");
        HashMap<String, String> tableSchemaMap = new HashMap<String, String>();
        Iterator tableElementIterator = wantedTables.values().iterator();
        while (tableElementIterator.hasNext()) {
            NullPointerException ignore2;
            SQLException sQLException2;
            Object var11_11;
            TableElement tableElement = (TableElement)tableElementIterator.next();
            String tableName = tableElement.getName();
            String schemaName = null;
            ResultSet tableRs = null;
            try {
                String alreadySchema;
                tableRs = this.getMetaData().getTables(this._catalog, this._schema, tableName, this._types);
                if (!(tableRs.next() || (tableRs = this.getMetaData().getTables(this._catalog, this._schema, tableName.toLowerCase(), this._types)).next() || (tableRs = this.getMetaData().getTables(this._catalog, this._schema, tableName.toUpperCase(), this._types)).next())) {
                    throw new MiddlegenException("The database doesn't have any table named " + tableName + ".  Please make sure the table exists. Also note that some databases are case sensitive." + this.getDatabaseTables());
                }
                schemaName = Util.ensureNotNull(tableRs.getString("TABLE_SCHEM"));
                String realTableName = tableRs.getString("TABLE_NAME");
                String tableType = tableRs.getString("TABLE_TYPE");
                tableElement.setPhysicalName(realTableName);
                if ("SYNONYM".equals(tableType) && this.isOracle()) {
                    tableElement.setOwnerSynonymName(this.getSynonymOwner(realTableName));
                }
                if ((alreadySchema = (String)tableSchemaMap.get(realTableName)) != null) {
                    throw new MiddlegenException("The table named " + realTableName + " was found both in the schema " + "named " + alreadySchema + " and in the schema named " + schemaName + ". " + "You have to specify schema=\"something\" in the middlegen task.");
                }
                tableSchemaMap.put(realTableName, schemaName);
                if (!(Util.equals(this._schema, schemaName) || "SYNONYM".equals(tableType) && this.isOracle())) {
                    _log.warn((Object)("The table named " + realTableName + " was found in the schema " + "named \"" + schemaName + "\". However, Middlegen was not configured " + "to look for tables in a specific schema. You should consider specifying " + "schema=\"" + schemaName + "\" instead of schema=\"" + this._schema + "\" in the middlegen task."));
                }
            }
            catch (Throwable throwable) {
                var11_11 = null;
                try {
                    tableRs.close();
                }
                catch (SQLException sQLException2) {
                }
                catch (NullPointerException ignore2) {
                    // empty catch block
                }
                throw throwable;
            }
            var11_11 = null;
            try {
                tableRs.close();
            }
            catch (SQLException sQLException2) {
            }
            catch (NullPointerException ignore2) {
                // empty catch block
            }
            DbTable table = new DbTable(tableElement, schemaName);
            table.init();
            this._middlegen.addTable(table);
        }
    }

    private static class ColumnComparator
    implements Comparator {
        private String _orderBy;

        public ColumnComparator(String orderBy) {
            this._orderBy = orderBy;
        }

        public int compare(Object o1, Object o2) {
            int priority2;
            Column c1 = (Column)o1;
            Column c2 = (Column)o2;
            if (c1.equals(c2)) {
                return 0;
            }
            int priority1 = this.getColumnPriority(c1);
            if (priority1 < (priority2 = this.getColumnPriority(c2))) {
                return -1;
            }
            if (priority1 > priority2) {
                return 1;
            }
            return c1.getSqlName().compareTo(c2.getSqlName());
        }

        private int getColumnPriority(Column column) {
            int priority = this._orderBy.length();
            int pos = -1;
            if (column.isPk() && (pos = this._orderBy.indexOf("pk")) >= 0 && pos < priority) {
                priority = pos;
            }
            if (column.isFk() && (pos = this._orderBy.indexOf("fk")) >= 0 && pos < priority) {
                priority = pos;
            }
            if (column.isNullable() && (pos = this._orderBy.indexOf("nullable")) >= 0 && pos < priority) {
                priority = pos;
            }
            if (!column.isNullable() && (pos = this._orderBy.indexOf("mandatory")) >= 0 && pos < priority) {
                priority = pos;
            }
            if (column.isIndexed() && (pos = this._orderBy.indexOf("indexed")) >= 0 && pos < priority) {
                priority = pos;
            }
            if (column.isUnique() && (pos = this._orderBy.indexOf("unique")) >= 0 && pos < priority) {
                priority = pos;
            }
            return priority;
        }
    }
}

