/*
 * Decompiled with CFR 0.152.
 */
package middlegen;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import middlegen.Column;
import middlegen.ColumnDecorator;
import middlegen.DbColumn;
import middlegen.DbTable;
import middlegen.FileProducer;
import middlegen.Middlegen;
import middlegen.MiddlegenException;
import middlegen.Table;
import middlegen.TableDecorator;
import middlegen.swing.JColumnSettingsPanel;
import middlegen.swing.JTableSettingsPanel;
import org.apache.log4j.Category;
import org.apache.velocity.app.VelocityEngine;

public class Plugin {
    private Middlegen _middlegen;
    private final HashMap _columnDecorators = new HashMap();
    private final HashMap _tableDecorators = new HashMap();
    private final Class[] _columnDecoratorConstructorArgs;
    private final Class[] _tableDecoratorConstructorArgs;
    private File _destinationDir;
    private String _name;
    private String _mergedir;
    private HashMap _fileProducers;
    private String _displayName;
    private boolean _useSchemaPrefix;
    private static Category _log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    static {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("middlegen.Plugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _log = Category.getInstance((String)clazz.getName());
    }

    public Plugin() {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("middlegen.Column");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        this._columnDecoratorConstructorArgs = classArray;
        Class[] classArray2 = new Class[1];
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("middlegen.Table");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[0] = clazz2;
        this._tableDecoratorConstructorArgs = classArray2;
        this._fileProducers = new HashMap();
        this._useSchemaPrefix = false;
    }

    public void setUseSchemaPrefix(boolean flag) {
        this._useSchemaPrefix = flag;
    }

    public void setMergedir(String md) {
        this._mergedir = md;
    }

    public void setDestination(File dir) {
        this._destinationDir = dir;
    }

    public final void setName(String name) {
        this._name = name;
    }

    public boolean isUseSchemaPrefix() {
        return this._useSchemaPrefix;
    }

    public String getRelationName(Table table) {
        return String.valueOf(table.getSqlName()) + "-" + this.getName();
    }

    public Middlegen getMiddlegen() {
        return this._middlegen;
    }

    public File getDestinationDir() {
        return this._destinationDir;
    }

    public JColumnSettingsPanel getColumnSettingsPanel() {
        return null;
    }

    public JTableSettingsPanel getTableSettingsPanel() {
        return null;
    }

    public final String getDisplayName() {
        return this._displayName;
    }

    public final String getName() {
        return this._name;
    }

    public Class getColumnDecoratorClass() {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("middlegen.ColumnDecorator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public Class getTableDecoratorClass() {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("middlegen.TableDecorator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public final Collection getTables() {
        return this._tableDecorators.values();
    }

    public final TableDecorator getTable(String sqlName) {
        return (TableDecorator)this._tableDecorators.get(sqlName);
    }

    public String getMergedir() {
        return this._mergedir;
    }

    public void addConfiguredFileproducer(FileProducer fileProducer) {
        FileProducer customFileProducer;
        fileProducer.validate();
        String id = fileProducer.getId();
        if (id == null) {
            fileProducer.setId("__custom_" + this._fileProducers.size());
        }
        if ((customFileProducer = (FileProducer)this._fileProducers.get(id)) != null) {
            customFileProducer.copyPropsFrom(fileProducer);
        } else {
            this._fileProducers.put(fileProducer.getId(), fileProducer);
        }
    }

    public final void decorateAll(Collection tables) {
        Iterator tableIterator = tables.iterator();
        while (tableIterator.hasNext()) {
            DbTable table = (DbTable)tableIterator.next();
            TableDecorator tableDecorator = this.createDecorator(table);
            tableDecorator.setPlugin(this);
            this._tableDecorators.put(table.getSqlName(), tableDecorator);
            DbColumn pkColumn = (DbColumn)table.getPkColumn();
            if (pkColumn != null) {
                ColumnDecorator pkColumnDecorator = this.createDecorator(pkColumn);
                pkColumnDecorator.setTableDecorator(tableDecorator);
                tableDecorator.setPkColumnDecorator(pkColumnDecorator);
                this._columnDecorators.put(pkColumn, pkColumnDecorator);
            }
            ArrayList<ColumnDecorator> columnDecorators = new ArrayList<ColumnDecorator>(table.getColumns().size());
            Iterator columns = table.getColumns().iterator();
            while (columns.hasNext()) {
                DbColumn column = (DbColumn)columns.next();
                ColumnDecorator columnDecorator = this.createDecorator(column);
                columnDecorator.setPlugin(this);
                columnDecorator.setTableDecorator(tableDecorator);
                this._columnDecorators.put(column, columnDecorator);
                columnDecorators.add(columnDecorator);
            }
            tableDecorator.setColumnDecorators(columnDecorators);
        }
        Iterator tableDecorators = this._tableDecorators.values().iterator();
        while (tableDecorators.hasNext()) {
            ((TableDecorator)tableDecorators.next()).init();
        }
        Iterator columnDecorators = this._columnDecorators.values().iterator();
        while (columnDecorators.hasNext()) {
            ((ColumnDecorator)columnDecorators.next()).init();
        }
    }

    public void validate() throws MiddlegenException {
        if (this._destinationDir == null) {
            throw new MiddlegenException("destination must be specified in <" + this.getName() + ">");
        }
    }

    public boolean mergeFileExists(String mergeFile) {
        return new File(this.getMergedir(), mergeFile).exists();
    }

    protected final void setDisplayName(String s) {
        this._displayName = s;
    }

    protected void registerFileProducers() {
    }

    protected void generate() throws MiddlegenException {
        this.registerFileProducers();
        VelocityEngine velocityEngine = this.getEngine();
        this.doIt(velocityEngine);
    }

    void setMiddlegen(Middlegen middlegen) {
        this._middlegen = middlegen;
    }

    final Column decorate(Column column) {
        Class<?> clazz = column.getClass();
        Class<?> clazz2 = class$5;
        if (clazz2 == null) {
            try {
                clazz2 = class$5 = Class.forName("middlegen.DbColumn");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz != clazz2) {
            StringBuffer stringBuffer = new StringBuffer("column must be of class ");
            Class<?> clazz3 = class$5;
            if (clazz3 == null) {
                try {
                    clazz3 = class$5 = Class.forName("middlegen.DbColumn");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new IllegalArgumentException(stringBuffer.append(clazz3.getName()).append(Middlegen.BUGREPORT).toString());
        }
        if (column == null) {
            throw new IllegalArgumentException("column can't be null!" + Middlegen.BUGREPORT);
        }
        ColumnDecorator result = (ColumnDecorator)this._columnDecorators.get(column);
        if (result == null) {
            throw new IllegalArgumentException("result can't be null!" + Middlegen.BUGREPORT);
        }
        return result;
    }

    final Table decorate(Table table) {
        Class<?> clazz = table.getClass();
        Class<?> clazz2 = class$6;
        if (clazz2 == null) {
            try {
                clazz2 = class$6 = Class.forName("middlegen.DbTable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.equals(clazz2)) {
            StringBuffer stringBuffer = new StringBuffer("table must be of class ");
            Class<?> clazz3 = class$6;
            if (clazz3 == null) {
                try {
                    clazz3 = class$6 = Class.forName("middlegen.DbTable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new IllegalArgumentException(stringBuffer.append(clazz3.getName()).append(Middlegen.BUGREPORT).toString());
        }
        if (table == null) {
            throw new IllegalArgumentException("table can't be null!" + Middlegen.BUGREPORT);
        }
        TableDecorator result = (TableDecorator)this._tableDecorators.get(table.getSqlName());
        if (result == null) {
            throw new IllegalArgumentException("result can't be null!" + Middlegen.BUGREPORT);
        }
        return result;
    }

    private final Collection getFileProducers() {
        return this._fileProducers.values();
    }

    private VelocityEngine getEngine() throws MiddlegenException {
        VelocityEngine velocityEngine = new VelocityEngine();
        Properties props = new Properties();
        props.setProperty("resource.loader", "file");
        props.setProperty("file.resource.loader.class", "middlegen.KindFileResourceLoader");
        if (this.getMergedir() != null) {
            props.setProperty("file.resource.loader.path", this.getMergedir());
        }
        props.setProperty("runtime.log.logsystem.class", "middlegen.DontCloseLog4JLogSystem");
        try {
            velocityEngine.init(props);
            return velocityEngine;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MiddlegenException(e.getMessage());
        }
    }

    private void doIt(VelocityEngine engine) throws MiddlegenException {
        Iterator fileProducerIterator = this.getFileProducers().iterator();
        while (fileProducerIterator.hasNext()) {
            FileProducer fileProducer = (FileProducer)fileProducerIterator.next();
            if (fileProducer.isGenerationPerTable()) {
                Iterator tableDecoratorIterator = this.getTables().iterator();
                while (tableDecoratorIterator.hasNext()) {
                    TableDecorator tableDecorator = (TableDecorator)tableDecoratorIterator.next();
                    if (!tableDecorator.getTableElement().isGenerate() || !tableDecorator.isGenerate() || !fileProducer.accept(tableDecorator)) continue;
                    fileProducer.getContextMap().put("plugin", this);
                    fileProducer.generateForTable(engine, tableDecorator);
                }
                continue;
            }
            ArrayList<TableDecorator> acceptedTableDecorators = new ArrayList<TableDecorator>();
            Iterator tableDecoratorIterator = this.getTables().iterator();
            while (tableDecoratorIterator.hasNext()) {
                TableDecorator tableDecorator = (TableDecorator)tableDecoratorIterator.next();
                if (!tableDecorator.getTableElement().isGenerate() || !tableDecorator.isGenerate() || !fileProducer.accept(tableDecorator)) continue;
                acceptedTableDecorators.add(tableDecorator);
            }
            fileProducer.getContextMap().put("plugin", this);
            fileProducer.generateForTables(engine, acceptedTableDecorators);
        }
    }

    private final ColumnDecorator createDecorator(DbColumn column) {
        Object decorator = this._columnDecorators.get(column);
        if (decorator == null) {
            decorator = this.createDecorator(column, this.getColumnDecoratorClass(), this._columnDecoratorConstructorArgs);
        }
        return (ColumnDecorator)decorator;
    }

    private final TableDecorator createDecorator(DbTable table) {
        Object decorator = this._tableDecorators.get(table.getSqlName());
        if (decorator == null) {
            decorator = this.createDecorator(table, this.getTableDecoratorClass(), this._tableDecoratorConstructorArgs);
        }
        return (TableDecorator)decorator;
    }

    private final Object createDecorator(Object subject, Class decoratorClass, Class[] decoratorConstructorArgs) {
        Object decorator = null;
        String declaredConstructor = String.valueOf(decoratorClass.getName()) + "(" + decoratorConstructorArgs[0].getName() + ")";
        String invokedConstructor = String.valueOf(decoratorClass.getName()) + "(" + subject.getClass().getName() + ")";
        try {
            Constructor constructor = decoratorClass.getConstructor(decoratorConstructorArgs);
            Object[] constructorArgs = new Object[]{subject};
            decorator = constructor.newInstance(constructorArgs);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("Couldn't invoke constructor " + invokedConstructor);
        }
        return decorator;
    }
}

