/*
 * Decompiled with CFR 0.152.
 */
package middlegen.javax;

import middlegen.Column;
import middlegen.ColumnDecorator;
import middlegen.DbNameConverter;
import middlegen.Middlegen;
import middlegen.Util;
import middlegen.javax.Sql2Java;

public class JavaColumn
extends ColumnDecorator {
    private String _javaType;
    private String _variableName;
    static /* synthetic */ Class class$0;

    public JavaColumn(Column subject) {
        super(subject);
    }

    public void setJavaType(String javaType) {
        if (javaType == null) {
            throw new IllegalStateException("BUG: javaType can't be null. " + Middlegen.BUGREPORT);
        }
        this.setPrefsValue("java-type", javaType);
        this._javaType = javaType;
    }

    public void setVariableName(String variableName) {
        this.setPrefsValue("java-name", variableName);
        this._variableName = variableName;
    }

    public String getJavaType() {
        return this._javaType;
    }

    public String getVariableName() {
        return this._variableName;
    }

    public String getCapitalisedVariableName() {
        return Util.capitalise(this.getVariableName());
    }

    public String getGetterName() {
        return "get" + this.getCapitalisedVariableName();
    }

    public String getSetterName() {
        return "set" + this.getCapitalisedVariableName();
    }

    public boolean isPrimitiveOrComparable() {
        boolean result = false;
        try {
            Class<?> clazz = Class.forName(this.getJavaType());
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.Comparable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz2.isAssignableFrom(clazz)) {
                result = true;
            }
        }
        catch (ClassNotFoundException e) {
            result = this.isPrimitive();
        }
        return result;
    }

    public boolean isPrimitive() {
        return Sql2Java.isPrimitive(this.getJavaType());
    }

    public boolean isNumericClass() {
        return Sql2Java.isNumericClass(this.getJavaType());
    }

    public String getClassForPrimitive() {
        return Sql2Java.getClassForPrimitive(this.getJavaType());
    }

    protected void setJavaType() {
        if (this.getPrefsValue("java-type") != null) {
            this.setJavaType(this.getPrefsValue("java-type"));
        } else {
            this.setJavaType(Sql2Java.getPreferredJavaType(this.getSqlType(), this.getSize(), this.getDecimalDigits()));
        }
    }

    protected void init() {
        super.init();
        this.setJavaType();
        if (this.getPrefsValue("java-name") != null) {
            this.setVariableName(this.getPrefsValue("java-name"));
        } else {
            this.setVariableName(Util.decapitalise(DbNameConverter.getInstance().columnNameToVariableName(this.getSqlName())));
        }
    }
}

