/*
 * Decompiled with CFR 0.152.
 */
package middlegen.javax;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import middlegen.DbNameConverter;
import middlegen.Plugin;
import middlegen.RelationshipRole;
import middlegen.Table;
import middlegen.TableDecorator;
import middlegen.Util;
import middlegen.javax.JavaColumn;
import middlegen.javax.JavaPlugin;
import org.apache.log4j.Category;

public class JavaTable
extends TableDecorator {
    private String _baseClassName;
    private String _package;
    private String _sequenceName = this.getTableElement().getSequenceName();
    private static Category _log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("middlegen.javax.JavaTable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _log = Category.getInstance((String)clazz.getName());
    }

    public JavaTable(Table subject) {
        super(subject);
        if (this._sequenceName != null) {
            this._sequenceName = this._sequenceName.trim().toUpperCase();
        }
    }

    public String setPackage(String pakkage) {
        this._package = pakkage;
        return this._package;
    }

    public void setPlugin(Plugin plugin) {
        super.setPlugin(plugin);
        JavaPlugin javaPlugin = (JavaPlugin)plugin;
        String packageName = javaPlugin.getPackage();
        if (packageName.indexOf("{0}") != -1) {
            packageName = MessageFormat.format(packageName, this.getName().toLowerCase());
        }
        this.setPackage(packageName);
    }

    public String getSequenceName() {
        if (this._sequenceName == null || this._sequenceName.equals("")) {
            this._sequenceName = String.valueOf(this.getSqlName().toUpperCase()) + "_SEQ";
        }
        return this._sequenceName;
    }

    public String getBaseClassName() {
        return this._baseClassName;
    }

    public String getDestinationClassName() {
        return this.getBaseClassName();
    }

    public String getSimplePkClassName() {
        JavaColumn pkColumn = (JavaColumn)this.getPkColumn();
        if (pkColumn != null) {
            return pkColumn.getJavaType();
        }
        return null;
    }

    public String getQualifiedBaseClassName() {
        String pakkage = ((JavaPlugin)this.getPlugin()).getPackage();
        return Util.getQualifiedClassName(pakkage, this.getBaseClassName());
    }

    public String getVariableName(RelationshipRole relationshipRole) {
        if (relationshipRole.getOrigin(this.getPlugin()) != this) {
            throw new IllegalArgumentException("The relationshipRole's origin must be " + this.getSqlName() + " , but was " + relationshipRole.getOrigin().getSqlName());
        }
        JavaTable target = (JavaTable)relationshipRole.getTarget(this.getPlugin());
        String result = relationshipRole.isTargetMany() ? target.getPluralisedVariableName() : target.getSingularisedVariableName();
        if (relationshipRole.getSuffix() != null) {
            result = String.valueOf(result) + relationshipRole.getSuffix();
        }
        return result;
    }

    public String getSubDirPath() {
        return this.getPackage().replace('.', '/');
    }

    public String getClassName(RelationshipRole relationshipRole) {
        if (relationshipRole.getOrigin(this.getPlugin()) != this) {
            throw new IllegalArgumentException("The relationshipRole's origin must be " + this.getSqlName() + " , but was " + relationshipRole.getOrigin().getSqlName());
        }
        JavaTable target = (JavaTable)relationshipRole.getTarget(this.getPlugin());
        String result = relationshipRole.isTargetMany() ? target.getManyClassName() : target.getQualifiedDestinationClassName();
        return result;
    }

    public String getPackage() {
        return this._package;
    }

    public String getSignature(Collection columns) {
        return this.delimit(columns, true);
    }

    public String getParameters(Collection columns) {
        return this.delimit(columns, false);
    }

    public String getRelationSignature(Collection relationshipRoles) {
        StringBuffer sb = new StringBuffer();
        Iterator i = relationshipRoles.iterator();
        while (i.hasNext()) {
            RelationshipRole role = (RelationshipRole)i.next();
            JavaTable target = null;
            JavaTable origin = null;
            Table t = role.getTarget(this.getPlugin());
            Table o = role.getOrigin(this.getPlugin());
            try {
                target = (JavaTable)t;
                origin = (JavaTable)o;
            }
            catch (ClassCastException e) {
                StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.getPlugin().getClass().getName())).append(" must override getTableDecoratorClass() and return a class which is ");
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("middlegen.javax.JavaTable");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new IllegalStateException(stringBuffer.append(clazz.getName()).append(" (or a subclass). It was ").append(t.getClass().getName()).toString());
            }
            if (sb.length() != 0) {
                sb.append(", ");
            }
            String targetType = target.getDestinationClassName();
            String targetName = origin.getVariableName(role);
            sb.append(targetType).append(" ").append(targetName);
        }
        return sb.toString();
    }

    public String getColumnAndRelationSignature(Collection columns, Collection relationshipRoles) {
        String columnSignature = this.getSignature(columns);
        String relationSignature = this.getRelationSignature(relationshipRoles);
        if (!columnSignature.equals("") && !relationSignature.equals("")) {
            return String.valueOf(columnSignature) + ", " + relationSignature;
        }
        return String.valueOf(columnSignature) + relationSignature;
    }

    public String getCapitalisedVariableName(RelationshipRole relationshipRole) {
        return Util.capitalise(this.getVariableName(relationshipRole));
    }

    public String getGetterName(RelationshipRole relationshipRole) {
        return "get" + this.getCapitalisedVariableName(relationshipRole);
    }

    public String getSetterName(RelationshipRole relationshipRole) {
        return "set" + this.getCapitalisedVariableName(relationshipRole);
    }

    public String getReplaceName() {
        return this.getBaseClassName();
    }

    public String getQualifiedDestinationClassName() {
        return Util.getQualifiedClassName(this.getPackage(), this.getDestinationClassName());
    }

    public String delimit(Collection columns, boolean includeType) {
        StringBuffer sb = new StringBuffer();
        Iterator i = columns.iterator();
        while (i.hasNext()) {
            JavaColumn column = null;
            Object c = i.next();
            try {
                column = (JavaColumn)c;
            }
            catch (ClassCastException e) {
                StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.getPlugin().getClass().getName())).append(" must override getColumnDecoratorClass() and return a class which is ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("middlegen.javax.JavaColumn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new IllegalStateException(stringBuffer.append(clazz.getName()).append(" (or a subclass). It was ").append(c.getClass().getName()).toString());
            }
            if (sb.length() != 0) {
                sb.append(", ");
            }
            if (includeType) {
                String columnType = column.getJavaType();
                sb.append(columnType).append(" ");
            }
            String columnName = column.getVariableName();
            sb.append(columnName);
        }
        return sb.toString();
    }

    protected void setBaseClassName(String baseClassName) {
        this.setPrefsValue("base-class-name", baseClassName);
        this._baseClassName = baseClassName;
    }

    protected String getManyClassName() {
        return "java.util.Collection";
    }

    protected void init() {
        String computedBaseClassName;
        super.init();
        String prefsBaseClassName = this.getPrefsValue("base-class-name");
        if (this.getTableElement().getSingular() != null) {
            computedBaseClassName = this.getTableElement().getSingular();
            computedBaseClassName = Util.capitalise(computedBaseClassName);
        } else {
            computedBaseClassName = DbNameConverter.getInstance().tableNameToVariableName(this.getName());
            computedBaseClassName = Util.singularise(computedBaseClassName);
        }
        String suffix = ((JavaPlugin)this.getPlugin()).getSuffix();
        computedBaseClassName = String.valueOf(computedBaseClassName) + suffix;
        if (prefsBaseClassName != null && !prefsBaseClassName.equals(computedBaseClassName)) {
            _log.warn((Object)("WARNING (" + this.getPlugin().getName() + "): " + "Your prefs file indicates that the base class name for table " + this.getSqlName() + " should be " + prefsBaseClassName + ", but according to your plugin settings " + "it should be " + computedBaseClassName + ". Middlegen will use " + prefsBaseClassName + ". " + "If you want it to be the other way around, please edit or delete your prefs file, " + "or modify the name in the gui."));
        }
        if (prefsBaseClassName != null) {
            this.setBaseClassName(prefsBaseClassName);
        } else {
            this.setBaseClassName(computedBaseClassName);
        }
    }

    private String getPluralisedVariableName() {
        if (this.getTableElement().getPlural() != null) {
            return this.getTableElement().getPlural();
        }
        return Util.pluralise(this.getVariableName());
    }

    private String getSingularisedVariableName() {
        if (this.getTableElement().getSingular() != null) {
            return this.getTableElement().getSingular();
        }
        return Util.singularise(this.getVariableName());
    }

    private String getVariableName() {
        return Util.decapitalise(this.getBaseClassName());
    }

    private final String getOneClassName() {
        return this.getQualifiedDestinationClassName();
    }
}

