/*
 * Decompiled with CFR 0.152.
 */
package middlegen.swing;

import java.awt.Graphics;
import java.util.Observer;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import middlegen.swing.BooleanNodeButtonModel;
import middlegen.util.BooleanNode;

public class BooleanNodeCheckBox
extends JCheckBox {
    private BooleanNode _booleanNode;
    private final Icon _true = new ImageIcon(this.getClass().getResource("images/true.gif"));
    private final Icon _fuzzy = new ImageIcon(this.getClass().getResource("images/fuzzy.gif"));
    private final Icon _false = new ImageIcon(this.getClass().getResource("images/false.gif"));

    public BooleanNodeCheckBox(String title, BooleanNode booleanNode) {
        super(title);
        this.setIcon(this._false);
        this.setSelectedIcon(this._true);
        if (booleanNode != null) {
            this.setBooleanNode(booleanNode);
        }
    }

    public void setBooleanNode(BooleanNode booleanNode) {
        this._booleanNode = booleanNode;
        ButtonModel oldModel = this.getModel();
        if (oldModel != null && oldModel instanceof Observer) {
            booleanNode.deleteObserver((Observer)((Object)oldModel));
        }
        this.setModel(new BooleanNodeButtonModel(booleanNode));
    }

    public void paint(Graphics g) {
        if (this._booleanNode != null) {
            if (this._booleanNode.isPartiallyTrue() && !this._booleanNode.isCompletelyTrue()) {
                this.setSelectedIcon(this._fuzzy);
            } else {
                this.setSelectedIcon(this._true);
            }
        }
        super.paint(g);
    }
}

