/*
 * Decompiled with CFR 0.152.
 */
package middlegen.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import middlegen.DbTable;
import middlegen.swing.JTableList;
import org.apache.log4j.Category;

public class JTablePanel
extends JPanel {
    private final DbTable _table;
    private final JLabel _title;
    private final JTableList _jList;
    private final int _cellHeight;
    private static Category _log;
    private static Border _unSelectedBorder;
    private static Border _selectedBorder;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("middlegen.swing.JTablePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _log = Category.getInstance((String)clazz.getName());
        _unSelectedBorder = BorderFactory.createLineBorder(Color.black, 1);
        _selectedBorder = BorderFactory.createLineBorder(Color.black, 2);
    }

    public JTablePanel(DbTable table) {
        this.setLayout(new BorderLayout());
        this._table = table;
        this._title = new JLabel(" " + table.getName() + " ", 0);
        this.add((Component)this._title, "North");
        this._jList = new JTableList(table);
        Rectangle r = this._jList.getCellBounds(0, 0);
        this._cellHeight = r.height;
        this.add((Component)this._jList, "Center");
        this.setSelected(false);
    }

    public void setSelected(boolean selected) {
        if (selected) {
            if (this.getBorder() == _unSelectedBorder) {
                this.setLocation(this.getLocation().x - 1, this.getLocation().y - 1);
            }
            this.setBorder(_selectedBorder);
        } else {
            if (this.getBorder() == _selectedBorder) {
                this.setLocation(this.getLocation().x + 1, this.getLocation().y + 1);
            }
            this.setBorder(_unSelectedBorder);
            this._jList.clearSelection();
        }
    }

    public JList getList() {
        return this._jList;
    }

    public DbTable getTable() {
        return this._table;
    }

    public int getColumnY(String columnName) {
        int h = this.getHeight();
        int rowCount = this._jList.getModel().getSize();
        int index = this._table.getIndex(columnName);
        if (index == -1) {
            _log.error((Object)("There is no column named " + columnName + " in the table named " + this._table.getSqlName()));
        }
        _log.debug((Object)(String.valueOf(this._table.getSqlName()) + "." + columnName + " " + index));
        int rowsUpFromBottom = rowCount - index;
        int y = h - rowsUpFromBottom * this._cellHeight + this._cellHeight / 2;
        _log.debug((Object)("y=" + y));
        return y;
    }
}

