/*
 * Decompiled with CFR 0.152.
 */
package middlegen.swing;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import middlegen.Column;
import middlegen.swing.JSettingsTabPane;
import middlegen.swing.JTableList;

public class SettingsPanelCommander
implements ListSelectionListener {
    private final JSettingsTabPane _settingsTabPane;
    private final JLabel _header;

    public SettingsPanelCommander(JSettingsTabPane settingsTabPane, JLabel header) {
        this._settingsTabPane = settingsTabPane;
        this._header = header;
    }

    public void valueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            JTableList tableList = (JTableList)evt.getSource();
            Collection columnsCollection = tableList.getTable().getColumns();
            List<Object> columnsList = Arrays.asList(columnsCollection.toArray());
            int[] selectedIndices = tableList.getSelectedIndices();
            String headerText = "";
            if (selectedIndices.length > 0) {
                Column[] columns = new Column[selectedIndices.length];
                int i = 0;
                while (i < columns.length) {
                    columns[i] = (Column)columnsList.get(selectedIndices[i]);
                    if (columns.length == 1) {
                        headerText = String.valueOf(headerText) + columns[i].getSqlName() + ": " + columns[i].getSqlTypeName();
                        if (columns[i].isPk()) {
                            headerText = String.valueOf(headerText) + ", primary key";
                        }
                        if (columns[i].isFk()) {
                            headerText = String.valueOf(headerText) + ", foreign key";
                        }
                        if (!columns[i].isNullable()) {
                            headerText = String.valueOf(headerText) + ", mandatory";
                        }
                        if (columns[i].isIndexed()) {
                            headerText = String.valueOf(headerText) + ", indexed";
                        }
                        if (columns[i].isUnique()) {
                            headerText = String.valueOf(headerText) + ", unique";
                        }
                    } else {
                        headerText = String.valueOf(headerText) + columns[i].getSqlName();
                    }
                    if (i < columns.length - 1) {
                        headerText = String.valueOf(headerText) + ", ";
                    }
                    ++i;
                }
                this._settingsTabPane.setColumns(columns);
                this._header.setText(headerText);
            }
        }
    }
}

