/*
 * Decompiled with CFR 0.152.
 */
package middlegen.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Observable;

public class BooleanNode
extends Observable {
    private boolean _value;
    private final BooleanNode _parent;
    private Collection _children;

    private BooleanNode(BooleanNode parent, boolean initialValue) {
        this._parent = parent;
        this._value = initialValue;
    }

    public void setValue(boolean value) {
        if (!this.haveChildren()) {
            this._value = value;
        } else {
            Iterator i = this._children.iterator();
            while (i.hasNext()) {
                BooleanNode child = (BooleanNode)i.next();
                child.setValue(value);
                child.notifyChanged();
            }
        }
        if (this._parent != null) {
            this._parent.notifyChanged();
        }
        this.notifyChanged();
    }

    public boolean isCompletelyTrue() {
        return this.isTrue(true);
    }

    public boolean isPartiallyTrue() {
        return this.isTrue(false);
    }

    public BooleanNode createChild(boolean initialValue) {
        BooleanNode child = new BooleanNode(this, initialValue);
        if (this._children == null) {
            this._children = new ArrayList();
        }
        this._children.add(child);
        this.notifyChanged();
        return child;
    }

    public String toString() {
        if (this.isCompletelyTrue()) {
            return "true";
        }
        if (this.isPartiallyTrue()) {
            return "fuzzy";
        }
        return "false";
    }

    private boolean isTrue(boolean andAllChildren) {
        boolean result = andAllChildren;
        if (!this.haveChildren()) {
            result = this._value;
        } else {
            Iterator i = this._children.iterator();
            boolean doLoop = true;
            while (i.hasNext() && doLoop) {
                BooleanNode child = (BooleanNode)i.next();
                boolean childValue = child.isTrue(andAllChildren);
                if (andAllChildren && !childValue) {
                    result = false;
                    doLoop = false;
                    continue;
                }
                if (andAllChildren || !childValue) continue;
                result = true;
                doLoop = false;
            }
        }
        return result;
    }

    private boolean haveChildren() {
        return this._children != null && !this._children.isEmpty();
    }

    private void notifyChanged() {
        this.setChanged();
        this.notifyObservers();
        if (this._parent != null) {
            this._parent.notifyChanged();
        }
    }

    public static BooleanNode createRoot(boolean initialValue) {
        return new BooleanNode(null, initialValue);
    }
}

