/*
 * Decompiled with CFR 0.152.
 */
package middlegen.plugins.hibernate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import middlegen.Column;
import middlegen.ColumnMap;
import middlegen.RelationshipRole;
import middlegen.Table;
import middlegen.Util;
import middlegen.javax.JavaTable;
import middlegen.plugins.hibernate.HibernateColumn;
import middlegen.plugins.hibernate.HibernatePlugin;
import middlegen.plugins.hibernate.predicates.relation.NotTargetInOriginPK;
import middlegen.plugins.hibernate.predicates.relation.TargetInOriginPK;
import middlegen.plugins.hibernate.predicates.relation.TargetOneToOneFKRoles;
import middlegen.predicates.column.PrimaryKey;
import middlegen.util.BooleanNode;

public class HibernateTable
extends JavaTable {
    private BooleanNode _lifecycle;
    private BooleanNode _validatable;
    private BooleanNode _equalsHashcode;
    private BooleanNode _proxy;
    private BooleanNode _plainCKey;
    private BooleanNode _mutable;
    private BooleanNode _dynamicUpdate;
    private BooleanNode _dynamicInsert;
    private BooleanNode _selectBeforeUpdate;
    private String _destinationClassName;
    private String _databaseSchema;
    private String _persister;
    private String _batchsize;
    private String _where;
    private String _classDescription;
    private String _classScope;
    private String _extends;
    private ArrayList _implements;
    private BooleanNode _pkInnerClass;
    private String _keyGenerator;
    private String _keyGeneratorArg;

    public HibernateTable(Table table) {
        super(table);
    }

    public void setImplementLifecycle(boolean flag) {
        this.setPrefsValue("lifecycle", Util.string((boolean)flag));
        this._lifecycle.setValue(flag);
    }

    public void setEqualsHashcode(boolean flag) {
        this.setPrefsValue("equalshashcode", Util.string((boolean)flag));
        this._equalsHashcode.setValue(flag);
    }

    public void setImplementValidatable(boolean flag) {
        this.setPrefsValue("validatable", Util.string((boolean)flag));
        this._validatable.setValue(flag);
    }

    public void setPlainCompoundKey(boolean flag) {
        this.setPrefsValue("plainCKey", Util.string((boolean)flag));
        this._plainCKey.setValue(flag);
    }

    public void setProxy(boolean flag) {
        this.setPrefsValue("proxy", Util.string((boolean)flag));
        this._proxy.setValue(flag);
    }

    public void setMutable(boolean flag) {
        this.setPrefsValue("mutable", Util.string((boolean)flag));
        this._mutable.setValue(flag);
    }

    public void setDynamicUpdate(boolean flag) {
        this.setPrefsValue("dynamicUpdate", Util.string((boolean)flag));
        this._dynamicUpdate.setValue(flag);
    }

    public void setDynamicInsert(boolean flag) {
        this.setPrefsValue("dynamicInsert", Util.string((boolean)flag));
        this._dynamicInsert.setValue(flag);
    }

    public void setSelectBeforeUpdate(boolean flag) {
        this.setPrefsValue("selectBeforeUpdate", Util.string((boolean)flag));
        this._selectBeforeUpdate.setValue(flag);
    }

    public void setDestinationClassName(String value) {
        this.setPrefsValue("destinationClassName", value);
        this._destinationClassName = value;
    }

    public void setDatabaseSchema(String value) {
        this.setPrefsValue("databaseSchema", value);
        this._databaseSchema = value;
    }

    public void setPersister(String value) {
        this.setPrefsValue("persister", value);
        this._persister = value;
    }

    public void setBatchSize(String value) {
        this.setPrefsValue("batchsize", value);
        this._batchsize = value;
    }

    public void setWhere(String value) {
        this.setPrefsValue("where", value);
        this._where = value;
    }

    public void setClassDescription(String value) {
        this.setPrefsValue("description", value);
        this._classDescription = value;
    }

    public void setClassScope(String value) {
        this.setPrefsValue("classscope", value);
        this._classScope = value;
    }

    public void setExtends(String value) {
        this.setPrefsValue("extends", value);
        this._extends = value;
    }

    public void setImplements(ArrayList value) {
        this.setPrefsValue("implements", this.encodeImplementsStr(value));
        this._implements = value;
    }

    public void setKeyGenerator(String value) {
        this.setPrefsValue("keygenerator", value);
        this._keyGenerator = value;
    }

    public void setKeyGeneratorArg(String value) {
        this.setPrefsValue("keygeneratorarg", value);
        this._keyGeneratorArg = value;
    }

    public String getDestinationClassName() {
        return this._destinationClassName;
    }

    public String getCompoundKeyDestinationClassName() {
        return this._destinationClassName + "PK";
    }

    public String getDatabaseSchema() {
        return this._databaseSchema.trim();
    }

    public String getPersister() {
        return this._persister.trim();
    }

    public String getBatchSize() {
        return this._batchsize.trim();
    }

    public String getWhere() {
        return this._where.trim();
    }

    public String getClassDescription() {
        return this._classDescription.trim();
    }

    public String getClassScope() {
        return this._classScope.trim();
    }

    public String getExtends() {
        return this._extends.trim();
    }

    public HibernateColumn getVersioningField() {
        Collection columns = this.getColumns();
        Iterator citr = columns.iterator();
        while (citr.hasNext()) {
            HibernateColumn curCol = (HibernateColumn)((Object)citr.next());
            if (!curCol.getColumnSpecialty().equals("version") && !curCol.getColumnSpecialty().equals("timestamp")) continue;
            return curCol;
        }
        return null;
    }

    public boolean isImplementLifecycle() {
        return this._lifecycle.isCompletelyTrue();
    }

    public boolean isEqualsHashcode() {
        return this._equalsHashcode.isCompletelyTrue();
    }

    public boolean isImplementValidatable() {
        return this._validatable.isCompletelyTrue();
    }

    public boolean isProxy() {
        return this._proxy.isCompletelyTrue();
    }

    public boolean isPlainCompoundKey() {
        return this._plainCKey.isCompletelyTrue();
    }

    public boolean isMutable() {
        return this._mutable.isCompletelyTrue();
    }

    public boolean isDynamicUpdate() {
        return this._dynamicUpdate.isCompletelyTrue();
    }

    public boolean isDynamicInsert() {
        return this._dynamicInsert.isCompletelyTrue();
    }

    public boolean isSelectBeforeUpdate() {
        return this._selectBeforeUpdate.isCompletelyTrue();
    }

    public boolean isSchemaName() {
        return this._databaseSchema != null && this._databaseSchema.trim().length() != 0;
    }

    public boolean isPersisterName() {
        return this._persister != null && this._persister.trim().length() != 0;
    }

    public boolean isBatchSizeVal() {
        return this._batchsize != null && this._batchsize.trim().length() != 0;
    }

    public boolean isWhereVal() {
        return this._where != null && this._where.trim().length() != 0;
    }

    public boolean isClassDescriptionName() {
        return this._classDescription != null && this._classDescription.trim().length() != 0;
    }

    public boolean isClassScopeName() {
        return this._classScope != null && this._classScope.trim().length() != 0 && !this._classScope.equals("public");
    }

    public boolean isExtendsName() {
        return this._extends != null && this._extends.trim().length() != 0;
    }

    public boolean isCompositeKey() {
        return this.getPkColumn() == null;
    }

    public boolean isVersioningPresent() {
        return this.getVersioningField() != null;
    }

    public BooleanNode getLifecycleNode() {
        return this._lifecycle;
    }

    public BooleanNode getEqualsHashcodeNode() {
        return this._equalsHashcode;
    }

    public BooleanNode getValidatableNode() {
        return this._validatable;
    }

    public BooleanNode getPlainCompoundKeyNode() {
        return this._plainCKey;
    }

    public BooleanNode getProxyNode() {
        return this._proxy;
    }

    public BooleanNode getDynamicUpdateNode() {
        return this._dynamicUpdate;
    }

    public BooleanNode getDynamicInsertNode() {
        return this._dynamicInsert;
    }

    public BooleanNode getSelectBeforeUpdateNode() {
        return this._selectBeforeUpdate;
    }

    public BooleanNode getMutableNode() {
        return this._mutable;
    }

    public ArrayList getImplements() {
        return this._implements;
    }

    public String getKeyGenerator() {
        return this._keyGenerator.trim();
    }

    public String getKeyGeneratorArg() {
        return this._keyGeneratorArg.trim();
    }

    public String getGeneratorUnsavedValue() {
        if ("identity".equals(this._keyGenerator)) {
            return "0";
        }
        return null;
    }

    public boolean isGeneratorRequiresParams() {
        return "hilo".equals(this._keyGenerator) || "seqhilo".equals(this._keyGenerator) || "sequence".equals(this._keyGenerator);
    }

    public Collection getPrimaryKeyRoles() {
        return this.getRelationshipRoles(TargetInOriginPK.getInstance());
    }

    public Collection getNotPrimaryKeyRoles() {
        return this.getRelationshipRoles(NotTargetInOriginPK.getInstance());
    }

    public Collection getChildSidePrimaryKeyOnlyOneToOneRoles() {
        return this.getRelationshipRoles(TargetOneToOneFKRoles.getInstance());
    }

    public Collection getFkColsInactive(RelationshipRole role) {
        return this.getColsInactive(role, false);
    }

    public Collection getFkColsPkInactive(RelationshipRole role) {
        return this.getColsInactive(role, true);
    }

    public Collection getColsInactive(RelationshipRole role, boolean pkSelector) {
        ArrayList<HibernateColumn> retVal = new ArrayList<HibernateColumn>();
        if (!role.getRelation().isMany2Many()) {
            ColumnMap[] cMap = role.getTargetRole().getColumnMaps();
            for (int i = 0; i < cMap.length; ++i) {
                HibernateColumn col = (HibernateColumn)this.getColumn(cMap[i].getForeignKey());
                if (pkSelector) {
                    if (!col.isPk()) continue;
                    retVal.add(col);
                    continue;
                }
                if (col.isPk()) continue;
                retVal.add(col);
            }
        }
        return retVal;
    }

    public boolean isRelationshipPkAndNonPkMembers() {
        boolean retVal = false;
        Collection rel = this.getNotPrimaryKeyRoles();
        Iterator itr = rel.iterator();
        while (itr.hasNext()) {
            RelationshipRole role = (RelationshipRole)itr.next();
            if (role.getRelation().isMany2Many()) continue;
            RelationshipRole trole = role.getTargetRole();
            ColumnMap[] colMaps = trole.getColumnMaps();
            boolean pk = false;
            boolean nonPk = false;
            for (int i = 0; i < colMaps.length; ++i) {
                Column col = this.getColumn(colMaps[i].getForeignKey());
                if (col.isPk()) {
                    pk = true;
                    continue;
                }
                nonPk = true;
            }
            if (!pk || !nonPk) continue;
            retVal = true;
        }
        return retVal;
    }

    public boolean isRoleOneToOnePrimaryKeys(RelationshipRole role, HibernateTable target) {
        boolean retVal = true;
        ColumnMap[] cMap = role.getColumnMaps();
        if (cMap.length <= 0) {
            return false;
        }
        int roleColCount = cMap.length;
        for (int i = 0; i < cMap.length; ++i) {
            HibernateColumn col_lefts = (HibernateColumn)this.getColumn(cMap[i].getPrimaryKey());
            HibernateColumn col_rights = (HibernateColumn)target.getColumn(cMap[i].getForeignKey());
            if (col_rights.isPk() && col_lefts.isPk()) continue;
            return false;
        }
        int lPKCount = this.getColumns(PrimaryKey.getInstance()).size();
        if (lPKCount != roleColCount) {
            return false;
        }
        int rPKCount = target.getColumns(PrimaryKey.getInstance()).size();
        if (rPKCount != roleColCount) {
            return false;
        }
        return retVal;
    }

    public boolean isFKRoleHasAnyEqualsHashcode(RelationshipRole role) {
        boolean retVal = false;
        ColumnMap[] cMap = role.getTargetRole().getColumnMaps();
        if (cMap.length <= 0) {
            return false;
        }
        int roleColCount = cMap.length;
        for (int i = 0; i < cMap.length; ++i) {
            HibernateColumn col = (HibernateColumn)this.getColumn(cMap[i].getForeignKey());
            if (!col.isIncludeEquals()) continue;
            return true;
        }
        return retVal;
    }

    public boolean isCompoundKeyHasAnyEqualsHashcode() {
        boolean retVal = false;
        if (this.isCompositeKey()) {
            Iterator itr = this.getPrimaryKeyColumns().iterator();
            while (itr.hasNext()) {
                HibernateColumn col = (HibernateColumn)((Object)itr.next());
                if (!col.isIncludeEquals()) continue;
                return true;
            }
        }
        return retVal;
    }

    public String getCardinalityValue(RelationshipRole role) {
        if (role.getRelation().isMany2Many()) {
            return "many-to-many";
        }
        if (role.getRelation().isOne2One()) {
            return "one-to-one";
        }
        if (role.isTargetMany()) {
            return "one-to-many";
        }
        return "many-to-one";
    }

    public String getDirectionality(RelationshipRole role) {
        if (role.getRelation().isBidirectional()) {
            return "bi-directional";
        }
        return "uni-directional";
    }

    protected void init() {
        super.init();
        HibernatePlugin plugin = (HibernatePlugin)this.getPlugin();
        this._lifecycle = plugin.getLifecycleNode().createChild(plugin.isLifecycle());
        if (this.getPrefsValue("lifecycle") != null) {
            this.setImplementLifecycle(Util.bool((String)this.getPrefsValue("lifecycle")));
        }
        this._validatable = plugin.getValidatableNode().createChild(plugin.isValidatable());
        if (this.getPrefsValue("validatable") != null) {
            this.setImplementValidatable(Util.bool((String)this.getPrefsValue("validatable")));
        }
        this._equalsHashcode = plugin.getEqualsHashcodeNode().createChild(plugin.isEqualsHashcode());
        if (this.getPrefsValue("equalshashcode") != null) {
            this.setEqualsHashcode(Util.bool((String)this.getPrefsValue("equalshashcode")));
        }
        this._plainCKey = plugin.getPlainCompoundKeyNode().createChild(plugin.isPlainCompoundKeys());
        if (this.getPrefsValue("plainCKey") != null) {
            this.setPlainCompoundKey(Util.bool((String)this.getPrefsValue("plainCKey")));
        }
        this._proxy = plugin.getProxyNode().createChild(plugin.isProxy());
        if (this.getPrefsValue("proxy") != null) {
            this.setProxy(Util.bool((String)this.getPrefsValue("proxy")));
        }
        this._mutable = plugin.getMutableNode().createChild(plugin.isMutable());
        if (this.getPrefsValue("mutable") != null) {
            this.setMutable(Util.bool((String)this.getPrefsValue("mutable")));
        }
        this._dynamicUpdate = plugin.getDynamicUpdateNode().createChild(plugin.isDynamicUpdate());
        if (this.getPrefsValue("dynamicUpdate") != null) {
            this.setDynamicUpdate(Util.bool((String)this.getPrefsValue("dynamicUpdate")));
        }
        this._dynamicInsert = plugin.getDynamicInsertNode().createChild(plugin.isDynamicInsert());
        if (this.getPrefsValue("dynamicInsert") != null) {
            this.setDynamicInsert(Util.bool((String)this.getPrefsValue("dynamicInsert")));
        }
        this._selectBeforeUpdate = plugin.getSelectBeforeUpdateNode().createChild(plugin.isSelectBeforeUpdate());
        if (this.getPrefsValue("selectBeforeUpdate") != null) {
            this.setSelectBeforeUpdate(Util.bool((String)this.getPrefsValue("selectBeforeUpdate")));
        }
        this._databaseSchema = plugin.getDatabaseSchema();
        if (this.getPrefsValue("databaseSchema") != null) {
            this.setDatabaseSchema(this.getPrefsValue("databaseSchema"));
        }
        this._classDescription = plugin.getClassDescription();
        if (this.getPrefsValue("description") != null) {
            this.setClassDescription(this.getPrefsValue("description"));
        }
        this._classScope = plugin.getClassScope();
        if (this.getPrefsValue("classscope") != null) {
            this.setClassScope(this.getPrefsValue("classscope"));
        }
        this._extends = plugin.getExtends();
        if (this.getPrefsValue("extends") != null) {
            this.setExtends(this.getPrefsValue("extends"));
        }
        this._implements = plugin.getImplements();
        if (this.getPrefsValue("implements") != null) {
            this.setImplements(this.decodeImplementsStr(this.getPrefsValue("implements"), this._implements));
        }
        this._persister = plugin.getPersister();
        if (this.getPrefsValue("persister") != null) {
            this.setPersister(this.getPrefsValue("persister"));
        }
        this._batchsize = plugin.getBatchSize();
        if (this.getPrefsValue("batchsize") != null) {
            this.setBatchSize(this.getPrefsValue("batchsize"));
        }
        this._where = "";
        if (this.getPrefsValue("where") != null) {
            this.setWhere(this.getPrefsValue("where"));
        }
        this._destinationClassName = this.getPrefsValue("destinationClassName") != null ? this.getPrefsValue("destinationClassName") : this.getBaseClassName() + plugin.getBeansuffix();
        this._keyGenerator = plugin.getStandardGeneratorScheme();
        if (this.getPrefsValue("keygenerator") != null) {
            this._keyGenerator = this.getPrefsValue("keygenerator");
        }
        this._keyGeneratorArg = "";
        if (this.getPrefsValue("keygeneratorarg") != null) {
            this._keyGeneratorArg = this.getPrefsValue("keygeneratorarg");
        }
    }

    private String encodeImplementsStr(ArrayList orig) {
        StringBuffer encodeBuffer = new StringBuffer();
        for (int i = 0; i < orig.size(); ++i) {
            encodeBuffer.append((String)orig.get(i));
            if (i + 1 >= orig.size()) continue;
            encodeBuffer.append(",");
        }
        return encodeBuffer.toString();
    }

    private ArrayList decodeImplementsStr(String encodedStr, ArrayList orig) {
        ArrayList<String> retVal = orig;
        if (encodedStr != null && encodedStr.length() != 0) {
            retVal = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(encodedStr, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.length() <= 0) continue;
                retVal.add(token);
            }
        }
        return retVal;
    }
}

