/*
 * Decompiled with CFR 0.152.
 */
package middlegen.plugins.hibernate.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import middlegen.Column;
import middlegen.javax.Sql2Java;
import middlegen.plugins.hibernate.HibernateColumn;
import middlegen.plugins.hibernate.HibernateTable;
import middlegen.plugins.hibernate.interfaces.JavaTypeMapper;
import middlegen.swing.BooleanNodeCheckBox;
import middlegen.swing.JColumnSettingsPanel;

public class JHibernateColumnSettingsPanel
extends JColumnSettingsPanel {
    protected HibernateColumn[] _currentColumns;
    private final JLabel _columnNameLabel = new JLabel("  Java property name");
    private final JTextField _columnNameField = new JTextField();
    private final JLabel _columnTypeLabel = new JLabel("  Java type");
    private final JComboBox _columnTypeCombo = new JComboBox();
    private final JRadioButton _accessFieldRadioButton = new JRadioButton("field");
    private final JRadioButton _accessPropertyRadioButton = new JRadioButton("property");
    private final JRadioButton _publicGetRadioButton = new JRadioButton("public");
    private final JRadioButton _protectedGetRadioButton = new JRadioButton("protected");
    private final JRadioButton _privateGetRadioButton = new JRadioButton("private");
    private final JRadioButton _publicSetRadioButton = new JRadioButton("public");
    private final JRadioButton _protectedSetRadioButton = new JRadioButton("protected");
    private final JRadioButton _privateSetRadioButton = new JRadioButton("private");
    private final JRadioButton _publicFieldRadioButton = new JRadioButton("public");
    private final JRadioButton _protectedFieldRadioButton = new JRadioButton("protected");
    private final JRadioButton _privateFieldRadioButton = new JRadioButton("private");
    private final JLabel _columnSpecialtyLabel = new JLabel("  Hibernate mapping specialty");
    private final JComboBox _columnSpecialtyCombo = new JComboBox();
    private final BooleanNodeCheckBox _columnUpdateableCheckBox = new BooleanNodeCheckBox("Column updateable", null);
    private final BooleanNodeCheckBox _columnInsertableCheckBox = new BooleanNodeCheckBox("Column insertable", null);
    private final JLabel _fieldDescriptionLabel = new JLabel("  Field description");
    private final JTextField _fieldDescriptionField = new JTextField();
    private final JLabel _fieldAccessMethodLabel = new JLabel("  Field access method");
    private final JLabel _propertyGetScopeLabel = new JLabel("  Property get scope");
    private final JLabel _propertySetScopeLabel = new JLabel("  Property set scope");
    private final JLabel _fieldScopeLabel = new JLabel("  Field set scope");
    private final BooleanNodeCheckBox _includeInEqualsCheckBox = new BooleanNodeCheckBox("Include in Equals/Hash", null);
    private final BooleanNodeCheckBox _includeInTostringCheckBox = new BooleanNodeCheckBox("Include in toString", null);
    private final BooleanNodeCheckBox _genPropertyCheckBox = new BooleanNodeCheckBox("Generate the property", null);
    private final JLabel _beanPropertyTypeLabel = new JLabel("  Bean constraint property type");
    private final JComboBox _beanPropertyTypeCombo = new JComboBox();
    private final DocumentListener _fieldDescriptionDocumentListener = new DocumentListener(){

        public void changedUpdate(DocumentEvent event) {
            this.update();
        }

        public void insertUpdate(DocumentEvent event) {
            this.update();
        }

        public void removeUpdate(DocumentEvent event) {
            this.update();
        }

        private void update() {
            for (int i = 0; i < JHibernateColumnSettingsPanel.this._currentColumns.length; ++i) {
                JHibernateColumnSettingsPanel.this._currentColumns[i].setFieldDescription(JHibernateColumnSettingsPanel.this._fieldDescriptionField.getText());
            }
        }
    };
    private final ActionListener _comboListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            this.update();
        }

        private void update() {
            String type = (String)JHibernateColumnSettingsPanel.this._columnTypeCombo.getSelectedItem();
            if (type != null) {
                for (int i = 0; i < JHibernateColumnSettingsPanel.this._currentColumns.length; ++i) {
                    String[] acceptableTypes = Sql2Java.getJavaTypes((int)JHibernateColumnSettingsPanel.this._currentColumns[i].getSqlType());
                    boolean yesOK = false;
                    for (int j = 0; j < acceptableTypes.length; ++j) {
                        if (!acceptableTypes[j].equals(type)) continue;
                        yesOK = true;
                        break;
                    }
                    if (yesOK) {
                        JHibernateColumnSettingsPanel.this._currentColumns[i].setJavaType(type);
                        continue;
                    }
                    JavaTypeMapper javaTypeMapper = JHibernateColumnSettingsPanel.this._currentColumns[i].getJavaTypeMapper();
                    if (javaTypeMapper == null) {
                        JHibernateColumnSettingsPanel.this._currentColumns[i].setJavaType(Sql2Java.getPreferredJavaType((int)JHibernateColumnSettingsPanel.this._currentColumns[i].getSqlType(), (int)0, (int)0));
                        continue;
                    }
                    JHibernateColumnSettingsPanel.this._currentColumns[i].setJavaType(javaTypeMapper.getPreferredJavaType(JHibernateColumnSettingsPanel.this._currentColumns[i]));
                }
            }
        }
    };
    private final ActionListener _beanComboListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            this.update();
        }

        private void update() {
            for (int i = 0; i < JHibernateColumnSettingsPanel.this._currentColumns.length; ++i) {
                String type = (String)JHibernateColumnSettingsPanel.this._beanPropertyTypeCombo.getSelectedItem();
                if (type == null) continue;
                JHibernateColumnSettingsPanel.this._currentColumns[i].setBeanPropertyType(type);
            }
        }
    };
    private final ActionListener _columnSpecialtyComboListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            this.update();
        }

        private void update() {
            for (int i = 0; i < JHibernateColumnSettingsPanel.this._currentColumns.length; ++i) {
                String type = (String)JHibernateColumnSettingsPanel.this._columnSpecialtyCombo.getSelectedItem();
                if (type == null) continue;
                JHibernateColumnSettingsPanel.this._currentColumns[i].setColumnSpecialty(type);
            }
        }
    };
    private final ActionListener toggleBtnUpdateableAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < JHibernateColumnSettingsPanel.this._currentColumns.length; ++i) {
                JHibernateColumnSettingsPanel.this._currentColumns[i].setUpdateable(((BooleanNodeCheckBox)e.getSource()).isSelected());
            }
        }
    };
    private final ActionListener toggleBtnInsertableAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < JHibernateColumnSettingsPanel.this._currentColumns.length; ++i) {
                JHibernateColumnSettingsPanel.this._currentColumns[i].setInsertable(((BooleanNodeCheckBox)e.getSource()).isSelected());
            }
        }
    };
    private final ActionListener toggleBtnIncludeToStringAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < JHibernateColumnSettingsPanel.this._currentColumns.length; ++i) {
                JHibernateColumnSettingsPanel.this._currentColumns[i].setIncludeToString(((BooleanNodeCheckBox)e.getSource()).isSelected());
            }
        }
    };
    private final ActionListener toggleBtnIncludeEqualsAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < JHibernateColumnSettingsPanel.this._currentColumns.length; ++i) {
                JHibernateColumnSettingsPanel.this._currentColumns[i].setIncludeEquals(((BooleanNodeCheckBox)e.getSource()).isSelected());
            }
        }
    };
    private final ActionListener toggleBtnGenPropertyAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < JHibernateColumnSettingsPanel.this._currentColumns.length; ++i) {
                JHibernateColumnSettingsPanel.this._currentColumns[i].setGenProperty(((BooleanNodeCheckBox)e.getSource()).isSelected());
            }
        }
    };

    public JHibernateColumnSettingsPanel() {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.initComponents();
        this.addComponents();
        this.assignAllListeners();
    }

    public void setColumns(Column[] columns) {
        boolean singleColumnSelected;
        this.deassignAllListeners();
        this._currentColumns = new HibernateColumn[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            this._currentColumns[i] = (HibernateColumn)columns[i];
        }
        boolean bl = singleColumnSelected = this._currentColumns.length == 1;
        if (this._currentColumns.length >= 1) {
            this._columnUpdateableCheckBox.setBooleanNode(this._currentColumns[0].getUpdateableNode());
            this._columnInsertableCheckBox.setBooleanNode(this._currentColumns[0].getInsertableNode());
            this._includeInTostringCheckBox.setBooleanNode(this._currentColumns[0].getIncludeToStringNode());
            this._genPropertyCheckBox.setBooleanNode(this._currentColumns[0].getGenPropertyNode());
            this._includeInEqualsCheckBox.setBooleanNode(this._currentColumns[0].getIncludeEqualsNode());
            this._fieldDescriptionField.setText(this._currentColumns[0].getFieldDescription());
            this._beanPropertyTypeCombo.setSelectedItem(this._currentColumns[0].getBeanPropertyType());
            this.setAccessField();
            this.setFieldScope();
            this.setFieldGetScope();
            this.setFieldSetScope();
        }
        this._columnNameField.setEnabled(singleColumnSelected);
        this._genPropertyCheckBox.setEnabled(singleColumnSelected);
        if (singleColumnSelected) {
            this._columnNameField.setText(this._currentColumns[0].getVariableName());
        } else {
            this._columnNameField.setText("");
        }
        this.setHibernateJavaTypeCombo();
        this.setHibernateSpecialtyCombo();
        this.assignAllListeners();
    }

    protected void initComponents() {
        String[] sitems = new String[]{"key", "compound key", "version", "timestamp", "property"};
        DefaultComboBoxModel<String> sModel = new DefaultComboBoxModel<String>(sitems);
        this._columnSpecialtyCombo.setModel(sModel);
        this._columnSpecialtyCombo.setEditable(false);
        String[] bitems = new String[]{"unbound", "bound", "constrained"};
        DefaultComboBoxModel<String> cModel = new DefaultComboBoxModel<String>(bitems);
        this._beanPropertyTypeCombo.setModel(cModel);
        this._beanPropertyTypeCombo.setEditable(false);
        this._columnNameField.setEditable(false);
    }

    protected void addComponents() {
        JPanel firstGroup = new JPanel();
        firstGroup.setLayout(new BoxLayout(firstGroup, 1));
        firstGroup.setBorder(BorderFactory.createTitledBorder("Column Mapping Attributes"));
        JPanel secondGroup = new JPanel();
        secondGroup.setLayout(new BoxLayout(secondGroup, 1));
        secondGroup.setBorder(BorderFactory.createTitledBorder("Domain Property Meta Attributes"));
        JPanel firstSectionGroup1 = new JPanel();
        firstSectionGroup1.setLayout(new GridLayout(0, 2, 4, 2));
        JPanel secondSectionGroup1 = new JPanel();
        secondSectionGroup1.setLayout(new GridLayout(0, 2, 4, 2));
        JPanel thirdSectionGroup1 = new JPanel();
        thirdSectionGroup1.setLayout(new GridLayout(0, 2, 4, 2));
        JPanel firstSectionGroup2 = new JPanel();
        firstSectionGroup2.setLayout(new GridLayout(0, 2, 4, 2));
        JPanel secondSectionGroup2 = new JPanel();
        secondSectionGroup2.setLayout(new GridLayout(0, 2, 0, 2));
        JPanel thirdSectionGroup2 = new JPanel();
        thirdSectionGroup2.setLayout(new GridLayout(0, 2, 4, 2));
        JPanel fourthSectionGroup2 = new JPanel();
        fourthSectionGroup2.setLayout(new GridLayout(0, 3, 4, 2));
        firstSectionGroup1.add(this._columnSpecialtyLabel);
        firstSectionGroup1.add(this._columnSpecialtyCombo);
        firstSectionGroup1.add(this._columnNameLabel);
        firstSectionGroup1.add(this._columnNameField);
        firstSectionGroup1.add(this._columnTypeLabel);
        firstSectionGroup1.add(this._columnTypeCombo);
        secondSectionGroup1.add(this._fieldAccessMethodLabel);
        secondSectionGroup1.add(this.BuildAccessPanel());
        thirdSectionGroup1.add((Component)this._columnUpdateableCheckBox);
        thirdSectionGroup1.add((Component)this._columnInsertableCheckBox);
        firstGroup.add(firstSectionGroup1);
        firstGroup.add(secondSectionGroup1);
        firstGroup.add(thirdSectionGroup1);
        firstSectionGroup2.add(this._fieldDescriptionLabel);
        firstSectionGroup2.add(this._fieldDescriptionField);
        secondSectionGroup2.add(this._propertyGetScopeLabel);
        secondSectionGroup2.add(this.BuildTableGetScopePanel());
        secondSectionGroup2.add(this._propertySetScopeLabel);
        secondSectionGroup2.add(this.BuildTableSetScopePanel());
        secondSectionGroup2.add(this._fieldScopeLabel);
        secondSectionGroup2.add(this.BuildTableFieldScopePanel());
        thirdSectionGroup2.add(this._beanPropertyTypeLabel);
        thirdSectionGroup2.add(this._beanPropertyTypeCombo);
        fourthSectionGroup2.add((Component)this._genPropertyCheckBox);
        fourthSectionGroup2.add((Component)this._includeInTostringCheckBox);
        fourthSectionGroup2.add((Component)this._includeInEqualsCheckBox);
        secondGroup.add(firstSectionGroup2);
        secondGroup.add(secondSectionGroup2);
        secondGroup.add(thirdSectionGroup2);
        secondGroup.add(fourthSectionGroup2);
        this.add(firstGroup);
        this.add(secondGroup);
    }

    private void setHibernateJavaTypeCombo() {
        this._columnTypeCombo.setEnabled(true);
        this._columnTypeCombo.removeAllItems();
        if (this._currentColumns[0].isPk() && ((HibernateTable)this._currentColumns[0].getTable()).isCompositeKey()) {
            if (this._currentColumns.length > 1) {
                this._columnTypeCombo.setEnabled(false);
            } else {
                this._columnTypeLabel.setText("  Java type   (" + ((HibernateTable)this._currentColumns[0].getTable()).getCompoundKeyDestinationClassName() + ")");
            }
        } else {
            this._columnTypeLabel.setText("  Java type");
        }
        String selectedJavaType = this._currentColumns[0].getJavaType();
        String[] common = Sql2Java.getJavaTypes((int)this._currentColumns[0].getSqlType());
        for (int i = 0; i < common.length; ++i) {
            this._columnTypeCombo.addItem(common[i]);
        }
        this._columnTypeCombo.setSelectedItem(selectedJavaType);
    }

    private void setHibernateSpecialtyCombo() {
        this._columnSpecialtyCombo.setEnabled(true);
        this._columnSpecialtyCombo.removeAllItems();
        if (this._currentColumns.length == 1) {
            if (this._currentColumns[0].isPk()) {
                if (((HibernateTable)this._currentColumns[0].getTable()).isCompositeKey()) {
                    this._columnSpecialtyCombo.addItem("compound key");
                } else {
                    this._columnSpecialtyCombo.addItem("key");
                }
            } else if (this._currentColumns[0].isFk()) {
                this._columnSpecialtyCombo.addItem("foreign key");
            } else {
                String ptype = this._currentColumns[0].getJavaType();
                if (ptype == null) {
                    JavaTypeMapper javaTypeMapper = this._currentColumns[0].getJavaTypeMapper();
                    ptype = javaTypeMapper == null ? Sql2Java.getPreferredJavaType((int)this._currentColumns[0].getSqlType(), (int)0, (int)0) : javaTypeMapper.getPreferredJavaType(this._currentColumns[0]);
                }
                this._columnSpecialtyCombo.addItem("property");
                if (ptype.equals("long") || ptype.equals("int") || ptype.equals("short")) {
                    this._columnSpecialtyCombo.addItem("version");
                } else if (ptype.equals("java.sql.Timestamp")) {
                    this._columnSpecialtyCombo.addItem("timestamp");
                }
            }
            this._columnSpecialtyCombo.setSelectedItem(this._currentColumns[0].getColumnSpecialty());
            this._currentColumns[0].setColumnSpecialty((String)this._columnSpecialtyCombo.getSelectedItem());
        } else {
            this._columnSpecialtyCombo.addItem("property");
            this._columnSpecialtyCombo.setEnabled(false);
        }
    }

    private void setFieldScope() {
        this._publicFieldRadioButton.setSelected(this._currentColumns[0].getFieldScope().equals("public"));
        this._protectedFieldRadioButton.setSelected(this._currentColumns[0].getFieldScope().equals("protected"));
        this._privateFieldRadioButton.setSelected(this._currentColumns[0].getFieldScope().equals("private"));
    }

    private void setAccessField() {
        this._accessFieldRadioButton.setSelected(this._currentColumns[0].getAccessField().equals("field"));
        this._accessPropertyRadioButton.setSelected(this._currentColumns[0].getAccessField().equals("property"));
    }

    private void setFieldGetScope() {
        this._publicGetRadioButton.setSelected(this._currentColumns[0].getFieldGetScope().equals("public"));
        this._protectedGetRadioButton.setSelected(this._currentColumns[0].getFieldGetScope().equals("protected"));
        this._privateGetRadioButton.setSelected(this._currentColumns[0].getFieldGetScope().equals("private"));
    }

    private void setFieldSetScope() {
        this._publicSetRadioButton.setSelected(this._currentColumns[0].getFieldSetScope().equals("public"));
        this._protectedSetRadioButton.setSelected(this._currentColumns[0].getFieldSetScope().equals("protected"));
        this._privateSetRadioButton.setSelected(this._currentColumns[0].getFieldSetScope().equals("private"));
    }

    private JPanel BuildAccessPanel() {
        JPanel spanel = new JPanel();
        spanel.setLayout(new FlowLayout());
        ButtonGroup group = new ButtonGroup();
        group.add(this._accessFieldRadioButton);
        group.add(this._accessPropertyRadioButton);
        ActionListener radioAccessBtnAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < JHibernateColumnSettingsPanel.this._currentColumns.length; ++i) {
                    JHibernateColumnSettingsPanel.this._currentColumns[i].setAccessField(e.getActionCommand());
                }
            }
        };
        this._accessFieldRadioButton.setActionCommand("field");
        this._accessFieldRadioButton.addActionListener(radioAccessBtnAction);
        this._accessPropertyRadioButton.addActionListener(radioAccessBtnAction);
        this._accessPropertyRadioButton.setActionCommand("property");
        spanel.add(this._accessFieldRadioButton);
        spanel.add(this._accessPropertyRadioButton);
        return spanel;
    }

    private JPanel BuildTableGetScopePanel() {
        JPanel spanel = new JPanel();
        spanel.setLayout(new FlowLayout());
        ButtonGroup group = new ButtonGroup();
        group.add(this._publicGetRadioButton);
        group.add(this._protectedGetRadioButton);
        group.add(this._privateGetRadioButton);
        ActionListener radioGetBtnAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < JHibernateColumnSettingsPanel.this._currentColumns.length; ++i) {
                    JHibernateColumnSettingsPanel.this._currentColumns[i].setFieldGetScope(e.getActionCommand());
                }
            }
        };
        this._publicGetRadioButton.setActionCommand("public");
        this._publicGetRadioButton.addActionListener(radioGetBtnAction);
        this._protectedGetRadioButton.addActionListener(radioGetBtnAction);
        this._protectedGetRadioButton.setActionCommand("protected");
        this._privateGetRadioButton.addActionListener(radioGetBtnAction);
        this._privateGetRadioButton.setActionCommand("private");
        spanel.add(this._publicGetRadioButton);
        spanel.add(this._protectedGetRadioButton);
        spanel.add(this._privateGetRadioButton);
        return spanel;
    }

    private JPanel BuildTableSetScopePanel() {
        JPanel spanel = new JPanel();
        spanel.setLayout(new FlowLayout());
        ButtonGroup group = new ButtonGroup();
        group.add(this._publicSetRadioButton);
        group.add(this._protectedSetRadioButton);
        group.add(this._privateSetRadioButton);
        ActionListener radioSetBtnAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < JHibernateColumnSettingsPanel.this._currentColumns.length; ++i) {
                    JHibernateColumnSettingsPanel.this._currentColumns[i].setFieldSetScope(e.getActionCommand());
                }
            }
        };
        this._publicSetRadioButton.setActionCommand("public");
        this._publicSetRadioButton.addActionListener(radioSetBtnAction);
        this._protectedSetRadioButton.addActionListener(radioSetBtnAction);
        this._protectedSetRadioButton.setActionCommand("protected");
        this._privateSetRadioButton.addActionListener(radioSetBtnAction);
        this._privateSetRadioButton.setActionCommand("private");
        spanel.add(this._publicSetRadioButton);
        spanel.add(this._protectedSetRadioButton);
        spanel.add(this._privateSetRadioButton);
        return spanel;
    }

    private JPanel BuildTableFieldScopePanel() {
        JPanel spanel = new JPanel();
        spanel.setLayout(new FlowLayout());
        ButtonGroup group = new ButtonGroup();
        group.add(this._publicFieldRadioButton);
        group.add(this._protectedFieldRadioButton);
        group.add(this._privateFieldRadioButton);
        ActionListener radioFieldBtnAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < JHibernateColumnSettingsPanel.this._currentColumns.length; ++i) {
                    JHibernateColumnSettingsPanel.this._currentColumns[i].setFieldScope(e.getActionCommand());
                }
            }
        };
        this._publicFieldRadioButton.setActionCommand("public");
        this._publicFieldRadioButton.addActionListener(radioFieldBtnAction);
        this._protectedFieldRadioButton.addActionListener(radioFieldBtnAction);
        this._protectedFieldRadioButton.setActionCommand("protected");
        this._privateFieldRadioButton.addActionListener(radioFieldBtnAction);
        this._privateFieldRadioButton.setActionCommand("private");
        spanel.add(this._publicFieldRadioButton);
        spanel.add(this._protectedFieldRadioButton);
        spanel.add(this._privateFieldRadioButton);
        return spanel;
    }

    private Object[] common(Object[][] arrays) {
        Integer occurrances;
        HashMap<Object, Integer> union = new HashMap<Object, Integer>();
        for (int i = 0; i < arrays.length; ++i) {
            Object[] array = arrays[i];
            for (int j = 0; j < array.length; ++j) {
                occurrances = (Integer)union.get(array[j]);
                if (occurrances == null) {
                    occurrances = new Integer(0);
                }
                union.put(array[j], new Integer(occurrances + 1));
            }
        }
        ArrayList<String> common = new ArrayList<String>();
        if (arrays.length > 1) {
            common.add("");
        }
        Iterator iterator = union.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            occurrances = (Integer)entry.getValue();
            if (occurrances != arrays.length) continue;
            common.add((String)entry.getKey());
        }
        Object[] result = common.toArray();
        Arrays.sort(result, Sql2Java.getTypeComparator());
        return result;
    }

    private void assignAllListeners() {
        this._columnTypeCombo.addActionListener(this._comboListener);
        this._fieldDescriptionField.getDocument().addDocumentListener(this._fieldDescriptionDocumentListener);
        this._beanPropertyTypeCombo.addActionListener(this._beanComboListener);
        this._columnSpecialtyCombo.addActionListener(this._columnSpecialtyComboListener);
        this._columnUpdateableCheckBox.addActionListener(this.toggleBtnUpdateableAction);
        this._columnInsertableCheckBox.addActionListener(this.toggleBtnInsertableAction);
        this._includeInTostringCheckBox.addActionListener(this.toggleBtnIncludeToStringAction);
        this._genPropertyCheckBox.addActionListener(this.toggleBtnGenPropertyAction);
        this._includeInEqualsCheckBox.addActionListener(this.toggleBtnIncludeEqualsAction);
    }

    private void deassignAllListeners() {
        this._columnTypeCombo.removeActionListener(this._comboListener);
        this._fieldDescriptionField.getDocument().removeDocumentListener(this._fieldDescriptionDocumentListener);
        this._beanPropertyTypeCombo.removeActionListener(this._beanComboListener);
        this._columnSpecialtyCombo.removeActionListener(this._columnSpecialtyComboListener);
        this._columnUpdateableCheckBox.removeActionListener(this.toggleBtnUpdateableAction);
        this._columnInsertableCheckBox.removeActionListener(this.toggleBtnInsertableAction);
        this._includeInTostringCheckBox.removeActionListener(this.toggleBtnIncludeToStringAction);
        this._genPropertyCheckBox.removeActionListener(this.toggleBtnGenPropertyAction);
        this._includeInEqualsCheckBox.removeActionListener(this.toggleBtnIncludeEqualsAction);
    }
}

