/*
 * Decompiled with CFR 0.152.
 */
package middlegen.plugins.hibernate.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import middlegen.Table;
import middlegen.plugins.hibernate.HibernateTable;
import middlegen.swing.BooleanNodeCheckBox;
import middlegen.swing.JTableSettingsPanel;

public class JHibernateTableSettingsPanel
extends JTableSettingsPanel {
    private final JLabel _beanKeyGeneratorLabel = new JLabel("  Key generator");
    private final JLabel _beanNameLabel = new JLabel("  Domain class name");
    private final JTextField _beanNameField = new JTextField();
    private final JLabel _schemaNameLabel = new JLabel("  Schema name");
    private final JTextField _schemaNameField = new JTextField();
    private final JLabel _persisterLabel = new JLabel("  Persister");
    private final JTextField _persisterField = new JTextField();
    private final JLabel _classDescriptionLabel = new JLabel("  Class description");
    private final JTextField _classDescriptionField = new JTextField();
    private final JLabel _extendsLabel = new JLabel("  Extends");
    private final JTextField _extendsField = new JTextField();
    private final BooleanNodeCheckBox _implementLifecycleCheckBox = new BooleanNodeCheckBox("Lifecycle interface", null);
    private final BooleanNodeCheckBox _implementValidatableCheckBox = new BooleanNodeCheckBox("Validatable interface", null);
    private final BooleanNodeCheckBox _pcKeyCheckBox = new BooleanNodeCheckBox("Plain Compoundkey", null);
    private final BooleanNodeCheckBox _proxyCheckBox = new BooleanNodeCheckBox("Enable proxies", null);
    private final BooleanNodeCheckBox _mutableCheckBox = new BooleanNodeCheckBox("Mutable", null);
    private final BooleanNodeCheckBox _dynamicUpdateCheckBox = new BooleanNodeCheckBox("Dynamic Update", null);
    private final BooleanNodeCheckBox _dynamicInsertCheckBox = new BooleanNodeCheckBox("Dynamic Insert", null);
    private final BooleanNodeCheckBox _selectBeforeUpdateCheckBox = new BooleanNodeCheckBox("Select Before Update", null);
    private final JRadioButton _publicRadioButton = new JRadioButton("public");
    private final JRadioButton _protectedRadioButton = new JRadioButton("protected");
    private final JRadioButton _privateRadioButton = new JRadioButton("private");
    private final JLabel _classScopeLabel = new JLabel("  Class scope");
    private final JLabel _implementsLabel = new JLabel("  Manage external class interfaces");
    private final JTextField _sourceTextField = new JTextField();
    private final DefaultComboBoxModel _implementsComboModel = new DefaultComboBoxModel();
    private final JComboBox _implementsComboBox = new JComboBox(this._implementsComboModel);
    private final JComboBox _beanKeyGeneratorCombo = new JComboBox();
    private final JTextField _beanKeyGeneratorField = new JTextField();
    private final JLabel _batchSizeLabel = new JLabel("  Batch Size ");
    private final JTextField _batchSizeField = new JTextField();
    private final JLabel _whereLabel = new JLabel("     Where  ");
    private final JTextField _whereField = new JTextField();
    private final BooleanNodeCheckBox _implementEqualsHashcode = new BooleanNodeCheckBox("Generate Equals/Hash", null);
    private final DocumentListener _identityClassListener = new DocumentListener(){

        public void changedUpdate(DocumentEvent event) {
            this.update();
        }

        public void insertUpdate(DocumentEvent event) {
            this.update();
        }

        public void removeUpdate(DocumentEvent event) {
            this.update();
        }

        private void update() {
            JHibernateTableSettingsPanel.this.updateTable(JHibernateTableSettingsPanel.this._beanNameField.getText());
        }
    };
    private final DocumentListener _schemaDocumentListener = new DocumentListener(){

        public void changedUpdate(DocumentEvent event) {
            this.update();
        }

        public void insertUpdate(DocumentEvent event) {
            this.update();
        }

        public void removeUpdate(DocumentEvent event) {
            this.update();
        }

        private void update() {
            JHibernateTableSettingsPanel.this._currentTable.setDatabaseSchema(JHibernateTableSettingsPanel.this._schemaNameField.getText());
        }
    };
    private final DocumentListener _persisterDocumentListener = new DocumentListener(){

        public void changedUpdate(DocumentEvent event) {
            this.update();
        }

        public void insertUpdate(DocumentEvent event) {
            this.update();
        }

        public void removeUpdate(DocumentEvent event) {
            this.update();
        }

        private void update() {
            JHibernateTableSettingsPanel.this._currentTable.setPersister(JHibernateTableSettingsPanel.this._persisterField.getText());
        }
    };
    private final DocumentListener _batchSizeDocumentListener = new DocumentListener(){

        public void changedUpdate(DocumentEvent event) {
            this.update();
        }

        public void insertUpdate(DocumentEvent event) {
            this.update();
        }

        public void removeUpdate(DocumentEvent event) {
            this.update();
        }

        private void update() {
            JHibernateTableSettingsPanel.this._currentTable.setBatchSize(JHibernateTableSettingsPanel.this._batchSizeField.getText());
        }
    };
    private final DocumentListener _whereDocumentListener = new DocumentListener(){

        public void changedUpdate(DocumentEvent event) {
            this.update();
        }

        public void insertUpdate(DocumentEvent event) {
            this.update();
        }

        public void removeUpdate(DocumentEvent event) {
            this.update();
        }

        private void update() {
            JHibernateTableSettingsPanel.this._currentTable.setWhere(JHibernateTableSettingsPanel.this._whereField.getText());
        }
    };
    private final DocumentListener _classDescriptionDocumentListener = new DocumentListener(){

        public void changedUpdate(DocumentEvent event) {
            this.update();
        }

        public void insertUpdate(DocumentEvent event) {
            this.update();
        }

        public void removeUpdate(DocumentEvent event) {
            this.update();
        }

        private void update() {
            JHibernateTableSettingsPanel.this._currentTable.setClassDescription(JHibernateTableSettingsPanel.this._classDescriptionField.getText());
        }
    };
    private final DocumentListener _extendsDocumentListener = new DocumentListener(){

        public void changedUpdate(DocumentEvent event) {
            this.update();
        }

        public void insertUpdate(DocumentEvent event) {
            this.update();
        }

        public void removeUpdate(DocumentEvent event) {
            this.update();
        }

        private void update() {
            JHibernateTableSettingsPanel.this._currentTable.setExtends(JHibernateTableSettingsPanel.this._extendsField.getText());
        }
    };
    private final DocumentListener _keyGeneratorArgListener = new DocumentListener(){

        public void changedUpdate(DocumentEvent event) {
            this.update();
        }

        public void insertUpdate(DocumentEvent event) {
            this.update();
        }

        public void removeUpdate(DocumentEvent event) {
            this.update();
        }

        private void update() {
            JHibernateTableSettingsPanel.this._currentTable.setKeyGeneratorArg(JHibernateTableSettingsPanel.this._beanKeyGeneratorField.getText());
        }
    };
    private final ActionListener toggleBtnMutableAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            JHibernateTableSettingsPanel.this._currentTable.setMutable(((BooleanNodeCheckBox)e.getSource()).isSelected());
        }
    };
    private final ActionListener toggleBtnProxyAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            JHibernateTableSettingsPanel.this._currentTable.setProxy(((BooleanNodeCheckBox)e.getSource()).isSelected());
        }
    };
    private final ActionListener togglePlainCompoundKeyAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            JHibernateTableSettingsPanel.this._currentTable.setPlainCompoundKey(((BooleanNodeCheckBox)e.getSource()).isSelected());
        }
    };
    private final ActionListener toggleBtnDynamicUpdateAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            JHibernateTableSettingsPanel.this._currentTable.setDynamicUpdate(((BooleanNodeCheckBox)e.getSource()).isSelected());
        }
    };
    private final ActionListener toggleBtnDynamicInsertAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            JHibernateTableSettingsPanel.this._currentTable.setDynamicInsert(((BooleanNodeCheckBox)e.getSource()).isSelected());
        }
    };
    private final ActionListener toggleBtnSelectBeforeUpdateAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            JHibernateTableSettingsPanel.this._currentTable.setSelectBeforeUpdate(((BooleanNodeCheckBox)e.getSource()).isSelected());
        }
    };
    private final ActionListener toggleBtnLifecycleAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            JHibernateTableSettingsPanel.this._currentTable.setImplementLifecycle(((BooleanNodeCheckBox)e.getSource()).isSelected());
        }
    };
    private final ActionListener toggleBtnEqualsHashcodeAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            JHibernateTableSettingsPanel.this._currentTable.setEqualsHashcode(((BooleanNodeCheckBox)e.getSource()).isSelected());
        }
    };
    private final ActionListener toggleBtnValidatableAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            JHibernateTableSettingsPanel.this._currentTable.setImplementValidatable(((BooleanNodeCheckBox)e.getSource()).isSelected());
        }
    };
    private final ActionListener keyGeneratorComboAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            JHibernateTableSettingsPanel.this._currentTable.setKeyGenerator((String)JHibernateTableSettingsPanel.this._beanKeyGeneratorCombo.getSelectedItem());
        }
    };
    private HibernateTable _currentTable;

    public JHibernateTableSettingsPanel() {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        JPanel firstGroup = new JPanel();
        firstGroup.setLayout(new BoxLayout(firstGroup, 1));
        firstGroup.setBorder(BorderFactory.createTitledBorder("Table Mapping Attributes"));
        JPanel secondGroup = new JPanel();
        secondGroup.setLayout(new BoxLayout(secondGroup, 1));
        secondGroup.setBorder(BorderFactory.createTitledBorder("Domain Class Meta Attributes"));
        JPanel firstSectionGroup1 = new JPanel();
        firstSectionGroup1.setLayout(new GridLayout(0, 2, 4, 2));
        JPanel secondSectionGroup1 = new JPanel();
        secondSectionGroup1.setLayout(new GridLayout(0, 3, 4, 2));
        JPanel firstSectionGroup2 = new JPanel();
        firstSectionGroup2.setLayout(new GridLayout(0, 2, 4, 2));
        JPanel secondSectionGroup2 = new JPanel();
        secondSectionGroup2.setLayout(new GridLayout(0, 2, 4, 2));
        JPanel thirdSectionGroup2 = new JPanel();
        thirdSectionGroup2.setLayout(new GridLayout(0, 2, 4, 2));
        JPanel fourthSectionGroup2 = new JPanel();
        fourthSectionGroup2.setLayout(new GridLayout(0, 3, 4, 2));
        firstSectionGroup1.add(this._beanNameLabel);
        firstSectionGroup1.add(this._beanNameField);
        firstSectionGroup1.add(this._beanKeyGeneratorLabel);
        firstSectionGroup1.add(this.BuildKeyGeneratorPanel());
        firstSectionGroup1.add(this._schemaNameLabel);
        firstSectionGroup1.add(this._schemaNameField);
        firstSectionGroup1.add(this._persisterLabel);
        firstSectionGroup1.add(this._persisterField);
        firstSectionGroup1.add(this.BuildBatchSizePanel());
        firstSectionGroup1.add(this.BuildWherePanel());
        secondSectionGroup1.add((Component)this._pcKeyCheckBox);
        secondSectionGroup1.add((Component)this._proxyCheckBox);
        secondSectionGroup1.add((Component)this._mutableCheckBox);
        secondSectionGroup1.add((Component)this._dynamicUpdateCheckBox);
        secondSectionGroup1.add((Component)this._dynamicInsertCheckBox);
        secondSectionGroup1.add((Component)this._selectBeforeUpdateCheckBox);
        firstGroup.add(firstSectionGroup1);
        firstGroup.add(secondSectionGroup1);
        firstSectionGroup2.add(this._classDescriptionLabel);
        firstSectionGroup2.add(this._classDescriptionField);
        firstSectionGroup2.add(this._extendsLabel);
        firstSectionGroup2.add(this._extendsField);
        secondSectionGroup2.add(this._classScopeLabel);
        secondSectionGroup2.add(this.BuildTableScopePanel());
        thirdSectionGroup2.add(this._implementsLabel);
        thirdSectionGroup2.add(this.BuildImplementsPanel());
        fourthSectionGroup2.add((Component)this._implementLifecycleCheckBox);
        fourthSectionGroup2.add((Component)this._implementValidatableCheckBox);
        fourthSectionGroup2.add((Component)this._implementEqualsHashcode);
        secondGroup.add(firstSectionGroup2);
        secondGroup.add(secondSectionGroup2);
        secondGroup.add(thirdSectionGroup2);
        secondGroup.add(fourthSectionGroup2);
        this.add(firstGroup);
        this.add(secondGroup);
        this._schemaNameField.getDocument().addDocumentListener(this._schemaDocumentListener);
        this._persisterField.getDocument().addDocumentListener(this._persisterDocumentListener);
        this._classDescriptionField.getDocument().addDocumentListener(this._classDescriptionDocumentListener);
        this._extendsField.getDocument().addDocumentListener(this._extendsDocumentListener);
        this._beanKeyGeneratorField.getDocument().addDocumentListener(this._keyGeneratorArgListener);
        this._batchSizeField.getDocument().addDocumentListener(this._batchSizeDocumentListener);
        this._whereField.getDocument().addDocumentListener(this._whereDocumentListener);
        this._pcKeyCheckBox.addActionListener(this.togglePlainCompoundKeyAction);
        this._mutableCheckBox.addActionListener(this.toggleBtnMutableAction);
        this._proxyCheckBox.addActionListener(this.toggleBtnProxyAction);
        this._dynamicUpdateCheckBox.addActionListener(this.toggleBtnDynamicUpdateAction);
        this._dynamicInsertCheckBox.addActionListener(this.toggleBtnDynamicInsertAction);
        this._selectBeforeUpdateCheckBox.addActionListener(this.toggleBtnSelectBeforeUpdateAction);
        this._implementLifecycleCheckBox.addActionListener(this.toggleBtnLifecycleAction);
        this._implementValidatableCheckBox.addActionListener(this.toggleBtnValidatableAction);
        this._implementEqualsHashcode.addActionListener(this.toggleBtnEqualsHashcodeAction);
        this._beanKeyGeneratorCombo.addActionListener(this.keyGeneratorComboAction);
        this._beanNameField.setEditable(false);
    }

    public void setTable(Table table) {
        this._currentTable = (HibernateTable)table;
        this._implementEqualsHashcode.setBooleanNode(this._currentTable.getEqualsHashcodeNode());
        this._implementLifecycleCheckBox.setBooleanNode(this._currentTable.getLifecycleNode());
        this._implementValidatableCheckBox.setBooleanNode(this._currentTable.getValidatableNode());
        this._pcKeyCheckBox.setBooleanNode(this._currentTable.getPlainCompoundKeyNode());
        this._proxyCheckBox.setBooleanNode(this._currentTable.getProxyNode());
        this._mutableCheckBox.setBooleanNode(this._currentTable.getMutableNode());
        this._dynamicUpdateCheckBox.setBooleanNode(this._currentTable.getDynamicUpdateNode());
        this._dynamicInsertCheckBox.setBooleanNode(this._currentTable.getDynamicInsertNode());
        this._selectBeforeUpdateCheckBox.setBooleanNode(this._currentTable.getSelectBeforeUpdateNode());
        this._beanNameField.setText(this._currentTable.getDestinationClassName());
        this._schemaNameField.setText(this._currentTable.getDatabaseSchema());
        this._persisterField.setText(this._currentTable.getPersister());
        this._batchSizeField.setText(this._currentTable.getBatchSize());
        this._whereField.setText(this._currentTable.getWhere());
        this._classDescriptionField.setText(this._currentTable.getClassDescription());
        this._extendsField.setText(this._currentTable.getExtends());
        this.setKeyGenerator();
        this.setClassScope();
        this.setMultipleImplements();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    private void setKeyGenerator() {
        String[] aKeyGenItem = new String[]{"assigned", "native", "sequence", "identity", "increment", "hilo", "seqhilo", "uuid.hex", "uuid.string", "foreign"};
        String[] cKeyGenItem = new String[]{"assigned"};
        DefaultComboBoxModel<String> cModel = null;
        cModel = this._currentTable.isCompositeKey() ? new DefaultComboBoxModel<String>(cKeyGenItem) : new DefaultComboBoxModel<String>(aKeyGenItem);
        String keyGeneratorValue = this._currentTable.getKeyGenerator();
        this._beanKeyGeneratorCombo.setModel(cModel);
        this._beanKeyGeneratorField.setEditable(!this._currentTable.isCompositeKey());
        this._beanKeyGeneratorField.setText(this._currentTable.getKeyGeneratorArg());
        this._beanKeyGeneratorCombo.setSelectedItem(keyGeneratorValue);
    }

    private void setClassScope() {
        this._publicRadioButton.setSelected(this._currentTable.getClassScope().equals("public"));
        this._protectedRadioButton.setSelected(this._currentTable.getClassScope().equals("protected"));
        this._privateRadioButton.setSelected(this._currentTable.getClassScope().equals("private"));
    }

    private void setMultipleImplements() {
        this._implementsComboBox.removeAllItems();
        ArrayList aList = this._currentTable.getImplements();
        for (int i = 0; i < aList.size(); ++i) {
            this._implementsComboBox.addItem(aList.get(i));
        }
    }

    private JPanel BuildTableScopePanel() {
        JPanel spanel = new JPanel();
        spanel.setLayout(new FlowLayout());
        ButtonGroup group = new ButtonGroup();
        group.add(this._publicRadioButton);
        group.add(this._protectedRadioButton);
        group.add(this._privateRadioButton);
        ActionListener radioBtnAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JHibernateTableSettingsPanel.this._currentTable.setClassScope(e.getActionCommand());
            }
        };
        this._publicRadioButton.setActionCommand("public");
        this._publicRadioButton.addActionListener(radioBtnAction);
        this._protectedRadioButton.addActionListener(radioBtnAction);
        this._protectedRadioButton.setActionCommand("protected");
        this._privateRadioButton.addActionListener(radioBtnAction);
        this._privateRadioButton.setActionCommand("private");
        spanel.add(this._publicRadioButton);
        spanel.add(this._protectedRadioButton);
        spanel.add(this._privateRadioButton);
        return spanel;
    }

    private JPanel BuildImplementsPanel() {
        JPanel ipanel = new JPanel();
        ipanel.setLayout(new BoxLayout(ipanel, 1));
        JButton addButton = new JButton("Add");
        JButton removeButton = new JButton("Remove");
        ActionListener addBtnAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String txt = JHibernateTableSettingsPanel.this._sourceTextField.getText().trim();
                if (txt.length() > 0) {
                    JHibernateTableSettingsPanel.this._implementsComboBox.addItem(txt);
                    JHibernateTableSettingsPanel.this._sourceTextField.setText("");
                    ArrayList aList = JHibernateTableSettingsPanel.this._currentTable.getImplements();
                    aList.add(txt);
                    JHibernateTableSettingsPanel.this._currentTable.setImplements(aList);
                }
            }
        };
        ActionListener removeBtnAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int idx = JHibernateTableSettingsPanel.this._implementsComboBox.getSelectedIndex();
                if (idx >= 0) {
                    JHibernateTableSettingsPanel.this._implementsComboBox.removeItemAt(idx);
                    ArrayList aList = JHibernateTableSettingsPanel.this._currentTable.getImplements();
                    aList.remove(idx);
                    JHibernateTableSettingsPanel.this._currentTable.setImplements(aList);
                }
            }
        };
        addButton.addActionListener(addBtnAction);
        removeButton.addActionListener(removeBtnAction);
        Dimension btnSize = new Dimension(80, 20);
        addButton.setPreferredSize(btnSize);
        removeButton.setPreferredSize(btnSize);
        Box firstRow = Box.createHorizontalBox();
        Box secondRow = Box.createHorizontalBox();
        firstRow.add(this._sourceTextField);
        firstRow.add(addButton);
        secondRow.add(this._implementsComboBox);
        secondRow.add(removeButton);
        ipanel.add(firstRow);
        ipanel.add(secondRow);
        return ipanel;
    }

    private JPanel BuildBatchSizePanel() {
        JPanel ipanel = new JPanel();
        ipanel.setLayout(new BoxLayout(ipanel, 1));
        Box firstRow = Box.createHorizontalBox();
        firstRow.add(this._batchSizeLabel);
        firstRow.add(this._batchSizeField);
        firstRow.add(this._whereLabel);
        ipanel.add(firstRow);
        return ipanel;
    }

    private JPanel BuildWherePanel() {
        JPanel ipanel = new JPanel();
        ipanel.setLayout(new BoxLayout(ipanel, 1));
        Box firstRow = Box.createHorizontalBox();
        firstRow.add(this._whereField);
        ipanel.add(firstRow);
        return ipanel;
    }

    private JPanel BuildKeyGeneratorPanel() {
        JPanel ipanel = new JPanel();
        ipanel.setLayout(new BoxLayout(ipanel, 1));
        this._beanKeyGeneratorCombo.setEditable(false);
        Dimension btnSize = new Dimension(90, 20);
        this._beanKeyGeneratorCombo.setPreferredSize(btnSize);
        Box firstRow = Box.createHorizontalBox();
        firstRow.add(this._beanKeyGeneratorCombo);
        firstRow.add(this._beanKeyGeneratorField);
        ipanel.add(firstRow);
        return ipanel;
    }

    private void updateTable(String beanName) {
        this._currentTable.setDestinationClassName(beanName);
    }
}

