/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.gradebook.dto;

import java.util.ArrayList;
import org.lamsfoundation.lams.gradebook.dto.GradebookGridRowDTO;
import org.lamsfoundation.lams.gradebook.util.GBGridView;
import org.lamsfoundation.lams.gradebook.util.GradebookUtil;
import org.lamsfoundation.lams.usermanagement.User;
import org.springframework.web.util.HtmlUtils;

public class GBUserGridRowDTO
extends GradebookGridRowDTO {
    private String activityUrl;
    private String firstName;
    private String lastName;
    private String login;
    private String currentActivity;
    private Long portraitId;

    public GBUserGridRowDTO() {
    }

    public GBUserGridRowDTO(User user) {
        this.id = user.getUserId().toString();
        this.rowName = HtmlUtils.htmlEscape((String)(user.getLastName() + ", " + user.getFirstName()));
        this.firstName = user.getFirstName();
        this.lastName = user.getLastName();
        this.login = user.getLogin();
        this.setPortraitId(user.getPortraitUuid());
    }

    @Override
    public ArrayList<String> toStringArray(GBGridView view) {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(this.id.toString());
        if (view == GBGridView.MON_USER) {
            ret.add(this.rowName);
            ret.add(this.status);
            ret.add(this.timeTaken != null ? this.convertTimeToString(this.timeTaken) : "-");
            ret.add(this.startDate != null ? this.convertDateToString(this.startDate, null) : "-");
            ret.add(this.finishDate != null ? this.convertDateToString(this.finishDate, null) : "-");
            ret.add(this.feedback);
            ret.add(this.mark != null ? GradebookUtil.niceFormatting(this.mark, this.displayMarkAsPercent) : "-");
            ret.add(this.portraitId != null ? this.portraitId.toString() : "");
        } else if (view == GBGridView.MON_ACTIVITY) {
            ret.add(this.marksAvailable != null ? this.marksAvailable.toString() : "");
            ret.add(this.rowName);
            ret.add(this.status);
            ret.add(this.timeTaken != null ? this.convertTimeToString(this.timeTaken) : "-");
            ret.add(this.startDate != null ? this.convertDateToString(this.startDate, null) : "-");
            ret.add(this.finishDate != null ? this.convertDateToString(this.finishDate, null) : "-");
            ret.add(this.feedback);
            ret.add(this.mark != null ? GradebookUtil.niceFormatting(this.mark) : "-");
            ret.add(this.portraitId != null ? this.portraitId.toString() : "");
            if (this.activityUrl != null && this.activityUrl.length() != 0) {
                ret.add("javascript:launchPopup(\"" + this.activityUrl + "\",\"" + this.rowName + "\",796,570)'>");
            }
        } else if (view == GBGridView.MON_COURSE) {
            ret.add(this.rowName);
            ret.add(this.status);
            ret.add(this.timeTaken != null ? this.convertTimeToString(this.timeTaken) : "-");
            ret.add(this.startDate != null ? this.convertDateToString(this.startDate, null) : "-");
            ret.add(this.finishDate != null ? this.convertDateToString(this.finishDate, null) : "-");
            ret.add(this.feedback);
            ret.add(this.mark != null ? GradebookUtil.niceFormatting(this.mark, this.displayMarkAsPercent) : "-");
            ret.add(this.portraitId != null ? this.portraitId.toString() : "");
        } else if (view == GBGridView.LIST) {
            ret.add(this.rowName);
            ret.add(this.portraitId != null ? this.portraitId.toString() : "");
        }
        return ret;
    }

    public String getActivityUrl() {
        return this.activityUrl;
    }

    public void setActivityUrl(String activityUrl) {
        this.activityUrl = activityUrl;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getCurrentActivity() {
        return this.currentActivity;
    }

    public void setCurrentActivity(String currentActivity) {
        this.currentActivity = currentActivity;
    }

    public Long getPortraitId() {
        return this.portraitId;
    }

    public void setPortraitId(Long portraitId) {
        this.portraitId = portraitId;
    }
}

