/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.gradebook.dto;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.lamsfoundation.lams.gradebook.util.GBGridView;

public abstract class GradebookGridRowDTO {
    protected static final String CELL_EMPTY = "-";
    protected static final DateFormat DEFAULT_DATE_FORMAT = DateFormat.getDateTimeInstance(3, 3);
    protected String id;
    protected String rowName;
    protected Long timeTaken;
    protected Date startDate;
    protected Date finishDate;
    protected Long medianTimeTaken;
    protected Long minTimeTaken;
    protected Long maxTimeTaken;
    protected Double mark;
    protected Double averageMark;
    protected Long marksAvailable;
    protected String status;
    protected String feedback;
    protected boolean displayMarkAsPercent = false;

    public abstract ArrayList<String> toStringArray(GBGridView var1);

    protected String convertTimeToString(Long timeInMillis) {
        StringBuilder sb = new StringBuilder();
        if (timeInMillis != null && timeInMillis > 1000L) {
            long totalTimeInSeconds = timeInMillis / 1000L;
            long seconds = totalTimeInSeconds >= 60L ? totalTimeInSeconds % 60L : totalTimeInSeconds;
            long minutes = (totalTimeInSeconds /= 60L) >= 60L ? totalTimeInSeconds % 60L : totalTimeInSeconds;
            long hours = (totalTimeInSeconds /= 60L) >= 24L ? totalTimeInSeconds % 24L : totalTimeInSeconds;
            long days = totalTimeInSeconds /= 24L;
            if (days != 0L) {
                sb.append("" + days + "d, ");
            }
            if (hours != 0L) {
                sb.append("" + hours + "h, ");
            }
            if (minutes != 0L) {
                sb.append("" + minutes + "m, ");
            }
            if (seconds != 0L) {
                sb.append("" + seconds + "s");
            }
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    protected String convertDateToString(Date date, DateFormat format) {
        if (date != null) {
            DateFormat usedFormat = format == null ? DEFAULT_DATE_FORMAT : format;
            return usedFormat.format(date);
        }
        return null;
    }

    protected String toItalic(String string) {
        return "<i>" + string + "</i>";
    }

    public Long getTimeTaken() {
        return this.timeTaken;
    }

    public Long getTimeTakenSeconds() {
        if (this.timeTaken != null) {
            return this.timeTaken / 1000L;
        }
        return null;
    }

    public void setTimeTaken(Long timeTaken) {
        this.timeTaken = timeTaken;
    }

    public Double getMark() {
        return this.mark;
    }

    public void setMark(Double mark) {
        this.mark = mark;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRowName() {
        return this.rowName;
    }

    public void setRowName(String rowName) {
        this.rowName = rowName;
    }

    public Long getMedianTimeTaken() {
        return this.medianTimeTaken;
    }

    public Long getMedianTimeTakenSeconds() {
        if (this.medianTimeTaken != null) {
            return this.medianTimeTaken / 1000L;
        }
        return null;
    }

    public void setMedianTimeTaken(Long medianTimeTaken) {
        this.medianTimeTaken = medianTimeTaken;
    }

    public Long getMinTimeTaken() {
        return this.minTimeTaken;
    }

    public Long getMinTimeTakenSeconds() {
        if (this.minTimeTaken != null) {
            return this.minTimeTaken / 1000L;
        }
        return null;
    }

    public void setMinTimeTaken(Long minTimeTaken) {
        this.minTimeTaken = minTimeTaken;
    }

    public Long getMaxTimeTaken() {
        return this.maxTimeTaken;
    }

    public Long getMaxTimeTakenSeconds() {
        if (this.maxTimeTaken != null) {
            return this.maxTimeTaken / 1000L;
        }
        return null;
    }

    public void setMaxTimeTaken(Long maxTimeTaken) {
        this.maxTimeTaken = maxTimeTaken;
    }

    public Double getAverageMark() {
        return this.averageMark;
    }

    public void setAverageMark(Double averageMark) {
        this.averageMark = averageMark;
    }

    public Long getMarksAvailable() {
        return this.marksAvailable;
    }

    public void setMarksAvailable(Long marksAvailable) {
        this.marksAvailable = marksAvailable;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getFeedback() {
        return this.feedback;
    }

    public void setFeedback(String feedback) {
        this.feedback = feedback;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getFinishDate() {
        return this.finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }

    public boolean getDisplayMarkAsPercent() {
        return this.displayMarkAsPercent;
    }

    public void setDisplayMarkAsPercent(boolean displayMarkAsPercent) {
        this.displayMarkAsPercent = displayMarkAsPercent;
    }
}

