/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.gradebook.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.dao.IBaseDAO;
import org.lamsfoundation.lams.gradebook.GradebookUserActivity;
import org.lamsfoundation.lams.gradebook.GradebookUserActivityArchive;
import org.lamsfoundation.lams.gradebook.GradebookUserLesson;
import org.lamsfoundation.lams.gradebook.GradebookUserLessonArchive;
import org.lamsfoundation.lams.gradebook.dao.IGradebookDAO;
import org.lamsfoundation.lams.gradebook.dto.GBActivityGridRowDTO;
import org.lamsfoundation.lams.gradebook.dto.GBLessonGridRowDTO;
import org.lamsfoundation.lams.gradebook.dto.GBUserGridRowDTO;
import org.lamsfoundation.lams.gradebook.dto.GradebookGridRowDTO;
import org.lamsfoundation.lams.gradebook.service.IGradebookService;
import org.lamsfoundation.lams.gradebook.util.GBGridView;
import org.lamsfoundation.lams.gradebook.util.GradebookUtil;
import org.lamsfoundation.lams.gradebook.util.LessonComparator;
import org.lamsfoundation.lams.gradebook.util.UserComparator;
import org.lamsfoundation.lams.learning.service.ICoreLearnerService;
import org.lamsfoundation.lams.learning.web.bean.ActivityURL;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ActivityEvaluation;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.FloatingActivity;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.OptionsActivity;
import org.lamsfoundation.lams.learningdesign.ParallelActivity;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.lesson.CompletedActivityProgress;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.dao.ILearnerProgressDAO;
import org.lamsfoundation.lams.lesson.dao.ILessonDAO;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.logevent.service.ILogEventService;
import org.lamsfoundation.lams.tool.ToolOutput;
import org.lamsfoundation.lams.tool.ToolOutputValue;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.DateUtil;
import org.lamsfoundation.lams.util.ExcelCell;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.util.HtmlUtils;

public class GradebookService
implements IGradebookService {
    private static Logger logger = Logger.getLogger(GradebookService.class);
    private static final ExcelCell[] EMPTY_ROW = new ExcelCell[4];
    private static final String TOOL_SIGNATURE_ASSESSMENT = "laasse10";
    public static final String TOOL_SIGNATURE_SCRATCHIE = "lascrt11";
    public static final String TOOL_SIGNATURE_MCQ = "lamc11";
    private ILamsCoreToolService toolService;
    private IGradebookDAO gradebookDAO;
    private ILearnerProgressDAO learnerProgressDAO;
    private ILessonDAO lessonDAO;
    private ILessonService lessonService;
    private IUserManagementService userService;
    private IBaseDAO baseDAO;
    private IActivityDAO activityDAO;
    private MessageService messageService;
    private ILogEventService logEventService;
    private static ICoreLearnerService learnerService;

    @Override
    public List<GradebookGridRowDTO> getGBActivityRowsForLearner(Long lessonId, Integer userId, TimeZone userTimezone) {
        logger.debug((Object)("Getting gradebook user data for lesson: " + lessonId + ". For user: " + userId));
        Lesson lesson = this.lessonService.getLesson(lessonId);
        User learner = (User)this.userService.findById(User.class, (Serializable)userId);
        ArrayList<GradebookGridRowDTO> gradebookActivityDTOs = new ArrayList<GradebookGridRowDTO>();
        List<ToolActivity> activities = this.getLessonActivitiesForLearner(lesson, userId);
        for (ToolActivity activity : activities) {
            byte activityState;
            Group group;
            String groupName = null;
            Long groupId = null;
            if (activity.getGrouping() != null && (group = activity.getGroupFor(learner)) != null) {
                groupName = group.getGroupName();
                groupId = group.getGroupId();
            }
            GBActivityGridRowDTO activityDTO = new GBActivityGridRowDTO((Activity)activity, groupName, groupId);
            activityDTO.setMarksAvailable(this.toolService.getActivityMaxPossibleMark(activity));
            GradebookUserActivity gradebookActivity = this.gradebookDAO.getGradebookUserDataForActivity(activity.getActivityId(), learner.getUserId());
            if (gradebookActivity != null) {
                activityDTO.setMark(gradebookActivity.getMark());
                activityDTO.setFeedback(gradebookActivity.getFeedback());
            }
            LearnerProgress learnerProgress = this.lessonService.getUserProgressForLesson(learner.getUserId(), lesson.getLessonId());
            activityDTO.setStartDate(this.getActivityStartDate(learnerProgress, (Activity)activity, userTimezone));
            activityDTO.setFinishDate(this.getActivityFinishDate(learnerProgress, (Activity)activity, userTimezone));
            activityDTO.setTimeTaken(this.getActivityDuration(learnerProgress, (Activity)activity));
            activityDTO.setStatus(this.getActivityStatusStr(learnerProgress, (Activity)activity));
            activityDTO.setAverageMark(this.gradebookDAO.getAverageMarkForActivity(activity.getActivityId()));
            activityDTO.setMedianTimeTaken(this.gradebookDAO.getMedianTimeTakenForActivity(activity.getActivityId()));
            activityDTO.setMaxTimeTaken(this.gradebookDAO.getMaxTimeTakenForActivity(activity.getActivityId()));
            activityDTO.setMinTimeTaken(this.gradebookDAO.getMinTimeTakenForActivity(activity.getActivityId()));
            ToolSession toolSession = this.toolService.getToolSessionByLearner(learner, (Activity)activity);
            if (toolSession != null && learnerProgress != null && ((activityState = learnerProgress.getProgressState((Activity)activity)) == 2 || activityState == 1)) {
                activityDTO.setActivityUrl(Configuration.get((String)ConfigurationKeys.SERVER_URL) + activity.getTool().getLearnerProgressUrl() + "&userID=" + learner.getUserId() + "&toolSessionID=" + toolSession.getToolSessionId().toString());
            }
            gradebookActivityDTOs.add(activityDTO);
        }
        return gradebookActivityDTOs;
    }

    @Override
    public List<GradebookGridRowDTO> getGBLessonComplete(Long lessonId, Integer userId) {
        logger.debug((Object)("Getting lesson complete gradebook user data for lesson: " + lessonId + ". For user: " + userId));
        Lesson lesson = this.lessonService.getLesson(lessonId);
        User learner = (User)this.userService.findById(User.class, (Serializable)userId);
        ArrayList<GradebookGridRowDTO> gradebookActivityDTOs = new ArrayList<GradebookGridRowDTO>();
        List<ToolActivity> activities = this.getLessonActivitiesForLearner(lesson, userId);
        for (ToolActivity activity : activities) {
            Group group;
            String groupName = null;
            Long groupId = null;
            if (activity.getGrouping() != null && (group = activity.getGroupFor(learner)) != null) {
                groupName = group.getGroupName();
                groupId = group.getGroupId();
            }
            GBActivityGridRowDTO activityDTO = new GBActivityGridRowDTO((Activity)activity, groupName, groupId);
            GradebookUserActivity gradebookActivity = this.gradebookDAO.getGradebookUserDataForActivity(activity.getActivityId(), learner.getUserId());
            if (gradebookActivity != null) {
                activityDTO.setMark(gradebookActivity.getMark());
            }
            activityDTO.setAverageMark(this.gradebookDAO.getAverageMarkForActivity(activity.getActivityId()));
            LearnerProgress learnerProgress = this.lessonService.getUserProgressForLesson(learner.getUserId(), lesson.getLessonId());
            activityDTO.setStatus(this.getActivityStatusStr(learnerProgress, (Activity)activity));
            gradebookActivityDTOs.add(activityDTO);
        }
        return gradebookActivityDTOs;
    }

    @Override
    public List<GradebookGridRowDTO> getGBActivityRowsForLesson(Long lessonId, TimeZone userTimezone, boolean escapeTitles) {
        logger.debug((Object)("Getting gradebook data for lesson: " + lessonId));
        Lesson lesson = this.lessonService.getLesson(lessonId);
        ArrayList<GradebookGridRowDTO> gradebookActivityDTOs = new ArrayList<GradebookGridRowDTO>();
        List<ToolActivity> activities = this.getLessonToolActivitiesForLesson(lesson);
        for (ToolActivity activity : activities) {
            Grouping grouping = activity.getGrouping();
            if (grouping != null) {
                Set groups = grouping.getGroups();
                if (groups == null) continue;
                for (Group group : groups) {
                    GBActivityGridRowDTO activityDTO = this.getGradebookActivityDTO(activity, lesson, group.getGroupName(), group.getGroupId(), escapeTitles);
                    gradebookActivityDTOs.add(activityDTO);
                }
                continue;
            }
            GBActivityGridRowDTO activityDTO = this.getGradebookActivityDTO(activity, lesson, null, null, escapeTitles);
            gradebookActivityDTOs.add(activityDTO);
        }
        return gradebookActivityDTOs;
    }

    @Override
    public List<GBUserGridRowDTO> getGBUserRowsForActivity(Lesson lesson, ToolActivity activity, Long groupId, int page, int size, String sortBy, String sortOrder, String searchString, TimeZone timezone) {
        Group group;
        Long lessonId = lesson.getLessonId();
        Long activityId = activity.getActivityId();
        ArrayList<GBUserGridRowDTO> gradebookUserDTOs = new ArrayList<GBUserGridRowDTO>();
        List learners = null;
        learners = groupId != null ? ((group = (Group)this.userService.findById(Group.class, (Serializable)groupId)) != null ? this.gradebookDAO.getUsersByGroup(lessonId, activityId, groupId, page, size, sortBy, sortOrder, searchString) : this.gradebookDAO.getUsersByActivity(lessonId, activityId, page, size, sortBy, sortOrder, searchString)) : this.gradebookDAO.getUsersByActivity(lessonId, activityId, page, size, sortBy, sortOrder, searchString);
        if (learners != null) {
            Map<Integer, LearnerProgress> userToLearnerProgressMap = this.getUserToLearnerProgressMap(lesson, learners);
            Map<Integer, GradebookUserActivity> userToGradebookUserLessonMap = this.getUserToGradebookUserActivityMap((Activity)activity, learners);
            Long maxPossibleMark = this.toolService.getActivityMaxPossibleMark(activity);
            for (User learner : learners) {
                GradebookUserActivity gradebookUserActivity;
                byte activityState;
                GBUserGridRowDTO gUserDTO = new GBUserGridRowDTO(learner);
                gUserDTO.setMarksAvailable(maxPossibleMark);
                LearnerProgress learnerProgress = userToLearnerProgressMap.get(learner.getUserId());
                gUserDTO.setStatus(this.getActivityStatusStr(learnerProgress, (Activity)activity));
                gUserDTO.setTimeTaken(this.getActivityDuration(learnerProgress, (Activity)activity));
                gUserDTO.setStartDate(this.getActivityStartDate(learnerProgress, (Activity)activity, timezone));
                gUserDTO.setFinishDate(this.getActivityFinishDate(learnerProgress, (Activity)activity, timezone));
                ToolSession toolSession = this.toolService.getToolSessionByLearner(learner, (Activity)activity);
                if (toolSession != null && learnerProgress != null && ((activityState = learnerProgress.getProgressState((Activity)activity)) == 2 || activityState == 1)) {
                    gUserDTO.setActivityUrl(Configuration.get((String)ConfigurationKeys.SERVER_URL) + activity.getTool().getLearnerProgressUrl() + "&userID=" + learner.getUserId() + "&toolSessionID=" + toolSession.getToolSessionId().toString());
                }
                if ((gradebookUserActivity = userToGradebookUserLessonMap.get(learner.getUserId())) != null) {
                    gUserDTO.setFeedback(gradebookUserActivity.getFeedback());
                    gUserDTO.setMark(gradebookUserActivity.getMark());
                }
                gradebookUserDTOs.add(gUserDTO);
            }
        }
        return gradebookUserDTOs;
    }

    public ArrayList<GBUserGridRowDTO> getGBUserRowsForLesson(Lesson lesson, TimeZone timeZone) {
        return this.getGBUserRowsForLesson(lesson, 0, 0, null, null, null, timeZone);
    }

    public ArrayList<GBUserGridRowDTO> getGBUserRowsForLesson(Lesson lesson, int page, int size, String sortBy, String sortOrder, String searchString, TimeZone userTimeZone) {
        ArrayList<GBUserGridRowDTO> gradebookUserDTOs = new ArrayList<GBUserGridRowDTO>();
        if (lesson != null) {
            Map<Integer, GradebookUserLesson> userToGradebookUserLessonMap;
            Map<Integer, LearnerProgress> userToLearnerProgressMap;
            LinkedList<User> learners;
            if (size == 0) {
                learners = new LinkedList(lesson.getAllLearners());
                Collections.sort(learners, new UserComparator());
                userToLearnerProgressMap = this.getUserToLearnerProgressMap(lesson, null);
                userToGradebookUserLessonMap = this.getUserToGradebookUserLessonMap(lesson, null);
            } else {
                learners = this.gradebookDAO.getUsersByLesson(lesson.getLessonId(), page, size, sortBy, sortOrder, searchString);
                userToLearnerProgressMap = this.getUserToLearnerProgressMap(lesson, learners);
                userToGradebookUserLessonMap = this.getUserToGradebookUserLessonMap(lesson, learners);
            }
            boolean isWeighted = this.toolService.isWeightedMarks(lesson.getLearningDesign());
            for (User learner : learners) {
                GradebookUserLesson gradebookUserLesson;
                LearnerProgress learnerProgress = userToLearnerProgressMap.get(learner.getUserId());
                GBUserGridRowDTO gradebookUserDTO = new GBUserGridRowDTO(learner);
                gradebookUserDTOs.add(gradebookUserDTO);
                gradebookUserDTO.setStatus(this.getLessonStatusStr(learnerProgress));
                if (learnerProgress != null && learnerProgress.getCurrentActivity() != null) {
                    gradebookUserDTO.setCurrentActivity(learnerProgress.getCurrentActivity().getTitle());
                }
                if (learnerProgress != null) {
                    Date startDate = learnerProgress.getStartDate();
                    Date finishDate = learnerProgress.getFinishDate();
                    if (startDate != null && finishDate != null) {
                        gradebookUserDTO.setTimeTaken(finishDate.getTime() - startDate.getTime());
                    }
                    if (startDate != null) {
                        if (userTimeZone != null) {
                            startDate = DateUtil.convertToTimeZoneFromDefault((TimeZone)userTimeZone, (Date)startDate);
                        }
                        gradebookUserDTO.setStartDate(startDate);
                    }
                    if (learnerProgress.getFinishDate() != null) {
                        if (userTimeZone != null) {
                            finishDate = DateUtil.convertToTimeZoneFromDefault((TimeZone)userTimeZone, (Date)finishDate);
                        }
                        gradebookUserDTO.setFinishDate(finishDate);
                    }
                }
                if ((gradebookUserLesson = userToGradebookUserLessonMap.get(learner.getUserId())) == null) continue;
                gradebookUserDTO.setMark(gradebookUserLesson.getMark());
                gradebookUserDTO.setFeedback(gradebookUserLesson.getFeedback());
                gradebookUserDTO.setDisplayMarkAsPercent(isWeighted);
            }
        }
        return gradebookUserDTOs;
    }

    @Override
    public int getCountUsersByLesson(Long lessonId, String searchString) {
        return this.gradebookDAO.getCountUsersByLesson(lessonId, searchString);
    }

    @Override
    public ArrayList<GBUserGridRowDTO> getGBUserRowsForOrganisation(Organisation organisation, int page, int size, String sortOrder, String searchString) {
        List learners;
        ArrayList<GBUserGridRowDTO> gradebookUserDTOs = new ArrayList<GBUserGridRowDTO>();
        if (organisation != null && (learners = this.gradebookDAO.getUsersFromOrganisation(organisation.getOrganisationId(), page, size, sortOrder, searchString)) != null) {
            for (User learner : learners) {
                GBUserGridRowDTO gradebookUserDTO = new GBUserGridRowDTO(learner);
                gradebookUserDTOs.add(gradebookUserDTO);
            }
        }
        return gradebookUserDTOs;
    }

    @Override
    public int getCountUsersByOrganisation(Integer orgId, String searchString) {
        return this.gradebookDAO.getCountUsersByOrganisation(orgId, searchString);
    }

    @Override
    public GradebookUserLesson getGradebookUserLesson(Long lessonID, Integer userID) {
        return this.gradebookDAO.getGradebookUserDataForLesson(lessonID, userID);
    }

    @Override
    public List<GradebookUserLesson> getGradebookUserLesson(Long lessonID) {
        return this.gradebookDAO.getGradebookUserDataForLesson(lessonID);
    }

    @Override
    public GradebookUserActivity getGradebookUserActivity(Long activityID, Integer userID) {
        return this.gradebookDAO.getGradebookUserDataForActivity(activityID, userID);
    }

    @Override
    public List<GradebookUserActivity> getGradebookUserActivities(Long activityId) {
        return this.gradebookDAO.getAllGradebookUserActivitiesForActivity(activityId);
    }

    @Override
    public Double getAverageMarkForActivity(Long activityID, Long groupID) {
        Double averageMark = groupID == null ? this.gradebookDAO.getAverageMarkForActivity(activityID) : this.gradebookDAO.getAverageMarkForGroupedActivity(activityID, groupID);
        return averageMark;
    }

    @Override
    public Double getAverageMarkForLesson(Long lessonID) {
        return this.gradebookDAO.getAverageMarkForLesson(lessonID);
    }

    @Override
    public void updateUserLessonGradebookMark(Lesson lesson, User learner, Double mark) {
        if (lesson != null && learner != null) {
            GradebookUserLesson gradebookUserLesson = this.gradebookDAO.getGradebookUserDataForLesson(lesson.getLessonId(), learner.getUserId());
            if (gradebookUserLesson == null) {
                gradebookUserLesson = new GradebookUserLesson(lesson, learner);
            }
            String oldMark = gradebookUserLesson.getMark() == null ? "-" : gradebookUserLesson.getMark().toString();
            gradebookUserLesson.setMark(mark);
            this.gradebookDAO.insertOrUpdate((Object)gradebookUserLesson);
            UserDTO monitorUser = (UserDTO)SessionManager.getSession().getAttribute("user");
            Object[] args = new String[]{learner.getLogin() + "(" + learner.getUserId() + ")", lesson.getLessonId().toString(), oldMark, mark.toString()};
            String message = this.messageService.getMessage("audit.lesson.change.mark", args);
            this.logEventService.logEvent(Integer.valueOf(17), monitorUser.getUserID(), learner.getUserId(), lesson.getLessonId(), null, message);
        }
    }

    @Override
    public void recalculateTotalMarksForLesson(Long lessonId) throws Exception {
        Lesson lesson = this.lessonDAO.getLesson(lessonId);
        if (lesson == null) {
            return;
        }
        boolean weighted = this.toolService.isWeightedMarks(lesson.getLearningDesign());
        Map<Integer, GradebookUserLesson> userToGradebookUserLessonMap = this.getUserToGradebookUserLessonMap(lesson, null);
        Set users = lesson.getAllLearners();
        for (User user : users) {
            Integer userId = user.getUserId();
            GradebookUserLesson gradebookUserLesson = userToGradebookUserLessonMap.get(userId);
            List userActivities = this.gradebookDAO.getGradebookUserActivitiesForLesson(lessonId, userId);
            Double totalMark = this.calculateLessonMark(weighted, userActivities, null);
            if (totalMark == null) continue;
            if (totalMark > 0.0 && gradebookUserLesson == null) {
                throw new Exception("An error detected: user (userId:" + userId + ") has total mark that equals to " + totalMark + " but no assocciated gradebookUserLesson exist ");
            }
            if (gradebookUserLesson == null) continue;
            gradebookUserLesson.setMark(totalMark);
            this.gradebookDAO.insertOrUpdate((Object)gradebookUserLesson);
        }
    }

    @Override
    public void recalculateGradebookMarksForActivity(Activity activity) {
        Long activityId = activity.getActivityId();
        Lesson lesson = this.lessonDAO.getLessonForActivity(activityId.longValue());
        if (lesson == null || activity == null || !(activity instanceof ToolActivity) || ((ToolActivity)activity).getEvaluation() == null) {
            return;
        }
        ToolActivity toolActivity = (ToolActivity)activity;
        ActivityEvaluation eval = toolActivity.getEvaluation();
        String toolOutputDefinition = eval.getToolOutputDefinition();
        Map<Integer, GradebookUserActivity> userToGradebookUserActivityMap = this.getUserToGradebookUserActivityMap(activity, null);
        Map<Integer, GradebookUserLesson> userToGradebookUserLessonMap = this.getUserToGradebookUserLessonMap(lesson, null);
        List toolOutputs = this.toolService.getOutputsFromTool(toolOutputDefinition, toolActivity);
        List users = this.learnerProgressDAO.getLearnersCompletedActivity(activity);
        for (User user : users) {
            ToolOutput toolOutput = null;
            for (ToolOutput toolOutputIter : toolOutputs) {
                if (!toolOutputIter.getUserId().equals(user.getUserId())) continue;
                toolOutput = toolOutputIter;
            }
            Double outputDouble = toolOutput == null || toolOutput.getValue() == null ? null : toolOutput.getValue().getDouble();
            GradebookUserActivity gradebookUserActivity = userToGradebookUserActivityMap.get(user.getUserId());
            GradebookUserLesson gradebookUserLesson = userToGradebookUserLessonMap.get(user.getUserId());
            if (gradebookUserActivity != null && gradebookUserActivity.getMarkedInGradebook().booleanValue()) continue;
            this.updateUserActivityGradebookMark(lesson, user, (Activity)toolActivity, outputDouble, false, false, gradebookUserActivity, gradebookUserLesson);
        }
    }

    @Override
    public void updateUserActivityGradebookMark(Lesson lesson, Activity activity, User learner) {
        ToolSession toolSession = this.toolService.getToolSessionByLearner(learner, activity);
        if (toolSession == null || toolSession == null || learner == null || lesson == null || activity == null || !(activity instanceof ToolActivity) || ((ToolActivity)activity).getEvaluation() == null) {
            return;
        }
        ToolActivity toolActivity = (ToolActivity)activity;
        ActivityEvaluation eval = toolActivity.getEvaluation();
        try {
            ToolOutputValue outputVal;
            ToolOutput toolOutput = this.toolService.getOutputFromTool(eval.getToolOutputDefinition(), toolSession, learner.getUserId());
            if (toolOutput != null && (outputVal = toolOutput.getValue()) != null) {
                Double outputDouble = outputVal.getDouble();
                GradebookUserActivity gradebookUserActivity = this.getGradebookUserActivity(toolActivity.getActivityId(), learner.getUserId());
                if (gradebookUserActivity == null || !gradebookUserActivity.getMarkedInGradebook().booleanValue()) {
                    this.updateUserActivityGradebookMark(lesson, learner, (Activity)toolActivity, outputDouble, false, false);
                }
            }
        }
        catch (ToolException e) {
            logger.debug((Object)("Runtime exception when attempted to get outputs for activity: " + toolActivity.getActivityId()), (Throwable)e);
        }
    }

    @Override
    public void updateUserActivityGradebookMark(Lesson lesson, User learner, Activity activity, Double mark, Boolean markedInGradebook, boolean isAuditLogRequired) {
        GradebookUserActivity gradebookUserActivity = this.gradebookDAO.getGradebookUserDataForActivity(activity.getActivityId(), learner.getUserId());
        GradebookUserLesson gradebookUserLesson = this.gradebookDAO.getGradebookUserDataForLesson(lesson.getLessonId(), learner.getUserId());
        this.updateUserActivityGradebookMark(lesson, learner, activity, mark, markedInGradebook, isAuditLogRequired, gradebookUserActivity, gradebookUserLesson);
    }

    @Override
    public boolean isWeightedMarks(Long lessonId) {
        Lesson lesson = this.lessonService.getLesson(lessonId);
        return this.toolService.isWeightedMarks(lesson.getLearningDesign());
    }

    @Override
    public List<String[]> getWeights(LearningDesign design) {
        ArrayList<String[]> evaluations = new ArrayList<String[]>();
        Set activities = design.getActivities();
        for (Activity activity : activities) {
            ToolActivity act;
            ActivityEvaluation eval;
            if (!activity.isToolActivity() || (eval = (act = (ToolActivity)this.activityDAO.getActivityByActivityId(activity.getActivityId())).getEvaluation()) == null || eval.getWeight() == null || eval.getWeight() <= 0) continue;
            String[] evaluation = new String[]{act.getTitle(), eval.getToolOutputDefinition(), eval.getWeight().toString() + '%'};
            evaluations.add(evaluation);
        }
        return evaluations;
    }

    private void updateUserActivityGradebookMark(Lesson lesson, User learner, Activity activity, Double mark, Boolean markedInGradebook, boolean isAuditLogRequired, GradebookUserActivity gradebookUserActivity, GradebookUserLesson gradebookUserLesson) {
        if (lesson != null && activity != null && learner != null && activity.isToolActivity()) {
            if (gradebookUserActivity == null) {
                gradebookUserActivity = new GradebookUserActivity((ToolActivity)activity, learner);
            }
            String oldMark = gradebookUserActivity.getMark() == null ? "-" : gradebookUserActivity.getMark().toString();
            Double oldActivityMark = gradebookUserActivity.getMark();
            gradebookUserActivity.setMark(mark);
            gradebookUserActivity.setUpdateDate(new Date());
            gradebookUserActivity.setMarkedInGradebook(markedInGradebook);
            this.gradebookDAO.insertOrUpdate((Object)gradebookUserActivity);
            this.gradebookDAO.flush();
            if (gradebookUserLesson == null) {
                gradebookUserLesson = new GradebookUserLesson();
                gradebookUserLesson.setLearner(learner);
                gradebookUserLesson.setLesson(lesson);
            }
            boolean isWeightedMarks = this.toolService.isWeightedMarks(lesson.getLearningDesign());
            this.aggregateTotalMarkForLesson(isWeightedMarks, gradebookUserLesson, gradebookUserActivity, oldActivityMark);
            if (isAuditLogRequired) {
                UserDTO monitorUser = (UserDTO)SessionManager.getSession().getAttribute("user");
                String markStr = mark == null ? "" : mark.toString();
                Object[] args = new String[]{learner.getLogin() + "(" + learner.getUserId() + ")", lesson.getLessonId().toString(), activity.getActivityId().toString(), oldMark.toString(), markStr};
                String message = this.messageService.getMessage("audit.activity.change.mark", args);
                this.logEventService.logEvent(Integer.valueOf(17), monitorUser.getUserID(), learner.getUserId(), lesson.getLessonId(), activity.getActivityId(), message);
            }
        }
    }

    @Override
    public void updateUserLessonGradebookFeedback(Lesson lesson, User learner, String feedback) {
        GradebookUserLesson gradebookUserLesson = this.gradebookDAO.getGradebookUserDataForLesson(lesson.getLessonId(), learner.getUserId());
        if (gradebookUserLesson == null) {
            gradebookUserLesson = new GradebookUserLesson(lesson, learner);
        }
        gradebookUserLesson.setFeedback(feedback);
        this.gradebookDAO.insertOrUpdate((Object)gradebookUserLesson);
    }

    @Override
    public void updateUserActivityGradebookFeedback(Activity activity, User learner, String feedback) {
        GradebookUserActivity gradebookUserActivity = this.gradebookDAO.getGradebookUserDataForActivity(activity.getActivityId(), learner.getUserId());
        if (gradebookUserActivity == null) {
            gradebookUserActivity = new GradebookUserActivity((ToolActivity)activity, learner);
        }
        gradebookUserActivity.setFeedback(feedback);
        gradebookUserActivity.setUpdateDate(new Date());
        this.gradebookDAO.insertOrUpdate((Object)gradebookUserActivity);
    }

    @Override
    public void toggleMarksReleased(Long lessonId) {
        Lesson lesson = this.lessonService.getLesson(lessonId);
        boolean isMarksReleased = lesson.getMarksReleased() != null && lesson.getMarksReleased() != false;
        lesson.setMarksReleased(Boolean.valueOf(!isMarksReleased));
        this.userService.save((Object)lesson);
        UserDTO monitor = (UserDTO)SessionManager.getSession().getAttribute("user");
        String messageKey = isMarksReleased ? "audit.marks.released.off" : "audit.marks.released.on";
        String message = this.messageService.getMessage(messageKey, (Object[])new String[]{lessonId.toString()});
        this.logEventService.logEvent(Integer.valueOf(18), monitor.getUserID(), null, lessonId, null, message);
    }

    @Override
    public List<GBLessonGridRowDTO> getGBLessonRows(Organisation organisation, User user, User viewer, GBGridView view, int page, int size, String sortBy, String sortOrder, String searchString, TimeZone userTimeZone) {
        ArrayList<GBLessonGridRowDTO> lessonRows = new ArrayList<GBLessonGridRowDTO>();
        Integer userId = user.getUserId();
        Integer orgId = organisation.getOrganisationId();
        if (organisation != null) {
            List lessons;
            List list = lessons = view == GBGridView.MON_COURSE || view == GBGridView.LIST ? this.gradebookDAO.getLessonsByGroupAndUser(userId, orgId, page, size, sortBy, sortOrder, searchString) : this.lessonService.getLessonsByGroupAndUser(userId, orgId);
            if (lessons != null) {
                for (Lesson lesson : lessons) {
                    if (view == GBGridView.LRN_COURSE) {
                        boolean marksReleased;
                        boolean bl = marksReleased = lesson.getMarksReleased() != null && lesson.getMarksReleased() != false;
                        boolean hasLearnerPermission = lesson.getAllLearners().contains(user);
                        if (!hasLearnerPermission || !marksReleased) continue;
                    }
                    GBLessonGridRowDTO lessonRow = new GBLessonGridRowDTO();
                    lessonRows.add(lessonRow);
                    lessonRow.setLessonName(lesson.getLessonName());
                    lessonRow.setId(lesson.getLessonId().toString());
                    boolean isWeightedMarks = this.toolService.isWeightedMarks(lesson.getLearningDesign());
                    lessonRow.setDisplayMarkAsPercent(isWeightedMarks);
                    if (view == GBGridView.LIST) continue;
                    if (view == GBGridView.MON_COURSE) {
                        lessonRow.setMedianTimeTaken(this.gradebookDAO.getMedianTimeTakenLesson(lesson.getLessonId()));
                        lessonRow.setAverageMark(this.gradebookDAO.getAverageMarkForLesson(lesson.getLessonId()));
                        String gbMonURL = Configuration.get((String)ConfigurationKeys.SERVER_URL) + "gradebook/gradebookMonitoring.do?lessonID=" + lesson.getLessonId().toString();
                        lessonRow.setGradebookMonitorURL(gbMonURL);
                        Date startDate = lesson.getStartDateTime();
                        if (startDate != null) {
                            if (userTimeZone != null) {
                                startDate = DateUtil.convertToTimeZoneFromDefault((TimeZone)userTimeZone, (Date)startDate);
                            }
                            lessonRow.setStartDate(startDate);
                        }
                    } else if (view == GBGridView.LRN_COURSE || view == GBGridView.MON_USER) {
                        GradebookUserLesson gbLesson = this.gradebookDAO.getGradebookUserDataForLesson(lesson.getLessonId(), userId);
                        lessonRow.setMedianTimeTaken(this.gradebookDAO.getMedianTimeTakenLesson(lesson.getLessonId()));
                        lessonRow.setAverageMark(this.gradebookDAO.getAverageMarkForLesson(lesson.getLessonId()));
                        if (gbLesson != null) {
                            lessonRow.setMark(gbLesson.getMark());
                            lessonRow.setFeedback(gbLesson.getFeedback());
                        }
                        LearnerProgress learnerProgress = this.lessonService.getUserProgressForLesson(userId, lesson.getLessonId());
                        lessonRow.setStatus(this.getLessonStatusStr(learnerProgress));
                        if (learnerProgress != null) {
                            Date startDate = learnerProgress.getStartDate();
                            Date finishDate = learnerProgress.getFinishDate();
                            if (startDate != null && finishDate != null) {
                                lessonRow.setTimeTaken(finishDate.getTime() - startDate.getTime());
                            }
                            if (startDate != null) {
                                if (userTimeZone != null) {
                                    startDate = DateUtil.convertToTimeZoneFromDefault((TimeZone)userTimeZone, (Date)startDate);
                                }
                                lessonRow.setStartDate(startDate);
                            }
                            if (learnerProgress.getFinishDate() != null) {
                                if (userTimeZone != null) {
                                    finishDate = DateUtil.convertToTimeZoneFromDefault((TimeZone)userTimeZone, (Date)finishDate);
                                }
                                lessonRow.setFinishDate(finishDate);
                            }
                        }
                    }
                    if (lesson.getOrganisation().getOrganisationId() != organisation.getOrganisationId()) {
                        lessonRow.setSubGroup(lesson.getOrganisation().getName());
                        continue;
                    }
                    lessonRow.setSubGroup("");
                }
            }
        } else {
            logger.error((Object)"Request for gradebook grid with a null organisation");
        }
        return lessonRows;
    }

    private Map<ToolActivity, List<GBUserGridRowDTO>> getDataForLessonGradebookExport(Lesson lesson) {
        LinkedHashMap<ToolActivity, List<GBUserGridRowDTO>> activityToUserDTOMap = new LinkedHashMap<ToolActivity, List<GBUserGridRowDTO>>();
        TreeSet<User> learners = new TreeSet<User>(new UserComparator());
        if (lesson.getAllLearners() != null) {
            learners.addAll(lesson.getAllLearners());
        }
        Map<Integer, LearnerProgress> userToLearnerProgressMap = this.getUserToLearnerProgressMap(lesson, null);
        List<Activity> activities = this.getLessonActivitiesForLesson(lesson);
        for (Activity activity : activities) {
            this.getActivityDataForLessonGradebookExport(activityToUserDTOMap, learners, userToLearnerProgressMap, activity);
        }
        return activityToUserDTOMap;
    }

    private void getActivityDataForLessonGradebookExport(Map<ToolActivity, List<GBUserGridRowDTO>> activityToUserDTOMap, Set<User> learners, Map<Integer, LearnerProgress> userToLearnerProgressMap, Activity activity) {
        if (activity.isToolActivity()) {
            List<GBUserGridRowDTO> userDTOs = this.getToolActivityDataForLessonGradebookExport(learners, userToLearnerProgressMap, (ToolActivity)activity);
            activityToUserDTOMap.put((ToolActivity)activity, userDTOs);
        } else if (activity instanceof ComplexActivity) {
            Set<User> complexLearners = learners;
            if (activity instanceof SequenceActivity) {
                complexLearners = new TreeSet<User>(new UserComparator());
                for (User learner : learners) {
                    LearnerProgress learnerProgress = userToLearnerProgressMap.get(learner.getUserId());
                    if (learnerProgress == null || learnerProgress.getCompletedActivities().get(activity) == null && learnerProgress.getAttemptedActivities().get(activity) == null) continue;
                    complexLearners.add(learner);
                }
            }
            ComplexActivity sequence = (ComplexActivity)activity;
            Set childActivities = sequence.getActivities();
            for (Activity childActivity : childActivities) {
                this.getActivityDataForLessonGradebookExport(activityToUserDTOMap, complexLearners, userToLearnerProgressMap, this.activityDAO.getActivityByActivityId(childActivity.getActivityId()));
            }
        }
    }

    private List<GBUserGridRowDTO> getToolActivityDataForLessonGradebookExport(Set<User> learners, Map<Integer, LearnerProgress> userToLearnerProgressMap, ToolActivity toolActivity) {
        Map<Integer, GradebookUserActivity> userToGradebookUserActivityMap = this.getUserToGradebookUserActivityMap((Activity)toolActivity, null);
        ArrayList<GBUserGridRowDTO> userDTOs = new ArrayList<GBUserGridRowDTO>();
        for (User learner : learners) {
            GBUserGridRowDTO userDTO = new GBUserGridRowDTO(learner);
            LearnerProgress learnerProgress = userToLearnerProgressMap.get(learner.getUserId());
            userDTO.setTimeTaken(this.getActivityDuration(learnerProgress, (Activity)toolActivity));
            userDTO.setStartDate(this.getActivityStartDate(learnerProgress, (Activity)toolActivity, null));
            userDTO.setFinishDate(this.getActivityFinishDate(learnerProgress, (Activity)toolActivity, null));
            GradebookUserActivity gradebookUserActivity = userToGradebookUserActivityMap.get(learner.getUserId());
            if (gradebookUserActivity != null) {
                userDTO.setMark(gradebookUserActivity.getMark());
            }
            userDTOs.add(userDTO);
        }
        return userDTOs;
    }

    @Override
    public LinkedHashMap<String, ExcelCell[][]> exportLessonGradebook(Lesson lesson) {
        List<GBUserGridRowDTO> userDtos;
        ExcelCell markCell;
        boolean isWeighted = this.toolService.isWeightedMarks(lesson.getLearningDesign());
        LinkedHashMap<String, ExcelCell[][]> dataToExport = new LinkedHashMap<String, ExcelCell[][]>();
        LinkedList<Object> rowList = new LinkedList<Object>();
        Double lessonAverageMarkValue = this.getAverageMarkForLesson(lesson.getLessonId());
        ExcelCell[] lessonAverageMark = new ExcelCell[]{new ExcelCell((Object)this.getMessage("gradebook.export.average.lesson.mark"), Boolean.valueOf(true)), markCell = isWeighted ? GradebookUtil.createPercentageCell(lessonAverageMarkValue, true) : new ExcelCell((Object)lessonAverageMarkValue, Boolean.valueOf(false))};
        ExcelCell[] lessonMedianTimeTaken = new ExcelCell[]{new ExcelCell((Object)this.getMessage("gradebook.export.average.lesson.time.taken"), Boolean.valueOf(true)), new ExcelCell((Object)(this.gradebookDAO.getMedianTimeTakenLesson(lesson.getLessonId()) / 1000L), Boolean.valueOf(false))};
        rowList.add(lessonMedianTimeTaken);
        rowList.add(EMPTY_ROW);
        List<GradebookGridRowDTO> activityRows = this.getGBActivityRowsForLesson(lesson.getLessonId(), null, false);
        ExcelCell[] activityAverageTitle = new ExcelCell[]{new ExcelCell((Object)this.getMessage("gradebook.export.activities"), Boolean.valueOf(true))};
        rowList.add(activityAverageTitle);
        ExcelCell[] activityAverageRow = new ExcelCell[]{new ExcelCell((Object)this.getMessage("gradebook.export.activity"), Boolean.valueOf(true)), new ExcelCell((Object)this.getMessage("gradebook.columntitle.competences"), Boolean.valueOf(true)), new ExcelCell((Object)this.getMessage("gradebook.export.average.time.taken.seconds"), Boolean.valueOf(true)), new ExcelCell((Object)this.getMessage("gradebook.columntitle.averageMark"), Boolean.valueOf(true)), new ExcelCell((Object)this.getMessage("gradebook.export.min.time.taken.seconds"), Boolean.valueOf(true)), new ExcelCell((Object)this.getMessage("gradebook.export.max.time.taken.seconds"), Boolean.valueOf(true))};
        rowList.add(activityAverageRow);
        for (GBActivityGridRowDTO gBActivityGridRowDTO : activityRows) {
            ExcelCell[] activityDataRow = new ExcelCell[]{new ExcelCell((Object)gBActivityGridRowDTO.getRowName(), Boolean.valueOf(false)), new ExcelCell((Object)gBActivityGridRowDTO.getCompetences(), Boolean.valueOf(false)), new ExcelCell((Object)gBActivityGridRowDTO.getMedianTimeTakenSeconds(), Boolean.valueOf(false)), new ExcelCell((Object)gBActivityGridRowDTO.getAverageMark(), Boolean.valueOf(false)), new ExcelCell((Object)gBActivityGridRowDTO.getMinTimeTakenSeconds(), Boolean.valueOf(false)), new ExcelCell((Object)gBActivityGridRowDTO.getMaxTimeTakenSeconds(), Boolean.valueOf(false))};
            rowList.add(activityDataRow);
        }
        rowList.add(EMPTY_ROW);
        ExcelCell[] excelCellArray = new ExcelCell[]{new ExcelCell((Object)this.getMessage("gradebook.export.total.marks.for.lesson"), Boolean.valueOf(true))};
        rowList.add(excelCellArray);
        List userRows = this.getGBUserRowsForLesson(lesson, null);
        ExcelCell[] userTitleRow = new ExcelCell[]{new ExcelCell((Object)this.getMessage("gradebook.export.last.name"), Boolean.valueOf(true)), new ExcelCell((Object)this.getMessage("gradebook.export.first.name"), Boolean.valueOf(true)), new ExcelCell((Object)this.getMessage("gradebook.export.login"), Boolean.valueOf(true)), new ExcelCell((Object)this.getMessage("gradebook.exportcourse.progress"), Boolean.valueOf(true)), new ExcelCell((Object)this.getMessage("gradebook.export.time.taken.seconds"), Boolean.valueOf(true)), new ExcelCell((Object)this.getMessage("gradebook.export.total.mark"), Boolean.valueOf(true))};
        rowList.add(userTitleRow);
        for (GBUserGridRowDTO userRow : userRows) {
            ExcelCell[] userDataRow = new ExcelCell[]{new ExcelCell((Object)userRow.getLastName(), Boolean.valueOf(false)), new ExcelCell((Object)userRow.getFirstName(), Boolean.valueOf(false)), new ExcelCell((Object)userRow.getLogin(), Boolean.valueOf(false)), new ExcelCell((Object)this.getProgressMessage(userRow), Boolean.valueOf(false)), new ExcelCell((Object)userRow.getTimeTakenSeconds(), Boolean.valueOf(false)), isWeighted ? GradebookUtil.createPercentageCell(userRow.getMark(), true) : new ExcelCell((Object)userRow.getMark(), Boolean.valueOf(false))};
            rowList.add(userDataRow);
        }
        rowList.add(EMPTY_ROW);
        Map<ToolActivity, List<GBUserGridRowDTO>> activityToUserDTOMap = this.getDataForLessonGradebookExport(lesson);
        LinkedHashMap<ToolActivity, List<GBUserGridRowDTO>> filteredActivityToUserDTOMap = new LinkedHashMap<ToolActivity, List<GBUserGridRowDTO>>();
        for (ToolActivity activity : activityToUserDTOMap.keySet()) {
            Iterator<Object> toolSignature = activity.getTool().getToolSignature();
            if (activity.getEvaluation() == null || !TOOL_SIGNATURE_ASSESSMENT.equals(toolSignature) && !TOOL_SIGNATURE_MCQ.equals(toolSignature) && !TOOL_SIGNATURE_SCRATCHIE.equals(toolSignature)) continue;
            filteredActivityToUserDTOMap.put(activity, activityToUserDTOMap.get(activity));
        }
        ExcelCell[] headerRow = new ExcelCell[]{new ExcelCell((Object)this.getMessage("gradebook.summary.activity.marks"), Boolean.valueOf(true))};
        rowList.add(headerRow);
        headerRow = new ExcelCell[3 + filteredActivityToUserDTOMap.keySet().size()];
        int count = 3;
        for (Activity activity : filteredActivityToUserDTOMap.keySet()) {
            headerRow[count++] = new ExcelCell((Object)activity.getTitle(), Boolean.valueOf(true));
        }
        rowList.add(headerRow);
        headerRow = new ExcelCell[4 + filteredActivityToUserDTOMap.keySet().size()];
        count = 0;
        headerRow[count++] = new ExcelCell((Object)this.getMessage("gradebook.export.last.name"), Boolean.valueOf(true));
        headerRow[count++] = new ExcelCell((Object)this.getMessage("gradebook.export.first.name"), Boolean.valueOf(true));
        headerRow[count++] = new ExcelCell((Object)this.getMessage("gradebook.export.login"), Boolean.valueOf(true));
        for (Activity activity : filteredActivityToUserDTOMap.keySet()) {
            headerRow[count++] = new ExcelCell((Object)this.getMessage("gradebook.columntitle.mark"), Boolean.valueOf(true));
        }
        headerRow[count] = new ExcelCell((Object)this.getMessage("gradebook.export.total.mark"), Boolean.valueOf(true));
        rowList.add(headerRow);
        for (GBUserGridRowDTO userRow : userRows) {
            ExcelCell[] userDataRow = new ExcelCell[4 + filteredActivityToUserDTOMap.keySet().size()];
            count = 0;
            userDataRow[count++] = new ExcelCell((Object)userRow.getLastName(), Boolean.valueOf(false));
            userDataRow[count++] = new ExcelCell((Object)userRow.getFirstName(), Boolean.valueOf(false));
            userDataRow[count++] = new ExcelCell((Object)userRow.getLogin(), Boolean.valueOf(false));
            for (Activity activity : filteredActivityToUserDTOMap.keySet()) {
                Double userActivityMark = null;
                userDtos = (List<GBUserGridRowDTO>)filteredActivityToUserDTOMap.get(activity);
                for (GBUserGridRowDTO userDto : userDtos) {
                    if (!userDto.getLogin().equals(userRow.getLogin())) continue;
                    userActivityMark = userDto.getMark();
                    break;
                }
                userDataRow[count++] = new ExcelCell(userActivityMark, Boolean.valueOf(false));
            }
            userDataRow[count] = isWeighted ? GradebookUtil.createPercentageCell(userRow.getMark(), true) : new ExcelCell((Object)userRow.getMark(), Boolean.valueOf(false));
            rowList.add(userDataRow);
        }
        ExcelCell[][] summaryData = (ExcelCell[][])rowList.toArray((T[])new ExcelCell[0][]);
        dataToExport.put(this.getMessage("gradebook.export.lesson.summary"), summaryData);
        LinkedList<Object> rowList1 = new LinkedList<Object>();
        for (Activity activity : activityToUserDTOMap.keySet()) {
            ExcelCell[] activityTitleRow = new ExcelCell[7];
            activityTitleRow[0] = new ExcelCell((Object)activity.getTitle(), Boolean.valueOf(true));
            rowList1.add(activityTitleRow);
            count = 0;
            ExcelCell[] titleRow = new ExcelCell[7];
            titleRow[count++] = new ExcelCell((Object)this.getMessage("gradebook.export.last.name"), Boolean.valueOf(true));
            titleRow[count++] = new ExcelCell((Object)this.getMessage("gradebook.export.first.name"), Boolean.valueOf(true));
            titleRow[count++] = new ExcelCell((Object)this.getMessage("gradebook.export.login"), Boolean.valueOf(true));
            titleRow[count++] = new ExcelCell((Object)this.getMessage("gradebook.columntitle.startDate"), Boolean.valueOf(true));
            titleRow[count++] = new ExcelCell((Object)this.getMessage("gradebook.columntitle.completeDate"), Boolean.valueOf(true));
            titleRow[count++] = new ExcelCell((Object)this.getMessage("gradebook.export.time.taken.seconds"), Boolean.valueOf(true));
            titleRow[count++] = new ExcelCell((Object)this.getMessage("gradebook.columntitle.mark"), Boolean.valueOf(true));
            rowList1.add(titleRow);
            userDtos = activityToUserDTOMap.get(activity);
            for (GBUserGridRowDTO userDto : userDtos) {
                String startDate = userDto.getStartDate() == null ? "" : FileUtil.EXPORT_TO_SPREADSHEET_TITLE_DATE_FORMAT.format(userDto.getStartDate());
                String finishDate = userDto.getFinishDate() == null ? "" : FileUtil.EXPORT_TO_SPREADSHEET_TITLE_DATE_FORMAT.format(userDto.getFinishDate());
                count = 0;
                ExcelCell[] userDataRow = new ExcelCell[7];
                userDataRow[count++] = new ExcelCell((Object)userDto.getLastName(), Boolean.valueOf(false));
                userDataRow[count++] = new ExcelCell((Object)userDto.getFirstName(), Boolean.valueOf(false));
                userDataRow[count++] = new ExcelCell((Object)userDto.getLogin(), Boolean.valueOf(false));
                userDataRow[count++] = new ExcelCell((Object)startDate, Boolean.valueOf(false));
                userDataRow[count++] = new ExcelCell((Object)finishDate, Boolean.valueOf(false));
                userDataRow[count++] = new ExcelCell((Object)userDto.getTimeTakenSeconds(), Boolean.valueOf(false));
                userDataRow[count++] = new ExcelCell((Object)userDto.getMark(), Boolean.valueOf(false));
                rowList1.add(userDataRow);
            }
            rowList1.add(EMPTY_ROW);
        }
        ExcelCell[][] activityData = (ExcelCell[][])rowList1.toArray((T[])new ExcelCell[0][]);
        dataToExport.put(this.getMessage("gradebook.gridtitle.activitygrid"), activityData);
        TreeSet<User> treeSet = new TreeSet<User>(new UserComparator());
        if (lesson.getAllLearners() != null) {
            treeSet.addAll(lesson.getAllLearners());
        }
        rowList = new LinkedList();
        for (User learner : treeSet) {
            userTitleRow = new ExcelCell[4];
            userTitleRow[0] = new ExcelCell((Object)(learner.getFullName() + " (" + learner.getLogin() + ")"), Boolean.valueOf(true));
            rowList.add(userTitleRow);
            ExcelCell[] titleRow = new ExcelCell[]{new ExcelCell((Object)this.getMessage("gradebook.export.activity"), Boolean.valueOf(true)), new ExcelCell((Object)this.getMessage("gradebook.columntitle.startDate"), Boolean.valueOf(true)), new ExcelCell((Object)this.getMessage("gradebook.columntitle.completeDate"), Boolean.valueOf(true)), new ExcelCell((Object)this.getMessage("gradebook.export.time.taken.seconds"), Boolean.valueOf(true)), new ExcelCell((Object)this.getMessage("gradebook.columntitle.mark"), Boolean.valueOf(true))};
            rowList.add(titleRow);
            for (ToolActivity activity : activityToUserDTOMap.keySet()) {
                Group group;
                List<GBUserGridRowDTO> userDtos2 = activityToUserDTOMap.get(activity);
                GBUserGridRowDTO userDto = null;
                for (GBUserGridRowDTO dbUserDTO : userDtos2) {
                    if (!dbUserDTO.getId().equals(learner.getUserId().toString())) continue;
                    userDto = dbUserDTO;
                }
                if (userDto == null) continue;
                String groupName = null;
                Long groupId = null;
                if (activity.getGrouping() != null && (group = activity.getGroupFor(learner)) != null) {
                    groupName = group.getGroupName();
                    groupId = group.getGroupId();
                }
                String activityRowName = groupName != null && groupId != null ? activity.getTitle() + " (" + groupName + ")" : activity.getTitle();
                String startDate = userDto.getStartDate() == null ? "" : FileUtil.EXPORT_TO_SPREADSHEET_TITLE_DATE_FORMAT.format(userDto.getStartDate());
                String finishDate = userDto.getFinishDate() == null ? "" : FileUtil.EXPORT_TO_SPREADSHEET_TITLE_DATE_FORMAT.format(userDto.getFinishDate());
                ExcelCell[] activityDataRow = new ExcelCell[]{new ExcelCell((Object)activityRowName, Boolean.valueOf(false)), new ExcelCell((Object)startDate, Boolean.valueOf(false)), new ExcelCell((Object)finishDate, Boolean.valueOf(false)), new ExcelCell((Object)userDto.getTimeTakenSeconds(), Boolean.valueOf(false)), new ExcelCell((Object)userDto.getMark(), Boolean.valueOf(false))};
                rowList.add(activityDataRow);
            }
            rowList.add(EMPTY_ROW);
        }
        ExcelCell[][] userData = (ExcelCell[][])rowList.toArray((T[])new ExcelCell[0][]);
        dataToExport.put(this.getMessage("gradebook.export.learner.view"), userData);
        return dataToExport;
    }

    @Override
    public LinkedHashMap<String, ExcelCell[][]> exportCourseGradebook(Integer userId, Integer organisationId) {
        LinkedHashMap<String, ExcelCell[][]> dataToExport = new LinkedHashMap<String, ExcelCell[][]>();
        LinkedList<ExcelCell[]> rowList = new LinkedList<ExcelCell[]>();
        TreeSet<Lesson> lessons = new TreeSet<Lesson>(new LessonComparator());
        lessons.addAll(this.lessonService.getLessonsByGroupAndUser(userId, organisationId));
        HashMap<Long, Boolean> isWeightedLessonMap = new HashMap<Long, Boolean>();
        if (lessons != null && lessons.size() > 0) {
            int numberOfCellsInARow = 3 + lessons.size() * 6;
            ExcelCell[] lessonsNames = new ExcelCell[numberOfCellsInARow];
            int i = 0;
            lessonsNames[i++] = new ExcelCell((Object)"", Boolean.valueOf(false));
            lessonsNames[i++] = new ExcelCell((Object)"", Boolean.valueOf(false));
            lessonsNames[i++] = new ExcelCell((Object)"", Boolean.valueOf(false));
            for (Lesson lesson : lessons) {
                lessonsNames[i++] = new ExcelCell((Object)this.messageService.getMessage("gradebook.exportcourse.lesson", new Object[]{lesson.getLessonName()}), Boolean.valueOf(true));
                lessonsNames[i++] = new ExcelCell((Object)"", Boolean.valueOf(false));
                lessonsNames[i++] = new ExcelCell((Object)"", Boolean.valueOf(false));
                lessonsNames[i++] = new ExcelCell((Object)"", Boolean.valueOf(false));
                lessonsNames[i++] = new ExcelCell((Object)"", Boolean.valueOf(false));
                lessonsNames[i++] = new ExcelCell((Object)"", Boolean.valueOf(false));
            }
            rowList.add(lessonsNames);
            ExcelCell[] headerRow = new ExcelCell[numberOfCellsInARow];
            i = 0;
            headerRow[i++] = new ExcelCell((Object)this.getMessage("gradebook.export.last.name"), Boolean.valueOf(true));
            headerRow[i++] = new ExcelCell((Object)this.getMessage("gradebook.export.first.name"), Boolean.valueOf(true));
            headerRow[i++] = new ExcelCell((Object)this.getMessage("gradebook.export.login"), Boolean.valueOf(true));
            for (Lesson lesson : lessons) {
                headerRow[i++] = new ExcelCell((Object)this.getMessage("gradebook.exportcourse.progress"), Boolean.valueOf(true));
                headerRow[i++] = new ExcelCell((Object)this.getMessage("gradebook.columntitle.startDate"), Boolean.valueOf(false));
                headerRow[i++] = new ExcelCell((Object)this.getMessage("gradebook.columntitle.completeDate"), Boolean.valueOf(false));
                headerRow[i++] = new ExcelCell((Object)this.getMessage("gradebook.export.time.taken.seconds"), Boolean.valueOf(true));
                headerRow[i++] = new ExcelCell((Object)this.getMessage("gradebook.exportcourse.lessonFeedback"), Boolean.valueOf(true));
                headerRow[i++] = new ExcelCell((Object)this.getMessage("gradebook.export.total.mark"), Boolean.valueOf(true));
            }
            rowList.add(headerRow);
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            LinkedList<Long> lessonIds = new LinkedList<Long>();
            for (Lesson lesson : lessons) {
                Set dbLessonUsers = lesson.getAllLearners();
                linkedHashSet.addAll(dbLessonUsers);
                lessonIds.add(lesson.getLessonId());
                boolean isWeightedMarks = this.toolService.isWeightedMarks(lesson.getLearningDesign());
                isWeightedLessonMap.put(lesson.getLessonId(), isWeightedMarks);
            }
            List learnerProgresses = new LinkedList();
            List gradebookUserLessons = new LinkedList();
            if (!linkedHashSet.isEmpty()) {
                learnerProgresses = this.learnerProgressDAO.getLearnerProgressForLessons(lessonIds);
                gradebookUserLessons = this.gradebookDAO.getGradebookUserLessons(lessonIds);
            }
            TreeSet<User> sortedLearners = new TreeSet<User>(new UserComparator());
            sortedLearners.addAll(linkedHashSet);
            for (User learner : sortedLearners) {
                i = 0;
                ExcelCell[] userDataRow = new ExcelCell[numberOfCellsInARow];
                userDataRow[i++] = new ExcelCell((Object)learner.getLastName(), Boolean.valueOf(false));
                userDataRow[i++] = new ExcelCell((Object)learner.getFirstName(), Boolean.valueOf(false));
                userDataRow[i++] = new ExcelCell((Object)learner.getLogin(), Boolean.valueOf(false));
                for (Lesson lesson : lessons) {
                    GBUserGridRowDTO userDto = new GBUserGridRowDTO(learner);
                    String startDate = "";
                    String finishDate = "";
                    Long timeTakenSeconds = null;
                    Double mark = null;
                    String feedback = "";
                    if (lesson.getAllLearners().contains(learner)) {
                        LearnerProgress learnerProgress = null;
                        for (LearnerProgress learnerProgressIter : learnerProgresses) {
                            if (!learnerProgressIter.getUser().getUserId().equals(learner.getUserId()) || !learnerProgressIter.getLesson().getLessonId().equals(lesson.getLessonId())) continue;
                            learnerProgress = learnerProgressIter;
                        }
                        userDto.setStatus(this.getLessonStatusStr(learnerProgress));
                        if (learnerProgress != null && learnerProgress.getCurrentActivity() != null) {
                            userDto.setCurrentActivity(learnerProgress.getCurrentActivity().getTitle());
                        }
                        if (learnerProgress != null && learnerProgress.getStartDate() != null) {
                            startDate = FileUtil.EXPORT_TO_SPREADSHEET_TITLE_DATE_FORMAT.format(learnerProgress.getStartDate());
                        }
                        if (learnerProgress != null && learnerProgress.getFinishDate() != null) {
                            finishDate = FileUtil.EXPORT_TO_SPREADSHEET_TITLE_DATE_FORMAT.format(learnerProgress.getFinishDate());
                        }
                        if (learnerProgress != null && learnerProgress.getStartDate() != null && learnerProgress.getFinishDate() != null) {
                            timeTakenSeconds = learnerProgress.getFinishDate().getTime() - learnerProgress.getStartDate().getTime();
                        }
                        GradebookUserLesson gradebookUserLesson = null;
                        for (GradebookUserLesson gradebookUserLessonIter : gradebookUserLessons) {
                            if (!gradebookUserLessonIter.getLearner().getUserId().equals(learner.getUserId()) || !gradebookUserLessonIter.getLesson().getLessonId().equals(lesson.getLessonId())) continue;
                            gradebookUserLesson = gradebookUserLessonIter;
                        }
                        if (gradebookUserLesson != null) {
                            mark = gradebookUserLesson.getMark();
                            feedback = gradebookUserLesson.getFeedback();
                        }
                    } else {
                        userDto.setStatus("n/a");
                    }
                    userDataRow[i++] = new ExcelCell((Object)this.getProgressMessage(userDto), Boolean.valueOf(false));
                    userDataRow[i++] = new ExcelCell((Object)startDate, Boolean.valueOf(false));
                    userDataRow[i++] = new ExcelCell((Object)finishDate, Boolean.valueOf(false));
                    userDataRow[i++] = new ExcelCell((Object)timeTakenSeconds, Boolean.valueOf(false));
                    userDataRow[i++] = new ExcelCell((Object)feedback, Boolean.valueOf(false));
                    userDataRow[i++] = (Boolean)isWeightedLessonMap.get(lesson.getLessonId()) != false ? GradebookUtil.createPercentageCell(mark, true) : new ExcelCell((Object)mark, Boolean.valueOf(false));
                }
                rowList.add(userDataRow);
            }
        }
        ExcelCell[][] summaryData = (ExcelCell[][])rowList.toArray((T[])new ExcelCell[0][]);
        dataToExport.put(this.getMessage("gradebook.exportcourse.course.summary"), summaryData);
        return dataToExport;
    }

    @Override
    public LinkedHashMap<String, ExcelCell[][]> exportSelectedLessonsGradebook(Integer userId, Integer organisationId, String[] lessonIds, boolean simplified) {
        LinkedHashMap<String, ExcelCell[][]> dataToExport = new LinkedHashMap<String, ExcelCell[][]>();
        Organisation organisation = (Organisation)this.userService.findById(Organisation.class, (Serializable)organisationId);
        LinkedList<ExcelCell[]> rowList = new LinkedList<ExcelCell[]>();
        User user = (User)this.userService.findById(User.class, (Serializable)userId);
        TreeSet<Lesson> selectedLessons = new TreeSet<Lesson>(new LessonComparator());
        HashMap<Long, Boolean> isWeightedLessonMap = new HashMap<Long, Boolean>();
        Integer organisationToCheckPermission = organisation.getOrganisationType().getOrganisationTypeId().equals(OrganisationType.COURSE_TYPE) ? organisation.getOrganisationId() : organisation.getParentOrganisation().getOrganisationId();
        boolean isGroupManager = this.userService.isUserInRole(userId, organisationToCheckPermission, "GROUP MANAGER");
        LinkedHashSet allLearners = new LinkedHashSet();
        HashMap<Long, List<ToolActivity>> lessonActivitiesMap = new HashMap<Long, List<ToolActivity>>();
        ArrayList<ToolActivity> allActivities = new ArrayList<ToolActivity>();
        for (String lessonIdStr : lessonIds) {
            Long l = Long.parseLong(lessonIdStr);
            Lesson lesson = this.lessonService.getLesson(l);
            if (!lesson.getLessonClass().isStaffMember(user) && !isGroupManager) continue;
            selectedLessons.add(lesson);
            boolean isWeightedMarks = this.toolService.isWeightedMarks(lesson.getLearningDesign());
            isWeightedLessonMap.put(lesson.getLessonId(), isWeightedMarks);
            allLearners.addAll(lesson.getAllLearners());
            List<ToolActivity> lessonActivities = this.getLessonToolActivitiesForLesson(lesson);
            lessonActivitiesMap.put(lesson.getLessonId(), lessonActivities);
            allActivities.addAll(lessonActivities);
        }
        if (!selectedLessons.isEmpty()) {
            int i;
            LinkedList<Long> lessonIdLongs = new LinkedList<Long>();
            for (String string : lessonIds) {
                lessonIdLongs.add(Long.valueOf(string));
            }
            List learnerProgresses = new LinkedList();
            if (!allLearners.isEmpty()) {
                learnerProgresses = this.learnerProgressDAO.getLearnerProgressForLessons(lessonIdLongs);
            }
            Map<Long, Long> activityToTotalMarkMap = this.getActivityToTotalMarkMap(allActivities);
            HashMap<Long, Map<Integer, GradebookUserActivity>> activityTouserToGradebookUserActivityMap = new HashMap<Long, Map<Integer, GradebookUserActivity>>();
            for (ToolActivity activity : allActivities) {
                Map<Integer, GradebookUserActivity> userToGradebookUserActivityMap = this.getUserToGradebookUserActivityMap((Activity)activity, null);
                activityTouserToGradebookUserActivityMap.put(activity.getActivityId(), userToGradebookUserActivityMap);
            }
            int n = simplified ? 3 + selectedLessons.size() + 3 : selectedLessons.size() * 9 + allActivities.size() * 2 + 5;
            String weightedMessage = this.messageService.getMessage("label.activity.marks.weighted");
            ExcelCell[] lessonsNames = new ExcelCell[n];
            if (simplified) {
                i = 3;
                for (Lesson lesson : selectedLessons) {
                    lessonsNames[i++] = new ExcelCell((Object)lesson.getLessonName(), Boolean.valueOf(true)).setAlignment(3);
                }
                lessonsNames[i++] = new ExcelCell((Object)"", 4);
                lessonsNames[i++] = new ExcelCell((Object)this.getMessage("label.overall.totals"), Boolean.valueOf(true)).setAlignment(3);
                lessonsNames[i++] = new ExcelCell((Object)"", 2);
            } else {
                i = 4;
                for (Lesson lesson : selectedLessons) {
                    List lessonActivities = (List)lessonActivitiesMap.get(lesson.getLessonId());
                    int numberActivities = lessonActivities.size();
                    String lessonName = (Boolean)isWeightedLessonMap.get(lesson.getLessonId()) != false ? lesson.getLessonName() + " " + weightedMessage : lesson.getLessonName();
                    lessonsNames[i + numberActivities] = new ExcelCell((Object)lessonName, Boolean.valueOf(true));
                    i += 9 + numberActivities * 2;
                }
                i -= 2;
                lessonsNames[i++] = new ExcelCell((Object)"", 1);
                lessonsNames[i++] = new ExcelCell((Object)this.getMessage("label.overall.totals"), Boolean.valueOf(true));
                lessonsNames[i++] = new ExcelCell((Object)"", 2);
            }
            rowList.add(lessonsNames);
            if (simplified) {
                rowList.add(this.createSelectedLessonsHeaderSimplified(selectedLessons, n));
            } else {
                rowList.add(this.createSelectedLessonsHeaderFull(selectedLessons, lessonActivitiesMap, n));
            }
            for (User learner : allLearners) {
                Double overallTotal = 0.0;
                Double overallMaxMark = 0.0;
                ExcelCell[] userRow = new ExcelCell[n];
                int i2 = 0;
                if (simplified) {
                    i2 = this.addUsernameCells(learner, userRow, i2);
                }
                for (Lesson lesson : selectedLessons) {
                    Double lessonTotal = 0.0;
                    Double lessonMaxMark = 0.0;
                    List activities = (List)lessonActivitiesMap.get(lesson.getLessonId());
                    Boolean weighted = (Boolean)isWeightedLessonMap.get(lesson.getLessonId());
                    if (!simplified) {
                        Object group22;
                        i2 = this.addUsernameCells(learner, userRow, i2);
                        if (!lesson.getAllLearners().contains(learner)) {
                            i2 += 3 + activities.size() * 2;
                            userRow[i2++] = new ExcelCell((Object)"", 1);
                            userRow[i2++] = new ExcelCell((Object)"", Boolean.valueOf(false));
                            userRow[i2++] = new ExcelCell((Object)"", 2);
                            continue;
                        }
                        Object groupName = "";
                        for (Object group22 : lesson.getLessonClass().getGroups()) {
                            if (!group22.hasLearner(learner)) continue;
                            groupName = group22.getGroupName();
                            break;
                        }
                        userRow[i2++] = new ExcelCell(groupName, Boolean.valueOf(false));
                        LearnerProgress learnerProgress = null;
                        group22 = learnerProgresses.iterator();
                        while (group22.hasNext()) {
                            LearnerProgress learnerProgressIter = (LearnerProgress)group22.next();
                            if (!learnerProgressIter.getUser().getUserId().equals(learner.getUserId()) || !learnerProgressIter.getLesson().getLessonId().equals(lesson.getLessonId())) continue;
                            learnerProgress = learnerProgressIter;
                        }
                        String startDate = learnerProgress == null || learnerProgress.getStartDate() == null ? "" : FileUtil.EXPORT_TO_SPREADSHEET_TITLE_DATE_FORMAT.format(learnerProgress.getStartDate());
                        userRow[i2++] = new ExcelCell((Object)startDate, Boolean.valueOf(false));
                        String finishDate = learnerProgress == null || learnerProgress.getFinishDate() == null ? "" : FileUtil.EXPORT_TO_SPREADSHEET_TITLE_DATE_FORMAT.format(learnerProgress.getFinishDate());
                        userRow[i2++] = new ExcelCell((Object)finishDate, Boolean.valueOf(false));
                    }
                    for (ToolActivity activity : activities) {
                        Map userToGradebookUserActivityMap = (Map)activityTouserToGradebookUserActivityMap.get(activity.getActivityId());
                        GradebookUserActivity gradebookUserActivity = (GradebookUserActivity)userToGradebookUserActivityMap.get(learner.getUserId());
                        Long rawActivityTotalMarks = 0L;
                        if (activityToTotalMarkMap.get(activity.getActivityId()) != null) {
                            rawActivityTotalMarks = activityToTotalMarkMap.get(activity.getActivityId());
                        }
                        Integer weight = weighted != false && activity.getEvaluation() != null && activity.getEvaluation().getWeight() != null ? activity.getEvaluation().getWeight() : null;
                        Long weightedActivityTotalMarks = weight != null ? (long)weight.intValue() : rawActivityTotalMarks;
                        Double mark = 0.0;
                        if (gradebookUserActivity != null) {
                            mark = gradebookUserActivity.getMark();
                            if (weight != null) {
                                mark = this.doWeightedMarkCalc(mark, activity, weight, rawActivityTotalMarks);
                            }
                            if (!simplified) {
                                userRow[i2++] = new ExcelCell((Object)mark, Boolean.valueOf(false));
                            }
                        } else if (!simplified) {
                            userRow[i2++] = new ExcelCell((Object)"", Boolean.valueOf(false));
                        }
                        if (!simplified) {
                            userRow[i2++] = weightedActivityTotalMarks > 0L ? new ExcelCell((Object)weightedActivityTotalMarks, Boolean.valueOf(false)) : new ExcelCell((Object)"", Boolean.valueOf(false));
                        }
                        lessonTotal = lessonTotal + mark;
                        overallTotal = overallTotal + mark;
                        lessonMaxMark = lessonMaxMark + (double)weightedActivityTotalMarks.longValue();
                        overallMaxMark = overallMaxMark + (double)weightedActivityTotalMarks.longValue();
                    }
                    if (simplified) {
                        if (weighted.booleanValue()) {
                            userRow[i2++] = GradebookUtil.createPercentageCell(lessonTotal, true, false, 1);
                            continue;
                        }
                        userRow[i2++] = new ExcelCell((Object)lessonTotal, 1);
                        continue;
                    }
                    userRow[i2++] = new ExcelCell((Object)lessonTotal, 1);
                    userRow[i2++] = new ExcelCell((Object)lessonMaxMark, Boolean.valueOf(false));
                    Double percentage = lessonMaxMark != 0.0 ? lessonTotal / lessonMaxMark : 0.0;
                    userRow[i2++] = GradebookUtil.createPercentageCell(percentage, false, false, 2);
                }
                Double percentage = overallMaxMark != 0.0 ? overallTotal / overallMaxMark : 0.0;
                if (simplified) {
                    userRow[i2++] = new ExcelCell((Object)overallTotal, 4);
                    userRow[i2++] = new ExcelCell((Object)overallMaxMark, Boolean.valueOf(false));
                    userRow[i2++] = GradebookUtil.createPercentageCell(percentage, false, false, 2);
                } else {
                    i2 += 2;
                    userRow[i2++] = new ExcelCell((Object)overallTotal, 1);
                    userRow[i2++] = new ExcelCell((Object)overallMaxMark, Boolean.valueOf(false));
                    userRow[i2++] = GradebookUtil.createPercentageCell(percentage, false, true, 2);
                }
                rowList.add(userRow);
            }
        }
        ExcelCell[][] summaryData = (ExcelCell[][])rowList.toArray((T[])new ExcelCell[0][]);
        dataToExport.put(this.getMessage("gradebook.exportcourse.course.summary"), summaryData);
        return dataToExport;
    }

    private int addUsernameCells(User learner, ExcelCell[] userRow, int i) {
        String lastName = learner.getLastName() == null ? "" : learner.getLastName().toUpperCase();
        userRow[i++] = new ExcelCell((Object)lastName, Boolean.valueOf(false));
        String firstName = learner.getFirstName() == null ? "" : learner.getFirstName().toUpperCase();
        userRow[i++] = new ExcelCell((Object)firstName, Boolean.valueOf(false));
        userRow[i++] = new ExcelCell((Object)learner.getLogin(), Boolean.valueOf(false));
        return i;
    }

    private ExcelCell[] createSelectedLessonsHeaderFull(Set<Lesson> selectedLessons, Map<Long, List<ToolActivity>> lessonActivitiesMap, int numberCellsPerRow) {
        ExcelCell[] headerRow = new ExcelCell[numberCellsPerRow];
        int i = 0;
        for (Lesson lesson : selectedLessons) {
            headerRow[i++] = new ExcelCell((Object)this.getMessage("gradebook.export.last.name"), Boolean.valueOf(false));
            headerRow[i++] = new ExcelCell((Object)this.getMessage("gradebook.export.first.name"), Boolean.valueOf(false));
            headerRow[i++] = new ExcelCell((Object)this.getMessage("gradebook.export.login"), Boolean.valueOf(false));
            headerRow[i++] = new ExcelCell((Object)this.getMessage("label.group"), Boolean.valueOf(false));
            headerRow[i++] = new ExcelCell((Object)this.getMessage("gradebook.columntitle.startDate"), Boolean.valueOf(false));
            headerRow[i++] = new ExcelCell((Object)this.getMessage("gradebook.columntitle.completeDate"), Boolean.valueOf(false));
            List<ToolActivity> activities = lessonActivitiesMap.get(lesson.getLessonId());
            for (Activity activity : activities) {
                headerRow[i++] = new ExcelCell((Object)activity.getTitle(), Boolean.valueOf(true));
                headerRow[i++] = new ExcelCell((Object)this.getMessage("label.max.possible"), Boolean.valueOf(false));
            }
            headerRow[i++] = new ExcelCell((Object)this.getMessage("label.total.actuals"), Boolean.valueOf(true), 1);
            headerRow[i++] = new ExcelCell((Object)this.getMessage("label.max.mark"), Boolean.valueOf(false));
            headerRow[i++] = new ExcelCell((Object)"%", 2);
        }
        i += 2;
        headerRow[i++] = new ExcelCell((Object)this.getMessage("label.actuals"), Boolean.valueOf(true), 1);
        headerRow[i++] = new ExcelCell((Object)this.getMessage("label.max"), Boolean.valueOf(true));
        headerRow[i++] = new ExcelCell((Object)"%", Boolean.valueOf(true), 2);
        return headerRow;
    }

    private ExcelCell[] createSelectedLessonsHeaderSimplified(Set<Lesson> selectedLessons, int numberCellsPerRow) {
        int i = 0;
        ExcelCell[] headerRow = new ExcelCell[numberCellsPerRow];
        headerRow[i++] = new ExcelCell((Object)this.getMessage("gradebook.export.last.name"), Boolean.valueOf(false));
        headerRow[i++] = new ExcelCell((Object)this.getMessage("gradebook.export.first.name"), Boolean.valueOf(false));
        headerRow[i++] = new ExcelCell((Object)this.getMessage("gradebook.export.login"), Boolean.valueOf(false));
        for (Lesson lesson : selectedLessons) {
            headerRow[i++] = new ExcelCell((Object)this.getMessage("label.total.actuals"), Boolean.valueOf(false), 1).setAlignment(3);
        }
        headerRow[i++] = new ExcelCell((Object)this.getMessage("label.actuals"), Boolean.valueOf(true), 4).setAlignment(3);
        headerRow[i++] = new ExcelCell((Object)this.getMessage("label.max"), Boolean.valueOf(false)).setAlignment(3);
        headerRow[i++] = new ExcelCell((Object)"%", Boolean.valueOf(false), 2).setAlignment(3);
        return headerRow;
    }

    @Override
    public void updateActivityMark(Double mark, String feedback, Integer userID, Long toolSessionID, Boolean markedInGradebook) {
        ToolActivity activity;
        GradebookUserActivity gradebookUserActivity;
        ToolSession toolSession = this.toolService.getToolSessionById(toolSessionID);
        User learner = (User)this.userService.findById(User.class, (Serializable)userID);
        if (learner != null && toolSession != null && ((gradebookUserActivity = this.getGradebookUserActivity((activity = toolSession.getToolActivity()).getActivityId(), userID)) == null || markedInGradebook.booleanValue() || !gradebookUserActivity.getMarkedInGradebook().booleanValue())) {
            this.updateUserActivityGradebookMark(toolSession.getLesson(), learner, (Activity)activity, mark, markedInGradebook, false);
            this.updateUserActivityGradebookFeedback((Activity)activity, learner, feedback);
        }
    }

    @Override
    public void removeActivityMark(Integer userID, Long toolSessionID) {
        ToolActivity activity;
        GradebookUserActivity gradebookUserActivity;
        ToolSession toolSession = this.toolService.getToolSessionById(toolSessionID);
        User learner = (User)this.userService.findById(User.class, (Serializable)userID);
        if (learner != null && toolSession != null && (gradebookUserActivity = this.getGradebookUserActivity((activity = toolSession.getToolActivity()).getActivityId(), userID)) != null) {
            this.removeActivityMark((Activity)activity, gradebookUserActivity);
        }
    }

    @Override
    public void removeActivityMark(Long toolContentID) {
        ToolActivity activity = this.activityDAO.getToolActivityByToolContentId(toolContentID);
        List<GradebookUserActivity> userActivities = this.getGradebookUserActivities(activity.getActivityId());
        for (GradebookUserActivity gradebookUserActivity : userActivities) {
            this.removeActivityMark((Activity)activity, gradebookUserActivity);
        }
    }

    private void removeActivityMark(Activity activity, GradebookUserActivity gradebookUserActivity) {
        Double oldActivityMark = gradebookUserActivity.getMark();
        gradebookUserActivity.setMark(null);
        Lesson lesson = (Lesson)activity.getLearningDesign().getLessons().iterator().next();
        boolean isWeightedMarks = this.toolService.isWeightedMarks(lesson.getLearningDesign());
        GradebookUserLesson gradebookUserLesson = this.getGradebookUserLesson(lesson.getLessonId(), gradebookUserActivity.getLearner().getUserId());
        this.aggregateTotalMarkForLesson(isWeightedMarks, gradebookUserLesson, gradebookUserActivity, oldActivityMark);
        this.gradebookDAO.delete((Object)gradebookUserActivity);
    }

    @Override
    public Activity getActivityById(Long activityID) {
        return this.activityDAO.getActivityByActivityId(activityID);
    }

    @Override
    public void removeLearnerFromLesson(Long lessonId, Integer learnerId) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing activity and lesson entries for learner ID " + learnerId + " and lesson ID " + lessonId));
        }
        Lesson lesson = this.getLessonService().getLesson(lessonId);
        List<ToolActivity> activities = this.getLessonActivitiesForLearner(lesson, learnerId);
        for (ToolActivity activity : activities) {
            GradebookUserActivity gradebookUserActivity = this.getGradebookUserActivity(activity.getActivityId(), learnerId);
            if (gradebookUserActivity == null) continue;
            this.gradebookDAO.delete((Object)gradebookUserActivity);
        }
        GradebookUserLesson gradebookUserLesson = this.getGradebookUserLesson(lesson.getLessonId(), learnerId);
        if (gradebookUserLesson != null) {
            this.gradebookDAO.delete((Object)gradebookUserLesson);
        }
    }

    @Override
    public void archiveLearnerMarks(Long lessonId, Integer learnerId) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Archiving activity and lesson entries for learner ID " + learnerId + " and lesson ID " + lessonId));
        }
        Lesson lesson = this.getLessonService().getLesson(lessonId);
        List<ToolActivity> activities = this.getLessonActivitiesForLearner(lesson, learnerId);
        for (ToolActivity activity : activities) {
            GradebookUserActivity gradebookUserActivity = this.getGradebookUserActivity(activity.getActivityId(), learnerId);
            if (gradebookUserActivity == null) continue;
            this.gradebookDAO.insert((Object)new GradebookUserActivityArchive(gradebookUserActivity));
        }
        GradebookUserLesson gradebookUserLesson = this.getGradebookUserLesson(lesson.getLessonId(), learnerId);
        if (gradebookUserLesson != null) {
            this.gradebookDAO.insert((Object)new GradebookUserLessonArchive(gradebookUserLesson));
        }
    }

    private List<ToolActivity> getLessonToolActivitiesForLesson(Lesson lesson) {
        ArrayList<ToolActivity> toolActivities = new ArrayList<ToolActivity>();
        List activityUrls = this.getLearnerService().getStructuredActivityURLs(lesson.getLessonId());
        for (ActivityURL activityUrl : activityUrls) {
            this.processLessonToolActivity(activityUrl, toolActivities);
        }
        return toolActivities;
    }

    private void processLessonToolActivity(ActivityURL activityUrl, List<ToolActivity> toolActivities) {
        Activity activity = this.activityDAO.getActivityByActivityId(activityUrl.getActivityId());
        if (activity instanceof ToolActivity) {
            ToolActivity toolActivity = (ToolActivity)activity;
            toolActivities.add(toolActivity);
        } else if (activity instanceof ComplexActivity) {
            for (ActivityURL childUrl : activityUrl.getChildActivities()) {
                this.processLessonToolActivity(childUrl, toolActivities);
            }
        }
    }

    private List<Activity> getLessonActivitiesForLesson(Lesson lesson) {
        ArrayList<Activity> activities = new ArrayList<Activity>();
        List activityUrls = this.getLearnerService().getStructuredActivityURLs(lesson.getLessonId());
        for (ActivityURL activityUrl : activityUrls) {
            this.processLessonActivity(activityUrl, activities);
        }
        return activities;
    }

    private void processLessonActivity(ActivityURL activityUrl, List<Activity> activities) {
        Activity activity = this.activityDAO.getActivityByActivityId(activityUrl.getActivityId());
        if (activity instanceof ToolActivity || activity instanceof SequenceActivity) {
            activities.add(activity);
        } else if (activity instanceof ComplexActivity) {
            for (ActivityURL childUrl : activityUrl.getChildActivities()) {
                this.processLessonActivity(childUrl, activities);
            }
        }
    }

    private List<ToolActivity> getLessonActivitiesForLearner(Lesson lesson, Integer learnerId) {
        ArrayList<ToolActivity> toolActivities = new ArrayList<ToolActivity>();
        Object[] objs = this.getLearnerService().getStructuredActivityURLs(learnerId, lesson.getLessonId());
        if (objs != null) {
            List activityUrls = (List)objs[0];
            for (ActivityURL activityUrl : activityUrls) {
                this.processLearnerActivity(activityUrl, toolActivities, false);
            }
        }
        return toolActivities;
    }

    private void processLearnerActivity(ActivityURL activityUrl, List<ToolActivity> toolActivities, boolean includeOnlyAttemptedCompleted) {
        block6: {
            Activity activity;
            block5: {
                activity = this.activityDAO.getActivityByActivityId(activityUrl.getActivityId());
                if (!(activity instanceof ToolActivity)) break block5;
                if (includeOnlyAttemptedCompleted && activityUrl.getStatus() == 3) break block6;
                ToolActivity toolActivity = (ToolActivity)activity;
                toolActivities.add(toolActivity);
                break block6;
            }
            if (activity instanceof ParallelActivity || activity instanceof FloatingActivity) {
                for (ActivityURL childUrl : activityUrl.getChildActivities()) {
                    this.processLearnerActivity(childUrl, toolActivities, false);
                }
            } else if (activity instanceof OptionsActivity) {
                for (ActivityURL childUrl : activityUrl.getChildActivities()) {
                    this.processLearnerActivity(childUrl, toolActivities, true);
                }
            }
        }
    }

    private String getProgressMessage(GBUserGridRowDTO userRow) {
        String originalStatus = userRow.getStatus();
        String status = originalStatus.contains("check") ? this.getMessage("gradebook.exportcourse.ok") : (originalStatus.contains("cog") ? this.getMessage("gradebook.exportcourse.current.activity", new String[]{userRow.getCurrentActivity()}) : originalStatus);
        return status;
    }

    private void aggregateTotalMarkForLesson(boolean useWeightings, GradebookUserLesson gradebookUserLesson, GradebookUserActivity markedActivity, Double oldActivityMark) {
        List userActivities = this.gradebookDAO.getGradebookUserActivitiesForLesson(gradebookUserLesson.getLesson().getLessonId(), gradebookUserLesson.getLearner().getUserId());
        if (markedActivity.getMark() == null && userActivities.size() == 1 && ((GradebookUserActivity)userActivities.get(0)).getUid() == markedActivity.getUid()) {
            this.gradebookDAO.delete((Object)gradebookUserLesson);
            return;
        }
        Double totalMark = null;
        if (oldActivityMark == null || gradebookUserLesson.getMark() == null) {
            totalMark = this.calculateLessonMark(useWeightings, userActivities, markedActivity);
        } else if (!useWeightings) {
            totalMark = gradebookUserLesson.getMark() - oldActivityMark;
            if (markedActivity != null && markedActivity.getMark() != null) {
                totalMark = totalMark + markedActivity.getMark();
            }
        } else {
            Double oldWeightedMark = this.getWeightedMark(true, markedActivity, oldActivityMark);
            Double newWeighterMark = markedActivity.getMark() == null ? 0.0 : this.getWeightedMark(true, markedActivity, markedActivity.getMark());
            totalMark = gradebookUserLesson.getMark() - oldWeightedMark + newWeighterMark;
        }
        gradebookUserLesson.setMark(totalMark);
        this.gradebookDAO.insertOrUpdate((Object)gradebookUserLesson);
    }

    private Double calculateLessonMark(boolean useWeightings, List<GradebookUserActivity> userActivities, GradebookUserActivity markedActivity) {
        Double totalMark = markedActivity != null ? this.getWeightedMark(useWeightings, markedActivity, markedActivity.getMark()) : 0.0;
        for (GradebookUserActivity guact : userActivities) {
            if (markedActivity != null && guact.getUid() == markedActivity.getUid()) continue;
            if (useWeightings) {
                totalMark = totalMark + this.getWeightedMark(useWeightings, guact, guact.getMark());
                continue;
            }
            totalMark = totalMark + guact.getMark();
        }
        return totalMark;
    }

    private Double getWeightedMark(boolean useWeightings, GradebookUserActivity guact, Double inputRawMark) {
        Double rawMark = inputRawMark != null ? inputRawMark : 0.0;
        if (useWeightings) {
            ToolActivity activity = guact.getActivity();
            if (activity.getEvaluation() == null || activity.getEvaluation().getWeight() == null) {
                return 0.0;
            }
            return this.doWeightedMarkCalc(rawMark, activity, activity.getEvaluation().getWeight(), this.toolService.getActivityMaxPossibleMark(activity));
        }
        return rawMark;
    }

    private Double doWeightedMarkCalc(Double rawMark, ToolActivity activity, Integer weight, Long maxMark) {
        if (maxMark == null) {
            logger.error((Object)("Unable to correctly calculate weighted mark as no maximum mark is known for activity \"" + activity.getTitle() + "\" (" + activity.getActivityId() + "). This activity will be skipped."));
            return 0.0;
        }
        if (maxMark == 0L) {
            return 0.0;
        }
        return rawMark / (double)maxMark.longValue() * (double)weight.intValue();
    }

    private GBActivityGridRowDTO getGradebookActivityDTO(ToolActivity activity, Lesson lesson, String groupName, Long groupId, boolean escapeTitles) {
        GBActivityGridRowDTO activityDTO = new GBActivityGridRowDTO((Activity)activity, groupName, groupId, escapeTitles);
        if (groupName != null && groupId != null) {
            activityDTO.setAverageMark(this.gradebookDAO.getAverageMarkForGroupedActivity(activity.getActivityId(), groupId));
            activityDTO.setMedianTimeTaken(this.gradebookDAO.getMedianTimeTakenForGroupedActivity(activity.getActivityId(), groupId));
            activityDTO.setMinTimeTaken(this.gradebookDAO.getMinTimeTakenForGroupedActivity(activity.getActivityId(), groupId));
            activityDTO.setMaxTimeTaken(this.gradebookDAO.getMaxTimeTakenForGroupedActivity(activity.getActivityId(), groupId));
        } else {
            activityDTO.setAverageMark(this.gradebookDAO.getAverageMarkForActivity(activity.getActivityId()));
            activityDTO.setMedianTimeTaken(this.gradebookDAO.getMedianTimeTakenForActivity(activity.getActivityId()));
            activityDTO.setMinTimeTaken(this.gradebookDAO.getMinTimeTakenForActivity(activity.getActivityId()));
            activityDTO.setMaxTimeTaken(this.gradebookDAO.getMaxTimeTakenForActivity(activity.getActivityId()));
        }
        activityDTO.setMarksAvailable(this.toolService.getActivityMaxPossibleMark(activity));
        String monitorUrl = Configuration.get((String)ConfigurationKeys.SERVER_URL) + activity.getTool().getMonitorUrl() + "?" + "contentFolderID" + "=" + lesson.getLearningDesign().getContentFolderID() + "&" + "toolContentID" + "=" + activity.getToolContentId();
        activityDTO.setMonitorUrl(monitorUrl);
        return activityDTO;
    }

    private Date getActivityStartDate(LearnerProgress learnerProgress, Activity activity, TimeZone timeZone) {
        CompletedActivityProgress compProg;
        Date startDate = null;
        if (learnerProgress != null && (startDate = (Date)learnerProgress.getAttemptedActivities().get(activity)) == null && (compProg = (CompletedActivityProgress)learnerProgress.getCompletedActivities().get(activity)) != null) {
            startDate = compProg.getStartDate();
        }
        if (startDate != null) {
            if (timeZone == null) {
                logger.warn((Object)"No user time zone provided, leaving server default");
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Adjusting time according to zone \"" + timeZone + "\""));
                }
                startDate = DateUtil.convertToTimeZoneFromDefault((TimeZone)timeZone, (Date)startDate);
            }
        }
        return startDate;
    }

    private Date getActivityFinishDate(LearnerProgress learnerProgress, Activity activity, TimeZone timeZone) {
        CompletedActivityProgress compProg;
        Date finishDate = null;
        if (learnerProgress != null && (compProg = (CompletedActivityProgress)learnerProgress.getCompletedActivities().get(activity)) != null) {
            finishDate = compProg.getFinishDate();
        }
        if (finishDate != null) {
            if (timeZone == null) {
                logger.warn((Object)"No user time zone provided, leaving server default");
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Adjusting time according to zone \"" + timeZone + "\""));
                }
                finishDate = DateUtil.convertToTimeZoneFromDefault((TimeZone)timeZone, finishDate);
            }
        }
        return finishDate;
    }

    private Long getActivityDuration(LearnerProgress learnerProgress, Activity activity) {
        CompletedActivityProgress compProg;
        if (learnerProgress != null && learnerProgress.getCompletedActivities().get(activity) != null && (compProg = (CompletedActivityProgress)learnerProgress.getCompletedActivities().get(activity)) != null) {
            Date startTime = compProg.getStartDate();
            Date endTime = compProg.getFinishDate();
            if (startTime != null && endTime != null) {
                return endTime.getTime() - startTime.getTime();
            }
        }
        return null;
    }

    private String getLessonStatusStr(LearnerProgress learnerProgress) {
        String status = "-";
        String IMAGES_DIR = Configuration.get((String)ConfigurationKeys.SERVER_URL) + "images";
        if (learnerProgress != null) {
            if (learnerProgress.isComplete()) {
                status = "<i class='fa fa-check text-success'></i>";
            } else if (learnerProgress.getAttemptedActivities() != null && learnerProgress.getAttemptedActivities().size() > 0) {
                String currentActivityTitle = learnerProgress.getCurrentActivity() == null ? "" : HtmlUtils.htmlEscape((String)learnerProgress.getCurrentActivity().getTitle());
                status = "<i class='fa fa-cog' title='" + currentActivityTitle + "'></i>";
            }
        }
        return status;
    }

    private String getActivityStatusStr(LearnerProgress learnerProgress, Activity activity) {
        String IMAGES_DIR = Configuration.get((String)ConfigurationKeys.SERVER_URL) + "images";
        if (learnerProgress != null) {
            byte statusByte = learnerProgress.getProgressState(activity);
            if (statusByte == 2 && learnerProgress.getCurrentActivity() != null) {
                return "<i class='fa fa-cog' title='" + HtmlUtils.htmlEscape((String)learnerProgress.getCurrentActivity().getTitle()) + "'></i>";
            }
            if (statusByte == 1) {
                return "<i class='fa fa-check text-success'></i>";
            }
        }
        return "-";
    }

    private Map<Integer, LearnerProgress> getUserToLearnerProgressMap(Lesson lesson, List<User> learners) {
        List learnerProgresses;
        HashMap<Integer, LearnerProgress> map = new HashMap<Integer, LearnerProgress>();
        if (lesson == null || learners != null && learners.isEmpty()) {
            return map;
        }
        if (learners == null) {
            learnerProgresses = this.lessonService.getUserProgressForLesson(lesson.getLessonId());
        } else {
            LinkedList<Integer> userIds = new LinkedList<Integer>();
            for (User learner : learners) {
                userIds.add(learner.getUserId());
            }
            learnerProgresses = this.learnerProgressDAO.getLearnerProgressForLesson(lesson.getLessonId(), userIds);
        }
        if (learnerProgresses != null) {
            for (LearnerProgress learnerProgress : learnerProgresses) {
                map.put(learnerProgress.getUser().getUserId(), learnerProgress);
            }
        }
        return map;
    }

    private Map<Integer, GradebookUserActivity> getUserToGradebookUserActivityMap(Activity activity, List<User> learners) {
        List gradebookUserActivities;
        HashMap<Integer, GradebookUserActivity> map = new HashMap<Integer, GradebookUserActivity>();
        if (activity == null || learners != null && learners.isEmpty()) {
            return map;
        }
        if (learners == null) {
            gradebookUserActivities = this.gradebookDAO.getAllGradebookUserActivitiesForActivity(activity.getActivityId());
        } else {
            LinkedList<Integer> userIds = new LinkedList<Integer>();
            for (User learner : learners) {
                userIds.add(learner.getUserId());
            }
            gradebookUserActivities = this.gradebookDAO.getGradebookUserActivitiesForActivity(activity.getActivityId(), userIds);
        }
        if (gradebookUserActivities != null) {
            for (GradebookUserActivity gradebookUserActivity : gradebookUserActivities) {
                map.put(gradebookUserActivity.getLearner().getUserId(), gradebookUserActivity);
            }
        }
        return map;
    }

    private Map<Long, Long> getActivityToTotalMarkMap(Collection<ToolActivity> activities) {
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        for (ToolActivity activity : activities) {
            map.put(activity.getActivityId(), this.toolService.getActivityMaxPossibleMark(activity));
        }
        return map;
    }

    private Map<Integer, GradebookUserLesson> getUserToGradebookUserLessonMap(Lesson lesson, List<User> learners) {
        List gradebookUserLessons;
        HashMap<Integer, GradebookUserLesson> map = new HashMap<Integer, GradebookUserLesson>();
        if (lesson == null || learners != null && learners.isEmpty()) {
            return map;
        }
        if (learners == null) {
            gradebookUserLessons = this.gradebookDAO.getGradebookUserLessons(lesson);
        } else {
            LinkedList<Integer> userIds = new LinkedList<Integer>();
            for (User learner : learners) {
                userIds.add(learner.getUserId());
            }
            gradebookUserLessons = this.gradebookDAO.getGradebookUserLessons(lesson, userIds);
        }
        if (gradebookUserLessons != null) {
            for (GradebookUserLesson gradebookUserLesson : gradebookUserLessons) {
                map.put(gradebookUserLesson.getLearner().getUserId(), gradebookUserLesson);
            }
        }
        return map;
    }

    @Override
    public List<Number> getMarksArray(Long lessonId) {
        return this.gradebookDAO.getAllMarksForLesson(lessonId);
    }

    private ICoreLearnerService getLearnerService() {
        if (learnerService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)SessionManager.getServletContext());
            learnerService = (ICoreLearnerService)ctx.getBean("learnerService");
        }
        return learnerService;
    }

    @Override
    public String getMessage(String key) {
        return this.messageService.getMessage(key);
    }

    private String getMessage(String key, Object[] args) {
        return this.messageService.getMessage(key, args);
    }

    public void setLogEventService(ILogEventService logEventService) {
        this.logEventService = logEventService;
    }

    public ILamsCoreToolService getToolService() {
        return this.toolService;
    }

    public void setToolService(ILamsCoreToolService toolService) {
        this.toolService = toolService;
    }

    public IGradebookDAO getGradebookDAO() {
        return this.gradebookDAO;
    }

    public void setGradebookDAO(IGradebookDAO gradebookDAO) {
        this.gradebookDAO = gradebookDAO;
    }

    public void setLearnerProgressDAO(ILearnerProgressDAO learnerProgressDAO) {
        this.learnerProgressDAO = learnerProgressDAO;
    }

    public void setLessonDAO(ILessonDAO lessonDAO) {
        this.lessonDAO = lessonDAO;
    }

    public ILessonService getLessonService() {
        return this.lessonService;
    }

    public void setLessonService(ILessonService lessonService) {
        this.lessonService = lessonService;
    }

    public IUserManagementService getUserService() {
        return this.userService;
    }

    public void setUserService(IUserManagementService userService) {
        this.userService = userService;
    }

    public IBaseDAO getBaseDAO() {
        return this.baseDAO;
    }

    public void setBaseDAO(IBaseDAO baseDAO) {
        this.baseDAO = baseDAO;
    }

    public IActivityDAO getActivityDAO() {
        return this.activityDAO;
    }

    public void setActivityDAO(IActivityDAO activityDAO) {
        this.activityDAO = activityDAO;
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }
}

