/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.gradebook.web.action;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.gradebook.GradebookUserLesson;
import org.lamsfoundation.lams.gradebook.dto.GBLessonGridRowDTO;
import org.lamsfoundation.lams.gradebook.dto.GradebookGridRowDTO;
import org.lamsfoundation.lams.gradebook.service.IGradebookService;
import org.lamsfoundation.lams.gradebook.util.GBGridView;
import org.lamsfoundation.lams.gradebook.util.GradebookUtil;
import org.lamsfoundation.lams.learning.service.ICoreLearnerService;
import org.lamsfoundation.lams.learning.web.bean.ActivityURL;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.security.ISecurityService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class GradebookAction
extends LamsDispatchAction {
    private static Logger logger = Logger.getLogger(GradebookAction.class);
    private static IGradebookService gradebookService;
    private static IUserManagementService userService;
    private static ILessonService lessonService;
    private static ISecurityService securityService;
    private static ICoreLearnerService learnerService;

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return null;
    }

    public ActionForward getActivityGridData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int page = WebUtil.readIntParam((HttpServletRequest)request, (String)"page");
        int rowLimit = WebUtil.readIntParam((HttpServletRequest)request, (String)"rows");
        String sortOrder = WebUtil.readStrParam((HttpServletRequest)request, (String)"sord");
        String sortBy = WebUtil.readStrParam((HttpServletRequest)request, (String)"sidx", (boolean)true);
        Boolean isSearch = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"_search");
        String searchField = WebUtil.readStrParam((HttpServletRequest)request, (String)"searchField", (boolean)true);
        String searchOper = WebUtil.readStrParam((HttpServletRequest)request, (String)"searchOper", (boolean)true);
        String searchString = WebUtil.readStrParam((HttpServletRequest)request, (String)"searchString", (boolean)true);
        GBGridView view = GradebookUtil.readGBGridViewParam(request, "view", false);
        Long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        if (!this.getSecurityService().isLessonParticipant(lessonID, this.getUser().getUserID(), "get activity gradebook data", false)) {
            response.sendError(403, "User is not a learner in the lesson");
            return null;
        }
        UserDTO currentUserDTO = this.getUser();
        Integer userID = null;
        if (view == GBGridView.MON_USER) {
            userID = WebUtil.readIntParam((HttpServletRequest)request, (String)"userID");
        } else if (view == GBGridView.LRN_ACTIVITY && currentUserDTO != null) {
            userID = currentUserDTO.getUserID();
        }
        List<Object> gradebookActivityDTOs = new ArrayList();
        if (view == GBGridView.MON_USER || view == GBGridView.LRN_ACTIVITY) {
            gradebookActivityDTOs = this.getGradebookService().getGBActivityRowsForLearner(lessonID, userID, currentUserDTO.getTimeZone());
        } else if (view == GBGridView.MON_ACTIVITY) {
            gradebookActivityDTOs = this.getGradebookService().getGBActivityRowsForLesson(lessonID, currentUserDTO.getTimeZone(), true);
        }
        if (sortBy == null || sortBy.equals("")) {
            sortBy = "startDate";
        }
        String ret = GradebookUtil.toGridXML(gradebookActivityDTOs, view, sortBy, isSearch, searchField, searchOper, searchString, sortOrder, rowLimit, page);
        this.writeResponse(response, "text/xml", "UTF8", ret);
        return null;
    }

    public ActionForward getLessonCompleteGridData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        UserDTO currentUserDTO = this.getUser();
        Integer userId = currentUserDTO.getUserID();
        if (!this.getSecurityService().isLessonParticipant(lessonId, userId, "get lesson complete gradebook data", false)) {
            response.sendError(403, "User is not a learner in the lesson");
            return null;
        }
        List<GradebookGridRowDTO> gradebookActivityDTOs = this.getGradebookService().getGBLessonComplete(lessonId, userId);
        ObjectNode resultJSON = JsonNodeFactory.instance.objectNode();
        resultJSON.put("records", gradebookActivityDTOs.size());
        ArrayNode rowsJSON = JsonNodeFactory.instance.arrayNode();
        for (GradebookGridRowDTO gradebookActivityDTO : gradebookActivityDTOs) {
            ObjectNode rowJSON = JsonNodeFactory.instance.objectNode();
            String id = gradebookActivityDTO.getId();
            String[] idParts = id.split("_");
            if (idParts.length > 1) {
                id = idParts[0];
            }
            rowJSON.put("id", id);
            ArrayNode cellJSON = JsonNodeFactory.instance.arrayNode();
            cellJSON.add(gradebookActivityDTO.getRowName());
            cellJSON.add(gradebookActivityDTO.getStatus());
            cellJSON.add(gradebookActivityDTO.getAverageMark() == null ? "-" : GradebookUtil.niceFormatting(gradebookActivityDTO.getAverageMark()));
            cellJSON.add(gradebookActivityDTO.getMark() == null ? "-" : GradebookUtil.niceFormatting(gradebookActivityDTO.getMark()));
            rowJSON.set("cell", (JsonNode)cellJSON);
            rowsJSON.add((JsonNode)rowJSON);
        }
        resultJSON.set("rows", (JsonNode)rowsJSON);
        ObjectNode activityURLJSON = JsonNodeFactory.instance.objectNode();
        Object[] ret = this.getLearnerService().getStructuredActivityURLs(userId, lessonId);
        for (ActivityURL activity : (List)ret[0]) {
            String serverUrl;
            String url = activity.getUrl();
            if (url == null) continue;
            if (url.startsWith("learner.do")) {
                url = "learning/" + url;
            }
            if (!url.startsWith(serverUrl = Configuration.get((String)ConfigurationKeys.SERVER_URL))) {
                url = serverUrl + url;
            }
            activityURLJSON.put(activity.getActivityId().toString(), activity.getUrl());
        }
        resultJSON.set("urls", (JsonNode)activityURLJSON);
        boolean isWeighted = this.getGradebookService().isWeightedMarks(lessonId);
        GradebookUserLesson gradebookUserLesson = this.getGradebookService().getGradebookUserLesson(lessonId, userId);
        resultJSON.put("learnerLessonMark", gradebookUserLesson == null || gradebookUserLesson.getMark() == null ? "-" : GradebookUtil.niceFormatting(gradebookUserLesson.getMark(), isWeighted));
        Double averageLessonMark = this.getGradebookService().getAverageMarkForLesson(lessonId);
        resultJSON.put("averageLessonMark", averageLessonMark == null ? "-" : GradebookUtil.niceFormatting(averageLessonMark, isWeighted));
        response.setContentType("application/json;charset=utf-8");
        response.getWriter().print(resultJSON.toString());
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ActionForward getUserGridData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int totalUsers;
        List<Object> gradebookUserDTOs;
        GBGridView view;
        int rowLimit;
        int page;
        block9: {
            UserDTO user;
            Integer organisationID;
            String searchString;
            String sortOrder;
            block7: {
                Lesson lesson;
                String sortBy;
                block8: {
                    page = WebUtil.readIntParam((HttpServletRequest)request, (String)"page");
                    rowLimit = WebUtil.readIntParam((HttpServletRequest)request, (String)"rows");
                    sortOrder = WebUtil.readStrParam((HttpServletRequest)request, (String)"sord");
                    sortBy = WebUtil.readStrParam((HttpServletRequest)request, (String)"sidx", (boolean)true);
                    Boolean isSearch = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"_search");
                    String searchField = WebUtil.readStrParam((HttpServletRequest)request, (String)"searchField", (boolean)true);
                    searchString = WebUtil.readStrParam((HttpServletRequest)request, (String)"searchString", (boolean)true);
                    view = GradebookUtil.readGBGridViewParam(request, "view", false);
                    Long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID", (boolean)true);
                    organisationID = WebUtil.readIntParam((HttpServletRequest)request, (String)"organisationID", (boolean)true);
                    user = this.getUser();
                    if (isSearch.booleanValue() && searchField == null) {
                        searchField = "rowName";
                        searchString = WebUtil.readStrParam((HttpServletRequest)request, (String)"rowName", (boolean)true);
                    }
                    gradebookUserDTOs = new ArrayList();
                    totalUsers = 0;
                    if (lessonID == null) break block7;
                    if (!this.getSecurityService().isLessonMonitor(lessonID, user.getUserID(), "get gradebook", false)) {
                        response.sendError(403, "User is not a monitor in the lesson");
                        return null;
                    }
                    lesson = this.getLessonService().getLesson(lessonID);
                    if (view != GBGridView.MON_USER && view != GBGridView.MON_COURSE) break block8;
                    gradebookUserDTOs = this.getGradebookService().getGBUserRowsForLesson(lesson, page - 1, rowLimit, sortBy, sortOrder, searchString, user.getTimeZone());
                    totalUsers = lesson.getAllLearners().size();
                    break block9;
                }
                if (view != GBGridView.MON_ACTIVITY) break block9;
                String rowID = WebUtil.readStrParam((HttpServletRequest)request, (String)"activityID");
                Long activityID = null;
                String[] split = rowID.split("_");
                activityID = split.length == 2 ? Long.valueOf(Long.parseLong(split[0])) : Long.valueOf(Long.parseLong(rowID));
                Long groupId = WebUtil.readLongParam((HttpServletRequest)request, (String)"groupId", (boolean)true);
                Activity activity = this.getGradebookService().getActivityById(activityID);
                if (activity != null && activity instanceof ToolActivity) {
                    Group group;
                    gradebookUserDTOs = this.getGradebookService().getGBUserRowsForActivity(lesson, (ToolActivity)activity, groupId, page - 1, rowLimit, sortBy, sortOrder, searchString, user.getTimeZone());
                    totalUsers = lesson.getAllLearners().size();
                    if (groupId != null && (group = (Group)this.getUserService().findById(Group.class, (Serializable)groupId)) != null) {
                        totalUsers = group.getUsers().size();
                    }
                    break block9;
                } else {
                    logger.error((Object)("No activity found for: " + activityID));
                    return null;
                }
            }
            if (organisationID == null) {
                LamsDispatchAction.log.error((Object)"Missing parameters: either lessonID or organisationID should be specified.");
                response.sendError(400, "Missing parameters");
                return null;
            }
            if (!this.getSecurityService().isGroupMonitor(organisationID, user.getUserID(), "get gradebook", false)) {
                response.sendError(403, "User is not a monitor in the organisation");
                return null;
            }
            Organisation org = (Organisation)this.getUserService().findById(Organisation.class, (Serializable)organisationID);
            gradebookUserDTOs = this.getGradebookService().getGBUserRowsForOrganisation(org, page - 1, rowLimit, sortOrder, searchString);
            totalUsers = gradebookService.getCountUsersByOrganisation(organisationID, searchString);
        }
        int totalPages = new Double(Math.ceil(new Integer(totalUsers).doubleValue() / new Integer(rowLimit).doubleValue())).intValue();
        String ret = GradebookUtil.toGridXML(gradebookUserDTOs, page, totalPages, view);
        this.writeResponse(response, "text/xml", "UTF8", ret);
        return null;
    }

    public ActionForward getCourseGridData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String ret;
        User user;
        Set lessons;
        int page = WebUtil.readIntParam((HttpServletRequest)request, (String)"page");
        int rowLimit = WebUtil.readIntParam((HttpServletRequest)request, (String)"rows");
        String sortOrder = WebUtil.readStrParam((HttpServletRequest)request, (String)"sord");
        String sortBy = WebUtil.readStrParam((HttpServletRequest)request, (String)"sidx", (boolean)true);
        Boolean isSearch = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"_search");
        String searchField = WebUtil.readStrParam((HttpServletRequest)request, (String)"searchField", (boolean)true);
        String searchOper = WebUtil.readStrParam((HttpServletRequest)request, (String)"searchOper", (boolean)true);
        String searchString = WebUtil.readStrParam((HttpServletRequest)request, (String)"searchString", (boolean)true);
        GBGridView view = GradebookUtil.readGBGridViewParam(request, "view", false);
        Integer courseID = WebUtil.readIntParam((HttpServletRequest)request, (String)"organisationID");
        Organisation organisation = (Organisation)this.getUserService().findById(Organisation.class, (Serializable)courseID);
        if (isSearch.booleanValue() && searchField == null) {
            searchField = "rowName";
            searchOper = "cn";
            searchString = WebUtil.readStrParam((HttpServletRequest)request, (String)"rowName", (boolean)true);
        }
        if (sortBy == null) {
            sortBy = "id";
        }
        if (sortOrder == null) {
            sortOrder = "asc";
        }
        if ((lessons = organisation.getLessons()) == null) {
            return null;
        }
        User viewer = this.getRealUser();
        if (view == GBGridView.MON_USER) {
            Integer userID = WebUtil.readIntParam((HttpServletRequest)request, (String)"userID");
            user = (User)this.getUserService().findById(User.class, (Serializable)userID);
        } else {
            user = this.getRealUser();
        }
        if (view == GBGridView.MON_USER) {
            if (!this.getSecurityService().isGroupMonitor(courseID, viewer.getUserId(), "get course gradebook", false)) {
                response.sendError(403, "User is not a monitor in the organisation");
                return null;
            }
        } else if (view == GBGridView.MON_COURSE || view == GBGridView.LIST) {
            if (!this.getSecurityService().hasOrgRole(courseID, viewer.getUserId(), new String[]{"GROUP MANAGER", "GROUP ADMIN"}, "get course gradebook", false)) {
                response.sendError(403, "User is not a group manager or admin in the organisation");
                return null;
            }
        } else if (view == GBGridView.LRN_COURSE) {
            if (!this.getSecurityService().hasOrgRole(courseID, viewer.getUserId(), new String[]{"LEARNER"}, "get course gradebook for learner", false)) {
                response.sendError(403, "User is not a learner in the organisation");
                return null;
            }
        } else {
            return null;
        }
        if (organisation == null || user == null || viewer == null) {
            logger.error((Object)("Error: request for course gradebook data with null course or user. CourseID: " + courseID));
            return null;
        }
        List<GBLessonGridRowDTO> gradebookLessonDTOs = this.getGradebookService().getGBLessonRows(organisation, user, viewer, view, page - 1, rowLimit, sortBy, sortOrder, searchString, this.getUser().getTimeZone());
        if (view == GBGridView.MON_COURSE || view == GBGridView.LIST) {
            int totalPages = new Double(Math.ceil(new Integer(lessons.size()).doubleValue() / new Integer(rowLimit).doubleValue())).intValue();
            ret = GradebookUtil.toGridXML(gradebookLessonDTOs, page, totalPages, view);
        } else {
            ret = GradebookUtil.toGridXML(gradebookLessonDTOs, view, sortBy, isSearch, searchField, searchOper, searchString, sortOrder, rowLimit, page);
        }
        this.writeResponse(response, "text/xml", "UTF8", ret);
        return null;
    }

    public ActionForward getLessonMarkAggregate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        Integer userID = WebUtil.readIntParam((HttpServletRequest)request, (String)"userID");
        if (this.getUser().getUserID().equals(userID)) {
            if (!this.getSecurityService().isLessonParticipant(lessonID, userID, "get lesson mark aggregate", false)) {
                response.sendError(403, "User is not a participant in the lesson");
                return null;
            }
        } else if (!this.getSecurityService().isLessonMonitor(lessonID, this.getUser().getUserID(), "get lesson mark aggregate", false)) {
            response.sendError(403, "User is not a monitor in the lesson");
            return null;
        }
        Lesson lesson = this.getLessonService().getLesson(lessonID);
        User learner = (User)this.getUserService().findById(User.class, (Serializable)userID);
        if (lesson != null && learner != null) {
            GradebookUserLesson lessonMark = this.getGradebookService().getGradebookUserLesson(lessonID, userID);
            if (lessonMark.getMark() != null) {
                this.writeResponse(response, "text/plain", "UTF8", GradebookUtil.niceFormatting(lessonMark.getMark()));
            }
        } else {
            logger.error((Object)("Error: request for course gradebook data with null user or lesson. lessonID: " + lessonID));
        }
        return null;
    }

    public ActionForward getActivityMarkAverage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String rowID = WebUtil.readStrParam((HttpServletRequest)request, (String)"activityID");
        Long activityID = null;
        Long groupID = null;
        String[] split = rowID.split("_");
        if (split.length == 2) {
            activityID = Long.parseLong(split[0]);
            groupID = Long.parseLong(split[1]);
        } else {
            activityID = Long.parseLong(rowID);
        }
        Activity activity = this.getGradebookService().getActivityById(activityID);
        if (activity == null) {
            LamsDispatchAction.log.error((Object)("Activity with ID: " + activityID + " could not be found when getting activity mark average"));
            response.sendError(400, "Missing parameters");
            return null;
        }
        Integer userID = this.getUser().getUserID();
        for (Lesson lesson : activity.getLearningDesign().getLessons()) {
            if (this.getSecurityService().isLessonMonitor(lesson.getLessonId(), userID, "get activity mark average", false)) continue;
            response.sendError(403, "User is not a monitor in the lesson");
            return null;
        }
        Double averageMark = this.getGradebookService().getAverageMarkForActivity(activityID, groupID);
        if (averageMark != null) {
            this.writeResponse(response, "text/plain", "UTF8", GradebookUtil.niceFormatting(averageMark));
        } else {
            this.writeResponse(response, "text/plain", "UTF8", "-");
        }
        return null;
    }

    public ActionForward getAverageMarkForLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        if (!this.getSecurityService().isLessonMonitor(lessonID, this.getUser().getUserID(), "get lesson mark average", false)) {
            response.sendError(403, "User is not a monitor in the lesson");
            return null;
        }
        Double averageMark = this.getGradebookService().getAverageMarkForLesson(lessonID);
        if (averageMark != null) {
            this.writeResponse(response, "text/plain", "UTF8", GradebookUtil.niceFormatting(averageMark));
        } else {
            this.writeResponse(response, "text/plain", "UTF8", "-");
        }
        return null;
    }

    private UserDTO getUser() {
        HttpSession ss = SessionManager.getSession();
        return (UserDTO)ss.getAttribute("user");
    }

    private User getRealUser() {
        UserDTO userDTO = this.getUser();
        if (userDTO != null) {
            return this.getUserService().getUserByLogin(userDTO.getLogin());
        }
        return null;
    }

    private IUserManagementService getUserService() {
        if (userService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            userService = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return userService;
    }

    private ILessonService getLessonService() {
        if (lessonService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            lessonService = (ILessonService)ctx.getBean("lessonService");
        }
        return lessonService;
    }

    private IGradebookService getGradebookService() {
        if (gradebookService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            gradebookService = (IGradebookService)ctx.getBean("gradebookService");
        }
        return gradebookService;
    }

    private ISecurityService getSecurityService() {
        if (securityService == null) {
            WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            securityService = (ISecurityService)webContext.getBean("securityService");
        }
        return securityService;
    }

    private ICoreLearnerService getLearnerService() {
        if (learnerService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            learnerService = (ICoreLearnerService)ctx.getBean("learnerService");
        }
        return learnerService;
    }
}

