/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.gradebook.web.action;

import java.io.Serializable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.security.ISecurityService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class GradebookLearningAction
extends LamsDispatchAction {
    private static Logger logger = Logger.getLogger(GradebookLearningAction.class);
    private static IUserManagementService userService;
    private static ISecurityService securityService;

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return null;
    }

    public ActionForward courseLearner(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Integer oranisationID = WebUtil.readIntParam((HttpServletRequest)request, (String)"organisationID");
            UserDTO user = this.getUser();
            if (user == null) {
                logger.error((Object)"User missing from session. ");
                return mapping.findForward("error");
            }
            if (!this.getSecurityService().hasOrgRole(oranisationID, user.getUserID(), new String[]{"GROUP MANAGER", "MONITOR", "LEARNER"}, "get course gradebook for learner", false)) {
                response.sendError(403, "User is not a participant in the organisation");
                return null;
            }
            if (LamsDispatchAction.log.isDebugEnabled()) {
                logger.debug((Object)("Getting learner gradebook for organisation: " + oranisationID));
            }
            Organisation organisation = (Organisation)this.getUserService().findById(Organisation.class, (Serializable)oranisationID);
            request.setAttribute("organisationID", (Object)oranisationID);
            request.setAttribute("organisationName", (Object)organisation.getName());
            request.setAttribute("fullName", (Object)(user.getFirstName() + " " + user.getLastName()));
            return mapping.findForward("learnercoursegradebook");
        }
        catch (Exception e) {
            logger.error((Object)"Failed to load learner gradebook", (Throwable)e);
            return mapping.findForward("error");
        }
    }

    private UserDTO getUser() {
        HttpSession ss = SessionManager.getSession();
        return (UserDTO)ss.getAttribute("user");
    }

    private IUserManagementService getUserService() {
        if (userService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            userService = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return userService;
    }

    private ISecurityService getSecurityService() {
        if (securityService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            securityService = (ISecurityService)ctx.getBean("securityService");
        }
        return securityService;
    }
}

