/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.gradebook.web.action;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.gradebook.service.IGradebookService;
import org.lamsfoundation.lams.gradebook.util.GBGridView;
import org.lamsfoundation.lams.gradebook.util.GradebookUtil;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.dto.LessonDetailsDTO;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.security.ISecurityService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.ExcelCell;
import org.lamsfoundation.lams.util.ExcelUtil;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.JsonUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class GradebookMonitoringAction
extends LamsDispatchAction {
    private static Logger log = Logger.getLogger(GradebookMonitoringAction.class);
    private static IGradebookService gradebookService;
    private static IUserManagementService userService;
    private static ILessonService lessonService;
    private static ISecurityService securityService;

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            UserDTO user;
            Long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Getting gradebook for lesson " + lessonId));
            }
            if ((user = this.getUser()) == null) {
                log.error((Object)"User missing from session. ");
                return mapping.findForward("error");
            }
            if (!this.getSecurityService().isLessonMonitor(lessonId, user.getUserID(), "get lesson gradebook", false)) {
                response.sendError(403, "User is not a monitor in the lesson");
                return null;
            }
            Lesson lesson = this.getLessonService().getLesson(lessonId);
            boolean marksReleased = lesson.getMarksReleased() != null && lesson.getMarksReleased() != false;
            LessonDetailsDTO lessonDetatilsDTO = lesson.getLessonDetails();
            request.setAttribute("lessonDetails", (Object)lessonDetatilsDTO);
            request.setAttribute("marksReleased", (Object)marksReleased);
            List<String[]> weights = this.getGradebookService().getWeights(lesson.getLearningDesign());
            if (weights.size() > 0) {
                request.setAttribute("weights", weights);
            }
            request.setAttribute("isInTabs", (Object)WebUtil.readBooleanParam((HttpServletRequest)request, (String)"isInTabs", (boolean)false));
            return mapping.findForward("monitorgradebook");
        }
        catch (Exception e) {
            log.error((Object)"Failed to load lesson gradebook", (Throwable)e);
            return mapping.findForward("error");
        }
    }

    public ActionForward courseMonitor(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            UserDTO user;
            Integer organisationID = WebUtil.readIntParam((HttpServletRequest)request, (String)"organisationID");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Getting gradebook for organisation " + organisationID));
            }
            if ((user = this.getUser()) == null) {
                log.error((Object)"User missing from session. ");
                return mapping.findForward("error");
            }
            if (!this.getSecurityService().hasOrgRole(organisationID, user.getUserID(), new String[]{"GROUP MANAGER", "GROUP ADMIN"}, "get course gradebook page", false)) {
                response.sendError(403, "User is not a monitor in the organisation");
                return null;
            }
            Organisation organisation = (Organisation)this.getUserService().findById(Organisation.class, (Serializable)organisationID);
            request.setAttribute("organisationID", (Object)organisationID);
            request.setAttribute("organisationName", (Object)organisation.getName());
            return mapping.findForward("monitorcoursegradebook");
        }
        catch (Exception e) {
            log.error((Object)"Failed to load course gradebook", (Throwable)e);
            return mapping.findForward("error");
        }
    }

    public ActionForward updateUserLessonGradebookData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        if (!this.getSecurityService().isLessonMonitor(lessonID, this.getUser().getUserID(), "update lesson gradebook", false)) {
            response.sendError(403, "User is not a monitor in the lesson");
            return null;
        }
        Integer userID = WebUtil.readIntParam((HttpServletRequest)request, (String)"id");
        User learner = (User)this.getUserService().findById(User.class, (Serializable)userID);
        if (learner == null) {
            log.error((Object)("User with ID " + userID + " could not be found to update his lesson gradebook"));
            response.sendError(400, "User could not be found");
            return null;
        }
        String markStr = WebUtil.readStrParam((HttpServletRequest)request, (String)"mark", (boolean)true);
        String feedback = WebUtil.readStrParam((HttpServletRequest)request, (String)"feedback", (boolean)true);
        Lesson lesson = this.getLessonService().getLesson(lessonID);
        if (markStr != null && !markStr.equals("")) {
            Double mark = Double.parseDouble(markStr);
            this.getGradebookService().updateUserLessonGradebookMark(lesson, learner, mark);
        }
        if (feedback != null) {
            this.getGradebookService().updateUserLessonGradebookFeedback(lesson, learner, feedback);
        }
        return null;
    }

    public ActionForward updateUserActivityGradebookData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String rowID;
        Long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        if (!this.getSecurityService().isLessonMonitor(lessonID, this.getUser().getUserID(), "update activity gradebook", false)) {
            response.sendError(403, "User is not a monitor in the lesson");
            return null;
        }
        GBGridView view = GradebookUtil.readGBGridViewParam(request, "view", false);
        Long activityID = null;
        Integer userID = null;
        if (view == GBGridView.MON_ACTIVITY) {
            rowID = WebUtil.readStrParam((HttpServletRequest)request, (String)"activityID");
            activityID = this.getActivityFromParameter(rowID);
            userID = WebUtil.readIntParam((HttpServletRequest)request, (String)"id");
        } else if (view == GBGridView.MON_USER) {
            rowID = WebUtil.readStrParam((HttpServletRequest)request, (String)"id");
            activityID = this.getActivityFromParameter(rowID);
            userID = WebUtil.readIntParam((HttpServletRequest)request, (String)"userID");
        }
        Activity activity = this.getGradebookService().getActivityById(activityID);
        if (activity == null || !activity.isToolActivity()) {
            log.error((Object)("Activity with ID " + activityID + " could not be found or it is not a Tool Activity"));
            response.sendError(400, "Wrong activity");
            return null;
        }
        User learner = (User)this.getUserService().findById(User.class, (Serializable)userID);
        if (learner == null) {
            log.error((Object)("User with ID " + userID + " could not be found to update his activity gradebook"));
            response.sendError(400, "User could not be found");
            return null;
        }
        String markStr = WebUtil.readStrParam((HttpServletRequest)request, (String)"mark", (boolean)true);
        String feedback = WebUtil.readStrParam((HttpServletRequest)request, (String)"feedback", (boolean)true);
        Lesson lesson = this.getLessonService().getLesson(lessonID);
        if (markStr != null && !markStr.equals("")) {
            Double mark = Double.parseDouble(markStr);
            this.getGradebookService().updateUserActivityGradebookMark(lesson, learner, activity, mark, true, true);
        }
        if (feedback != null) {
            this.getGradebookService().updateUserActivityGradebookFeedback(activity, learner, feedback);
        }
        return null;
    }

    private Long getActivityFromParameter(String rowID) {
        String[] split = rowID.split("_");
        Long activityID = split.length == 2 ? Long.valueOf(Long.parseLong(split[0])) : Long.valueOf(Long.parseLong(rowID));
        return activityID;
    }

    public ActionForward toggleReleaseMarks(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        if (!this.getSecurityService().isLessonMonitor(lessonID, this.getUser().getUserID(), "toggle release marks", false)) {
            response.sendError(403, "User is not a monitor in the lesson");
            return null;
        }
        this.getGradebookService().toggleMarksReleased(lessonID);
        this.writeResponse(response, "text/plain", "UTF8", "success");
        return null;
    }

    public ActionForward exportExcelLessonGradebook(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        if (!this.getSecurityService().isLessonMonitor(lessonID, this.getUser().getUserID(), "export lesson gradebook spreadsheet", false)) {
            response.sendError(403, "User is not a monitor in the lesson");
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exporting to a spreadsheet lesson: " + lessonID));
        }
        Lesson lesson = this.getLessonService().getLesson(lessonID);
        String fileName = lesson.getLessonName().replaceAll(" ", "_") + ".xlsx";
        fileName = FileUtil.encodeFilenameForDownload((HttpServletRequest)request, (String)fileName);
        response.setContentType("application/x-download");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        log.debug((Object)("Exporting to a spreadsheet gradebook lesson: " + lessonID));
        ServletOutputStream out = response.getOutputStream();
        LinkedHashMap<String, ExcelCell[][]> dataToExport = this.getGradebookService().exportLessonGradebook(lesson);
        String downloadTokenValue = WebUtil.readStrParam((HttpServletRequest)request, (String)"downloadTokenValue");
        Cookie fileDownloadTokenCookie = new Cookie("fileDownloadToken", downloadTokenValue);
        fileDownloadTokenCookie.setPath("/");
        response.addCookie(fileDownloadTokenCookie);
        ExcelUtil.createExcel((OutputStream)out, dataToExport, (String)this.getGradebookService().getMessage("gradebook.export.dateheader"), (boolean)true);
        return null;
    }

    public ActionForward exportExcelCourseGradebook(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer organisationID = WebUtil.readIntParam((HttpServletRequest)request, (String)"organisationID");
        UserDTO user = this.getUser();
        if (!this.getSecurityService().hasOrgRole(organisationID, user.getUserID(), new String[]{"GROUP MANAGER", "GROUP ADMIN"}, "get course gradebook spreadsheet", false)) {
            response.sendError(403, "User is not a monitor in the organisation");
            return null;
        }
        Organisation organisation = (Organisation)this.getUserService().findById(Organisation.class, (Serializable)organisationID);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exporting to a spreadsheet course: " + organisationID));
        }
        LinkedHashMap<String, ExcelCell[][]> dataToExport = this.getGradebookService().exportCourseGradebook(user.getUserID(), organisationID);
        String fileName = organisation.getName().replaceAll(" ", "_") + ".xlsx";
        fileName = FileUtil.encodeFilenameForDownload((HttpServletRequest)request, (String)fileName);
        response.setContentType("application/x-download");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        String downloadTokenValue = WebUtil.readStrParam((HttpServletRequest)request, (String)"downloadTokenValue");
        Cookie fileDownloadTokenCookie = new Cookie("fileDownloadToken", downloadTokenValue);
        fileDownloadTokenCookie.setPath("/");
        response.addCookie(fileDownloadTokenCookie);
        ServletOutputStream out = response.getOutputStream();
        ExcelUtil.createExcel((OutputStream)out, dataToExport, (String)this.getGradebookService().getMessage("gradebook.export.dateheader"), (boolean)true);
        return null;
    }

    public ActionForward exportExcelSelectedLessons(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer organisationID = WebUtil.readIntParam((HttpServletRequest)request, (String)"organisationID");
        UserDTO user = this.getUser();
        if (!this.getSecurityService().isGroupMonitor(organisationID, user.getUserID(), "export selected lessons gradebook spreadsheet", false)) {
            response.sendError(403, "User is not a monitor in the organisation");
            return null;
        }
        boolean simplified = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"simplified", (boolean)false);
        Organisation organisation = (Organisation)this.getUserService().findById(Organisation.class, (Serializable)organisationID);
        Object[] lessonIds = request.getParameterValues("lessonID");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exporting to a spreadsheet lessons " + Arrays.toString(lessonIds) + " from course: " + organisationID));
        }
        LinkedHashMap<String, ExcelCell[][]> dataToExport = this.getGradebookService().exportSelectedLessonsGradebook(user.getUserID(), organisationID, (String[])lessonIds, simplified);
        String fileName = organisation.getName().replaceAll(" ", "_") + ".xlsx";
        fileName = FileUtil.encodeFilenameForDownload((HttpServletRequest)request, (String)fileName);
        response.setContentType("application/x-download");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        String downloadTokenValue = WebUtil.readStrParam((HttpServletRequest)request, (String)"downloadTokenValue");
        Cookie fileDownloadTokenCookie = new Cookie("fileDownloadToken", downloadTokenValue);
        fileDownloadTokenCookie.setPath("/");
        response.addCookie(fileDownloadTokenCookie);
        ServletOutputStream out = response.getOutputStream();
        ExcelUtil.createExcel((OutputStream)out, dataToExport, null, (boolean)false);
        return null;
    }

    public ActionForward getMarkChartData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        if (!this.getSecurityService().isLessonMonitor(lessonID, this.getUser().getUserID(), "export lesson gradebook spreadsheet", false)) {
            response.sendError(403, "User is not a monitor in the lesson");
            return null;
        }
        List<Number> results = this.getGradebookService().getMarksArray(lessonID);
        ObjectNode responseJSON = JsonNodeFactory.instance.objectNode();
        if (results != null) {
            responseJSON.set("data", (JsonNode)JsonUtil.readArray(results));
        } else {
            responseJSON.set("data", (JsonNode)JsonUtil.readArray((Object)new Float[0]));
        }
        response.setContentType("application/json;charset=utf-8");
        response.getWriter().write(responseJSON.toString());
        return null;
    }

    private UserDTO getUser() {
        HttpSession ss = SessionManager.getSession();
        return (UserDTO)ss.getAttribute("user");
    }

    private IUserManagementService getUserService() {
        if (userService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            userService = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return userService;
    }

    private ILessonService getLessonService() {
        if (lessonService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            lessonService = (ILessonService)ctx.getBean("lessonService");
        }
        return lessonService;
    }

    private IGradebookService getGradebookService() {
        if (gradebookService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            gradebookService = (IGradebookService)ctx.getBean("gradebookService");
        }
        return gradebookService;
    }

    private ISecurityService getSecurityService() {
        if (securityService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            securityService = (ISecurityService)ctx.getBean("securityService");
        }
        return securityService;
    }
}

