/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.gradebook.web.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.gradebook.service.IGradebookService;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.logevent.service.ILogEventService;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class RecalculateTotalMarksForLessonServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(RecalculateTotalMarksForLessonServlet.class);
    private static ILogEventService logEventService;
    private static ILessonService lessonService;
    private static IGradebookService gradebookService;

    public void init() throws ServletException {
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        logEventService = (ILogEventService)ctx.getBean("logEventService");
        lessonService = (ILessonService)ctx.getBean("lessonService");
        gradebookService = (IGradebookService)ctx.getBean("gradebookService");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = response.getWriter();
        Long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        Lesson lesson = lessonService.getLesson(lessonId);
        if (lesson == null) {
            log.error((Object)("RecalculateTotalMarksForLessonServlet: lesson not found " + lessonId));
            out.println("ERROR: lesson not found " + lessonId);
            out.close();
            return;
        }
        try {
            gradebookService.recalculateTotalMarksForLesson(lessonId);
        }
        catch (Throwable e) {
            String errorMsg = "Error occured " + e.getMessage() + e.getCause();
            out.println(errorMsg);
            out.close();
            return;
        }
        String msg = "Total marks have been successfully recalculated for lessonId " + lessonId;
        UserDTO monitorUser = (UserDTO)SessionManager.getSession().getAttribute("user");
        logEventService.logEvent(Integer.valueOf(17), monitorUser.getUserID(), null, lessonId, null, msg);
        out.println(msg);
        out.close();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

