/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.comments.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.SortedSet;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.comments.Comment;
import org.lamsfoundation.lams.comments.CommentSession;
import org.lamsfoundation.lams.comments.dao.ICommentDAO;
import org.lamsfoundation.lams.comments.dao.ICommentLikeDAO;
import org.lamsfoundation.lams.comments.dao.ICommentSessionDAO;
import org.lamsfoundation.lams.comments.dto.CommentDTO;
import org.lamsfoundation.lams.comments.service.ICommentService;
import org.lamsfoundation.lams.logevent.service.ILogEventService;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.MessageService;

public class CommentService
implements ICommentService {
    private static Logger log = Logger.getLogger(CommentService.class);
    private static final String MODULE_NAME = "Comments";
    private IUserManagementService userService;
    private MessageService messageService;
    private ILogEventService logEventService;
    private ILamsToolService toolService;
    private ICommentSessionDAO commentSessionDAO;
    private ICommentDAO commentDAO;
    private ICommentLikeDAO commentLikeDAO;

    @Override
    public List<CommentDTO> getTopicThread(Long externalId, Long externalSecondaryId, Integer externalType, String externalSignature, Long lastCommentSeqId, Integer pageSize, Integer sortBy, String extraSortParam, Integer userId) {
        long lastThreadMessageUid = lastCommentSeqId != null ? lastCommentSeqId : 0L;
        Comment rootTopic = this.commentDAO.getRootTopic(externalId, externalSecondaryId, externalType, externalSignature);
        if (rootTopic == null) {
            return new ArrayList<CommentDTO>();
        }
        SortedSet<Comment> comments = this.commentDAO.getNextThreadByThreadId(rootTopic.getUid(), lastThreadMessageUid, pageSize, sortBy, extraSortParam, userId);
        return this.getSortedCommentDTO(comments);
    }

    @Override
    public List<CommentDTO> getTopicStickyThread(Long externalId, Long externalSecondaryId, Integer externalType, String externalSignature, Integer sortBy, String extraSortParam, Integer userId) {
        Comment rootTopic = this.commentDAO.getRootTopic(externalId, externalSecondaryId, externalType, externalSignature);
        if (rootTopic == null) {
            return new ArrayList<CommentDTO>();
        }
        SortedSet<Comment> comments = this.commentDAO.getStickyThreads(rootTopic.getUid(), sortBy, extraSortParam, userId);
        return this.getSortedCommentDTO(comments);
    }

    private List<CommentDTO> getSortedCommentDTO(SortedSet<Comment> comments) {
        ArrayList<CommentDTO> msgDtoList = new ArrayList<CommentDTO>();
        for (Comment comment : comments) {
            CommentDTO dto = CommentDTO.getCommentDTO(comment);
            dto.setLevel(comment.getCommentLevel());
            dto.setThreadNum(comment.getThreadComment().getUid().intValue());
            msgDtoList.add(dto);
        }
        return msgDtoList;
    }

    @Override
    public List<CommentDTO> getThread(Long threadId, Integer sortBy, Integer userId) {
        SortedSet<Comment> comments = this.commentDAO.getThreadByThreadId(threadId, sortBy, userId);
        return this.getSortedCommentDTO(comments);
    }

    @Override
    public Comment createOrGetRoot(Long externalId, Long externalSecondaryId, Integer externalIdType, String externalSignature, User user) {
        Comment rootComment = this.commentDAO.getRootTopic(externalId, externalSecondaryId, externalIdType, externalSignature);
        return rootComment != null ? rootComment : this.createRoot(externalId, externalSecondaryId, externalIdType, externalSignature, user);
    }

    @Override
    public Comment getRoot(Long externalId, Long externalSecondaryId, Integer externalIdType, String externalSignature) {
        return this.commentDAO.getRootTopic(externalId, externalSecondaryId, externalIdType, externalSignature);
    }

    private Comment createRoot(Long externalId, Long externalSecondaryId, Integer externalIdType, String externalSignature, User user) {
        CommentSession session = new CommentSession();
        session.setExternalId(externalId);
        session.setExternalSecondaryId(externalSecondaryId);
        session.setExternalIdType(externalIdType);
        session.setExternalSignature(externalSignature);
        Comment comment = new Comment();
        comment.setBody("Hidden Root Message");
        comment.setHideFlag(true);
        comment.setReplyNumber(0);
        comment.setSession(session);
        comment.updateModificationData(user);
        comment.setCommentLevel((short)0);
        comment.setRootComment(comment);
        comment.setThreadComment(null);
        this.commentSessionDAO.save(session);
        this.commentDAO.saveOrUpdate(comment);
        return comment;
    }

    @Override
    public Comment createReply(Comment parent, String replyText, User user, boolean isMonitor, boolean isAnonymous) {
        Comment replyMessage = new Comment();
        replyMessage.setBody(replyText);
        replyMessage.setHideFlag(false);
        replyMessage.updateModificationData(user);
        replyMessage.setMonitor(isMonitor);
        replyMessage.setAnonymous(isAnonymous);
        replyMessage.setParent(parent);
        replyMessage.setSession(parent.getSession());
        Comment root = parent.getRootComment();
        replyMessage.setCommentLevel((short)(parent.getCommentLevel() + 1));
        replyMessage.setRootComment(root);
        if (replyMessage.getCommentLevel() == 1) {
            replyMessage.setThreadComment(replyMessage);
        } else {
            Comment threadComment = parent;
            while (threadComment.getCommentLevel() > 1) {
                threadComment = threadComment.getParent();
            }
            replyMessage.setThreadComment(threadComment);
        }
        this.commentDAO.saveOrUpdate(replyMessage);
        root.setLastReplyDate(new Date());
        root.setReplyNumber(root.getReplyNumber() + 1);
        this.commentDAO.saveOrUpdate(root);
        return replyMessage;
    }

    @Override
    public boolean addLike(Long commentUid, User user, Integer likeVote) {
        return this.commentLikeDAO.addLike(commentUid, user.getUserId(), likeVote);
    }

    @Override
    public Comment hideComment(Long commentUid, User user, boolean status) {
        Comment comment = this.commentDAO.getById(commentUid);
        comment.setHideFlag(status);
        this.commentDAO.saveOrUpdate(comment);
        Long learnerUserId = 0L;
        String loginName = "Default";
        if (comment.getCreatedBy() != null) {
            learnerUserId = comment.getCreatedBy().getUserId().longValue();
            loginName = comment.getCreatedBy().getLogin();
        }
        Long toolContentId = this.getToolContentIdForAuditing(commentUid, comment);
        if (status) {
            this.getLogEventService().logHideLearnerContent(learnerUserId, loginName, toolContentId, comment.toString());
        } else {
            this.getLogEventService().logShowLearnerContent(learnerUserId, loginName, toolContentId, comment.toString());
        }
        return comment;
    }

    @Override
    public Comment createReply(Long parentId, String replyText, User user, boolean isMonitor, boolean isAnonymous) {
        Comment parent = this.commentDAO.getById(parentId);
        return this.createReply(parent, replyText, user, isMonitor, isAnonymous);
    }

    @Override
    public Comment updateComment(Long commentUid, String newBody, User user, Boolean isAnonymous, boolean makeAuditEntry) {
        Comment comment = this.commentDAO.getById(commentUid);
        if (comment != null && user != null) {
            if (makeAuditEntry) {
                Long learnerUserId = 0L;
                String loginName = "Default";
                if (comment.getCreatedBy() != null) {
                    learnerUserId = comment.getCreatedBy().getUserId().longValue();
                    loginName = comment.getCreatedBy().getLogin();
                }
                Long toolContentId = this.getToolContentIdForAuditing(commentUid, comment);
                this.getLogEventService().logChangeLearnerContent(learnerUserId, loginName, toolContentId, comment.getBody(), newBody);
            }
            comment.setBody(newBody);
            comment.updateModificationData(user);
            if (isAnonymous != null) {
                comment.setAnonymous(isAnonymous);
            }
            this.commentDAO.saveOrUpdate(comment);
            return comment;
        }
        log.error((Object)("Unable to update comment as comment not found or user missing. Comment uid " + commentUid + " new body " + newBody + " user " + (user != null ? user.getLogin() : " missing")));
        return null;
    }

    private Long getToolContentIdForAuditing(Long commentUid, Comment comment) {
        Long toolContentId = null;
        String externalSignature = comment.getSession().getExternalSignature();
        if (externalSignature != null) {
            Long externalId = comment.getSession().getExternalId();
            ToolSession session = this.getToolService().getToolSession(externalId);
            if (session != null && externalSignature.equals(session.getToolActivity().getTool().getToolSignature())) {
                toolContentId = session.getToolActivity().getToolContentId();
            }
        }
        if (toolContentId == null) {
            log.error((Object)("Unexpected data for comment. Will create incomplete audit entry - cannot determine toolContentId. CommentUid=" + commentUid));
        }
        return toolContentId;
    }

    @Override
    public Comment updateSticky(Long commentUid, Boolean newSticky) {
        Comment comment = this.commentDAO.getById(commentUid);
        if (comment != null) {
            comment.setSticky(newSticky);
            this.commentDAO.saveOrUpdate(comment);
            return comment;
        }
        log.error((Object)("Unable to update comment as comment not found. Comment uid " + commentUid + " new sticky " + newSticky));
        return null;
    }

    @Override
    public CommentDTO getComment(Long commentUid) {
        Comment comment = this.commentDAO.getById(commentUid);
        return comment != null ? CommentDTO.getCommentDTO(comment) : null;
    }

    public IUserManagementService getUserService() {
        return this.userService;
    }

    public void setUserService(IUserManagementService userService) {
        this.userService = userService;
    }

    @Override
    public MessageService getMessageService() {
        return this.messageService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public ILogEventService getLogEventService() {
        return this.logEventService;
    }

    public void setLogEventService(ILogEventService logEventService) {
        this.logEventService = logEventService;
    }

    public ILamsToolService getToolService() {
        return this.toolService;
    }

    public void setToolService(ILamsToolService toolService) {
        this.toolService = toolService;
    }

    public ICommentSessionDAO getCommentSessionDAO() {
        return this.commentSessionDAO;
    }

    public void setCommentSessionDAO(ICommentSessionDAO commentSessionDAO) {
        this.commentSessionDAO = commentSessionDAO;
    }

    public ICommentDAO getCommentDAO() {
        return this.commentDAO;
    }

    public void setCommentDAO(ICommentDAO commentDAO) {
        this.commentDAO = commentDAO;
    }

    public ICommentLikeDAO getCommentLikeDAO() {
        return this.commentLikeDAO;
    }

    public void setCommentLikeDAO(ICommentLikeDAO commentLikeDAO) {
        this.commentLikeDAO = commentLikeDAO;
    }
}

