/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.events;

import java.security.InvalidParameterException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.lamsfoundation.lams.events.Subscription;

public class Event {
    private Long uid;
    private String name;
    private String scope;
    private Long eventSessionId;
    private Set<Subscription> subscriptions = new HashSet<Subscription>();
    private String message;
    private String subject;
    private boolean htmlFormat;
    private Date failTime;

    public Event() {
    }

    public Event(String scope, String name, Long sessionId, String subject, String message, boolean isHtmlContentType) throws InvalidParameterException {
        if (scope == null) {
            throw new InvalidParameterException("Event scope can not be null.");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new InvalidParameterException("Event name can not be blank.");
        }
        this.scope = scope;
        this.name = name;
        this.eventSessionId = sessionId;
        this.subject = subject;
        this.message = message;
        this.htmlFormat = isHtmlContentType;
    }

    public Event(String scope, String name, Long sessionId, String subject, String message, boolean isHtmlContentType, Date failTime) throws InvalidParameterException {
        if (scope == null) {
            throw new InvalidParameterException("Event scope can not be null.");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new InvalidParameterException("Event name can not be blank.");
        }
        this.scope = scope;
        this.name = name;
        this.eventSessionId = sessionId;
        this.subject = subject;
        this.message = message;
        this.htmlFormat = isHtmlContentType;
        this.failTime = failTime;
    }

    public Object clone() {
        return new Event(this.scope, this.name, this.eventSessionId, this.subject, this.message, this.htmlFormat, this.failTime);
    }

    public Long getEventSessionId() {
        return this.eventSessionId;
    }

    public Date getFailTime() {
        return this.failTime;
    }

    public String getMessage() {
        return this.message;
    }

    public String getName() {
        return this.name;
    }

    public String getScope() {
        return this.scope;
    }

    public String getSubject() {
        return this.subject;
    }

    public Set<Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    public Long getUid() {
        return this.uid;
    }

    public boolean isHtmlFormat() {
        return this.htmlFormat;
    }

    public void setEventSessionId(Long sessionId) {
        this.eventSessionId = sessionId;
    }

    public void setFailTime(Date failTime) {
        this.failTime = failTime;
    }

    public void setHtmlFormat(boolean isHtmlContentType) {
        this.htmlFormat = isHtmlContentType;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setSubscriptions(Set<Subscription> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }
}

