/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.events.dao.hibernate;

import java.security.InvalidParameterException;
import java.util.List;
import org.hibernate.Query;
import org.lamsfoundation.lams.dao.hibernate.LAMSBaseDAO;
import org.lamsfoundation.lams.events.EmailNotificationArchive;
import org.lamsfoundation.lams.events.Event;
import org.lamsfoundation.lams.events.Subscription;
import org.lamsfoundation.lams.events.dao.EventDAO;
import org.lamsfoundation.lams.usermanagement.User;
import org.springframework.stereotype.Repository;

@Repository
class EventDAOHibernate
extends LAMSBaseDAO
implements EventDAO {
    private static final String GET_EVENT_QUERY = "FROM " + Event.class.getName() + " AS e WHERE e.scope=? AND e.name=? AND e.eventSessionId=? AND e.failTime IS NULL";
    private static final String GET_EVENTS_TO_RESEND_QUERY = "SELECT DISTINCT e FROM " + Event.class.getName() + " AS e WHERE e.failTime IS NOT NULL";
    private static final String GET_LESSON_EVENT_SUBSCRIPTIONS = "FROM " + Subscription.class.getName() + " AS s WHERE s.userId = ? AND s.event.scope LIKE 'LESSON_%'";
    private static final String COUNT_PENDING_NOTIFICATIONS = "SELECT COUNT(*) FROM " + Subscription.class.getName() + " AS s WHERE (s.lastOperationMessage IS NULL OR s.lastOperationMessage != '" + "seen" + "') AND s.userId = ? AND s.event.scope LIKE 'LESSON_%'";
    private static final String GET_ARCHIVED_EMAIL_NOTIFICATION_RECIPIENTS = "SELECT u FROM " + User.class.getName() + " AS u, " + EmailNotificationArchive.class.getName() + " AS e WHERE e.uid = ? AND u.userId IN ELEMENTS(e.recipients) ORDER BY u.firstName, u.lastName";

    EventDAOHibernate() {
    }

    @Override
    public Event getEvent(String scope, String name, Long sessionId) throws InvalidParameterException {
        List<?> events = this.doFind(GET_EVENT_QUERY, scope, name, sessionId);
        if (events.size() > 1) {
            throw new InvalidParameterException("Two events with the same parameters exist in the database.");
        }
        if (events.size() == 0) {
            return null;
        }
        return (Event)events.get(0);
    }

    @Override
    public List<Event> getEventsToResend() {
        return this.doFind(GET_EVENTS_TO_RESEND_QUERY, new Object[0]);
    }

    @Override
    public List<Subscription> getLessonEventSubscriptions(Long lessonId, Integer userId, boolean pendingOnly, Integer limit, Integer offset) {
        String query = GET_LESSON_EVENT_SUBSCRIPTIONS;
        if (lessonId != null) {
            query = query + " AND s.event.eventSessionId = ?";
        }
        if (pendingOnly) {
            query = query + " AND (s.lastOperationMessage IS NULL OR s.lastOperationMessage != 'seen')";
        }
        query = query + " ORDER BY ISNULL(s.lastOperationMessage) DESC, uid DESC";
        Query queryObject = this.getSession().createQuery(query);
        queryObject.setInteger(0, userId.intValue());
        if (lessonId != null) {
            queryObject.setLong(1, lessonId.longValue());
        }
        if (limit != null) {
            queryObject.setMaxResults(limit.intValue());
        }
        if (offset != null) {
            queryObject.setFirstResult(offset.intValue());
        }
        return queryObject.list();
    }

    @Override
    public long getPendingNotificationCount(Long lessonId, Integer userId) {
        String query = COUNT_PENDING_NOTIFICATIONS;
        if (lessonId != null) {
            query = query + " AND s.event.eventSessionId = ?";
        }
        Query queryObject = this.getSession().createQuery(query);
        queryObject.setInteger(0, userId.intValue());
        if (lessonId != null) {
            queryObject.setLong(1, lessonId.longValue());
        }
        return (Long)queryObject.uniqueResult();
    }

    @Override
    public List<User> getArchivedEmailNotificationRecipients(Long emailNotificationUid, Integer limit, Integer offset) {
        Query queryObject = this.getSession().createQuery(GET_ARCHIVED_EMAIL_NOTIFICATION_RECIPIENTS);
        queryObject.setLong(0, emailNotificationUid.longValue());
        if (limit != null) {
            queryObject.setMaxResults(limit.intValue());
        }
        if (offset != null) {
            queryObject.setFirstResult(offset.intValue());
        }
        return queryObject.list();
    }
}

