/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dto.ValidationErrorDTO;
import org.lamsfoundation.lams.learningdesign.strategy.ScheduleGateActivityStrategy;
import org.lamsfoundation.lams.tool.SystemTool;
import org.lamsfoundation.lams.util.MessageService;

public class ScheduleGateActivity
extends GateActivity
implements Serializable {
    private Long gateStartTimeOffset;
    private Long gateEndTimeOffset;
    private Boolean gateActivityCompletionBased;

    public ScheduleGateActivity(Long activityId, Integer id, String description, String title, Integer xcoord, Integer ycoord, Integer orderId, Date createDateTime, LearningLibrary learningLibrary, Activity parentActivity, Activity libraryActivity, Integer parentUIID, LearningDesign learningDesign, Grouping grouping, Integer activityTypeId, Transition transitionTo, Transition transitionFrom, String languageFile, Boolean stopAfterActivity, Set inputActivities, Integer gateActivityLevelId, Long gateStartTimeOffset, Long gateEndTimeOffset, SystemTool sysTool, Set branchActivityEntries) {
        super(activityId, id, description, title, xcoord, ycoord, orderId, createDateTime, learningLibrary, parentActivity, libraryActivity, parentUIID, learningDesign, grouping, activityTypeId, transitionTo, transitionFrom, languageFile, stopAfterActivity, inputActivities, gateActivityLevelId, sysTool, branchActivityEntries);
        if (gateStartTimeOffset != null && gateEndTimeOffset != null && gateStartTimeOffset.intValue() > gateEndTimeOffset.intValue()) {
            throw new IllegalStateException("End time offset must be larger than start time offset");
        }
        this.gateStartTimeOffset = gateStartTimeOffset;
        this.gateEndTimeOffset = gateEndTimeOffset;
        this.simpleActivityStrategy = new ScheduleGateActivityStrategy(this);
    }

    public ScheduleGateActivity() {
        this.simpleActivityStrategy = new ScheduleGateActivityStrategy(this);
    }

    public ScheduleGateActivity(Long activityId, Date createDateTime, LearningLibrary learningLibrary, Activity parentActivity, LearningDesign learningDesign, Grouping grouping, Integer activityTypeId, Transition transitionTo, Transition transitionFrom, Integer gateActivityLevelId, Long gateStartTimeOffset, Long gateEndTimeOffset) {
        super(activityId, createDateTime, learningLibrary, parentActivity, learningDesign, grouping, activityTypeId, transitionTo, transitionFrom, gateActivityLevelId);
        if (gateStartTimeOffset != null && gateEndTimeOffset != null && gateStartTimeOffset.intValue() > gateEndTimeOffset.intValue()) {
            throw new IllegalStateException("End time offset must be larger than start time offset");
        }
        this.gateStartTimeOffset = gateStartTimeOffset;
        this.gateEndTimeOffset = gateEndTimeOffset;
        this.simpleActivityStrategy = new ScheduleGateActivityStrategy(this);
    }

    @Override
    public Activity createCopy(int uiidOffset) {
        ScheduleGateActivity newScheduleGateActivity = new ScheduleGateActivity();
        this.copyToNewActivity(newScheduleGateActivity, uiidOffset);
        newScheduleGateActivity.setGateActivityLevelId(this.getGateActivityLevelId());
        newScheduleGateActivity.setGateOpen(new Boolean(false));
        newScheduleGateActivity.setGateEndTimeOffset(this.getGateEndTimeOffset());
        newScheduleGateActivity.setGateStartTimeOffset(this.getGateStartTimeOffset());
        newScheduleGateActivity.setGateActivityCompletionBased(this.getGateActivityCompletionBased());
        return newScheduleGateActivity;
    }

    public Long getGateStartTimeOffset() {
        return this.gateStartTimeOffset;
    }

    public void setGateStartTimeOffset(Long gateStartTimeOffset) {
        this.gateStartTimeOffset = gateStartTimeOffset;
    }

    public Long getGateEndTimeOffset() {
        return this.gateEndTimeOffset;
    }

    public void setGateEndTimeOffset(Long gateEndTimeOffset) {
        this.gateEndTimeOffset = gateEndTimeOffset;
    }

    public Boolean getGateActivityCompletionBased() {
        return this.gateActivityCompletionBased;
    }

    public void setGateActivityCompletionBased(Boolean gateActivityCompletionBased) {
        this.gateActivityCompletionBased = gateActivityCompletionBased;
    }

    public Date getGateOpenTime(Date referenceTime) {
        GregorianCalendar openTime = new GregorianCalendar(TimeZone.getDefault());
        openTime.setTime(referenceTime);
        if (this.isScheduledByStartTimeOffset()) {
            ((Calendar)openTime).add(12, this.getGateStartTimeOffset().intValue());
        }
        return openTime.getTime();
    }

    public Date getGateCloseTime(Date referenceTime) {
        GregorianCalendar closeTime = new GregorianCalendar(TimeZone.getDefault());
        closeTime.setTime(referenceTime);
        if (this.isScheduledByEndTimeOffset()) {
            ((Calendar)closeTime).add(12, this.getGateEndTimeOffset().intValue());
        }
        return closeTime.getTime();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("activityId", (Object)this.getActivityId()).toString();
    }

    @Override
    public boolean isNull() {
        return false;
    }

    public Vector validateActivity(MessageService messageService) {
        Vector<ValidationErrorDTO> listOfValidationErrors = new Vector<ValidationErrorDTO>();
        if (this.isScheduledByTimeOffset()) {
            if (this.getGateStartTimeOffset().equals(this.getGateEndTimeOffset())) {
                listOfValidationErrors.add(new ValidationErrorDTO("SG1", messageService.getMessage("validation.error.illegalScheduleGateOffsetsType1"), this.getActivityUIID()));
            } else if (this.getGateStartTimeOffset().compareTo(this.getGateEndTimeOffset()) > 0) {
                listOfValidationErrors.add(new ValidationErrorDTO("SG1", messageService.getMessage("validation.error.illegalScheduleGateOffsetsType2"), this.getActivityUIID()));
            }
        }
        return listOfValidationErrors;
    }

    private boolean isScheduledByTimeOffset() {
        return this.getGateStartTimeOffset() != null && this.getGateEndTimeOffset() != null;
    }

    private boolean isScheduledByStartTimeOffset() {
        return this.getGateStartTimeOffset() != null;
    }

    private boolean isScheduledByEndTimeOffset() {
        return this.getGateEndTimeOffset() != null;
    }
}

