/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import org.lamsfoundation.lams.util.LanguageUtil;

public class NumberUtil {
    private static Locale getServerLocale() {
        String[] defaults = LanguageUtil.getDefaultLangCountry();
        return new Locale(defaults[0] != null ? defaults[0] : "", defaults[1] != null ? defaults[1] : "");
    }

    public static String formatLocalisedNumberForceDecimalPlaces(Number number, Locale locale, int numFractionDigits) {
        NumberFormat format = null;
        format = locale == null ? NumberFormat.getInstance(NumberUtil.getServerLocale()) : NumberFormat.getInstance(locale);
        format.setMinimumFractionDigits(numFractionDigits);
        return format.format(number);
    }

    public static String formatLocalisedNumber(Number number, Locale locale, int numFractionDigits) {
        NumberFormat format = null;
        format = locale == null ? NumberFormat.getInstance(NumberUtil.getServerLocale()) : NumberFormat.getInstance(locale);
        return NumberUtil.formatLocalisedNumber(number, format, numFractionDigits);
    }

    public static String formatLocalisedNumber(Number number, NumberFormat numberFormat, int numFractionDigits) {
        NumberFormat format = numberFormat != null ? numberFormat : NumberFormat.getInstance();
        format.setMaximumFractionDigits(numFractionDigits);
        return format.format(number);
    }

    public static Float getLocalisedFloat(String inputStr, Locale locale) {
        ParsePosition pp;
        Locale useLocale;
        NumberFormat format;
        Number num;
        String numberStr = inputStr;
        if (numberStr != null) {
            numberStr = numberStr.replace(" ", "");
        }
        if (numberStr != null && numberStr.length() > 0 && (num = (format = NumberFormat.getInstance(useLocale = locale != null ? locale : NumberUtil.getServerLocale())).parse(numberStr, pp = new ParsePosition(0))) != null && pp.getIndex() == numberStr.length()) {
            return Float.valueOf(num.floatValue());
        }
        throw new NumberFormatException("Unable to convert number " + numberStr + "to float using locale " + locale.getCountry() + " " + locale.getLanguage());
    }

    public static Double getLocalisedDouble(String inputStr, Locale locale) {
        ParsePosition pp;
        Locale useLocale;
        NumberFormat format;
        Number num;
        String numberStr = inputStr;
        if (numberStr != null) {
            numberStr = numberStr.replace(" ", "");
        }
        if (numberStr != null && numberStr.length() > 0 && (num = (format = NumberFormat.getInstance(useLocale = locale != null ? locale : NumberUtil.getServerLocale())).parse(numberStr, pp = new ParsePosition(0))) != null && pp.getIndex() == numberStr.length()) {
            return num.doubleValue();
        }
        throw new NumberFormatException("Unable to convert number " + numberStr + "to double using locale " + locale.getCountry() + " " + locale.getLanguage());
    }
}

