/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.general.PieDataset;

public class DefaultPieDataset
extends AbstractDataset
implements PieDataset,
Cloneable,
Serializable {
    private DefaultKeyedValues data = new DefaultKeyedValues();

    public DefaultPieDataset() {
    }

    public DefaultPieDataset(KeyedValues data) {
        for (int i = 0; i < data.getItemCount(); ++i) {
            this.data.addValue(data.getKey(i), data.getValue(i));
        }
    }

    public int getItemCount() {
        return this.data.getItemCount();
    }

    public List getKeys() {
        return Collections.unmodifiableList(this.data.getKeys());
    }

    public Comparable getKey(int item) {
        Comparable result = null;
        if (this.getItemCount() > item) {
            result = this.data.getKey(item);
        }
        return result;
    }

    public int getIndex(Comparable key) {
        return this.data.getIndex(key);
    }

    public Number getValue(int item) {
        Number result = null;
        if (this.getItemCount() > item) {
            result = this.data.getValue(item);
        }
        return result;
    }

    public Number getValue(Comparable key) {
        if (key == null) {
            throw new IllegalArgumentException("PieDataset: null key not allowed.");
        }
        return this.data.getValue(key);
    }

    public void setValue(Comparable key, Number value) {
        this.data.setValue(key, value);
        this.fireDatasetChanged();
    }

    public void setValue(Comparable key, double value) {
        this.setValue(key, new Double(value));
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof PieDataset)) {
            return false;
        }
        PieDataset pd = (PieDataset)o;
        int count = this.getItemCount();
        if (pd.getItemCount() != count) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            Comparable k2;
            Comparable k1 = this.getKey(i);
            if (!k1.equals(k2 = pd.getKey(i))) {
                return false;
            }
            Number v1 = this.getValue(i);
            Number v2 = pd.getValue(i);
            if (!(v1 == null ? v2 != null : !v1.equals(v2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultPieDataset clone = (DefaultPieDataset)super.clone();
        clone.data = (DefaultKeyedValues)this.data.clone();
        return clone;
    }
}

