/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jfree.data.time.TimePeriod;
import org.jfree.date.MonthConstants;

public abstract class RegularTimePeriod
implements TimePeriod,
Comparable,
MonthConstants {
    public static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getDefault();
    public static final Calendar WORKING_CALENDAR = Calendar.getInstance(DEFAULT_TIME_ZONE);

    public abstract RegularTimePeriod previous();

    public abstract RegularTimePeriod next();

    public abstract long getSerialIndex();

    public Date getStart() {
        return new Date(this.getFirstMillisecond());
    }

    public Date getEnd() {
        return new Date(this.getLastMillisecond());
    }

    public long getFirstMillisecond() {
        return this.getFirstMillisecond(DEFAULT_TIME_ZONE);
    }

    public long getFirstMillisecond(TimeZone zone) {
        WORKING_CALENDAR.setTimeZone(zone);
        return this.getFirstMillisecond(WORKING_CALENDAR);
    }

    public abstract long getFirstMillisecond(Calendar var1);

    public long getLastMillisecond() {
        return this.getLastMillisecond(DEFAULT_TIME_ZONE);
    }

    public long getLastMillisecond(TimeZone zone) {
        WORKING_CALENDAR.setTimeZone(zone);
        return this.getLastMillisecond(WORKING_CALENDAR);
    }

    public abstract long getLastMillisecond(Calendar var1);

    public long getMiddleMillisecond() {
        long m1 = this.getFirstMillisecond();
        long m2 = this.getLastMillisecond();
        return m1 + (m2 - m1) / 2L;
    }

    public long getMiddleMillisecond(TimeZone zone) {
        long m1 = this.getFirstMillisecond(zone);
        long m2 = this.getLastMillisecond(zone);
        return m1 + (m2 - m1) / 2L;
    }

    public long getMiddleMillisecond(Calendar calendar) {
        long m1 = this.getFirstMillisecond(calendar);
        long m2 = this.getLastMillisecond(calendar);
        return m1 + (m2 - m1) / 2L;
    }

    public String toString() {
        return String.valueOf(this.getStart());
    }
}

