/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.config.ConfigurationItem;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigAction
extends LamsDispatchAction {
    private static Configuration configurationService;
    private static MessageService messageService;

    private Configuration getConfiguration() {
        if (configurationService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            configurationService = (Configuration)ctx.getBean("configurationService");
        }
        return configurationService;
    }

    private MessageService getMessageService() {
        if (messageService == null) {
            messageService = AdminServiceProxy.getMessageService(this.getServlet().getServletContext());
        }
        return messageService;
    }

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("config", this.arrangeItems());
        return mapping.findForward("config");
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.isCancelled(request)) {
            return mapping.findForward("sysadmin");
        }
        DynaActionForm configForm = (DynaActionForm)form;
        String[] keys = (String[])configForm.get("key");
        String[] values = (String[])configForm.get("value");
        for (int i = 0; i < keys.length; ++i) {
            ConfigurationItem item = this.getConfiguration().getConfigItemByKey(keys[i]);
            if (item == null) continue;
            if (item.getRequired().booleanValue() && (values[i] == null || values[i].length() <= 0)) {
                request.setAttribute("error", (Object)this.getRequiredError(item.getDescriptionKey()));
                request.setAttribute("config", this.arrangeItems());
                return mapping.findForward("config");
            }
            String format = item.getFormat();
            if (format != null && format.equals(ConfigurationItem.LONG_FORMAT)) {
                try {
                    Long.parseLong(values[i]);
                }
                catch (NumberFormatException e) {
                    request.setAttribute("error", (Object)this.getNumericError(item.getDescriptionKey()));
                    request.setAttribute("config", this.arrangeItems());
                    return mapping.findForward("config");
                }
            }
            Configuration.updateItem((String)keys[i], (String)values[i]);
        }
        this.getConfiguration().persistUpdate();
        return mapping.findForward("sysadmin");
    }

    private String getRequiredError(String arg) {
        Object[] args = new String[]{this.getMessageService().getMessage(arg)};
        return this.getMessageService().getMessage("error.required", args);
    }

    private String getNumericError(String arg) {
        Object[] args = new String[]{this.getMessageService().getMessage(arg)};
        return this.getMessageService().getMessage("error.numeric", args);
    }

    private HashMap<String, ArrayList<ConfigurationItem>> arrangeItems() {
        List originalList = this.getConfiguration().getAllItems();
        HashMap<String, ArrayList<ConfigurationItem>> groupedList = new HashMap<String, ArrayList<ConfigurationItem>>();
        for (int i = 0; i < originalList.size(); ++i) {
            ConfigurationItem item = (ConfigurationItem)originalList.get(i);
            String header = item.getHeaderName();
            if (!groupedList.containsKey(header)) {
                groupedList.put(header, new ArrayList());
            }
            ArrayList<ConfigurationItem> currentList = groupedList.get(header);
            currentList.add(item);
            groupedList.put(header, currentList);
        }
        return groupedList;
    }
}

