/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;

public class LoginSaveAction
extends LamsDispatchAction {
    private static final String LOGO_TAG = "<img src=\"<lams:LAMSURL/>";
    private static final String ALPHABET = "ABCDEFGHIJKLMOPQRSTUWVXYZabcdefghijklmnopqrstuvwxyz_1234567890";
    private static final String IMAGE_FOLDER_SUFFIX = File.separatorChar + "lams-www.war" + File.separatorChar + "images";
    private static final String LOGIN_PAGE_PATH_SUFFIX = File.separatorChar + "lams-central.war" + File.separatorChar + "login.jsp";
    private static final String NEWS_PAGE_PATH_SUFFIX = File.separatorChar + "lams-www.war" + File.separatorChar + "news.html";

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.isCancelled(request)) {
            return mapping.findForward("sysadmin");
        }
        DynaActionForm loginMaintainForm = (DynaActionForm)form;
        ActionMessages errors = new ActionMessages();
        FormFile file = (FormFile)loginMaintainForm.get("logo");
        if (file != null && file.getFileSize() != 0) {
            this.checkFile(errors, file);
        }
        if (errors.isEmpty()) {
            if (file != null && file.getFileSize() != 0) {
                String fileName = this.fixBuggyFileName(file.getFileName());
                this.createImageFile(file, fileName);
                this.updateLoginPage(LoginSaveAction.buildURL(fileName));
            }
        } else {
            this.saveErrors(request, errors);
            return mapping.findForward("loginmaintain");
        }
        this.updateNewsPage(loginMaintainForm.getString("news"));
        return mapping.findForward("sysadmin");
    }

    private String fixBuggyFileName(String fileName) {
        fileName = this.generateRandomFileName() + fileName.substring(fileName.lastIndexOf(46));
        int i = 0;
        while (new File(Configuration.get((String)ConfigurationKeys.LAMS_EAR_DIR) + IMAGE_FOLDER_SUFFIX + File.separatorChar + fileName).exists()) {
            fileName = fileName.replace(".", new Integer(i).toString());
            ++i;
        }
        log.debug((Object)("generated filename " + fileName));
        return fileName;
    }

    private String generateRandomFileName() {
        StringBuilder name = new StringBuilder();
        int length = 1 + new Random().nextInt(ALPHABET.length());
        for (int i = 0; i < length; ++i) {
            name.append(ALPHABET.charAt(new Random().nextInt(ALPHABET.length())));
        }
        log.debug((Object)("generated random name " + name));
        return name.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNewsPage(String news) throws IOException {
        BufferedWriter bWriter = null;
        try {
            OutputStreamWriter ow = new OutputStreamWriter((OutputStream)new FileOutputStream(Configuration.get((String)ConfigurationKeys.LAMS_EAR_DIR) + NEWS_PAGE_PATH_SUFFIX), Charset.forName("UTF-8"));
            bWriter = new BufferedWriter(ow);
            bWriter.write(news);
            bWriter.flush();
        }
        finally {
            if (bWriter != null) {
                bWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLoginPage(String url) throws IOException {
        BufferedReader bReader = null;
        BufferedWriter bWriter = null;
        try {
            bReader = new BufferedReader(new FileReader(Configuration.get((String)ConfigurationKeys.LAMS_EAR_DIR) + LOGIN_PAGE_PATH_SUFFIX));
            StringBuilder source = new StringBuilder();
            String line = bReader.readLine();
            while (line != null) {
                source.append(line).append('\n');
                line = bReader.readLine();
            }
            int index = source.indexOf(LOGO_TAG);
            if (index != -1) {
                int startIndex = index + LOGO_TAG.length();
                int endIndex = source.indexOf("\"", startIndex);
                source.replace(startIndex, endIndex, url);
                bWriter = new BufferedWriter(new FileWriter(Configuration.get((String)ConfigurationKeys.LAMS_EAR_DIR) + LOGIN_PAGE_PATH_SUFFIX));
                bWriter.write(source.toString());
                bWriter.flush();
            }
        }
        finally {
            if (bReader != null) {
                bReader.close();
            }
            if (bWriter != null) {
                bWriter.close();
            }
        }
    }

    private static String buildURL(String fileName) throws UnsupportedEncodingException {
        return "/www/images/" + fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createImageFile(FormFile file, String fileName) throws IOException {
        File imagesFolder = new File(Configuration.get((String)ConfigurationKeys.LAMS_EAR_DIR) + IMAGE_FOLDER_SUFFIX);
        if (!imagesFolder.exists()) {
            imagesFolder.mkdir();
        }
        String imageFilePath = Configuration.get((String)ConfigurationKeys.LAMS_EAR_DIR) + IMAGE_FOLDER_SUFFIX + File.separatorChar + fileName;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(imageFilePath);
            out.write(file.getFileData());
            out.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private void checkFile(ActionMessages errors, FormFile file) {
        boolean imgFormat = file.getContentType().contains("image");
        if (!imgFormat) {
            errors.add("format", new ActionMessage("error.img.format"));
        }
        if (file.getFileSize() > 0x400000) {
            errors.add("size", new ActionMessage("error.img.size"));
        }
    }
}

