/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.admin.web.OrgManageBean;
import org.lamsfoundation.lams.admin.web.form.OrgManageForm;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationState;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;

public class OrgManageAction
extends Action {
    private static IUserManagementService service;
    private static MessageService messageService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        service = AdminServiceProxy.getService(this.getServlet().getServletContext());
        messageService = AdminServiceProxy.getMessageService(this.getServlet().getServletContext());
        Integer orgId = WebUtil.readIntParam((HttpServletRequest)request, (String)"org", (boolean)true);
        Organisation org = null;
        if (orgId == null) {
            orgId = (Integer)request.getAttribute("org");
        }
        if (orgId != null && orgId > 0 && (org = (Organisation)service.findById(Organisation.class, (Serializable)orgId)) == null) {
            request.setAttribute("errorName", (Object)"OrgManageAction");
            request.setAttribute("errorMessage", (Object)messageService.getMessage("error.org.invalid"));
            return mapping.findForward("error");
        }
        Integer numUsers = service.getRootOrganisation().equals(org) ? service.getCountUsers() : Integer.valueOf(service.getUsersFromOrganisation(orgId).size());
        String key = service.getRootOrganisation().getOrganisationId().equals(orgId) ? "label.users.in.system" : "label.users.in.group";
        Object[] args = new String[]{numUsers.toString()};
        request.setAttribute("numUsers", (Object)messageService.getMessage(key, args));
        Integer userId = ((UserDTO)SessionManager.getSession().getAttribute("user")).getUserID();
        OrgManageForm orgManageForm = (OrgManageForm)form;
        if (orgManageForm == null) {
            orgManageForm = new OrgManageForm();
            orgManageForm.setStateId(OrganisationState.ACTIVE);
        } else if (orgManageForm.getStateId() == null) {
            orgManageForm.setStateId(OrganisationState.ACTIVE);
        }
        orgManageForm.setParentId(orgId);
        orgManageForm.setParentName(org.getName());
        orgManageForm.setType(org.getOrganisationType().getOrganisationTypeId());
        if (!orgManageForm.getType().equals(OrganisationType.CLASS_TYPE)) {
            ArrayList<OrgManageBean> orgManageBeans = new ArrayList<OrgManageBean>();
            if (request.isUserInRole("SYSADMIN") || request.isUserInRole("GROUP ADMIN") || request.isUserInRole("GROUP MANAGER")) {
                Integer typeId = orgManageForm.getType().equals(OrganisationType.ROOT_TYPE) ? OrganisationType.COURSE_TYPE : OrganisationType.CLASS_TYPE;
                HashMap<String, Integer> properties = new HashMap<String, Integer>();
                properties.put("organisationType.organisationTypeId", typeId);
                properties.put("organisationState.organisationStateId", orgManageForm.getStateId());
                List organisations = service.findByProperties(Organisation.class, properties);
                for (int i = 0; i < organisations.size(); ++i) {
                    Organisation parentOrg;
                    Organisation organisation = (Organisation)organisations.get(i);
                    Organisation organisation2 = parentOrg = typeId.equals(OrganisationType.CLASS_TYPE) ? organisation.getParentOrganisation() : organisation;
                    if (!request.isUserInRole("SYSADMIN") && !service.isUserInRole(userId, parentOrg.getOrganisationId(), "GROUP ADMIN") && !service.isUserInRole(userId, parentOrg.getOrganisationId(), "GROUP MANAGER") && !service.isUserGlobalGroupAdmin() || typeId.equals(OrganisationType.CLASS_TYPE) && !parentOrg.getOrganisationId().equals(orgId)) continue;
                    OrgManageBean orgManageBean = new OrgManageBean();
                    BeanUtils.copyProperties((Object)orgManageBean, (Object)organisation);
                    orgManageBean.setStatus(organisation.getOrganisationState().getDescription());
                    orgManageBean.setEditable(true);
                    orgManageBeans.add(orgManageBean);
                }
            }
            Collections.sort(orgManageBeans);
            orgManageForm.setOrgManageBeans(orgManageBeans);
            request.setAttribute("OrgManageForm", (Object)orgManageForm);
            request.setAttribute("org", (Object)org);
        } else {
            Organisation pOrg = org.getParentOrganisation();
            org.setCourseAdminCanAddNewUsers(pOrg.getCourseAdminCanAddNewUsers());
            org.setCourseAdminCanBrowseAllUsers(pOrg.getCourseAdminCanBrowseAllUsers());
            org.setCourseAdminCanChangeStatusOfCourse(pOrg.getCourseAdminCanChangeStatusOfCourse());
            request.setAttribute("org", (Object)org);
            request.setAttribute("parentGroupName", (Object)pOrg.getName());
            request.setAttribute("parentGroupId", (Object)pOrg.getOrganisationId());
        }
        request.setAttribute("createGroup", (Object)(request.isUserInRole("SYSADMIN") || service.isUserGlobalGroupAdmin() ? 1 : 0));
        request.setAttribute("editGroup", (Object)service.canEditGroup(userId, orgId));
        request.setAttribute("manageGlobalRoles", (Object)request.isUserInRole("SYSADMIN"));
        return mapping.findForward("orglist");
    }
}

