/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web;

import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.admin.web.ScheduledJobDTO;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ScheduledJobListAction
extends Action {
    private static final Logger log = Logger.getLogger(ScheduledJobListAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        Scheduler scheduler = (Scheduler)ctx.getBean("scheduler");
        ArrayList<ScheduledJobDTO> jobList = new ArrayList<ScheduledJobDTO>();
        try {
            String[] jobNames;
            for (String name : jobNames = scheduler.getJobNames("DEFAULT")) {
                Trigger[] triggers;
                ScheduledJobDTO jobDto = new ScheduledJobDTO();
                JobDetail detail = scheduler.getJobDetail(name, "DEFAULT");
                jobDto.setName(name);
                jobDto.setDescription(detail.getDescription());
                for (Trigger trigger : triggers = scheduler.getTriggersOfJob(name, "DEFAULT")) {
                    jobDto.setStartDate(trigger.getStartTime());
                    jobList.add(jobDto);
                }
            }
        }
        catch (SchedulerException e) {
            log.equals("Failed get job names:" + e.getMessage());
        }
        request.setAttribute("jobList", jobList);
        return mapping.findForward("list");
    }
}

