/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.learningdesign.dto.LearningLibraryDTO;
import org.lamsfoundation.lams.learningdesign.dto.LibraryActivityDTO;
import org.lamsfoundation.lams.learningdesign.service.ILearningDesignService;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolContentListAction
extends Action {
    private String getUserLanguage() {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        return user != null ? user.getLocaleLanguage() : "";
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!request.isUserInRole("SYSADMIN") && !request.isUserInRole("AUTHOR ADMIN")) {
            request.setAttribute("errorName", (Object)"ToolContentListAction");
            request.setAttribute("errorMessage", (Object)AdminServiceProxy.getMessageService(this.getServlet().getServletContext()).getMessage("error.authorisation"));
            return mapping.findForward("error");
        }
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        ILearningDesignService learningDesignService = (ILearningDesignService)ctx.getBean("learningDesignService");
        ArrayList learningLibraryDTOs = learningDesignService.getAllLearningLibraryDetails(this.getUserLanguage());
        ArrayList<LibraryActivityDTO> activeTools = this.filterActiveTools(learningLibraryDTOs);
        request.setAttribute("activeTools", activeTools);
        IUserManagementService usermanagementService = (IUserManagementService)ctx.getBean("userManagementService");
        HashMap<Long, String> toolVersions = new HashMap<Long, String>();
        List tools = usermanagementService.findAll(Tool.class);
        for (Tool tool : tools) {
            toolVersions.put(tool.getToolId(), tool.getToolVersion());
        }
        request.setAttribute("toolVersions", toolVersions);
        HashMap<String, Integer> dbVersions = new HashMap<String, Integer>();
        DataSource dataSource = (DataSource)ctx.getBean("dataSource");
        Connection conn = dataSource.getConnection();
        PreparedStatement query = conn.prepareStatement("select system_name, patch_level from patches");
        ResultSet results = query.executeQuery();
        while (results.next()) {
            dbVersions.put(results.getString("system_name"), results.getInt("patch_level"));
        }
        request.setAttribute("dbVersions", dbVersions);
        return mapping.findForward("toolcontentlist");
    }

    private ArrayList<LibraryActivityDTO> filterActiveTools(List learningLibraryDTOs) {
        ArrayList<LibraryActivityDTO> activeTools = new ArrayList<LibraryActivityDTO>();
        for (int i = 0; i < learningLibraryDTOs.size(); ++i) {
            LearningLibraryDTO dto = (LearningLibraryDTO)learningLibraryDTOs.get(i);
            if (!dto.getValidFlag().booleanValue()) continue;
            Vector templateActivities = dto.getTemplateActivities();
            for (int j = 0; j < templateActivities.size(); ++j) {
                LibraryActivityDTO template = (LibraryActivityDTO)templateActivities.get(j);
                if (template.getToolContentID() == null || this.toolExists(template, activeTools)) continue;
                activeTools.add(template);
            }
        }
        return activeTools;
    }

    private boolean toolExists(LibraryActivityDTO item, ArrayList<LibraryActivityDTO> list) {
        for (LibraryActivityDTO l : list) {
            if (!StringUtils.equals((String)item.getToolSignature(), (String)l.getToolSignature())) continue;
            return true;
        }
        return false;
    }
}

