/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.admin.web.UserListDTO;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;

public class UserManageAction
extends Action {
    private static final Logger log = Logger.getLogger(UserManageAction.class);
    private static IUserManagementService service;
    private static MessageService messageService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        service = AdminServiceProxy.getService(this.getServlet().getServletContext());
        messageService = AdminServiceProxy.getMessageService(this.getServlet().getServletContext());
        Integer orgId = WebUtil.readIntParam((HttpServletRequest)request, (String)"org", (boolean)true);
        if (orgId == null) {
            orgId = (Integer)request.getAttribute("org");
        }
        if (orgId == null || orgId <= 0) {
            return this.forwardError(mapping, request, "error.org.invalid");
        }
        log.debug((Object)("orgId: " + orgId));
        Organisation organisation = (Organisation)service.findById(Organisation.class, (Serializable)orgId);
        if (organisation == null) {
            return this.forwardError(mapping, request, "error.org.invalid");
        }
        String orgName = organisation.getName();
        log.debug((Object)("orgName: " + orgName));
        Organisation pOrg = organisation.getParentOrganisation();
        if (pOrg != null) {
            request.setAttribute("pOrgId", (Object)pOrg.getOrganisationId());
            request.setAttribute("pOrgName", (Object)pOrg.getName());
        }
        OrganisationType orgType = organisation.getOrganisationType();
        request.setAttribute("orgType", (Object)orgType.getOrganisationTypeId());
        UserListDTO userManageForm = new UserListDTO();
        Integer userId = ((UserDTO)SessionManager.getSession().getAttribute("user")).getUserID();
        Organisation orgOfCourseAdmin = orgType.getOrganisationTypeId().equals(OrganisationType.CLASS_TYPE) ? pOrg : organisation;
        Integer rootOrgId = service.getRootOrganisation().getOrganisationId();
        if (request.isUserInRole("SYSADMIN") || service.isUserGlobalGroupAdmin() && !orgId.equals(rootOrgId)) {
            userManageForm.setCourseAdminCanAddNewUsers(true);
            userManageForm.setCourseAdminCanBrowseAllUsers(true);
            request.setAttribute("canDeleteUser", (Object)true);
        } else if ((service.isUserInRole(userId, orgOfCourseAdmin.getOrganisationId(), "GROUP ADMIN") || service.isUserInRole(userId, orgOfCourseAdmin.getOrganisationId(), "GROUP MANAGER")) && !orgId.equals(rootOrgId)) {
            userManageForm.setCourseAdminCanAddNewUsers(orgOfCourseAdmin.getCourseAdminCanAddNewUsers());
            userManageForm.setCourseAdminCanBrowseAllUsers(orgOfCourseAdmin.getCourseAdminCanBrowseAllUsers());
        } else {
            return this.forwardError(mapping, request, "error.authorisation");
        }
        userManageForm.setOrgId(orgId);
        userManageForm.setOrgName(orgName);
        List userManageBeans = service.getUserManageBeans(orgId);
        Collections.sort(userManageBeans);
        userManageForm.setUserManageBeans(userManageBeans);
        request.setAttribute("UserManageForm", (Object)userManageForm);
        Object[] args = new String[]{orgName};
        request.setAttribute("heading", (Object)messageService.getMessage("heading.manage.group.users", args));
        HashMap<String, Integer> roleCount = new HashMap<String, Integer>();
        if (orgId.equals(rootOrgId)) {
            roleCount.put("SYSADMIN", Role.ROLE_SYSADMIN);
            roleCount.put("AUTHOR ADMIN", Role.ROLE_AUTHOR_ADMIN);
            roleCount.put("GROUP ADMIN", Role.ROLE_GROUP_ADMIN);
        } else {
            roleCount.put("LEARNER", Role.ROLE_LEARNER);
            roleCount.put("MONITOR", Role.ROLE_MONITOR);
            roleCount.put("AUTHOR", Role.ROLE_AUTHOR);
            roleCount.put("GROUP MANAGER", Role.ROLE_GROUP_MANAGER);
            roleCount.put("GROUP ADMIN", Role.ROLE_GROUP_ADMIN);
        }
        for (String role : roleCount.keySet()) {
            Integer count = service.getCountRoleForOrg(orgId, (Integer)roleCount.get(role));
            request.setAttribute(role.replace(' ', '_'), (Object)count);
        }
        Integer numUsers = service.getUsersFromOrganisation(orgId).size();
        args[0] = numUsers.toString();
        request.setAttribute("numUsers", (Object)messageService.getMessage("label.users.in.group", args));
        return mapping.findForward("userlist");
    }

    private ActionForward forwardError(ActionMapping mapping, HttpServletRequest request, String key) {
        request.setAttribute("errorName", (Object)"UserManageAction");
        request.setAttribute("errorMessage", (Object)messageService.getMessage(key));
        return mapping.findForward("error");
    }
}

